/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.types.Binning;
import com.ibm.bi.predict.types.DataItemType;
import com.ibm.bi.predict.utils.JsonUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DataItem {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(DataItem.class);
    @NotNull
    private String id;
    private String itemId;
    private List<String> nest;
    private DataItemType type;
    private Binning binning;
    private AggregationType aggregate;
    @JsonIgnore
    boolean sort;

    public static List<DataItem> dataItemsById(String id, Map<String, DataItem> allDataItems) {
        if (!allDataItems.containsKey(id)) {
            return Collections.emptyList();
        }
        DataItem item = allDataItems.get(id);
        if (item.isNestedDataItem()) {
            return item.getNest().stream().map(dataItemId -> DataItem.dataItemsById(dataItemId, allDataItems)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.singletonList(item);
    }

    public DataItem() {
        this.sort = false;
    }

    public DataItem(String id, String itemId, List<String> nest, DataItemType type, Binning binning, AggregationType aggregate) {
        this.id = id;
        this.itemId = itemId;
        this.nest = nest;
        this.type = type;
        this.binning = binning;
        this.aggregate = aggregate;
        this.sort = false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public List<String> getNest() {
        return this.nest;
    }

    public void setNest(List<String> nest) {
        this.nest = nest;
    }

    public DataItemType getType() {
        return this.type;
    }

    public void setType(DataItemType type) {
        this.type = type;
    }

    public Binning getBinning() {
        return this.binning;
    }

    public void setBinning(Binning binning) {
        this.binning = binning;
    }

    public AggregationType getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(AggregationType aggregate) {
        this.aggregate = aggregate;
    }

    public boolean getSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public boolean isNestedDataItem() {
        return this.nest != null && !this.nest.isEmpty();
    }

    public String toString() {
        return String.format("[ id: %s, itemId: %s, nest: [%s], binning: %s, aggregate: %s, type: %s]", new Object[]{this.id, this.itemId, this.nest == null ? "" : String.join((CharSequence)",", this.nest.toArray(new String[0])), this.binning, this.aggregate, this.type});
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        try {
            JSONObject b;
            if (this.id != null) {
                o.put("id", (Object)this.id);
            }
            if (this.itemId != null) {
                o.put("itemId", (Object)this.itemId);
            }
            if (this.nest != null) {
                o.put("nest", (Collection)new JSONArray(this.nest));
            }
            if (this.binning != null && (b = this.binning.toJSON()) != null) {
                o.put("binning", (Map)b);
            }
            if (this.aggregate != null && this.aggregate != AggregationType.NONE) {
                o.put("aggregate", (Object)this.aggregate.toString());
            }
            if (this.type != null) {
                o.put("type", (Object)this.type.toString());
            }
            this.sortJSON(o);
        }
        catch (JSONException e) {
            LOGGER.warn("Serialization error in DataItem.toJSON", e);
        }
        return o;
    }

    private void sortJSON(JSONObject o) {
        try {
            if (this.sort) {
                JSONObject sel = new JSONObject();
                sel.put("operation", (Object)"order");
                JSONObject order = new JSONObject();
                order.put("type", (Object)"asc");
                order.put("priority", 0);
                order.put("by", (Object)"caption");
                sel.put("sort", (Map)order);
                o.put("selection", (Collection)new JSONArray((Object[])new JSONObject[]{sel}));
            }
        }
        catch (JSONException e) {
            LOGGER.warn("Serialization error in DataItem.toJSON", e);
        }
    }

    public static DataItem fromJSON(JSONObject o) {
        String id = JsonUtils.getRequiredString(o, "id");
        String itemId = JsonUtils.getOptionalString(o, "itemId");
        List<String> nest = JsonUtils.getOptionalStringArray(o, "nest");
        DataItemType type = DataItemType.fromString(JsonUtils.getOptionalString(o, "type"));
        Binning binning = Binning.fromString(JsonUtils.getOptionalString(o, "binning"));
        AggregationType aggregate = AggregationType.fromString(JsonUtils.getOptionalString(o, "aggregate"));
        return new DataItem(id, itemId, nest, type, binning, aggregate);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.itemId).append(this.nest).append((Object)this.type).append((Object)this.binning).append((Object)this.aggregate).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataItem)) {
            return false;
        }
        DataItem other = (DataItem)DataItem.class.cast(obj);
        return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.itemId, (Object)other.itemId).append(this.nest, other.nest).append((Object)this.type, (Object)other.type).append((Object)this.binning, (Object)other.binning).append((Object)this.aggregate, (Object)other.aggregate).isEquals();
    }
}

