/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.types.SlotType;

public enum DataItemType {
    DATETIME("datetime"),
    CATEGORICAL("categorical"),
    CONTINUOUS("continuous");

    private final String type;

    private DataItemType(String type) {
        this.type = type;
    }

    @JsonValue
    public String toString() {
        return this.type;
    }

    @JsonCreator
    public static DataItemType fromString(String type) {
        for (DataItemType f : DataItemType.values()) {
            if (!f.type.equalsIgnoreCase(type)) continue;
            return f;
        }
        return null;
    }

    public SlotType toSlotType() {
        switch (this) {
            case DATETIME: 
            case CATEGORICAL: {
                return SlotType.CATEGORICAL;
            }
            case CONTINUOUS: {
                return SlotType.CONTINUOUS;
            }
        }
        throw new IllegalStateException("Invalid data item type: " + (Object)((Object)this));
    }

    public FieldType toFieldType() {
        switch (this) {
            case DATETIME: {
                return FieldType.DATETIME;
            }
            case CATEGORICAL: {
                return FieldType.CATEGORICAL;
            }
            case CONTINUOUS: {
                return FieldType.NUMERICAL;
            }
        }
        throw new IllegalStateException("Invalid data item type: " + (Object)((Object)this));
    }
}

