/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.types;

import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.types.SlotType;
import com.ibm.bi.predict.utils.JsonUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Slot {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(DataItem.class);
    @NotNull(message="name")
    private String name;
    @NotNull
    @Size(min=1, message="dataItems")
    private List<String> dataItems;
    @NotNull(message="type")
    private SlotType type;
    @Valid
    @NotNull(message="role")
    private RoleType role;

    public Slot() {
    }

    public Slot(String name, List<String> dataItems, SlotType type, RoleType role) {
        this.name = name;
        this.dataItems = dataItems;
        this.type = type;
        this.setRole(role);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getDataItems() {
        return this.dataItems;
    }

    public void setDataItems(List<String> dataItems) {
        this.dataItems = dataItems;
    }

    public SlotType getType() {
        return this.type;
    }

    public void setType(SlotType type) {
        this.type = type;
    }

    public RoleType getRole() {
        return this.role;
    }

    public void setRole(RoleType role) {
        this.role = role;
    }

    public String toString() {
        return String.format("[ name: %s, type: %s, role: %s, dataItems: %s ]", new Object[]{this.name, this.type, this.role, this.dataItems.toString()});
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.type).append((Object)this.role).append(this.dataItems).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)Slot.class.cast(obj);
        return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.type, (Object)other.type).append((Object)this.role, (Object)other.role).append(this.dataItems, other.dataItems).isEquals();
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        try {
            if (this.name != null) {
                o.put("name", (Object)this.name);
            }
            if (this.dataItems != null) {
                o.put("dataItems", (Collection)new JSONArray(this.dataItems));
            }
            if (this.type != null) {
                o.put("type", (Object)this.type.toString());
            }
            if (this.role != null) {
                o.put("role", (Object)this.role.toString());
            }
        }
        catch (JSONException e) {
            LOGGER.warn("Serialization error in DataItem.toJSON", e);
        }
        return o;
    }

    public static Slot fromJSON(JSONObject o) {
        String name = JsonUtils.getRequiredString(o, "name");
        List<String> dataItems = JsonUtils.getStringArray(o, "dataItems");
        if (dataItems.isEmpty()) {
            throw new BadParametersException("The 'dataItems' of a slot or use must have at least one entry");
        }
        String s = JsonUtils.getRequiredString(o, "type");
        SlotType type = SlotType.fromString(s);
        if (type == null) {
            throw new BadParametersException("Unknown slot or use 'type' '" + s + "'");
        }
        s = JsonUtils.getRequiredString(o, "role");
        RoleType role = RoleType.fromString(s);
        if (role == null) {
            throw new BadParametersException("Unknown slot or use 'role' '" + s + "'");
        }
        return new Slot(name, dataItems, type, role);
    }
}

