/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class EnvironmentInfo {
    private static final Logger logger = PredictLoggerFactory.getLogger(EnvironmentInfo.class);
    private static final double MEGABYTE = 1048576.0;
    private final String machineName = this.machineName();
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    private final double jvmMaxMemoryInMB = (double)Runtime.getRuntime().maxMemory() / 1048576.0;
    private final double startingUsedMemoryInMB = this.calculateUsedMemory();
    private final String javaType;
    private final String javaHome = System.getProperty("java.home");
    private final String javaVersion;
    private final String os;
    private double endingUsedMemoryInMB;

    public EnvironmentInfo() {
        this.javaType = System.getProperty("java.vendor");
        this.javaVersion = System.getProperty("java.version");
        this.os = System.getProperty("os.name");
    }

    public double getLostMemory() {
        return this.endingUsedMemoryInMB - this.startingUsedMemoryInMB;
    }

    public void setEndStatus() {
        this.endingUsedMemoryInMB = this.calculateUsedMemory();
    }

    private double calculateUsedMemory() {
        for (int i = 0; i < 3; ++i) {
            System.gc();
            System.runFinalization();
        }
        Runtime runtime = Runtime.getRuntime();
        return (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0;
    }

    private String machineName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "Unknown";
        }
    }

    public String getMachineName() {
        return this.machineName;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public double getJvmMaxMemoryInMB() {
        return this.jvmMaxMemoryInMB;
    }

    public double getStartingUsedMemoryInMB() {
        return this.startingUsedMemoryInMB;
    }

    public double getEndingUsedMemoryInMB() {
        return this.endingUsedMemoryInMB;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getOs() {
        return this.os;
    }

    public void logSystemInfo() {
        logger.debug("Environment info:");
        logger.debug(String.format("Java version: %s", this.getJavaVersion()));
        logger.debug(String.format("Java vendor: %s", this.getJavaType()));
        logger.debug(String.format("OS: %s", this.getOs()));
        logger.debug(String.format("Machine name: %s", this.getMachineName()));
        logger.debug(String.format("Max JVM heap size: %.3f MB", this.getJvmMaxMemoryInMB()));
        logger.debug(String.format("Number of available processors: %d", this.getAvailableProcessors()));
    }
}

