/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.ibm.bi.predict.exceptions.BadParametersException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class JsonUtils {
    private static final String REQUIRED_FIELD_MSG = "Required field '";

    private JsonUtils() {
    }

    public static <T> T getValue(Class<T> clazz, JSONObject json, String key, String errorMessage) {
        try {
            T value = clazz.cast(json.get(key));
            if (value == null) {
                return JsonUtils.returnNullOrThrow(errorMessage, Optional.empty());
            }
            return value;
        }
        catch (Exception e) {
            return JsonUtils.returnNullOrThrow(errorMessage, Optional.of(e));
        }
    }

    public static <T> T returnNullOrThrow(String errorMessage, Optional<Exception> e) {
        if (errorMessage != null) {
            if (e.isPresent()) {
                throw new BadParametersException(errorMessage, e.get());
            }
            throw new BadParametersException(errorMessage);
        }
        return null;
    }

    public static String getRequiredString(JSONObject obj, String key) {
        try {
            return JsonUtils.asString(obj.get(key));
        }
        catch (Exception e) {
            throw new BadParametersException(REQUIRED_FIELD_MSG + key + "' missing or not string", e);
        }
    }

    public static String getOptionalString(JSONObject obj, String key) {
        return JsonUtils.getOptionalString(obj, key, null);
    }

    public static String getOptionalString(JSONObject obj, String key, String defaultValue) {
        try {
            Object o = obj.opt(key);
            if (o == null) {
                return defaultValue;
            }
            return (String)o;
        }
        catch (Exception e) {
            throw new BadParametersException("Optional field '" + key + "' not string", e);
        }
    }

    static String asString(Object o) {
        if (o == null) {
            throw new BadParametersException("object is null");
        }
        return (String)o;
    }

    public static List<String> getStringArray(JSONObject obj, String key) {
        JSONArray array;
        try {
            array = obj.getJSONArray(key);
        }
        catch (Exception e) {
            throw new BadParametersException(REQUIRED_FIELD_MSG + key + "' missing or not array", e);
        }
        int n = array.length();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            try {
                result.add(JsonUtils.asString(array.get(i)));
                continue;
            }
            catch (Exception e) {
                throw new BadParametersException("Field '" + key + "' entry " + i + " missing or not string", e);
            }
        }
        return result;
    }

    public static List<String> getOptionalStringArray(JSONObject obj, String key) {
        if (obj.opt(key) == null) {
            return Collections.emptyList();
        }
        return JsonUtils.getStringArray(obj, key);
    }

    public static List<String> getOptionalStringArrayOrNull(JSONObject obj, String key) {
        Object v = obj.opt(key);
        if (v == null || !(v instanceof JSONArray)) {
            return null;
        }
        JSONArray a = (JSONArray)v;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < a.size(); ++i) {
            Object o = a.get(i);
            if (!(o instanceof String)) {
                return null;
            }
            result.add((String)o);
        }
        return result;
    }

    public static int getOptionalInt(JSONObject obj, String key, int defaultValue) {
        return obj.optInt(key, defaultValue);
    }

    public static double getOptionalDouble(JSONObject obj, String key, double defaultValue) {
        return obj.optDouble(key, defaultValue);
    }

    public static boolean getOptionalBoolean(JSONObject obj, String key, boolean defaultValue) {
        return obj.optBoolean(key, defaultValue);
    }

    public static JSONObject getRequiredJSONObject(JSONObject object, String key) {
        try {
            return object.getJSONObject(key);
        }
        catch (Exception e) {
            throw new BadParametersException("Key " + key + "' missing or not JSONObject", e);
        }
    }

    public static JSONObject getOptionalJSONObject(JSONObject object, String key) {
        try {
            return object.getJSONObject(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JSONArray getRequiredJSONArray(JSONObject obj, String key) {
        try {
            return obj.getJSONArray(key);
        }
        catch (Exception e) {
            throw new BadParametersException(REQUIRED_FIELD_MSG + key + "' missing or not JSONArray", e);
        }
    }

    public static JSONArray getOptionalJSONArray(JSONObject obj, String key) {
        try {
            return obj.optJSONArray(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JSONArray getOptionalJSONArray(JSONObject obj, String key, JSONArray defaultValue) {
        try {
            return obj.optJSONArray(key, defaultValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JSONObject getRequiredJSONObject(JSONArray array, int i, String key) {
        try {
            return array.getJSONObject(i);
        }
        catch (Exception e) {
            throw new BadParametersException("Entry " + i + " in field '" + key + "' missing or not JSONObject", e);
        }
    }

    public static JSONObject getOptionalJSONObject(JSONArray array, int i) {
        try {
            return array.getJSONObject(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Object> jsonObjectToMap(JSONObject object) {
        return object;
    }
}

