/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import java.util.Arrays;
import java.util.stream.IntStream;

public class MultiArrayIndexer<T> {
    private final T[][] arrays;
    private final int[] counts;
    private final int[] index;

    public MultiArrayIndexer(T[] ... arrays) {
        this.arrays = arrays;
        this.counts = Arrays.stream(arrays).mapToInt(array -> ((Object[])array).length).toArray();
        this.index = Arrays.stream(this.counts).map(i -> i > 0 ? 0 : -1).toArray();
        this.index[this.index.length - 1] = -1;
    }

    public boolean next() {
        for (int i = this.index.length - 1; i >= 0; --i) {
            if (this.counts[i] == 0) continue;
            int n = i;
            this.index[n] = this.index[n] + 1;
            if (this.index[n] == this.counts[i]) {
                if (i == 0) {
                    return false;
                }
                this.index[i] = 0;
                continue;
            }
            return true;
        }
        return this.index[0] < this.counts[0];
    }

    public int[] currentIndex() {
        return this.index;
    }

    public T currentValue(int i) {
        return this.counts[i] == 0 ? null : (T)this.arrays[i][this.index[i]];
    }

    public T[] currentValues() {
        return IntStream.range(0, this.index.length).mapToObj(this::currentValue).toArray();
    }
}

