/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Optional;
import java.util.function.Supplier;

public class ScratchMemoryAllocation {
    private static final Logger logger = PredictLoggerFactory.getLogger(ScratchMemoryAllocation.class);

    private ScratchMemoryAllocation() {
    }

    public static <T> Optional<T> allocate(Supplier<T> supplier, int timeoutInMilliseconds) {
        long maxTime = System.currentTimeMillis() + (long)timeoutInMilliseconds;
        int retries = 0;
        while (System.currentTimeMillis() < maxTime) {
            Optional<T> result;
            if ((result = ScratchMemoryAllocation.tryAllocate(supplier, ++retries)).isPresent()) {
                return result;
            }
            long waitTime = Math.min(1000L, maxTime - System.currentTimeMillis());
            if (waitTime < 100L) {
                waitTime = 100L;
            }
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread was interrupted", e);
            }
        }
        logger.warn(String.format("Unable to allocate memory within the limit of %s ms", timeoutInMilliseconds));
        return Optional.empty();
    }

    private static <T> Optional<T> tryAllocate(Supplier<T> supplier, int retries) {
        try {
            T t = supplier.get();
            return Optional.of(t);
        }
        catch (OutOfMemoryError error) {
            logger.debug(String.format("Failed to allocate on attempt #%s", retries));
            return Optional.empty();
        }
        catch (Exception e) {
            logger.debug(String.format("Supplier caused exception on attempt #%s.", retries), e);
            return Optional.empty();
        }
    }
}

