/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.thirdparty;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.thirdparty.BiServiceCallException;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class BIService {
    private static final Logger LOG = PredictLoggerFactory.getLogger(BIService.class);
    private final RESTClientFactory clientFactory;
    private final Map<String, Object> httpContext;

    public BIService(RESTClientFactory clientFactory, Map<String, Object> httpContext) {
        this.clientFactory = clientFactory;
        this.httpContext = httpContext;
    }

    public BIService(Map<String, Object> context) {
        this.httpContext = context;
        this.clientFactory = RESTClientFactory.getInstance();
    }

    public JSONObject post(String url, JSONObject payload) throws IOException, JSONException {
        return this.makeServiceCall(url, "POST", payload);
    }

    public JSONObject get(String url) throws IOException, JSONException {
        return this.makeServiceCall(url, "GET", null);
    }

    public JSONObject postJsonAsMultipart(String url, String name, JSONObject multipartData) {
        String boundary = this.generateBoundary();
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody(name, multipartData.toString(), ContentType.APPLICATION_JSON).setBoundary(boundary).build();
        ImmutableMap headers = ImmutableMap.builder().put((Object)"Content-Type", (Object)this.multipartContentType(boundary)).put((Object)"Accept", (Object)ContentType.APPLICATION_JSON.getMimeType()).build();
        return this.postEntity(url, entity, Maps.newHashMap((Map)headers));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject postEntity(String url, HttpEntity entity, Map<String, String> headers) {
        try (RESTClient client = this.getRestClient();){
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                client.setRequestHeader(entry.getKey(), entry.getValue());
            }
            int statusCode = client.createResource(url, entity);
            if (statusCode == 200) {
                JSONObject jSONObject = new JSONObject(this.getResponseBody(client, url));
                return jSONObject;
            }
            String string = String.format("Error calling bi service. URL: %s, Message: %s", url, client.getErrorResponseString());
            throw new BiServiceCallException(string, statusCode, url);
        }
        catch (IOException | JSONException e) {
            LOG.warn("Error while posting entity. Reason: " + e.getMessage(), e);
            throw new PredictException("Error while posting entity. Reason: " + e.getMessage(), e);
        }
    }

    private String getResponseBody(RESTClient client, String url) {
        try {
            return client.getResponseAsJsonObject().toString();
        }
        catch (IOException e) {
            LOG.warn("Error while getting response body. Reason: " + e.getMessage(), (Throwable)e);
            throw new BiServiceCallException("Error while getting response body. Reason: " + e.getMessage(), 500, url, e);
        }
    }

    private String generateBoundary() {
        return "---------------" + UUID.randomUUID().toString();
    }

    private String multipartContentType(String boundary) {
        return ContentType.MULTIPART_FORM_DATA + ";boundary=" + boundary;
    }

    private JSONObject makeServiceCall(String url, String method, JSONObject payload) throws IOException, JSONException {
        RESTClient client = this.getRestClient();
        int statusCode = this.callService(client, url, method, payload);
        if (statusCode != 200) {
            String message = String.format("Error calling bi service. URL: %s, Message: %s", url, client.getErrorResponseString());
            LOG.error(message);
            client.close();
            throw new BiServiceCallException(message, statusCode, url);
        }
        JSONObject retVal = new JSONObject(client.getResponseAsJsonObject().toString());
        client.close();
        return retVal;
    }

    private int callService(RESTClient client, String url, String method, JSONObject payload) throws IOException {
        if ("GET".equals(method)) {
            return client.getResource(url);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(payload.toString().getBytes());
        return client.createResource(url, "application/json", (long)payload.toString().length(), (InputStream)stream);
    }

    private RESTClient getRestClient() {
        HttpServletRequest request = (HttpServletRequest)this.httpContext.get("httpServletRequest");
        return this.clientFactory.getClient(request);
    }
}

