/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.thirdparty;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.json.JsonDataAccessProvider;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.thirdparty.BIService;
import com.ibm.bi.predict.thirdparty.FieldIdAndType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class QueryService
extends BIService {
    private static final Logger log = PredictLoggerFactory.getLogger(BIService.class);
    private static final String DATA_SERVICE = "bi/v1/datasets/%s/data?type=module";
    private static final long DATA_ROWS_LIMIT = 10000L;
    private int seedLower = 10000;
    private int seedUpper = 99999;

    public QueryService(Map<String, Object> context) {
        super(context);
    }

    public DataAccessProvider getData(String dataSetId, FieldIdAndType target, Collection<FieldIdAndType> inputs) {
        return this.getData(dataSetId, target, inputs, new JSONArray());
    }

    public DataAccessProvider getData(String dataSetId, FieldIdAndType target, Collection<FieldIdAndType> inputs, JSONArray filters) {
        this.validate(dataSetId, target, inputs);
        JSONObject requestBody = this.createRequestBody(target, inputs, filters);
        return this.getData(dataSetId, requestBody);
    }

    private void validate(String datasetId, FieldIdAndType target, Collection<FieldIdAndType> inputs) {
        if (this.isNullOrEmpty(datasetId)) {
            log.warn("Invalid datasetId: {}", (Object)datasetId);
            throw new IllegalArgumentException("Invalid datasetId: " + datasetId);
        }
        if (this.isNullOrEmpty(target)) {
            log.warn("Invalid target: {}", (Object)target);
            throw new IllegalArgumentException("Invalid target: " + target);
        }
        if (this.isNullOrEmpty(inputs)) {
            log.warn("Invalid inputIds: {}", inputs);
            throw new IllegalArgumentException("Invalid inputIds: " + inputs);
        }
    }

    private JSONObject createRequestBody(FieldIdAndType target, Collection<FieldIdAndType> inputs, JSONArray filters) {
        try {
            JSONObject requestBody = new JSONObject();
            requestBody.put("dataItems", (Collection)this.getDataItems(target, inputs));
            requestBody.put("limit", 10000L);
            requestBody.put("projections", (Collection)this.getProjections(target, inputs));
            requestBody.put("sampling", (Map)this.getSampling());
            requestBody.put("filters", (Collection)filters);
            requestBody.put("version", (Object)"1");
            return requestBody;
        }
        catch (JSONException e) {
            log.warn("Error while creating request body. Reason: " + e.getMessage(), (Throwable)e);
            throw new PredictException("Error while creating request body. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private DataAccessProvider getData(String dataSetId, JSONObject requestBody) {
        JSONObject responseBody = this.postJsonAsMultipart(this.getDataServiceUrl(dataSetId), "querySpec", requestBody);
        return new JsonDataAccessProvider(responseBody);
    }

    private JSONArray getDataItems(FieldIdAndType target, Collection<FieldIdAndType> inputs) {
        JSONArray dataItems = new JSONArray();
        dataItems.add((Object)this.getDataItem(target));
        dataItems.addAll((Collection)inputs.stream().map(this::getDataItem).collect(Collectors.toList()));
        return dataItems;
    }

    private JSONObject getDataItem(FieldIdAndType item) {
        try {
            JSONObject dataItem = new JSONObject();
            dataItem.put("id", (Object)item.id());
            dataItem.put("itemId", (Object)item.id());
            dataItem.put("selection", (Collection)new JSONArray());
            if (item.isContinuous()) {
                dataItem.put("aggregate", (Object)"none");
            }
            return dataItem;
        }
        catch (JSONException e) {
            log.warn("Error while creating data items JSON. Reason: " + e.getMessage(), (Throwable)e);
            throw new PredictException("Error while creating data items JSON. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private JSONObject getSampling() {
        try {
            JSONObject sampling = new JSONObject();
            sampling.put("rowCount", 10000L);
            sampling.put("seed", this.seed());
            return sampling;
        }
        catch (JSONException e) {
            log.warn("Error while creating sampling JSON. Reason: " + e.getMessage(), (Throwable)e);
            throw new PredictException("Error while creating sampling JSON. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private JSONArray getProjections(FieldIdAndType target, Collection<FieldIdAndType> inputs) {
        JSONArray projections = new JSONArray();
        projections.add((Object)target.id());
        projections.addAll((Collection)inputs.stream().map(FieldIdAndType::id).collect(Collectors.toList()));
        return projections;
    }

    private String getDataServiceUrl(String dataSetId) {
        return String.format(DATA_SERVICE, dataSetId);
    }

    private int seed() {
        return ThreadLocalRandom.current().nextInt(this.seedLower, this.seedUpper + 1);
    }

    private boolean isNullOrEmpty(Object o) {
        if (o instanceof String) {
            return StringUtils.isBlank((String)((String)o));
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof FieldIdAndType) {
            return this.isNullOrEmpty(((FieldIdAndType)o).id()) || this.isNullOrEmpty(((FieldIdAndType)o).type());
        }
        return o == null;
    }
}

