/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.thirdparty.smarts;

import com.google.common.base.Strings;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.thirdparty.BIService;
import com.ibm.bi.predict.thirdparty.BiServiceCallException;
import com.ibm.bi.predict.thirdparty.smarts.SmartsModule;
import com.ibm.bi.predict.thirdparty.smarts.SmartsModuleParser;
import com.ibm.bi.predict.thirdparty.smarts.SmartsService;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.io.IOException;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class RemoteSmartsService
implements SmartsService {
    private static final Logger logger = PredictLoggerFactory.getLogger(RemoteSmartsService.class);
    private static final String SMARTS_GET_URL = "bi/v1/smarts/module/%s";
    private static final String SMARTS_POST_URL = "bi/v1/smarts/module";
    private final BIService biService;

    public RemoteSmartsService(BIService service) {
        this.biService = service;
    }

    @Override
    public SmartsModule smartsModuleByModuleId(String moduleId) {
        logger.info("Getting Smarts module by id - id={}", (Object)moduleId);
        if (Strings.isNullOrEmpty((String)moduleId)) {
            logger.warn("Error getting Smarts module. Found null or empty module ID");
            throw new IllegalArgumentException("Module ID must be present and non-empty");
        }
        try {
            String smartsModuleUrl = this.getSmartsModuleUrl(moduleId);
            logger.info("Requesting Smarts module - url={}", (Object)smartsModuleUrl);
            JSONObject smartsModule = this.biService.get(smartsModuleUrl);
            logger.info("Successfully retrieved Smarts module");
            return SmartsModuleParser.parse(smartsModule);
        }
        catch (BiServiceCallException | IOException | JSONException e) {
            logger.warn("Failed to get Smarts module by id - reason=" + ((Throwable)e).getMessage(), (Throwable)e);
            throw new PredictException("Failed to get Smarts module - reason=" + ((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    private String getSmartsModuleUrl(String moduleId) {
        return String.format(SMARTS_GET_URL, moduleId);
    }

    @Override
    public SmartsModule smartsModuleByTempModule(String tempModule) {
        logger.info("Getting Smarts module from tempModule");
        if (Strings.isNullOrEmpty((String)tempModule)) {
            logger.warn("Error getting Smarts module. Found null or empty module ID");
            throw new IllegalArgumentException("Module ID must be present and non-empty");
        }
        try {
            JSONObject jsonTempModule = (JSONObject)JSON.parse((String)tempModule);
            String smartsModuleUrl = SMARTS_POST_URL;
            logger.info("Requesting Smarts module by POST - url={}", (Object)smartsModuleUrl);
            JSONObject smartsModule = this.biService.post(smartsModuleUrl, jsonTempModule);
            logger.info("Successfully retrieved Smarts module");
            return SmartsModuleParser.parse(smartsModule);
        }
        catch (BiServiceCallException | IOException | JSONException e) {
            logger.warn("Failed to get Smarts module from tempModule - reason=" + ((Throwable)e).getMessage(), (Throwable)e);
            throw new PredictException("Failed to get Smarts module - reason=" + ((Throwable)e).getMessage(), (Throwable)e);
        }
    }
}

