/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.thirdparty.smarts;

import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.thirdparty.smarts.Concept;
import com.ibm.bi.predict.thirdparty.smarts.SmartsModule;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class SmartsModuleParser {
    private static final Logger logger = PredictLoggerFactory.getLogger(SmartsModuleParser.class);
    private final JSONObject smartsModuleJson;

    public SmartsModuleParser(JSONObject smartsModuleJson) {
        this.smartsModuleJson = smartsModuleJson;
    }

    public static SmartsModule parse(JSONObject smartsModuleJson) {
        logger.debug("Parsing Smarts module JSON - json={}", (Object)smartsModuleJson);
        SmartsModuleParser parser = new SmartsModuleParser(smartsModuleJson);
        return new SmartsModule(parser.id(), parser::conceptsForField);
    }

    public String id() {
        return JsonHelpers.getString((JSONObject)this.smartsModuleJson, (String)"id");
    }

    public boolean fieldExists(String fieldId) {
        try {
            this.fieldJson(fieldId);
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Could not find field - field={}", (Object)fieldId, (Object)e);
            return false;
        }
    }

    public List<Concept> conceptsForField(String fieldId) {
        logger.info("Getting Smarts concepts for field - field={}", (Object)fieldId);
        if (!this.fieldExists(fieldId)) {
            return Collections.emptyList();
        }
        return JsonHelpers.streamObjects((JSONArray)this.rawConceptsForField(fieldId)).map(this::parseRawConcept).collect(Collectors.toList());
    }

    private Concept parseRawConcept(JSONObject rawConcept) {
        String id = JsonHelpers.getString((JSONObject)rawConcept, (String)"conceptID");
        double confidence = JsonHelpers.getDouble((JSONObject)rawConcept, (String)"confidence");
        return new Concept(id, confidence);
    }

    private JSONObject fieldJson(String id) {
        return JsonHelpers.streamObjects((JSONArray)this.fieldsJson()).filter(this.isField(id)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find field: " + id));
    }

    private Predicate<JSONObject> isField(String id) {
        return fieldJson -> {
            JSONObject o = JsonHelpers.getObject((JSONObject)fieldJson, (String)"column");
            return id.equals(JsonHelpers.getString((JSONObject)o, (String)"idForExpression"));
        };
    }

    private JSONArray rawConceptsForField(String fieldId) {
        JSONObject field = this.fieldJson(fieldId);
        return JsonHelpers.getArray((JSONObject)JsonHelpers.getObject((JSONObject)JsonHelpers.getObject((JSONObject)field, (String)"column"), (String)"semanticInfo"), (String)"concepts");
    }

    private JSONArray fieldsJson() {
        return JsonHelpers.getArray((JSONObject)this.data(), (String)"item");
    }

    private JSONObject data() {
        return JsonHelpers.getObjFromArray((JSONArray)JsonHelpers.getArray((JSONObject)this.smartsModuleJson, (String)"datasets"), (int)0);
    }
}

