/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase;

import com.spss.ac.acbase.DirectorLocalRunner;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.analyticframework.api.ApplicationInfo;
import com.spss.analyticframework.api.ComponentId;
import com.spss.analyticframework.api.ComponentOutput;
import com.spss.analyticframework.api.ExecutionConfig;
import com.spss.analyticframework.api.IdMapping;
import com.spss.analyticframework.api.MessageService;
import com.spss.analyticframework.api.StreamExecutor;
import com.spss.analyticframework.api.StreamExecutorService;
import com.spss.analyticframework.api.Traversable;
import com.spss.analyticframework.api.TraversableBuilder;
import com.spss.analyticframework.api.container.ContainerService;
import com.spss.analyticframework.api.parameters.Parameters;
import com.spss.analyticframework.api.pull.ContainerChannel;
import com.spss.analyticframework.api.pull.RecordChannel;
import com.spss.analyticframework.api.pull.RecordIterator;
import com.spss.analyticframework.api.stream.ExecutionStream;
import com.spss.analyticframework.api.stream.StreamComponent;
import com.spss.analyticframework.api.temp.TempFileService;
import com.spss.analyticframework.cache.CacheManager;
import com.spss.analyticframework.commons.AFUtils;
import com.spss.analyticframework.commons.TraversableOperations;
import com.spss.analyticframework.componentapi.ComponentContext;
import com.spss.analyticframework.directorapi.DirectorContext;
import com.spss.analyticframework.directorapi.DirectorExecutionResults;
import com.spss.analyticframework.directorapi.ExecutionDirector;
import com.spss.datamodel.DataModel;
import com.spss.datamodel.Fields;
import com.spss.datarecord.DataVal;
import com.spss.datarecord.OpaqueVal;
import com.spss.datarecord.Record;
import com.spss.utilities.functional.Function1;
import com.spss.utilities.functional.Function1Unit;
import com.spss.utilities.functional.Tuple2;
import com.spss.utilities.i18n.LocMsgId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ComponentUtils {
    public static IdMapping<ComponentOutput> runComponent(StreamExecutorService executorService, ExecutionStream stream, RecordChannel ... inputChannels) {
        return ComponentUtils.runComponent(executorService, stream, null, (RecordChannel)null, inputChannels);
    }

    public static IdMapping<ComponentOutput> runComponent(StreamExecutorService executorService, ExecutionStream stream, ComponentId targetID, Tuple2<String, InputStream> sharedData, RecordChannel ... inputChannels) {
        RecordChannel sharedChannel = sharedData != null && targetID != null ? ComponentUtils.asRecordChannel(sharedData) : null;
        return ComponentUtils.runComponent(executorService, stream, targetID, sharedChannel, inputChannels);
    }

    public static IdMapping<ComponentOutput> runComponent(StreamExecutorService executorService, ExecutionStream stream, ComponentId targetID, final RecordChannel sharedChannel, final RecordChannel ... inputChannels) {
        String target;
        if (sharedChannel != null && targetID != null) {
            String targetComp = null;
            for (StreamComponent comp : stream.getComponents()) {
                if (!comp.getComponentId().equals(targetID.getComponentId()) || !comp.getModuleId().equals(targetID.getModuleId())) continue;
                targetComp = comp.getId();
                break;
            }
            target = targetComp;
        } else {
            target = null;
        }
        ExecutionStream execution = new ExecutionStream(stream){
            {
                super(x0);
                final String dataId = (String)this.getDataConnections().getStartNodes().iterator().next();
                this.applicationInputData = new IdMapping<TraversableBuilder<RecordChannel>>(this.applicationInputData){
                    {
                        super(x0);
                        this.mergeChannel(dataId, inputChannels);
                        this.mergeChannel(target, sharedChannel);
                    }

                    private void mergeChannel(String id, RecordChannel ... channels) {
                        if (id != null && channels != null) {
                            TraversableBuilder item = (TraversableBuilder)this.getItem(id);
                            if (item != null) {
                                ArrayList<TraversableBuilder> l = new ArrayList<TraversableBuilder>();
                                l.add(AFUtils.toTraversableBuilder((Object[])channels));
                                l.add(item);
                                this.mapId(id, TraversableOperations.composeTraversableBuilders(l));
                            } else {
                                this.mapId(id, AFUtils.toTraversableBuilder((Object[])channels));
                            }
                        }
                    }
                };
            }
        };
        StreamExecutor streamExecutor = executorService.build(execution);
        IdMapping outputs = streamExecutor.getOutputs();
        return outputs;
    }

    public static StreamComponent createStreamComponent(String streamID, String compId, String modId, Parameters params) {
        return ComponentUtils.createStreamComponent(streamID, compId, modId, params, false);
    }

    public static StreamComponent createStreamComponent(final String streamID, final String compId, final String modId, final Parameters params, final boolean cache) {
        return new StreamComponent(){
            {
                this.id = streamID;
                this.componentId = compId;
                this.moduleId = modId;
                this.parameters = params;
                this.cacheOutput = cache;
            }
        };
    }

    public static ContainerChannel getContainerChannel(IdMapping<ComponentOutput> outputs) {
        ContainerChannel result;
        block0: {
            result = null;
            Iterable comOuts = outputs.getItems();
            Iterator iterator = comOuts.iterator();
            if (!iterator.hasNext()) break block0;
            ComponentOutput comOut = (ComponentOutput)iterator.next();
            result = comOut.getContainerChannel();
        }
        return result;
    }

    public static Traversable<RecordChannel> getRecordChannels(IdMapping<ComponentOutput> outputs) {
        Traversable result;
        block0: {
            result = null;
            Iterable comOuts = outputs.getItems();
            Iterator iterator = comOuts.iterator();
            if (!iterator.hasNext()) break block0;
            ComponentOutput comOut = (ComponentOutput)iterator.next();
            result = comOut.getRecordChannels();
        }
        return result;
    }

    public static RecordChannel getRecordChannel(IdMapping<ComponentOutput> outputs) {
        RecordChannel result;
        block0: {
            ComponentOutput comOut;
            Traversable it;
            result = null;
            Iterable comOuts = outputs.getItems();
            Iterator iterator = comOuts.iterator();
            if (!iterator.hasNext() || !(it = (comOut = (ComponentOutput)iterator.next()).getRecordChannels()).hasNext()) break block0;
            result = (RecordChannel)it.next();
        }
        return result;
    }

    public static RecordChannel asRecordChannel(DirectorExecutionResults previousResults) {
        DirectorExecutionResults.Result result;
        block0: {
            DirectorExecutionResults.Result curResult;
            result = null;
            Iterator iterator = previousResults.iterator();
            if (!iterator.hasNext()) break block0;
            result = curResult = (DirectorExecutionResults.Result)iterator.next();
        }
        return result.asRecordChannel();
    }

    public static TraversableBuilder<RecordChannel> asRecordChannels(Map<String, ACSerializable> sharedData) {
        ArrayList<RecordChannel> channelList = new ArrayList<RecordChannel>(sharedData.size());
        for (Map.Entry<String, ACSerializable> entry : sharedData.entrySet()) {
            channelList.add(ComponentUtils.asRecordChannel(entry.getKey(), entry.getValue()));
        }
        return AFUtils.toTraversableBuilder(channelList);
    }

    public static RecordChannel asRecordChannel(Tuple2<String, InputStream> sharedData) {
        return ComponentUtils.asRecordChannel((String)sharedData._1(), ComponentUtils.asOpaqueVal((InputStream)sharedData._2()));
    }

    public static RecordChannel asRecordChannel(String channelName, ACSerializable object) {
        return ComponentUtils.asRecordChannel(channelName, ComponentUtils.asOpaqueVal(object));
    }

    public static RecordChannel asRecordChannel(final String channelName, final OpaqueVal sharedData) {
        return new RecordChannel(){

            public DataModel getDataModel() {
                return new DataModel(){
                    {
                        this.fields = new Fields();
                    }
                };
            }

            public String getName() {
                return channelName;
            }

            public RecordIterator getRecordIterator() {
                return new RecordIterator(){
                    private boolean hasNext = true;

                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    public Record next() {
                        this.hasNext = false;
                        return new Record(){

                            public DataVal getField(int arg0) {
                                return sharedData;
                            }

                            public int getNumFields() {
                                return 1;
                            }
                        };
                    }

                    public float getProgress() {
                        return 1.0f;
                    }
                };
            }
        };
    }

    public static Traversable<RecordChannel> getEmptyChannelIter() {
        return new Traversable<RecordChannel>(){

            public boolean hasNext() {
                return false;
            }

            public RecordChannel next() {
                return null;
            }
        };
    }

    public static OpaqueVal asOpaqueVal(InputStream inputStream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bos.toByteArray());
        return new OpaqueVal(buffer);
    }

    public static OpaqueVal asOpaqueVal(ACSerializable obj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutput = new DataOutputStream(bos);
            obj.writeObject(dataOutput);
        }
        catch (IOException e) {
            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bos.toByteArray());
        return new OpaqueVal(buffer);
    }

    public static OpaqueVal asOpaqueVal(Function1Unit<DataOutput> fun) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(bos);
        fun.apply((Object)dataOutput);
        ByteBuffer buffer = ByteBuffer.wrap(bos.toByteArray());
        return new OpaqueVal(buffer);
    }

    public static Tuple2<String, InputStream> asSharedData(String name, ACSerializable shared) {
        return new Tuple2((Object)name, (Object)ComponentUtils.asInputStream(shared));
    }

    public static InputStream asInputStream(ACSerializable obj) {
        ByteArrayInputStream result = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutput = new DataOutputStream(bos);
            obj.writeObject(dataOutput);
            result = new ByteArrayInputStream(bos.toByteArray());
        }
        catch (IOException e) {
            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        return result;
    }

    public static <T extends ACSerializable> T readOjbect(Class<T> clazz, OpaqueVal opaque) {
        ACSerializable result = null;
        try {
            InputStream inStream = opaque.asInputStream();
            DataInputStream dataInput = new DataInputStream(inStream);
            result = (ACSerializable)clazz.newInstance();
            result.readObject(dataInput);
        }
        catch (Exception e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        return (T)result;
    }

    public static <T> T readObject(OpaqueVal opaque, Function1<DataInput, T> fun) {
        Object result = null;
        try {
            InputStream inStream = opaque.asInputStream();
            DataInputStream dataInput = new DataInputStream(inStream);
            result = fun.apply((Object)dataInput);
        }
        catch (Exception e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        return (T)result;
    }

    public static <T extends ACSerializable> T readObject(Class<T> clazz, RecordChannel channel) {
        RecordIterator it = channel.getRecordIterator();
        Record record = (Record)it.next();
        return ComponentUtils.readObject(clazz, record);
    }

    public static <T extends ACSerializable> T readObject(Class<T> clazz, Record record) {
        DataVal val = record.getField(0);
        if (DataVal.DataType.OPAQUE == val.getDataType()) {
            return ComponentUtils.readOjbect(clazz, (OpaqueVal)val);
        }
        throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static Tuple2<String, Collection<InputStream>> asInstructions(String insName, Iterable<? extends ACSerializable> insIt) {
        void var5_7;
        ArrayList<byte[]> insInBytes = new ArrayList<byte[]>();
        int maxLen = 0;
        for (ACSerializable aCSerializable : insIt) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                DataOutputStream dataOutput = new DataOutputStream(bos);
                aCSerializable.writeObject(dataOutput);
                byte[] bytes = bos.toByteArray();
                if (bytes.length > maxLen) {
                    maxLen = bytes.length;
                }
                insInBytes.add(bytes);
            }
            catch (IOException e) {
                throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
        }
        ArrayList<ByteArrayInputStream> result = new ArrayList<ByteArrayInputStream>(insInBytes.size());
        boolean bl = false;
        while (var5_7 < insInBytes.size()) {
            byte[] bytes = (byte[])insInBytes.get((int)var5_7);
            if (bytes.length != maxLen) {
                result.add(new ByteArrayInputStream(Arrays.copyOf(bytes, maxLen)));
            } else {
                result.add(new ByteArrayInputStream(bytes));
            }
            ++var5_7;
        }
        return new Tuple2((Object)insName, result);
    }

    public static DirectorContext wrapAsDirectorContext(final ComponentContext context) {
        return new DirectorContext(){

            public String resolvePath(String arg0) {
                return context.resolvePath(arg0);
            }

            public ApplicationInfo getApplicationInfo() {
                return context.getApplicationInfo();
            }

            public ContainerService getContainerService() {
                return context.getContainerService();
            }

            public MessageService getMessageService() {
                return context.getMessageService();
            }

            public TempFileService getTempFileService() {
                return context.getTempFileService();
            }

            public StreamExecutorService getStreamExecutorService() {
                return context.getStreamExecutorService();
            }
        };
    }

    public static DirectorLocalRunner runDirector(ExecutionDirector director, DirectorContext context, Parameters parameters, ContainerChannel inputContainer, RecordChannel inputChannel) {
        DirectorLocalRunner runner = new DirectorLocalRunner(director);
        runner.init(context, parameters, true);
        if (inputChannel != null) {
            runner.setInputData((TraversableBuilder<RecordChannel>)AFUtils.toTraversableBuilder((Object[])new RecordChannel[]{inputChannel}));
        }
        if (inputContainer != null) {
            runner.setInputContainers((TraversableBuilder<ContainerChannel>)AFUtils.toTraversableBuilder((Object[])new ContainerChannel[]{inputContainer}));
        }
        return runner;
    }

    public static CacheManager getCacheManager(StreamExecutorService executorService) {
        CacheManager result = null;
        try {
            StreamExecutor executor = executorService.build(new ExecutionStream());
            Class<?> clazz = executor.getClass();
            Field field = clazz.getDeclaredField("cacheManager");
            field.setAccessible(true);
            result = (CacheManager)field.get(executor);
        }
        catch (Exception e) {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        return result;
    }

    public static ExecutionDirector getExecutionDirctor(StreamExecutorService executorService, String moduleId, String directorId) {
        ExecutionDirector result = null;
        ExecutionConfig config = null;
        try {
            StreamExecutor executor = executorService.build(new ExecutionStream());
            Class<?> clazz = executor.getClass();
            Field field = clazz.getDeclaredField("config");
            field.setAccessible(true);
            config = (ExecutionConfig)field.get(executor);
        }
        catch (Exception e) {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        if (config != null) {
            result = config.getDirectorProvider().getDirector(moduleId, directorId);
        }
        if (result == null) {
            throw new ACException("Can't find director", (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        return result;
    }

    public static Object simulateSerializtion(ACSerializable obj) {
        ACSerializable result = null;
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                DataOutputStream dataOutput = new DataOutputStream(os);
                obj.writeObject(dataOutput);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                DataInputStream dataInput = new DataInputStream(is);
                result = (ACSerializable)clazz.newInstance();
                result.readObject(dataInput);
            }
            catch (IOException e) {
                throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
            catch (InstantiationException e) {
                throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
        }
        return result;
    }
}

