/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.channels;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.analyticframework.api.container.ContainerEntry;
import com.spss.analyticframework.api.container.ContainerService;
import com.spss.analyticframework.api.container.MetaData;
import com.spss.analyticframework.api.container.ReadableContainer;
import com.spss.analyticframework.api.container.WritableContainer;
import com.spss.utilities.functional.Tuple2;
import com.spss.utilities.i18n.LocMsgId;
import com.spss.utilities.io.IOUtils;
import com.spss.utilities.mimetype.MimeType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContainerUtils {
    public static Tuple2<WritableContainer, OutputStream> createOutputContainer(ContainerService containerService, String name, String entryName, MimeType mimeType) {
        MetaData metaData = new MetaData(new Tuple2((Object)"mime-type", (Object)mimeType.getMimeType()));
        WritableContainer writableContainer = containerService.buildContainer(name, metaData);
        writableContainer.open();
        OutputStream os = writableContainer.createEntry(new ContainerEntry(entryName, metaData));
        return new Tuple2((Object)writableContainer, (Object)os);
    }

    public static Tuple2<WritableContainer, OutputStream> createPMMLContainer(ContainerService containerService) {
        return ContainerUtils.createOutputContainer(containerService, "PMML", "PMML.xml", MimeType.APPLICATION_VND_SPSS_PMML_XML);
    }

    public static Tuple2<WritableContainer, OutputStream> createStatXMLContainer(ContainerService containerService) {
        return ContainerUtils.createOutputContainer(containerService, "StatXML", "StatXML.xml", MimeType.APPLICATION_VND_SPSS_STAT_XML);
    }

    public static void closeContainer(Tuple2<WritableContainer, OutputStream> outputContainer) {
        try {
            ((OutputStream)outputContainer._2()).close();
            ((WritableContainer)outputContainer._1()).close();
        }
        catch (IOException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.XML_EXPORT_ERROR, new Object[0]);
        }
    }

    public static MetaData createPMMLMetaData() {
        return ContainerUtils.createMetaData(MimeType.APPLICATION_VND_SPSS_PMML_XML);
    }

    public static MetaData createStatXMLMetaData() {
        return ContainerUtils.createMetaData(MimeType.APPLICATION_VND_SPSS_STAT_XML);
    }

    public static MetaData createMetaData(MimeType mineType) {
        return new MetaData(new Tuple2((Object)"mime-type", (Object)mineType.getMimeType()));
    }

    public static void copyToContainer(WritableContainer writableContainer, InputStream is, OutputStream os) {
        byte[] buffer = new byte[20480];
        int len = 0;
        try {
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
            IOUtils.close((Closeable[])new Closeable[]{os});
        }
        catch (IOException e) {
            throw new ACException("error", (LocMsgId)ACMessages.UNKNOWN_ERROR, new Object[0]);
        }
    }

    public static void copyToContainer(WritableContainer writableContainer, MetaData metaData, String entryName, InputStream is) {
        OutputStream os = ContainerUtils.createContainerEntry(writableContainer, entryName, metaData);
        ContainerUtils.copyToContainer(writableContainer, is, os);
    }

    public static OutputStream createContainerEntry(WritableContainer writableContainer, String entryName, MetaData metaData) {
        return new BufferedOutputStream(writableContainer.createEntry(new ContainerEntry(entryName, metaData)));
    }

    public static InputStream getContainerEntry(ReadableContainer readableContainer, String entryName) {
        return new BufferedInputStream(readableContainer.getEntry(entryName).getData());
    }
}

