/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.channels;

import com.spss.ac.acbase.mr.ACMapReduceUtils;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acbase.serialization.BlockArrayOutputStream;
import com.spss.ac.acbase.serialization.BlockID;
import com.spss.ac.acbase.tuple.Tuple2;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.analyticframework.api.Traversable;
import com.spss.analyticframework.api.pull.CustomRecordChannel;
import com.spss.analyticframework.api.pull.KeyedRecord;
import com.spss.analyticframework.api.pull.KeyedRecordIterator;
import com.spss.analyticframework.api.pull.RecordIterator;
import com.spss.datamodel.DataModel;
import com.spss.datamodel.Field;
import com.spss.datamodel.Fields;
import com.spss.datamodel.Measure;
import com.spss.datamodel.Role;
import com.spss.datamodel.Storage;
import com.spss.datarecord.DataVal;
import com.spss.datarecord.OpaqueVal;
import com.spss.datarecord.Record;
import com.spss.utilities.i18n.LocMsgId;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RecordChannelHelper {
    public static CustomRecordChannel generateCustomRecordChannel(final String channelName, final String keyName, final ACSerializable value) {
        return new CustomRecordChannel(){

            public DataModel getDataModel() {
                return new DataModel(){
                    {
                        this.fields = new Fields(new Field[]{new Field("BinaryBlock", Measure.TYPELESS, Storage.UNKNOWN, Role.INPUT)});
                    }
                };
            }

            public String getName() {
                return channelName;
            }

            public KeyedRecordIterator getRecordIterator() {
                return new KeyedRecordIterator(){
                    private boolean hasMore = true;

                    public boolean hasNext() {
                        return this.hasMore;
                    }

                    public KeyedRecord next() {
                        this.hasMore = false;
                        Record inRec = new Record(){

                            public DataVal getField(int pos) {
                                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                                DataOutputStream dataOutput = new DataOutputStream(outStream);
                                try {
                                    value.writeObject(dataOutput);
                                }
                                catch (IOException e) {
                                    throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
                                }
                                ByteBuffer buffer = ByteBuffer.wrap(outStream.toByteArray());
                                return new OpaqueVal(buffer);
                            }

                            public int getNumFields() {
                                return 1;
                            }
                        };
                        return new KeyedRecord(keyName, inRec){};
                    }

                    public float getProgress() {
                        return 0.0f;
                    }
                };
            }
        };
    }

    public static Traversable<? extends CustomRecordChannel> generateTraversableCustomRecordChannel(final String channelName, final Map<String, ACSerializable> data) {
        return new Traversable<CustomRecordChannel>(){
            boolean hasNext = true;

            public boolean hasNext() {
                return this.hasNext;
            }

            public CustomRecordChannel next() {
                this.hasNext = false;
                return RecordChannelHelper.generateCustomRecordChannel(channelName, data);
            }
        };
    }

    public static CustomRecordChannel generateCustomRecordChannel(final String channelName, final Map<String, ACSerializable> vals) {
        return new CustomRecordChannel(){

            public DataModel getDataModel() {
                return new DataModel(){
                    {
                        this.fields = new Fields();
                    }
                };
            }

            public String getName() {
                return channelName;
            }

            public KeyedRecordIterator getRecordIterator() {
                return new KeyedRecordIterator(){
                    private Iterator<Map.Entry<String, ACSerializable>> it;
                    private String key;
                    {
                        this.it = vals.entrySet().iterator();
                        this.key = null;
                    }

                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    private OpaqueVal buildValue() {
                        Map.Entry<String, ACSerializable> entry = this.it.next();
                        this.key = entry.getKey();
                        ACSerializable val = entry.getValue();
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutput = new DataOutputStream(outStream);
                        try {
                            val.writeObject(dataOutput);
                        }
                        catch (IOException e) {
                            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
                        }
                        ByteBuffer buffer = ByteBuffer.wrap(outStream.toByteArray());
                        return new OpaqueVal(buffer);
                    }

                    public KeyedRecord next() {
                        Record inRec = new Record(){
                            OpaqueVal v;
                            {
                                this.v = this.buildValue();
                            }

                            public DataVal getField(int pos) {
                                return this.v;
                            }

                            public int getNumFields() {
                                return 1;
                            }
                        };
                        return new KeyedRecord(this.key, inRec){};
                    }

                    public float getProgress() {
                        return 0.0f;
                    }
                };
            }
        };
    }

    public static CustomRecordChannel generateCustomRecordChannelMultiChunks(String channelName, ACSerializable value) {
        return RecordChannelHelper.generateCustomRecordChannelMultiChunks(channelName, ACMapReduceUtils.createResults("", value), new UID().toString(), 0x2000000, false);
    }

    public static CustomRecordChannel generateCustomRecordChannelMultiChunks(String channelName, String keyName, ACSerializable value) {
        return RecordChannelHelper.generateCustomRecordChannelMultiChunks(channelName, ACMapReduceUtils.createResults(keyName, value), new UID().toString(), 0x2000000, false);
    }

    public static CustomRecordChannel generateCustomRecordChannelMultiChunks(String channelName, Map<String, ACSerializable> vals) {
        return RecordChannelHelper.generateCustomRecordChannelMultiChunks(channelName, vals, new UID().toString(), 0x2000000, false);
    }

    public static CustomRecordChannel generateCustomRecordChannelMultiChunks(String channelName, Map<String, ACSerializable> vals, boolean freeOriginalObject) {
        return RecordChannelHelper.generateCustomRecordChannelMultiChunks(channelName, vals, new UID().toString(), 0x2000000, freeOriginalObject);
    }

    public static CustomRecordChannel generateCustomRecordChannelMultiChunks(String channelName, Map<String, ACSerializable> vals, int maxChunkSizeM) {
        return RecordChannelHelper.generateCustomRecordChannelMultiChunks(channelName, vals, new UID().toString(), maxChunkSizeM * 1024 * 1024, false);
    }

    public static CustomRecordChannel generateCustomRecordChannelMultiChunks(final String channelName, final Map<String, ACSerializable> vals, String uid, final int maxChunkSize, final boolean freeOriginalObject) {
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("Max chunk size <= 0");
        }
        final BlockID bid = new BlockID(uid);
        return new CustomRecordChannel(){

            public DataModel getDataModel() {
                return new DataModel(){
                    {
                        this.fields = new Fields(new Field[]{new Field("BID", Measure.TYPELESS, Storage.UNKNOWN, Role.INPUT), new Field("BinaryBlock", Measure.TYPELESS, Storage.UNKNOWN, Role.INPUT)});
                    }
                };
            }

            public String getName() {
                return channelName;
            }

            public KeyedRecordIterator getRecordIterator() {
                return new KeyedRecordIterator(){
                    private Iterator<Map.Entry<String, ACSerializable>> it;
                    private String key;
                    private Iterator<Tuple2<OpaqueVal, OpaqueVal>> itBlocks;
                    {
                        this.it = vals.entrySet().iterator();
                        this.key = null;
                        this.itBlocks = null;
                    }

                    public boolean hasNext() {
                        return this.itBlocks != null && this.itBlocks.hasNext() || this.it.hasNext();
                    }

                    private List<Tuple2<OpaqueVal, OpaqueVal>> buildValue() {
                        Map.Entry<String, ACSerializable> entry = this.it.next();
                        this.key = entry.getKey();
                        ACSerializable val = entry.getValue();
                        BlockArrayOutputStream outStream = new BlockArrayOutputStream(maxChunkSize);
                        DataOutputStream dataOutput = new DataOutputStream(outStream);
                        try {
                            val.writeObject(dataOutput);
                        }
                        catch (IOException e) {
                            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
                        }
                        if (freeOriginalObject) {
                            entry.setValue(null);
                        }
                        int blockCount = outStream.blockCount();
                        ArrayList<Tuple2<OpaqueVal, OpaqueVal>> result = new ArrayList<Tuple2<OpaqueVal, OpaqueVal>>(blockCount);
                        bid.setKey(this.key);
                        bid.setBlockCount(blockCount);
                        for (int i = 0; i < blockCount; ++i) {
                            bid.setIndex(i);
                            ByteBuffer bufferBlock = ByteBuffer.wrap(bid.write2ByteArray());
                            ByteBuffer buffer = ByteBuffer.wrap(outStream.block(i));
                            result.add(new Tuple2<OpaqueVal, OpaqueVal>(new OpaqueVal(buffer), new OpaqueVal(bufferBlock)));
                        }
                        return result;
                    }

                    public KeyedRecord next() {
                        if (this.itBlocks == null || !this.itBlocks.hasNext()) {
                            this.itBlocks = this.buildValue().iterator();
                        }
                        Record inRec = new Record(){
                            Tuple2<OpaqueVal, OpaqueVal> v;
                            {
                                this.v = (Tuple2)itBlocks.next();
                            }

                            public DataVal getField(int pos) {
                                return pos == 0 ? (OpaqueVal)this.v.first : (OpaqueVal)this.v.second;
                            }

                            public int getNumFields() {
                                return 2;
                            }
                        };
                        return new KeyedRecord(this.key, inRec){};
                    }

                    public float getProgress() {
                        return 0.0f;
                    }
                };
            }
        };
    }

    public static List<KeyedRecord> generateCustomRecordMultiChunks(String key, ACSerializable val) {
        return RecordChannelHelper.generateCustomRecordMultiChunks(key, val, new UID().toString(), 32);
    }

    public static List<KeyedRecord> generateCustomRecordMultiChunks(String key, ACSerializable val, String uid, int maxChunkSizeM) {
        if (maxChunkSizeM <= 0) {
            throw new IllegalArgumentException("Max chunk size <= 0");
        }
        ArrayList<KeyedRecord> ret = new ArrayList<KeyedRecord>();
        CustomRecordChannel channel = RecordChannelHelper.generateCustomRecordChannelMultiChunks("testChannel", ACMapReduceUtils.createResults(key, val), uid, maxChunkSizeM * 1024 * 1024, false);
        KeyedRecordIterator iter = (KeyedRecordIterator)channel.getRecordIterator();
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
        return ret;
    }

    public static RecordIterator filterOutCustomRecordIteratorMultiChunks(final RecordIterator iterator) {
        final HashMap allResults = new HashMap();
        return new RecordIterator(){
            private boolean hasMore = false;
            private Record thisRecord = null;
            private Record nextRecord = null;
            private DataVal[] thisResultsHit = null;
            private DataVal[] nextResultHit = null;
            {
                this.nextRecord();
            }

            private boolean nextRecord() {
                if (this.nextRecord != null) {
                    this.thisRecord = this.nextRecord;
                } else if (this.nextResultHit != null) {
                    this.thisResultsHit = this.nextResultHit;
                    this.thisRecord = new Record(){

                        public DataVal getField(int pos) {
                            return thisResultsHit[pos];
                        }

                        public int getNumFields() {
                            return thisResultsHit.length;
                        }
                    };
                }
                this.hasMore = false;
                while (iterator.hasNext()) {
                    if (!this.handleRecord((Record)iterator.next())) continue;
                    this.hasMore = true;
                    break;
                }
                return this.hasMore;
            }

            private boolean handleRecord(Record record) {
                if (record.getNumFields() > 1) {
                    DataVal[] blockResults;
                    BlockID bid = ACSerializationUtils.readObject(BlockID.class, record.getField(1));
                    HashMap<String, DataVal[]> innerResults = (HashMap<String, DataVal[]>)allResults.get(bid.getKey());
                    if (innerResults == null) {
                        innerResults = new HashMap<String, DataVal[]>();
                        allResults.put(bid.getKey(), innerResults);
                    }
                    if ((blockResults = (DataVal[])innerResults.get(bid.getUID())) == null) {
                        blockResults = new DataVal[bid.getBlockCount()];
                        innerResults.put(bid.getUID(), blockResults);
                    }
                    blockResults[bid.getIndex()] = record.getField(0);
                    boolean isReady = true;
                    for (int i = blockResults.length - 1; i >= 0; --i) {
                        if (blockResults[i] != null) continue;
                        isReady = false;
                        break;
                    }
                    if (isReady) {
                        this.hasMore = true;
                        this.nextRecord = null;
                        this.nextResultHit = blockResults;
                        innerResults.remove(bid.getUID());
                    }
                } else {
                    this.nextRecord = record;
                    this.hasMore = true;
                }
                return this.hasMore;
            }

            public boolean hasNext() {
                return this.hasMore;
            }

            public Record next() {
                this.nextRecord();
                return this.thisRecord;
            }

            public float getProgress() {
                return iterator.getProgress();
            }
        };
    }
}

