/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.collections;

import com.spss.ac.acbase.collections.ACUtils;
import com.spss.datarecord.DataVal;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public class ArrayUtils {
    public static final double[] ZERO_DOUBLE_ARRAY = new double[0];
    public static final int[] ZERO_INT_ARRAY = new int[0];
    public static final boolean[] ZERO_BOOLEAN_ARRAY = new boolean[0];
    public static final String[] ZERO_STRING_ARRAY = new String[0];
    public static final long[] ZERO_LONG_ARRAY = new long[0];
    public static final Object[] ZERO_OBJECT_ARRAY = new Object[0];

    private ArrayUtils() {
    }

    public static double[] newArray(double initialVal, int size) {
        if (size <= 0) {
            return ZERO_DOUBLE_ARRAY;
        }
        double[] result = new double[size];
        if (initialVal != 0.0) {
            Arrays.fill(result, initialVal);
        }
        return result;
    }

    public static double[] newArray(int size, double initialVal) {
        return ArrayUtils.newArray(initialVal, size);
    }

    public static long[] newArray(long initialVal, int size) {
        if (size <= 0) {
            return ZERO_LONG_ARRAY;
        }
        long[] result = new long[size];
        if (initialVal != 0L) {
            Arrays.fill(result, initialVal);
        }
        return result;
    }

    public static long[] newArray(int size, long initialVal) {
        return ArrayUtils.newArray(initialVal, size);
    }

    public static int[] newArray(int initialVal, int size) {
        if (size <= 0) {
            return ZERO_INT_ARRAY;
        }
        int[] result = new int[size];
        if (initialVal != 0) {
            Arrays.fill(result, initialVal);
        }
        return result;
    }

    public static boolean[] newArray(boolean initialVal, int size) {
        if (size <= 0) {
            return ZERO_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[size];
        if (initialVal) {
            Arrays.fill(result, initialVal);
        }
        return result;
    }

    public static boolean[] newArray(int size, boolean initialVal) {
        return ArrayUtils.newArray(initialVal, size);
    }

    public static <T> T[] newArray(int size, T initialVal) {
        Object[] result = ZERO_OBJECT_ARRAY;
        if (initialVal != null) {
            result = (Object[])Array.newInstance(initialVal.getClass(), size);
            Arrays.fill(result, initialVal);
        }
        return result;
    }

    public static <T> T[] newArray(int size, Class<T> clazz) {
        Object[] result = ZERO_OBJECT_ARRAY;
        if (clazz != null) {
            result = (Object[])Array.newInstance(clazz, size);
        }
        return result;
    }

    public static <T> void fill(T[] arr, Class<T> clazz) {
        for (int i = 0; i < arr.length; ++i) {
            Object obj = null;
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            arr[i] = obj;
        }
    }

    public static void copy(double[] to, double[] from) {
        System.arraycopy(from, 0, to, 0, Math.min(to.length, from.length));
    }

    public static void copy(double[][] to, double[][] from) {
        System.arraycopy(from, 0, to, 0, Math.min(to.length, from.length));
    }

    public static void assign(double[] lhs, double[] rhs) {
        System.arraycopy(rhs, 0, lhs, 0, Math.min(lhs.length, rhs.length));
    }

    public static void assign(int[] lhs, int[] rhs) {
        System.arraycopy(rhs, 0, lhs, 0, Math.min(lhs.length, rhs.length));
    }

    public static double[] sqrt(double[] x) {
        return ArrayUtils.sqrt(x, false);
    }

    public static double[] sqrt(double[] x, boolean bItself) {
        double[] result = bItself ? x : new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = Math.sqrt(x[i]);
        }
        return result;
    }

    public static double[] sqrt(double[] target, double[] x) {
        int n = Math.min(target.length, x.length);
        for (int i = 0; i < n; ++i) {
            target[i] = Math.sqrt(x[i]);
        }
        return target;
    }

    public static double sum(double[] x) {
        double result = 0.0;
        for (double element : x) {
            result += element;
        }
        return result;
    }

    public static int sum(int[] x) {
        int result = 0;
        for (int element : x) {
            result += element;
        }
        return result;
    }

    public static double average(double[] x) {
        return ArrayUtils.sum(x) / (double)x.length;
    }

    public static double max(double[] x) {
        double result = -1.7976931348623157E308;
        for (double element : x) {
            if (!(element > result)) continue;
            result = element;
        }
        return result;
    }

    public static int max(int[] x) {
        int result = Integer.MIN_VALUE;
        for (int element : x) {
            if (element <= result) continue;
            result = element;
        }
        return result;
    }

    public static double min(double[] x) {
        double result = Double.MAX_VALUE;
        for (double element : x) {
            if (!(element < result)) continue;
            result = element;
        }
        return result;
    }

    public static int min(int[] x) {
        int result = Integer.MAX_VALUE;
        for (int element : x) {
            if (element >= result) continue;
            result = element;
        }
        return result;
    }

    public static double[] add(double[] target, double[] lhs, double[] rhs) {
        int n = Math.min(lhs.length, rhs.length);
        for (int i = 0; i < n; ++i) {
            target[i] = lhs[i] + rhs[i];
        }
        return target;
    }

    public static double[] add(double[] lhs, double[] rhs) {
        return ArrayUtils.add(lhs, rhs, true);
    }

    public static double[] add(double[] lhs, double[] rhs, boolean bItself) {
        int n = Math.min(lhs.length, rhs.length);
        double[] result = bItself ? lhs : new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = lhs[i] + rhs[i];
        }
        return result;
    }

    public static double[] subtract(double[] target, double[] lhs, double[] rhs) {
        int n = Math.min(lhs.length, rhs.length);
        for (int i = 0; i < n; ++i) {
            target[i] = lhs[i] - rhs[i];
        }
        return target;
    }

    public static double[] subtract(double[] lhs, double[] rhs) {
        return ArrayUtils.subtract(lhs, rhs, true);
    }

    public static double[] subtract(double[] lhs, double[] rhs, boolean bItself) {
        int n = Math.min(lhs.length, rhs.length);
        double[] result = bItself ? lhs : new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = lhs[i] - rhs[i];
        }
        return result;
    }

    public static double[] mul(double[] target, double[] lhs, double[] rhs) {
        int n = Math.min(lhs.length, rhs.length);
        for (int i = 0; i < n; ++i) {
            target[i] = lhs[i] * rhs[i];
        }
        return target;
    }

    public static double[] mul(double[] lhs, double[] rhs) {
        return ArrayUtils.mul(lhs, rhs, true);
    }

    public static double[] mul(double[] lhs, double[] rhs, boolean bItself) {
        int n = Math.min(lhs.length, rhs.length);
        double[] result = bItself ? lhs : new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = lhs[i] * rhs[i];
        }
        return result;
    }

    public static double[] mul(double[] lhs, double val) {
        return ArrayUtils.mul(lhs, val, true);
    }

    public static double[] mul(double val, double[] rhs) {
        return ArrayUtils.mul(rhs, val, false);
    }

    public static double[] mul(double[] lhs, double val, boolean bItself) {
        double[] result = bItself ? lhs : new double[lhs.length];
        for (int i = 0; i < lhs.length; ++i) {
            result[i] = lhs[i] * val;
        }
        return result;
    }

    public static int[] mul(int[] lhs, int val) {
        return ArrayUtils.mul(lhs, val, true);
    }

    public static int[] mul(int val, int[] rhs) {
        return ArrayUtils.mul(rhs, val, false);
    }

    public static int[] mul(int[] lhs, int val, boolean bItself) {
        int[] result = bItself ? lhs : new int[lhs.length];
        for (int i = 0; i < lhs.length; ++i) {
            result[i] = lhs[i] * val;
        }
        return result;
    }

    public static double[] div(double[] lhs, double[] rhs) {
        return ArrayUtils.div(lhs, rhs, true);
    }

    public static double[] div(double[] lhs, double[] rhs, boolean bItself) {
        int n = Math.min(lhs.length, rhs.length);
        double[] result = bItself ? lhs : new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = lhs[i] / rhs[i];
        }
        return result;
    }

    public static double[] div(double[] lhs, double val) {
        return ArrayUtils.div(lhs, val, true);
    }

    public static double[] div(double[] lhs, double val, boolean bItself) {
        double[] result = bItself ? lhs : new double[lhs.length];
        for (int i = 0; i < lhs.length; ++i) {
            result[i] = lhs[i] / val;
        }
        return result;
    }

    public static double[] div(double[] output, double[] lhs, double val) {
        for (int i = 0; i < lhs.length; ++i) {
            output[i] = lhs[i] / val;
        }
        return output;
    }

    public static double[] negative(double[] lhs) {
        double[] result = ZERO_DOUBLE_ARRAY;
        if (lhs != null) {
            result = new double[lhs.length];
            for (int i = 0; i < lhs.length; ++i) {
                result[i] = -lhs[i];
            }
        }
        return result;
    }

    public static int[] resize(int[] array, int newSize) {
        int[] result = null;
        if (array == null) {
            result = new int[newSize];
        } else if (array.length != newSize) {
            result = new int[newSize];
            System.arraycopy(array, 0, result, 0, Math.min(array.length, newSize));
        } else {
            result = array;
        }
        return result;
    }

    public static double[] resize(double[] array, int newSize) {
        double[] result = null;
        if (array == null) {
            result = new double[newSize];
        } else if (array.length != newSize) {
            result = new double[newSize];
            System.arraycopy(array, 0, result, 0, Math.min(array.length, newSize));
        } else {
            result = array;
        }
        return result;
    }

    public static int[] resize(int[] array, int newSize, int initialVal) {
        int[] result = null;
        if (array == null) {
            result = ACUtils.newArray(newSize, initialVal);
        } else if (array.length != newSize) {
            result = new int[newSize];
            System.arraycopy(array, 0, result, 0, Math.min(array.length, newSize));
            if (newSize > array.length) {
                Arrays.fill(result, array.length, newSize, initialVal);
            }
        } else {
            result = array;
        }
        return result;
    }

    public static double[] resize(double[] array, int newSize, double initialVal) {
        double[] result = null;
        if (array == null) {
            result = ArrayUtils.newArray(newSize, initialVal);
        } else if (array.length != newSize) {
            result = new double[newSize];
            System.arraycopy(array, 0, result, 0, Math.min(array.length, newSize));
            if (newSize > array.length) {
                Arrays.fill(result, array.length, newSize, initialVal);
            }
        } else {
            result = array;
        }
        return result;
    }

    public static <T> T back(List<T> list) {
        return list != null ? (list.isEmpty() ? null : list.get(list.size() - 1)) : null;
    }

    public static int back(int[] array) {
        return array != null ? (array.length == 0 ? 0 : array[array.length - 1]) : 0;
    }

    public static double back(double[] array) {
        return array != null ? (array.length == 0 ? Double.NaN : array[array.length - 1]) : Double.NaN;
    }

    public static int size(double[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(int[] array) {
        return array != null ? array.length : 0;
    }

    public static int indexOf(int[] arr, int num) {
        int result = -1;
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (num != arr[i]) continue;
                return i;
            }
        }
        return result;
    }

    public static int indexOf(DataVal[] arr, DataVal num) {
        int result = -1;
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (!num.equals(arr[i])) continue;
                return i;
            }
        }
        return result;
    }

    public static int[] merge(int[] to, int[] from) {
        int n = Math.min(to.length, from.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            to[n2] = to[n2] + from[i];
        }
        return to;
    }

    public static double[] merge(double[] to, double[] from) {
        int n = Math.min(to.length, from.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            to[n2] = to[n2] + from[i];
        }
        return to;
    }

    public static long[] merge(long[] to, long[] from) {
        int n = Math.min(to.length, from.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            to[n2] = to[n2] + from[i];
        }
        return to;
    }

    public static int[] extract(int[] to, int[] from) {
        int n = Math.min(to.length, from.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            to[n2] = to[n2] - from[i];
        }
        return to;
    }

    public static double[] extract(double[] to, double[] from) {
        int n = Math.min(to.length, from.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            to[n2] = to[n2] - from[i];
        }
        return to;
    }

    public static long[] extract(long[] to, long[] from) {
        int n = Math.min(to.length, from.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            to[n2] = to[n2] - from[i];
        }
        return to;
    }

    public static int[] concat(int[] left, int[] right) {
        int[] result = new int[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static double[][] toArrayArray(double[] array, int length) {
        int arrayLen = array.length;
        int firstDimensionLen = length;
        int secondDimensionLen = arrayLen / firstDimensionLen;
        double[][] arrayArray = new double[firstDimensionLen][secondDimensionLen];
        int firstDimensionIndex = 0;
        int secondDimensionIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i != 0 && i % secondDimensionLen == 0) {
                ++firstDimensionIndex;
                secondDimensionIndex = 0;
            }
            arrayArray[firstDimensionIndex][secondDimensionIndex] = array[i];
            ++secondDimensionIndex;
        }
        return arrayArray;
    }
}

