/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.collections;

import com.spss.ac.acbase.collections.ArrayUtils;
import com.spss.ac.acbase.collections.Assignable;
import java.util.Arrays;

public class VABool
implements Assignable<VABool>,
Cloneable {
    private boolean[] array = ArrayUtils.ZERO_BOOLEAN_ARRAY;

    public VABool() {
    }

    public VABool(int n) {
        this(false, n);
    }

    public VABool(boolean iniVal, int n) {
        this.array = ArrayUtils.newArray(iniVal, n);
    }

    public void resize(int n) {
        this.resize(n, false);
    }

    public void resize(int n, boolean value) {
        if (n != this.array.length) {
            boolean[] arr = n <= 0 ? ArrayUtils.ZERO_BOOLEAN_ARRAY : new boolean[n];
            Arrays.fill(arr, value);
            if (this.array.length > 0 && n > 0) {
                System.arraycopy(this.array, 0, arr, 0, Math.min(n, this.array.length));
            }
            this.array = arr;
        }
    }

    @Override
    public VABool assign(VABool rhs) {
        if (this != rhs) {
            this.assign(rhs.array);
        }
        return this;
    }

    @Override
    public void assign(boolean[] arr) {
        if (arr != null) {
            if (this.array.length != arr.length) {
                this.array = (boolean[])arr.clone();
            } else {
                System.arraycopy(arr, 0, this.array, 0, arr.length);
            }
        } else {
            this.array = ArrayUtils.ZERO_BOOLEAN_ARRAY;
        }
    }

    public void fill(boolean value) {
        Arrays.fill(this.array, value);
    }

    public boolean[] get() {
        return this.array;
    }

    public boolean[] toArray() {
        return this.array;
    }

    public boolean get(int index) {
        return this.array[index];
    }

    public void set(int index, boolean val) {
        this.array[index] = val;
    }

    public void attach(boolean[] arr) {
        this.array = arr;
    }

    public boolean[] detach() {
        boolean[] arr = this.array;
        this.array = ArrayUtils.ZERO_BOOLEAN_ARRAY;
        return arr;
    }

    public int size() {
        return this.array.length;
    }

    public VABool clone() {
        try {
            VABool result = (VABool)super.clone();
            if (this.array != null) {
                result.array = (boolean[])this.array.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return "VABool [array=" + Arrays.toString(this.array) + "]";
    }
}

