/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.efbining.ScaBin;
import com.spss.ac.acbase.efbining.ScaBinList;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acbase.tuple.Tuple2;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.i18n.LocMsgId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public class ArrScaBinList
implements ScaBinList,
Cloneable,
ACSerializable {
    ArrayList<ScaBin> container;
    boolean isExact = true;

    public ArrScaBinList() {
        this(200);
    }

    public ArrScaBinList(int initialCapacity) {
        this.container = new ArrayList(initialCapacity);
    }

    @Override
    public ScaBinList.ScaBinListType getListType() {
        return ScaBinList.ScaBinListType.ARRAYLIST;
    }

    @Override
    public int size() {
        return this.container.size();
    }

    @Override
    public void clear() {
        this.container.clear();
        this.isExact = true;
    }

    @Override
    public Iterator<ScaBin> iterator() {
        return this.container.iterator();
    }

    public ArrScaBinList clone() {
        ArrScaBinList binList = null;
        try {
            binList = (ArrScaBinList)super.clone();
            binList.container = (ArrayList)this.container.clone();
            for (int i = 0; i < binList.size(); ++i) {
                binList.container.set(i, this.container.get(i).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        return binList;
    }

    @Override
    public boolean update(double value, double weight) {
        int index = this.findInsertPosition(value);
        ScaBin bin = null;
        if (this.container.size() > 0) {
            if (index == this.container.size()) {
                if (this.container.get(index - 1).contains(value)) {
                    bin = this.container.get(index - 1);
                }
            } else {
                if (this.container.get(index).contains(value)) {
                    bin = this.container.get(index);
                }
                if (index > 0 && bin == null && this.container.get(index - 1).contains(value)) {
                    bin = this.container.get(index - 1);
                }
            }
        }
        if (bin != null) {
            bin.update(value, weight);
        } else {
            this.container.add(index, new ScaBin(value, weight));
        }
        return true;
    }

    @Override
    public boolean merge(ScaBinList binList) {
        boolean isOK = true;
        if (this.size() == binList.size()) {
            for (int i = 0; i < this.container.size(); ++i) {
                ScaBin obin = binList.get(i);
                ScaBin ibin = this.container.get(i);
                if (!(Math.abs(obin.lower - ibin.lower) < 1.0E-14) || !(Math.abs(obin.upper - ibin.upper) < 1.0E-14)) {
                    isOK = false;
                    break;
                }
                ibin.update(obin.mean, obin.weight);
            }
        } else {
            isOK = false;
        }
        return isOK;
    }

    @Override
    public void insert(ScaBin bin) {
        int pos = this.findInsertPosition(bin.lower);
        this.container.add(pos, bin);
    }

    @Override
    public void insert(Map<Double, Double> mapData) {
        for (Map.Entry<Double, Double> entry : mapData.entrySet()) {
            ScaBin bin = new ScaBin(entry.getKey(), entry.getValue());
            this.insert(bin);
        }
    }

    @Override
    public void compress(int newSize, double thresholdCompressRange) {
        if (newSize >= this.container.size()) {
            return;
        }
        int excludeIdx = (int)(thresholdCompressRange * (double)newSize);
        double maxBinUpper = this.container.get((int)(this.container.size() - 1 - excludeIdx)).upper;
        double minBinLower = this.container.get((int)excludeIdx).lower;
        double searchThreshold = 2.0 * (maxBinUpper - minBinLower) / ((1.0 - 2.0 * thresholdCompressRange) * (double)newSize - 1.0);
        while (this.container.size() > newSize) {
            int endIndex = this.container.size() - 1 - excludeIdx;
            int index = this.getIndexOfAdjacentBinsHavingMinDistance(excludeIdx, endIndex, searchThreshold);
            if (index >= excludeIdx && index <= endIndex - 1) {
                this.container.get(index).merge(this.container.get(index + 1));
                this.eraseAt(index + 1);
                continue;
            }
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }

    @Override
    public ScaBin pop() {
        ScaBin bin = null;
        if (this.container.size() > 0) {
            bin = this.container.remove(0);
        }
        return bin;
    }

    @Override
    public ScaBin get(int index) {
        return this.container.get(index);
    }

    @Override
    public void pushBack(ScaBin bin) {
        if (bin != null) {
            this.container.add(bin);
        }
    }

    @Override
    public void handleOverlapAndGap(double mergeThreshold) {
        if (this.container.size() >= 2) {
            int lastIdx = this.container.size() - 1;
            ScaBin curBin = this.container.get(lastIdx);
            ScaBin prevBin = this.container.get(lastIdx - 1);
            if (prevBin.lower <= curBin.lower) {
                if (prevBin.upper >= curBin.upper) {
                    prevBin.merge(curBin);
                    this.eraseAt(lastIdx);
                } else if (prevBin.upper > curBin.lower) {
                    if (curBin.upper - prevBin.lower <= mergeThreshold) {
                        prevBin.merge(curBin);
                        this.eraseAt(lastIdx);
                    } else {
                        this.splitOverlappedBins(prevBin, curBin);
                    }
                }
            } else if (lastIdx - 2 >= 0) {
                ScaBin ppBin = this.container.get(lastIdx - 2);
                if (ppBin.upper >= curBin.upper) {
                    ppBin.merge(curBin);
                    this.eraseAt(lastIdx);
                } else {
                    this.splitOverlappedBins(ppBin, curBin);
                    prevBin.merge(curBin);
                    this.eraseAt(lastIdx);
                }
            }
        }
    }

    @Override
    public boolean isDiscrete() {
        boolean res = true;
        for (ScaBin bin : this.container) {
            if (bin.containOneValue()) continue;
            res = false;
            break;
        }
        return res;
    }

    @Override
    public boolean isExact() {
        return this.isExact;
    }

    @Override
    public void setExact(boolean isExact) {
        this.isExact = isExact;
    }

    @Override
    public int findBinContainingValue(double value) {
        int result = -1;
        int low = 0;
        int high = this.container.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            ScaBin bin = this.container.get(mid);
            double midVal = bin.lower;
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            result = mid;
            break;
        }
        if (low > high && high >= 0) {
            ScaBin bin = this.container.get(high);
            if (bin.lower <= value && bin.upper >= value) {
                result = high;
            }
        }
        return result;
    }

    @Override
    public void removeBin(double value) {
        int index = this.findBinContainingValue(value);
        if (index >= 0 && index < this.container.size()) {
            ScaBin bin = this.container.get(index);
            if (Double.doubleToLongBits(bin.lower) == Double.doubleToLongBits(bin.upper) && Double.doubleToLongBits(bin.mean) == Double.doubleToLongBits(value)) {
                this.eraseAt(index);
            }
        }
    }

    @Override
    public void resetMeanWeight() {
        for (ScaBin bin : this.container) {
            bin.mean = 0.0;
            bin.weight = 0.0;
        }
    }

    @Override
    public Tuple2<Double, Double> getCompressRange(double threshold, boolean skipZero) {
        double lower = Double.POSITIVE_INFINITY;
        double upper = Double.NEGATIVE_INFINITY;
        int nonZeroOffSet = 0;
        if (skipZero) {
            ScaBin bin;
            for (int i = 0; i < this.size() && (bin = this.get(i)).containOneValue() && bin.getLower() == 0.0; ++i) {
                ++nonZeroOffSet;
            }
        }
        int tmp = (int)((double)(this.size() - nonZeroOffSet) * threshold);
        int beginIndex = nonZeroOffSet + tmp;
        int endIndex = this.size() - 1 - tmp;
        if (beginIndex >= 0 && beginIndex < this.size()) {
            lower = this.get((int)beginIndex).lower;
        }
        if (endIndex >= 0 && endIndex < this.size()) {
            upper = this.get((int)endIndex).upper;
        }
        return new Tuple2<Double, Double>(lower, upper);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.isExact ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrScaBinList other = (ArrScaBinList)obj;
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        return this.isExact == other.isExact;
    }

    public String toString() {
        return "ScaBinList [container=" + this.container + ", isExact=" + this.isExact + "]";
    }

    private int findInsertPosition(double value) {
        int insPos = Collections.binarySearch(this.container, new ScaBin(value, 1.0), new Comparator<ScaBin>(){

            @Override
            public int compare(ScaBin o1, ScaBin o2) {
                if (o1.lower < o2.lower) {
                    return -1;
                }
                if (o1.lower > o2.lower) {
                    return 1;
                }
                return 0;
            }
        });
        if (insPos < 0) {
            insPos = -insPos - 1;
        }
        return insPos;
    }

    private void splitOverlappedBins(ScaBin firstBin, ScaBin secondBin) {
        this.isExact = false;
        double ratio = (firstBin.upper - secondBin.lower) / (secondBin.upper - secondBin.lower);
        secondBin.mean = (secondBin.upper + firstBin.upper) / 2.0;
        double oMean = (firstBin.upper + secondBin.lower) / 2.0;
        double oWeight = ratio * secondBin.weight;
        firstBin.update(oMean, oWeight);
        secondBin.weight -= oWeight;
        secondBin.lower = firstBin.upper;
    }

    private void eraseAt(int index) {
        this.container.remove(index);
    }

    private int getIndexOfAdjacentBinsHavingMinDistance(int begIdx, int endIdx, double searchThreshold) {
        int index = -1;
        double minDistance = Double.MAX_VALUE;
        for (int i = begIdx; i < endIdx; ++i) {
            double distance;
            ScaBin curBin = this.container.get(i);
            ScaBin nextBin = this.container.get(i + 1);
            if (!(nextBin.upper - curBin.lower < searchThreshold) || !((distance = nextBin.mean - curBin.mean) < minDistance)) continue;
            minDistance = distance;
            index = i;
        }
        return index;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.isExact);
        ACSerializationUtils.writeObjectList(ScaBin.class, this.container, dataOutput);
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        this.isExact = dataInput.readBoolean();
        this.container = ACSerializationUtils.readObjectArrayList(ScaBin.class, dataInput);
        return this;
    }
}

