/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.efbining.ScaBin;
import com.spss.ac.acbase.efbining.ScaBinList;
import com.spss.ac.acbase.efbining.ScaBinListFactory;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.i18n.LocMsgId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class EFBinSerializationUtils {
    public static void writeScaBinList(ScaBinList binList, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("ScaBinList", binList != null, dataOutput);
        if (binList != null) {
            dataOutput.writeBoolean(binList.isExact());
            int numOfBins = binList.size();
            dataOutput.writeInt(numOfBins);
            for (ScaBin bin : binList) {
                bin.writeObject(dataOutput);
            }
        }
    }

    public static ScaBinList readScaBinList(DataInput dataInput, ScaBinListFactory binListFactory) throws IOException {
        ScaBinList binList = null;
        if (ACSerializationUtils.readObjectExistFlag("ScaBinList", dataInput)) {
            binList = binListFactory.createBinList();
            boolean isExact = dataInput.readBoolean();
            binList.setExact(isExact);
            int numOfBins = dataInput.readInt();
            for (int i = 0; i < numOfBins; ++i) {
                ScaBin bin = new ScaBin();
                bin.readObject(dataInput);
                binList.pushBack(bin);
            }
        }
        return binList;
    }

    public static Object simulateSerializtion(ACSerializable obj) {
        ACSerializable result = null;
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                DataOutputStream dataOutput = new DataOutputStream(os);
                obj.writeObject(dataOutput);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                DataInputStream dataInput = new DataInputStream(is);
                result = (ACSerializable)clazz.newInstance();
                result.readObject(dataInput);
            }
            catch (IOException e) {
                throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
            catch (InstantiationException e) {
                throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
        }
        return result;
    }
}

