/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EFBiningSettings
implements ACSerializable {
    private static final long serialVersionUID = 1L;
    protected String accurayLevel = "approximate";
    protected int maxNumOfBins = 1000;
    protected int maxNumOfCachedBins = 3000;
    protected int maxNumOfClusters = 200;
    protected int maxNumOfDistinctValuesInMap = 10000;
    protected int maxNumOfDistinctValuesInRed = 100000;
    protected double compressRangeThreshold = 0.01;
    protected List<Double> percentages = new ArrayList<Double>();
    protected int numOfBin4EFBinning;

    public EFBiningSettings() {
        this.percentages.add(0.25);
        this.percentages.add(0.5);
        this.percentages.add(0.75);
        this.numOfBin4EFBinning = 0;
    }

    public EFBiningSettings(List<Double> percentages) {
        this.percentages.add(0.25);
        this.percentages.add(0.5);
        this.percentages.add(0.75);
        this.numOfBin4EFBinning = 0;
        for (Double percentage : percentages) {
            this.percentages.add(percentage);
        }
        this.eraseDuplicatedPercentages();
        Collections.sort(percentages);
    }

    public EFBiningSettings(int numOfBin4EFBinning) {
        this.percentages.add(0.25);
        this.percentages.add(0.5);
        this.percentages.add(0.75);
        this.numOfBin4EFBinning = 0;
        this.numOfBin4EFBinning = numOfBin4EFBinning;
        for (int i = 1; i < numOfBin4EFBinning; ++i) {
            this.percentages.add((double)i / (double)numOfBin4EFBinning);
        }
        this.eraseDuplicatedPercentages();
        Collections.sort(this.percentages);
    }

    public boolean isComputeOrdStat() {
        return !this.accurayLevel.equals("none");
    }

    public String getAccurayLevel() {
        return this.accurayLevel;
    }

    public int getMaxNumOfBins() {
        return this.maxNumOfBins;
    }

    public void setMaxNumOfBins(int maxNumOfBins) {
        this.maxNumOfBins = maxNumOfBins;
    }

    public int getMaxNumOfCachedBins() {
        return this.maxNumOfCachedBins;
    }

    public void setMaxNumOfCachedBins(int maxNumOfCachedBins) {
        this.maxNumOfCachedBins = maxNumOfCachedBins;
    }

    public int getMaxNumOfClusters() {
        return this.maxNumOfClusters;
    }

    public void setMaxNumOfClusters(int maxNumOfClusters) {
        this.maxNumOfClusters = maxNumOfClusters;
    }

    public int getMaxNumOfDistinctValuesInMap() {
        return this.maxNumOfDistinctValuesInMap;
    }

    public void setMaxNumOfDistinctValuesInMap(int maxNumOfDistinctValuesInMap) {
        this.maxNumOfDistinctValuesInMap = maxNumOfDistinctValuesInMap;
    }

    public int getMaxNumOfDistinctValuesInRed() {
        return this.maxNumOfDistinctValuesInRed;
    }

    public void setMaxNumOfDistinctValuesInRed(int maxNumOfDistinctValuesInRed) {
        this.maxNumOfDistinctValuesInRed = maxNumOfDistinctValuesInRed;
    }

    public double getCompressRangeThreshold() {
        return this.compressRangeThreshold;
    }

    public void setCompressRangeThreshold(double compressRangeThreshold) {
        this.compressRangeThreshold = compressRangeThreshold;
    }

    public List<Double> getPercentages() {
        return this.percentages;
    }

    public List<Double> getPercentages4EFBinning() {
        ArrayList<Double> percentages = new ArrayList<Double>();
        for (int i = 1; i < this.numOfBin4EFBinning; ++i) {
            percentages.add((double)i / (double)this.numOfBin4EFBinning);
        }
        return percentages;
    }

    private void eraseDuplicatedPercentages() {
        Collections.sort(this.percentages);
        int i = 0;
        while (i < this.percentages.size() - 1) {
            if (this.percentages.get(i + 1) - this.percentages.get(i) < 1.0E-14) {
                this.percentages.remove(i + 1);
                continue;
            }
            ++i;
        }
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.numOfBin4EFBinning);
        ACSerializationUtils.writeDoubleList(this.percentages, dataOutput);
    }

    @Override
    public EFBiningSettings readObject(DataInput dataInput) throws IOException {
        this.numOfBin4EFBinning = dataInput.readInt();
        this.percentages = ACSerializationUtils.readDoubleArrayList(dataInput);
        return this;
    }
}

