/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.collections.ACUtils;
import com.spss.ac.acbase.efbining.ArrScaBinList;
import com.spss.ac.acbase.efbining.EFBinSerializationUtils;
import com.spss.ac.acbase.efbining.EFBiningSettings;
import com.spss.ac.acbase.efbining.Percentile;
import com.spss.ac.acbase.efbining.PercentileList;
import com.spss.ac.acbase.efbining.ScaBin;
import com.spss.ac.acbase.efbining.ScaBinList;
import com.spss.ac.acbase.efbining.ScaBinListFactory;
import com.spss.ac.acbase.efbining.ScaOrdStat;
import com.spss.ac.acbase.efbining.Tuple2Bin;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acbase.tuple.Tuple2;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.math.MissingValue;
import com.spss.utilities.i18n.LocMsgId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class EqualFreqBinning
implements ACSerializable {
    private static final long serialVersionUID = 2947825815155566780L;
    private EFBiningSettings ordStatSettings;
    protected double totalWeight;
    protected double compressLower = Double.POSITIVE_INFINITY;
    protected double compressUpper = Double.NEGATIVE_INFINITY;
    protected ScaBinList binList;
    transient PercentileList percentileList;
    private transient double range = MissingValue.getMissing();
    private transient double mergeThreshold;
    private transient double accumWeight;
    private transient double curMaxUpper;
    private transient int curPerctIndex;
    private transient int maxCapacityForBinList;
    private transient boolean treatZeroAsMissing = false;
    private transient boolean isValidStatAfterZeroInf = false;
    private transient double minValueWithoutZero = MissingValue.getMissing();
    private double compressLowerWithoutZero = Double.POSITIVE_INFINITY;
    private double compressUpperWithoutZero = Double.NEGATIVE_INFINITY;

    public EqualFreqBinning() {
        this.ordStatSettings = new EFBiningSettings();
        this.initInMap();
    }

    public EqualFreqBinning(EFBiningSettings ordSettings) {
        this.ordStatSettings = ordSettings;
        this.initInMap();
    }

    public EqualFreqBinning(int numOfEFbinings) {
        this.ordStatSettings = new EFBiningSettings(numOfEFbinings);
        this.initInMap();
    }

    public EqualFreqBinning(EFBiningSettings ordSettings, double totalWeight, double compressLower, double compressUpper) {
        this.ordStatSettings = ordSettings;
        this.initInRed();
        this.totalWeight = totalWeight;
        this.compressLower = compressLower;
        this.compressUpper = compressUpper;
    }

    public void update(double value, double weight) {
        if (!MissingValue.isMissing((double)value)) {
            this.totalWeight += weight;
            this.binList.update(value, weight);
            if (this.binList.size() > this.ordStatSettings.getMaxNumOfCachedBins() + this.ordStatSettings.getMaxNumOfBins()) {
                this.compressBinList();
            }
        }
    }

    public void update(double value) {
        this.update(value, 1.0);
    }

    public void doMapPostOp() {
        this.compressBinList();
        Tuple2<Double, Double> compressRange = this.binList.getCompressRange(this.ordStatSettings.getCompressRangeThreshold(), false);
        this.compressLower = (Double)compressRange.first;
        this.compressUpper = (Double)compressRange.second;
        compressRange = this.binList.getCompressRange(this.ordStatSettings.getCompressRangeThreshold(), true);
        this.compressLowerWithoutZero = (Double)compressRange.first;
        this.compressUpperWithoutZero = (Double)compressRange.second;
    }

    public void setTreatZeroAsMissing() {
        this.treatZeroAsMissing = true;
        this.isValidStatAfterZeroInf = true;
    }

    public boolean isValidStatAfterZeroInf() {
        return this.isValidStatAfterZeroInf;
    }

    public double getMinValueWithoutZero() {
        return this.minValueWithoutZero;
    }

    public void mergeWeight(EqualFreqBinning other) {
        if (this.percentileList == null) {
            this.initInRed();
        }
        if (other.totalWeight > 0.0) {
            this.totalWeight += other.totalWeight;
            if (!this.treatZeroAsMissing) {
                if (other.compressLower < this.compressLower) {
                    this.compressLower = other.compressLower;
                }
                if (other.compressUpper > this.compressUpper) {
                    this.compressUpper = other.compressUpper;
                }
            } else {
                if (other.compressLowerWithoutZero < this.compressLower) {
                    this.compressLower = other.compressLowerWithoutZero;
                }
                if (other.compressUpperWithoutZero > this.compressUpper) {
                    this.compressUpper = other.compressUpperWithoutZero;
                }
            }
        }
    }

    public void merge(EqualFreqBinning other1) {
        block17: {
            EqualFreqBinning other;
            block16: {
                block18: {
                    if (this.treatZeroAsMissing && !this.isValidStatAfterZeroInf) {
                        return;
                    }
                    if (this.percentileList == null) {
                        this.initInRed();
                    }
                    other = other1;
                    if (other.binList != null && other.binList.size() != 0) break block16;
                    if (!(other.totalWeight > 0.0)) break block17;
                    this.totalWeight += other.totalWeight;
                    if (this.treatZeroAsMissing) break block18;
                    if (other.compressLower < this.compressLower) {
                        this.compressLower = other.compressLower;
                    }
                    if (other.compressUpper > this.compressUpper) {
                        this.compressUpper = other.compressUpper;
                    }
                    break block17;
                }
                if (other.compressLowerWithoutZero < this.compressLower) {
                    this.compressLower = other.compressLowerWithoutZero;
                }
                if (!(other.compressUpperWithoutZero > this.compressUpper)) break block17;
                this.compressUpper = other.compressUpperWithoutZero;
                break block17;
            }
            if (MissingValue.isMissing((double)this.range)) {
                this.range = Double.MAX_VALUE;
                if (this.compressUpper > this.compressLower) {
                    this.range = this.compressUpper - this.compressLower;
                }
                this.mergeThreshold = 2.0 * this.range / ((1.0 - 2.0 * this.ordStatSettings.getCompressRangeThreshold()) * (double)this.ordStatSettings.getMaxNumOfBins() - 1.0);
                this.accumWeight = 0.0;
                this.curMaxUpper = -1.7976931348623157E308;
                this.curPerctIndex = 0;
                this.maxCapacityForBinList = 200 * this.ordStatSettings.getMaxNumOfBins();
            }
            for (ScaBin bin : other.binList) {
                if (this.treatZeroAsMissing) {
                    if (bin.getLower() < 0.0) {
                        this.isValidStatAfterZeroInf = false;
                        return;
                    }
                    if (bin.containOneValue()) {
                        if (bin.getLower() == 0.0) {
                            this.totalWeight -= bin.getWeight();
                            continue;
                        }
                        if (MissingValue.isMissing((double)this.minValueWithoutZero)) {
                            this.minValueWithoutZero = bin.getLower();
                        } else if (this.minValueWithoutZero > bin.getLower()) {
                            this.minValueWithoutZero = bin.getLower();
                        }
                    }
                }
                this.accumWeight += bin.weight;
                if (this.curMaxUpper < bin.upper) {
                    this.curMaxUpper = bin.upper;
                }
                this.curPerctIndex = this.calcApprPerctAndInterQuartMean(bin, this.curMaxUpper, this.accumWeight, this.totalWeight, this.curPerctIndex);
                this.binList.pushBack(bin.clone());
                this.binList.handleOverlapAndGap(this.mergeThreshold);
                if (this.binList.size() <= this.maxCapacityForBinList) continue;
                this.compressBinList();
            }
        }
    }

    public void doReducePostOp() {
        this.binList.compress(this.ordStatSettings.getMaxNumOfClusters(), this.ordStatSettings.getCompressRangeThreshold());
    }

    public void merge(List<? extends EqualFreqBinning> mapResults) {
        if (this.percentileList == null) {
            this.initInRed();
        }
        Iterator<? extends EqualFreqBinning> iterator = mapResults.iterator();
        while (iterator.hasNext()) {
            EqualFreqBinning equalFreqBinning;
            EqualFreqBinning stat = equalFreqBinning = iterator.next();
            this.totalWeight += stat.totalWeight;
        }
        ArrayList<ScaBinList> vecBinList = new ArrayList<ScaBinList>(mapResults.size());
        Iterator<? extends EqualFreqBinning> iterator2 = mapResults.iterator();
        while (iterator2.hasNext()) {
            EqualFreqBinning mapResult3;
            EqualFreqBinning stat = mapResult3 = iterator2.next();
            if (stat.binList instanceof ArrScaBinList) {
                vecBinList.add(((ArrScaBinList)stat.binList).clone());
                continue;
            }
            throw new ACException("Unknow type of bin list", (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        double d = this.getCompressRangeFromBinLists(vecBinList);
        double mergeThreshold = 2.0 * d / ((1.0 - 2.0 * this.ordStatSettings.getCompressRangeThreshold()) * (double)this.ordStatSettings.getMaxNumOfBins() - 1.0);
        ArrayList<Tuple2Bin> frontList = new ArrayList<Tuple2Bin>(vecBinList.size());
        for (int i = 0; i < vecBinList.size(); ++i) {
            if (((ScaBinList)vecBinList.get(i)).size() <= 0) continue;
            frontList.add(new Tuple2Bin(((ScaBinList)vecBinList.get(i)).pop(), i));
        }
        Collections.sort(frontList);
        double accumWeight = 0.0;
        double curMaxUpper = -1.7976931348623157E308;
        int curPerctIndex = 0;
        int maxCapacityForBinList = 200 * this.ordStatSettings.getMaxNumOfBins();
        while (!frontList.isEmpty()) {
            Tuple2Bin binWithIndex = (Tuple2Bin)frontList.get(0);
            ScaBin bin = (ScaBin)binWithIndex.first;
            int curMapIndex = (Integer)binWithIndex.second;
            frontList.remove(0);
            if (((ScaBinList)vecBinList.get(curMapIndex)).size() > 0) {
                Tuple2Bin tupBin = new Tuple2Bin(((ScaBinList)vecBinList.get(curMapIndex)).pop(), curMapIndex);
                int insertPos = Collections.binarySearch(frontList, tupBin);
                if (insertPos < 0) {
                    insertPos = -insertPos - 1;
                }
                frontList.add(insertPos, tupBin);
            }
            accumWeight += bin.weight;
            if (curMaxUpper < bin.upper) {
                curMaxUpper = bin.upper;
            }
            curPerctIndex = this.calcApprPerctAndInterQuartMean(bin, curMaxUpper, accumWeight, this.totalWeight, curPerctIndex);
            this.binList.pushBack(bin);
            this.binList.handleOverlapAndGap(mergeThreshold);
            if (this.binList.size() <= maxCapacityForBinList) continue;
            this.compressBinList();
        }
        this.binList.compress(this.ordStatSettings.getMaxNumOfClusters(), this.ordStatSettings.getCompressRangeThreshold());
    }

    public void merge(EqualFreqBinning result, double totalWeight, double totalMin, double totalMax) {
        EqualFreqBinning eb = new EqualFreqBinning();
        eb.binList = this.binList;
        eb.totalWeight = this.totalWeight;
        eb.percentileList = this.percentileList;
        this.percentileList = null;
        this.binList = null;
        if (this.percentileList == null) {
            this.initInRed();
        }
        ArrayList<EqualFreqBinning> mapResults = new ArrayList<EqualFreqBinning>();
        mapResults.add(eb);
        mapResults.add(result);
        this.totalWeight = totalWeight;
        ArrayList<ArrScaBinList> vecBinList = new ArrayList<ArrScaBinList>(mapResults.size());
        Iterator iterator = mapResults.iterator();
        while (iterator.hasNext()) {
            EqualFreqBinning mapResult;
            EqualFreqBinning stat = mapResult = (EqualFreqBinning)iterator.next();
            if (stat.binList instanceof ArrScaBinList) {
                vecBinList.add(((ArrScaBinList)stat.binList).clone());
                continue;
            }
            throw new ACException("Unknow type of bin list", (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        double range = totalMax - totalMin;
        double mergeThreshold = 2.0 * range / ((1.0 - 2.0 * this.ordStatSettings.getCompressRangeThreshold()) * (double)this.ordStatSettings.getMaxNumOfBins() - 1.0);
        ArrayList<Tuple2Bin> frontList = new ArrayList<Tuple2Bin>(vecBinList.size());
        for (int i = 0; i < vecBinList.size(); ++i) {
            if (((ScaBinList)vecBinList.get(i)).size() <= 0) continue;
            frontList.add(new Tuple2Bin(((ScaBinList)vecBinList.get(i)).pop(), i));
        }
        Collections.sort(frontList);
        double accumWeight = 0.0;
        double curMaxUpper = -1.7976931348623157E308;
        int curPerctIndex = 0;
        int maxCapacityForBinList = 200 * this.ordStatSettings.getMaxNumOfBins();
        while (!frontList.isEmpty()) {
            Tuple2Bin binWithIndex = (Tuple2Bin)frontList.get(0);
            ScaBin bin = (ScaBin)binWithIndex.first;
            int curMapIndex = (Integer)binWithIndex.second;
            frontList.remove(0);
            if (((ScaBinList)vecBinList.get(curMapIndex)).size() > 0) {
                Tuple2Bin tupBin = new Tuple2Bin(((ScaBinList)vecBinList.get(curMapIndex)).pop(), curMapIndex);
                int insertPos = Collections.binarySearch(frontList, tupBin);
                if (insertPos < 0) {
                    insertPos = -insertPos - 1;
                }
                frontList.add(insertPos, tupBin);
            }
            accumWeight += bin.weight;
            if (curMaxUpper < bin.upper) {
                curMaxUpper = bin.upper;
            }
            curPerctIndex = this.calcApprPerctAndInterQuartMean(bin, curMaxUpper, accumWeight, totalWeight, curPerctIndex);
            this.binList.pushBack(bin);
            this.binList.handleOverlapAndGap(mergeThreshold);
            if (this.binList.size() <= maxCapacityForBinList) continue;
            this.compressBinList();
        }
        this.binList.compress(this.ordStatSettings.getMaxNumOfClusters(), this.ordStatSettings.getCompressRangeThreshold());
    }

    public ScaOrdStat getDerivedStatistics() {
        ScaOrdStat ordStat = new ScaOrdStat();
        ordStat.binList = this.binList;
        ordStat.percentileList = this.percentileList;
        ordStat.totalWeight = this.totalWeight;
        return ordStat;
    }

    public double[] getEFBiningCutPoints() {
        if (this.percentileList == null) {
            this.doMapPostOp();
            EqualFreqBinning other = new EqualFreqBinning();
            other.binList = this.binList;
            this.setBinList(null);
            this.initNoMR();
            this.merge(other);
            this.doReducePostOp();
        }
        if (this.binList.size() == 1) {
            return new double[0];
        }
        PercentileList percts = this.percentileList.getPercentiles(this.ordStatSettings.getPercentages4EFBinning());
        ArrayList<Double> cutPoints = new ArrayList<Double>();
        for (int i = 0; i < percts.size(); ++i) {
            double cutPoint = ((Percentile)percts.get(i)).getValue();
            if (i > 0) {
                if (!(Math.abs((Double)cutPoints.get(cutPoints.size() - 1) - cutPoint) > 1.0E-14) || cutPoint == this.curMaxUpper) continue;
                cutPoints.add(cutPoint);
                continue;
            }
            cutPoints.add(cutPoint);
        }
        return ACUtils.toDArray(cutPoints);
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.totalWeight);
        dataOutput.writeDouble(this.compressLower);
        dataOutput.writeDouble(this.compressUpper);
        dataOutput.writeDouble(this.compressLowerWithoutZero);
        dataOutput.writeDouble(this.compressUpperWithoutZero);
        EFBinSerializationUtils.writeScaBinList(this.binList, dataOutput);
        ACSerializationUtils.writeObject(EFBiningSettings.class, this.ordStatSettings, dataOutput);
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        this.totalWeight = dataInput.readDouble();
        this.compressLower = dataInput.readDouble();
        this.compressUpper = dataInput.readDouble();
        this.compressLowerWithoutZero = dataInput.readDouble();
        this.compressUpperWithoutZero = dataInput.readDouble();
        this.binList = EFBinSerializationUtils.readScaBinList(dataInput, new ScaBinListFactory());
        this.ordStatSettings = ACSerializationUtils.readObject(EFBiningSettings.class, dataInput);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.binList == null ? 0 : this.binList.hashCode());
        long temp = Double.doubleToLongBits(this.totalWeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EqualFreqBinning other = (EqualFreqBinning)obj;
        if (this.binList == null ? other.binList != null : !this.binList.equals(other.binList)) {
            return false;
        }
        return Double.doubleToLongBits(this.totalWeight) == Double.doubleToLongBits(other.totalWeight);
    }

    public String toString() {
        return "MRApprOrdStat [totalWeight=" + this.totalWeight + ", binList=" + this.binList + "]";
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public double getCompressLower() {
        return this.compressLower;
    }

    public double getCompressUpper() {
        return this.compressUpper;
    }

    public ScaBinList getBinList() {
        return this.binList;
    }

    public void setBinList(ScaBinList binList) {
        this.binList = binList;
    }

    private void compressBinList() {
        this.binList.compress(this.ordStatSettings.getMaxNumOfBins(), this.ordStatSettings.getCompressRangeThreshold());
    }

    private int calcApprPerctAndInterQuartMean(ScaBin bin, double curMaxUpper, double accumWeight, double totalWeight, int curPerctIndex) {
        int updatePerctIndex;
        for (updatePerctIndex = curPerctIndex; updatePerctIndex < this.percentileList.size(); ++updatePerctIndex) {
            Percentile percentile = (Percentile)this.percentileList.get(updatePerctIndex);
            if (!(accumWeight >= percentile.percentage * totalWeight)) break;
            percentile.lower = bin.lower;
            percentile.upper = curMaxUpper;
            percentile.value = bin.mean;
        }
        return updatePerctIndex;
    }

    private double getCompressRangeFromBinLists(List<ScaBinList> vBinList) {
        double maxUpper = -1.7976931348623157E308;
        double minLower = Double.MAX_VALUE;
        for (ScaBinList binList : vBinList) {
            double upper;
            double lower;
            int beginIndex = (int)((double)binList.size() * this.ordStatSettings.getCompressRangeThreshold());
            int endIndex = binList.size() - beginIndex - 1;
            if (beginIndex >= 0 && beginIndex < binList.size() && (lower = binList.get((int)beginIndex).lower) < minLower) {
                minLower = lower;
            }
            if (endIndex < 0 || endIndex >= binList.size() || !((upper = binList.get((int)endIndex).upper) > maxUpper)) continue;
            maxUpper = upper;
        }
        double range = Double.MAX_VALUE;
        if (maxUpper > minLower) {
            range = maxUpper - minLower;
        }
        return range;
    }

    private void initInMap() {
        this.totalWeight = 0.0;
        this.binList = new ScaBinListFactory().createBinList(this.ordStatSettings.getMaxNumOfBins());
        this.percentileList = null;
    }

    private void initInRed() {
        this.totalWeight = 0.0;
        this.compressLower = Double.POSITIVE_INFINITY;
        this.compressUpper = Double.NEGATIVE_INFINITY;
        this.binList = new ScaBinListFactory().createBinList(this.ordStatSettings.getMaxNumOfBins());
        this.percentileList = new PercentileList();
        for (double percentage : this.ordStatSettings.getPercentages()) {
            this.percentileList.add(new Percentile(percentage));
        }
        this.percentileList.sort();
    }

    private void initNoMR() {
        this.binList = new ScaBinListFactory().createBinList(this.ordStatSettings.getMaxNumOfBins());
        this.percentileList = new PercentileList();
        for (double percentage : this.ordStatSettings.getPercentages()) {
            this.percentileList.add(new Percentile(percentage));
        }
        this.percentileList.sort();
    }
}

