/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.serialization.ACSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Percentile
implements ACSerializable {
    private static final long serialVersionUID = -662441271473302423L;
    double percentage;
    double value;
    double lower;
    double upper;

    public Percentile() {
        this(0.0);
    }

    public Percentile(double percentage) {
        this(percentage, 0.0, 0.0, 0.0);
    }

    public Percentile(double percentage, double value, double lower, double upper) {
        this.percentage = percentage;
        this.value = value;
        this.lower = lower;
        this.upper = upper;
    }

    public boolean isExact() {
        return this.upper - this.lower < 1.0E-14;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.percentage);
        dataOutput.writeDouble(this.value);
        dataOutput.writeDouble(this.lower);
        dataOutput.writeDouble(this.upper);
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        this.percentage = dataInput.readDouble();
        this.value = dataInput.readDouble();
        this.lower = dataInput.readDouble();
        this.upper = dataInput.readDouble();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lower);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.percentage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.upper);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percentile other = (Percentile)obj;
        if (Double.doubleToLongBits(this.lower) != Double.doubleToLongBits(other.lower)) {
            return false;
        }
        if (Double.doubleToLongBits(this.percentage) != Double.doubleToLongBits(other.percentage)) {
            return false;
        }
        if (Double.doubleToLongBits(this.upper) != Double.doubleToLongBits(other.upper)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public String toString() {
        return "Percentile [percentage=" + this.percentage + ", value=" + this.value + ", lower=" + this.lower + ", upper=" + this.upper + "]";
    }

    public double getPercentage() {
        return this.percentage;
    }

    public double getValue() {
        return this.value;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }
}

