/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.efbining.Percentile;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.tuple.Tuple3;
import com.spss.math.MissingValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PercentileList
extends ArrayList<Percentile>
implements ACSerializable {
    private static final long serialVersionUID = -7164561443292299279L;

    public PercentileList() {
        this(99);
    }

    public PercentileList(int initialCapacity) {
        super(initialCapacity);
    }

    public boolean isExact() {
        boolean exact = true;
        for (Percentile percentile : this) {
            if (percentile.isExact()) continue;
            exact = false;
            break;
        }
        return exact;
    }

    public double getInterQuartRange() {
        double range = MissingValue.getMissing();
        Tuple3<Percentile, Percentile, Percentile> quartiles = this.getQuartiles();
        if (quartiles.first != null && quartiles.third != null) {
            range = ((Percentile)quartiles.third).value - ((Percentile)quartiles.first).value;
        }
        return range;
    }

    public Tuple3<Percentile, Percentile, Percentile> getQuartiles() {
        Percentile firstQuart = null;
        Percentile secondQuart = null;
        Percentile thirdQuart = null;
        for (Percentile perct : this) {
            if (Math.abs(perct.percentage - 0.25) < 1.0E-14) {
                firstQuart = perct;
            }
            if (Math.abs(perct.percentage - 0.5) < 1.0E-14) {
                secondQuart = perct;
            }
            if (!(Math.abs(perct.percentage - 0.75) < 1.0E-14)) continue;
            thirdQuart = perct;
        }
        if (firstQuart == null || secondQuart == null || thirdQuart == null) {
            // empty if block
        }
        return new Tuple3<Object, Object, Object>(firstQuart, secondQuart, thirdQuart);
    }

    public PercentileList getPercentiles(List<Double> percentages) {
        PercentileList result = new PercentileList();
        block0: for (Double percentage : percentages) {
            for (Percentile perct : this) {
                if (!(Math.abs(perct.percentage - percentage) < 1.0E-14)) continue;
                result.add(perct);
                continue block0;
            }
        }
        if (result.size() != percentages.size()) {
            // empty if block
        }
        return result;
    }

    public PercentileList getApprPercentiles() {
        PercentileList apprList = new PercentileList();
        for (Percentile perct : this) {
            if (perct.isExact()) continue;
            apprList.add(perct);
        }
        return apprList;
    }

    public PercentileList getExactPercentiles() {
        PercentileList exactList = new PercentileList();
        for (Percentile perct : this) {
            if (!perct.isExact()) continue;
            exactList.add(perct);
        }
        return exactList;
    }

    public void mergeOverlappedPercentiles() {
        int i = 0;
        while (i < this.size() - 1) {
            Percentile curPerct = (Percentile)this.get(i);
            Percentile nextPerct = (Percentile)this.get(i + 1);
            if (nextPerct.lower <= curPerct.upper) {
                curPerct.upper = nextPerct.upper;
                this.remove(i + 1);
                continue;
            }
            ++i;
        }
    }

    public void removeRepeatedPercentiles() {
        this.sort();
        int i = 0;
        while (i < this.size() - 1) {
            Percentile curPerct = (Percentile)this.get(i);
            Percentile nextPerct = (Percentile)this.get(i + 1);
            if (nextPerct.percentage - curPerct.percentage < 1.0E-14) {
                this.remove(i + 1);
                continue;
            }
            ++i;
        }
    }

    public void sort() {
        Collections.sort(this, new Comparator<Percentile>(){

            @Override
            public int compare(Percentile o1, Percentile o2) {
                if (o1.percentage < o2.percentage) {
                    return -1;
                }
                if (o1.percentage > o2.percentage) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void merge(PercentileList other) {
        for (Percentile perct : other) {
            this.add(perct);
        }
        other.clear();
        this.sort();
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.size());
        for (Percentile pecert : this) {
            pecert.writeObject(dataOutput);
        }
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        for (int i = 0; i < size; ++i) {
            Percentile perct = (Percentile)new Percentile().readObject(dataInput);
            this.add(perct);
        }
        return this;
    }

    @Override
    public String toString() {
        return "PercentileList [toString()=" + super.toString() + "]";
    }
}

