/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.i18n.LocMsgId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ScaBin
implements ACSerializable,
Cloneable {
    private static final long serialVersionUID = -5207178464105622349L;
    double lower;
    double upper;
    double mean;
    double weight;

    public ScaBin() {
        this(0.0, 0.0);
    }

    public ScaBin(double value, double weight) {
        this(value, value, value, weight);
    }

    public ScaBin(double lower, double upper, double mean, double weight) {
        this.lower = lower;
        this.upper = upper;
        this.mean = mean;
        this.weight = weight;
    }

    public static int getByteLength() {
        return 32;
    }

    public boolean update(double value, double weight) {
        boolean canUpdate;
        boolean bl = canUpdate = value >= this.lower && value <= this.upper;
        if (canUpdate) {
            this.weight += weight;
            this.mean += weight * (value - this.mean) / this.weight;
        }
        return canUpdate;
    }

    public void merge(ScaBin other) {
        if (other.lower < this.lower) {
            this.lower = other.lower;
        }
        if (other.upper > this.upper) {
            this.upper = other.upper;
        }
        this.update(other.mean, other.weight);
    }

    public boolean containOneValue() {
        return this.upper - this.lower <= 1.0E-14;
    }

    public boolean contains(double value) {
        return value >= this.lower && value <= this.upper;
    }

    protected ScaBin clone() {
        ScaBin bin = null;
        try {
            bin = (ScaBin)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        return bin;
    }

    public void resetWeightMean() {
        this.weight = 0.0;
        this.mean = 0.0;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.lower);
        dataOutput.writeDouble(this.upper);
        dataOutput.writeDouble(this.mean);
        dataOutput.writeDouble(this.weight);
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        this.lower = dataInput.readDouble();
        this.upper = dataInput.readDouble();
        this.mean = dataInput.readDouble();
        this.weight = dataInput.readDouble();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lower);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.upper);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScaBin other = (ScaBin)obj;
        if (Double.doubleToLongBits(this.lower) != Double.doubleToLongBits(other.lower)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mean) != Double.doubleToLongBits(other.mean)) {
            return false;
        }
        if (Double.doubleToLongBits(this.upper) != Double.doubleToLongBits(other.upper)) {
            return false;
        }
        return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }

    public String toString() {
        return "ScaBin [lower=" + this.lower + ", upper=" + this.upper + ", mean=" + this.mean + ", weight=" + this.weight + "]";
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public double getMean() {
        return this.mean;
    }

    public double getWeight() {
        return this.weight;
    }
}

