/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.efbining;

import com.spss.ac.acbase.efbining.EFBinSerializationUtils;
import com.spss.ac.acbase.efbining.PercentileList;
import com.spss.ac.acbase.efbining.ScaBinList;
import com.spss.ac.acbase.efbining.ScaBinListFactory;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.math.MissingValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ScaOrdStat
implements ACSerializable {
    private static final long serialVersionUID = -1079673180314055365L;
    protected ScaBinList binList;
    protected PercentileList percentileList;
    protected double totalWeight;

    public ScaOrdStat() {
        this.binList = null;
        this.percentileList = null;
        this.totalWeight = MissingValue.getMissing();
    }

    public ScaOrdStat(ScaBinList binList, PercentileList percentileList, double totalWeight) {
        this.binList = binList;
        this.percentileList = percentileList;
        this.totalWeight = totalWeight;
    }

    public boolean isExact() {
        boolean exact = false;
        exact = this.binList.isExact() && this.percentileList.isExact();
        return exact;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        EFBinSerializationUtils.writeScaBinList(this.binList, dataOutput);
        ACSerializationUtils.writeObject(PercentileList.class, this.percentileList, dataOutput);
        dataOutput.writeDouble(this.totalWeight);
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        this.binList = EFBinSerializationUtils.readScaBinList(dataInput, new ScaBinListFactory());
        this.percentileList = ACSerializationUtils.readObject(PercentileList.class, dataInput);
        this.totalWeight = dataInput.readDouble();
        return this;
    }

    public String toString() {
        return "OrderStatistics [binList=" + this.binList + ", percentileList=" + this.percentileList + ", , weight=" + this.totalWeight + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.binList == null ? 0 : this.binList.hashCode());
        result = 31 * result + (this.percentileList == null ? 0 : this.percentileList.hashCode());
        long temp = Double.doubleToLongBits(this.totalWeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScaOrdStat other = (ScaOrdStat)obj;
        if (this.binList == null ? other.binList != null : !this.binList.equals(other.binList)) {
            return false;
        }
        if (this.percentileList == null ? other.percentileList != null : !this.percentileList.equals(other.percentileList)) {
            return false;
        }
        return Double.doubleToLongBits(this.totalWeight) == Double.doubleToLongBits(other.totalWeight);
    }

    public ScaBinList getBinList() {
        return this.binList;
    }

    public PercentileList getPercentileList() {
        return this.percentileList;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }
}

