/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.analyticframework.api.parameters.ParamValue;
import com.spss.analyticframework.api.parameters.Parameter;
import com.spss.analyticframework.api.parameters.Parameters;
import com.spss.analyticframework.api.parameters.values.BoolParamValue;
import com.spss.analyticframework.api.parameters.values.IntParamValue;
import com.spss.analyticframework.api.parameters.values.ListParamValue;
import com.spss.analyticframework.api.parameters.values.RealParamValue;
import com.spss.analyticframework.api.parameters.values.StringParamValue;
import com.spss.analyticframework.api.parameters.values.StructParamValue;
import com.spss.analyticframework.componentapi.expectedparams.ExpectParam;
import com.spss.analyticframework.componentapi.expectedparams.ExpectParamValue;
import com.spss.utilities.i18n.LocMsgId;
import java.util.ArrayList;
import java.util.Map;

public class JsonParamConvertor {
    public static Parameters json2Params(JSONObject jsonObject) {
        return new Parameters(JsonParamConvertor.json2IterableParam(jsonObject));
    }

    public static JSONObject params2Json(Parameters params) {
        return JsonParamConvertor.paramVal2JsonObject((Iterable<Parameter>)params);
    }

    public static boolean isDefaultParam(ParamValue value) {
        boolean result;
        block3: {
            block6: {
                block5: {
                    block4: {
                        if (value == null) {
                            return false;
                        }
                        result = false;
                        if (!(value instanceof Parameter)) break block4;
                        result = value instanceof ExpectParam ? true : JsonParamConvertor.isDefaultParam(((Parameter)value).getValue());
                        break block3;
                    }
                    if (!(value instanceof ExpectParamValue)) break block5;
                    result = true;
                    break block3;
                }
                if (!(value instanceof ListParamValue)) break block6;
                for (ParamValue subVal : (ListParamValue)value) {
                    if (!JsonParamConvertor.isDefaultParam(subVal)) continue;
                    result = true;
                    break block3;
                }
                break block3;
            }
            if (!(value instanceof StructParamValue)) break block3;
            for (ParamValue subVal : (StructParamValue)value) {
                if (!JsonParamConvertor.isDefaultParam(subVal)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static Iterable<Parameter> json2IterableParam(JSONObject jsonObject) {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>(jsonObject.size());
        JSONObject map = jsonObject;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            ParamValue paramVal = JsonParamConvertor.object2ParamValue(entry.getValue());
            paramList.add(new Parameter(key.toString(), paramVal));
        }
        return paramList;
    }

    private static ParamValue object2ParamValue(Object object) {
        BoolParamValue result = null;
        if (object != null) {
            if (object instanceof Boolean) {
                result = new BoolParamValue((Boolean)object);
            } else if (object instanceof Integer) {
                result = new IntParamValue((Integer)object);
            } else if (object instanceof Long) {
                result = new IntParamValue((Long)object);
            } else if (object instanceof Float) {
                result = new RealParamValue((Float)object);
            } else if (object instanceof Double) {
                result = new RealParamValue((Double)object);
            } else if (object instanceof String) {
                result = new StringParamValue((String)object);
            } else if (object instanceof JSONObject) {
                result = new StructParamValue(JsonParamConvertor.json2IterableParam((JSONObject)object));
            } else if (object instanceof JSONArray) {
                JSONArray arr = (JSONArray)object;
                ArrayList<ParamValue> valList = new ArrayList<ParamValue>();
                for (Object obj : arr) {
                    valList.add(JsonParamConvertor.object2ParamValue(obj));
                }
                result = new ListParamValue(valList);
            } else {
                throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
            }
        }
        return result;
    }

    private static JSONObject paramVal2JsonObject(Iterable<Parameter> paramIt) {
        JSONObject jsonObject = new JSONObject();
        for (Parameter param : paramIt) {
            jsonObject.put((Object)param.getName(), JsonParamConvertor.paramVal2Object(param.getValue()));
        }
        return jsonObject;
    }

    private static Object paramVal2Object(ParamValue paramVal) {
        if (paramVal == null) {
            return null;
        }
        Object result = null;
        if (paramVal instanceof StringParamValue) {
            result = ((StringParamValue)paramVal).getRawValue();
        } else if (paramVal instanceof IntParamValue) {
            result = ((IntParamValue)paramVal).getRawValue();
        } else if (paramVal instanceof RealParamValue) {
            result = ((RealParamValue)paramVal).getRawValue();
        } else if (paramVal instanceof BoolParamValue) {
            result = ((BoolParamValue)paramVal).getRawValue();
        } else if (paramVal instanceof ListParamValue) {
            ListParamValue list = (ListParamValue)paramVal;
            JSONArray arr = new JSONArray();
            for (ParamValue subVal : list) {
                arr.add(JsonParamConvertor.paramVal2Object(subVal));
            }
            result = arr;
        } else if (paramVal instanceof StructParamValue) {
            result = JsonParamConvertor.paramVal2JsonObject((Iterable<Parameter>)((StructParamValue)paramVal));
        } else {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        return result;
    }
}

