/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.spss.ac.acbase.collections.ACUtils;
import java.util.ArrayList;
import java.util.List;

public class JsonParser {
    protected JSONObject jObject;

    public JsonParser(JSONObject jObject) {
        this.jObject = jObject;
    }

    public JsonParser getJsonParser(String name) {
        JSONObject object = (JSONObject)this.jObject.get((Object)name);
        return new JsonParser(object);
    }

    public Object getObject(String name) {
        return this.jObject.get((Object)name);
    }

    public JSONObject getJsonObject(String name) {
        JSONObject object = (JSONObject)this.jObject.get((Object)name);
        return object;
    }

    public JSONArray getJsonArray(String name) {
        JSONArray object = (JSONArray)this.jObject.get((Object)name);
        return object;
    }

    public boolean hasElement(String name) {
        return this.jObject.get((Object)name) != null;
    }

    public Byte getByte(String name) {
        Byte result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj instanceof Number ? Byte.valueOf(((Number)obj).byteValue()) : Byte.valueOf(Byte.parseByte(obj.toString()));
        }
        return result;
    }

    public Short getShort(String name) {
        Short result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj instanceof Number ? Short.valueOf(((Number)obj).shortValue()) : Short.valueOf(Short.parseShort(obj.toString()));
        }
        return result;
    }

    public Integer getInt(String name) {
        Integer result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj instanceof Number ? Integer.valueOf(((Number)obj).intValue()) : Integer.valueOf(Integer.parseInt(obj.toString()));
        }
        return result;
    }

    public Long getLong(String name) {
        Long result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj instanceof Number ? Long.valueOf(((Number)obj).longValue()) : Long.valueOf(Long.parseLong(obj.toString()));
        }
        return result;
    }

    public Float getFloat(String name) {
        Float result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj instanceof Number ? Float.valueOf(((Number)obj).floatValue()) : Float.valueOf(Float.parseFloat(obj.toString()));
        }
        return result;
    }

    public Double getDouble(String name) {
        Double result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj instanceof Number ? Double.valueOf(((Number)obj).doubleValue()) : Double.valueOf(Double.parseDouble(obj.toString()));
        }
        return result;
    }

    public Boolean getBool(String name) {
        Boolean result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj instanceof Boolean ? (Boolean)obj : Boolean.valueOf(obj.toString().compareToIgnoreCase("true") == 0);
        }
        return result;
    }

    public String getString(String name) {
        String result = null;
        Object obj = this.jObject.get((Object)name);
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    public List<String> getStringList(String name) {
        String[] result = this.getStringArray(name);
        if (result != null) {
            ArrayList<String> strList = new ArrayList<String>(result.length);
            for (String str : result) {
                strList.add(str);
            }
            return strList;
        }
        return null;
    }

    public String[] getStringArray(String name) {
        String[] result = null;
        JSONArray arr = (JSONArray)this.jObject.get((Object)name);
        if (arr != null) {
            result = new String[arr.size()];
            int i = 0;
            for (Object obj : arr) {
                if (obj != null) {
                    result[i] = obj.toString();
                }
                ++i;
            }
        }
        return result;
    }

    public List<Integer> getIntList(String name) {
        return ACUtils.toList(this.getIntArray(name));
    }

    public int[] getIntArray(String name) {
        int[] result = null;
        JSONArray arr = (JSONArray)this.jObject.get((Object)name);
        if (arr != null) {
            result = new int[arr.size()];
            int i = 0;
            for (Object obj : arr) {
                result[i] = obj instanceof Number ? ((Number)obj).intValue() : Integer.parseInt(obj.toString());
                ++i;
            }
        }
        return result;
    }

    public List<Double> getDoubleList(String name) {
        return ACUtils.toList(this.getDoubleArray(name));
    }

    public double[] getDoubleArray(String name) {
        double[] result = null;
        JSONArray arr = (JSONArray)this.jObject.get((Object)name);
        if (arr != null) {
            result = new double[arr.size()];
            int i = 0;
            for (Object obj : arr) {
                result[i] = obj instanceof Number ? ((Number)obj).doubleValue() : Double.parseDouble(obj.toString());
                ++i;
            }
        }
        return result;
    }

    public List<List<Integer>> getIntListList(String name) {
        int[][] arr = this.getIntArrayArray(name);
        ArrayList<List<Integer>> result = null;
        if (arr != null) {
            result = new ArrayList<List<Integer>>(arr.length);
            for (int[] arr2 : arr) {
                result.add(ACUtils.toList(arr2));
            }
        }
        return result;
    }

    public int[][] getIntArrayArray(String name) {
        Object result = null;
        JSONArray arr = (JSONArray)this.jObject.get((Object)name);
        if (arr != null) {
            result = new int[arr.size()][];
            for (int i = 0; i < arr.size(); ++i) {
                JSONArray objArr = (JSONArray)arr.get(i);
                result[i] = new int[objArr.size()];
                for (int j = 0; j < objArr.size(); ++j) {
                    Object obj = objArr.get(j);
                    result[i][j] = obj instanceof Number ? ((Number)obj).intValue() : Integer.parseInt(obj.toString());
                }
            }
        }
        return result;
    }
}

