/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.mr;

import com.spss.ac.acbase.mr.ACMapReduceUtils;
import com.spss.analyticframework.directorapi.plans.mixins.JobAware;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ACJobAware
implements JobAware {
    private static Logger log = Logger.getLogger(ACJobAware.class);
    protected int maxMapCapacity = 1;
    private int maxReduceCapacity = 1;
    private int totalBlocks = 1;

    public ACJobAware(Properties properties) {
        this(properties, 1, 1);
    }

    public ACJobAware(Properties properties, int maxMapCapacity, int maxReduceCapacity) {
        this(properties, maxMapCapacity, maxReduceCapacity, 1);
    }

    public ACJobAware(Properties properties, int maxMapCapacity, int maxReduceCapacity, int totalBlocks) {
        this.maxMapCapacity = maxMapCapacity;
        this.maxReduceCapacity = maxReduceCapacity;
        this.totalBlocks = totalBlocks;
        this.setProperties(properties);
    }

    public int getMaxMapCapacity() {
        return this.maxMapCapacity;
    }

    public int getMaxReduceCapacity() {
        return this.maxReduceCapacity;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public void setProperties(Properties arg0) {
        if (arg0 != null) {
            Integer value = ACMapReduceUtils.getIntProperty("max.map.parallel.tasks", arg0);
            if (value != null) {
                this.maxMapCapacity = value;
            }
            log.debug((Object)("Max map capacity: " + this.maxMapCapacity));
            value = ACMapReduceUtils.getIntProperty("max.reduce.parallel.tasks", arg0);
            if (value != null) {
                this.maxReduceCapacity = value;
            }
            log.debug((Object)("Max reduce capacity: " + this.maxReduceCapacity));
            value = ACMapReduceUtils.getIntProperty("total.blocks", arg0);
            if (value != null) {
                this.totalBlocks = value;
            }
            log.debug((Object)("Total blocks: " + this.totalBlocks));
        }
    }
}

