/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.mr;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ACMRJobsLog {
    private static final Logger log = Logger.getLogger(ACMRJobsLog.class);
    private long startTime = 0L;
    private List<String> jobNames = new ArrayList<String>();
    private List<Long> timesOfMR = new ArrayList<Long>();
    private List<Long> timesOfController = new ArrayList<Long>();
    private List<Long> timesOfJob = new ArrayList<Long>();
    private List<Double> percentOfMR = new ArrayList<Double>();
    private List<Double> percentOfController = new ArrayList<Double>();

    public void startMRJob(String jobName) {
        this.startTime = System.currentTimeMillis();
        this.jobNames.add(jobName);
    }

    public void endOfMRComputation() {
        long endTime = System.currentTimeMillis();
        this.timesOfMR.add(endTime - this.startTime);
        this.startTime = System.currentTimeMillis();
    }

    public void endOfContoller() {
        long endTime = System.currentTimeMillis();
        long ctlTime = endTime - this.startTime;
        this.timesOfController.add(ctlTime);
        long totalTime = this.timesOfMR.get(this.timesOfMR.size() - 1) + ctlTime;
        this.timesOfJob.add(totalTime);
        double ctlPercent = (double)ctlTime * 100.0 / (double)totalTime;
        this.percentOfMR.add(100.0 - ctlPercent);
        this.percentOfController.add(ctlPercent);
        this.startTime = 0L;
    }

    public void dumpLogInfo() {
        if (!this.jobNames.isEmpty() && this.jobNames.size() == this.timesOfMR.size() && this.timesOfMR.size() == this.timesOfController.size()) {
            String caption = "JobName, MR_Times, %, Controller_Times, %, Total_Times, %";
            log.debug((Object)caption);
            long allJobsTimes = 0L;
            for (Long jobTime : this.timesOfJob) {
                allJobsTimes += jobTime.longValue();
            }
            String comma = ", ";
            int jobCount = this.jobNames.size();
            for (int i = 0; i < jobCount; ++i) {
                StringBuilder group = new StringBuilder();
                group.append(this.jobNames.get(i));
                group.append(comma);
                group.append(this.timesOfMR.get(i));
                group.append(comma);
                group.append(this.percentOfMR.get(i));
                group.append(comma);
                group.append(this.timesOfController.get(i));
                group.append(comma);
                group.append(this.percentOfController.get(i));
                group.append(comma);
                group.append(this.timesOfJob.get(i));
                group.append(comma);
                group.append((double)this.timesOfJob.get(i).longValue() * 100.0 / (double)allJobsTimes);
                log.debug((Object)group.toString());
            }
        }
    }
}

