/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.parameter;

import com.spss.analyticframework.api.parameters.ParamValue;
import com.spss.analyticframework.api.parameters.Parameter;
import com.spss.analyticframework.api.parameters.Parameters;
import com.spss.analyticframework.api.parameters.values.BoolParamValue;
import com.spss.analyticframework.api.parameters.values.IntParamValue;
import com.spss.analyticframework.api.parameters.values.ListParamValue;
import com.spss.analyticframework.api.parameters.values.RealParamValue;
import com.spss.analyticframework.api.parameters.values.StringParamValue;
import com.spss.analyticframework.api.parameters.values.TypedParamValue;
import com.spss.analyticframework.api.parameters.values.types.IntParamType;
import java.util.ArrayList;
import java.util.List;

public class ParamParser {
    protected Parameters params = null;

    public static ParamParser getParser(Parameters params) {
        return new ParamParser(params);
    }

    protected ParamParser(Parameters params) {
        this.params = params;
    }

    public boolean hasParam(String name) {
        return this.params.getParameter(name) != null;
    }

    public Boolean getBool(String name) {
        Parameter param = this.params.getParameter(name);
        return (Boolean)((BoolParamValue)param.getValue()).getValue();
    }

    public Integer getInt(String name) {
        Parameter param = this.params.getParameter(name);
        Long lVal = (Long)((IntParamValue)param.getValue()).getValue();
        return lVal.intValue();
    }

    public Long getLong(String name) {
        Parameter param = this.params.getParameter(name);
        Long lVal = (Long)((IntParamValue)param.getValue()).getValue();
        return lVal;
    }

    public Double getDouble(String name) {
        Parameter param = this.params.getParameter(name);
        if (param.getValue() instanceof IntParamValue) {
            return ((Long)((IntParamValue)param.getValue()).getValue()).doubleValue();
        }
        return (Double)((RealParamValue)param.getValue()).getValue();
    }

    public String getString(String name) {
        String result = null;
        Parameter param = this.params.getParameter(name);
        if (param != null && param.getValue() != null) {
            result = (String)((StringParamValue)param.getValue()).getValue();
        }
        return result;
    }

    public List<String> getStringList(String name) {
        ArrayList<Object> valueList = null;
        Parameter param = this.params.getParameter(name);
        if (param != null) {
            valueList = new ArrayList<Object>();
            ListParamValue listParamVal = (ListParamValue)param.getValue();
            if (listParamVal != null) {
                for (ParamValue paramVal : listParamVal) {
                    valueList.add(((StringParamValue)paramVal).getValue());
                }
            }
        }
        return valueList;
    }

    public List<Integer> getIntList(String name) {
        ArrayList<Integer> valueList = null;
        Parameter param = this.params.getParameter(name);
        if (param != null) {
            valueList = new ArrayList<Integer>();
            ListParamValue listParamVal = (ListParamValue)param.getValue();
            for (ParamValue paramVal : listParamVal) {
                Long lVal = (Long)((IntParamValue)paramVal).getValue();
                valueList.add(lVal.intValue());
            }
        }
        return valueList;
    }

    public List<Double> getDoubleList(String name) {
        ArrayList<Object> valueList = null;
        Parameter param = this.params.getParameter(name);
        if (param != null) {
            valueList = new ArrayList<Object>();
            ListParamValue listParamVal = (ListParamValue)param.getValue();
            for (ParamValue paramVal : listParamVal) {
                if (paramVal.getType() instanceof IntParamType) {
                    valueList.add(Double.valueOf(((Long)((IntParamValue)paramVal).getValue()).longValue()));
                    continue;
                }
                valueList.add(((RealParamValue)paramVal).getValue());
            }
        }
        return valueList;
    }

    public List<List<String>> getStringListList(String name) {
        ArrayList valueList = null;
        Parameter param = this.params.getParameter(name);
        if (param != null) {
            valueList = new ArrayList();
            ListParamValue listParamVal = (ListParamValue)param.getValue();
            if (listParamVal != null) {
                for (ParamValue paramVal : listParamVal) {
                    ArrayList<Object> valueListInner = new ArrayList<Object>();
                    ListParamValue listParamValInner = (ListParamValue)paramVal;
                    for (ParamValue paramValInner : listParamValInner) {
                        valueListInner.add(((StringParamValue)paramValInner).getValue());
                    }
                    valueList.add(valueListInner);
                }
            }
        }
        return valueList;
    }

    public List<List<Integer>> getIntListList(String name) {
        ArrayList valueList = null;
        Parameter param = this.params.getParameter(name);
        if (param != null) {
            valueList = new ArrayList();
            ListParamValue listParamVal = (ListParamValue)param.getValue();
            if (listParamVal != null) {
                for (ParamValue paramVal : listParamVal) {
                    ArrayList<Integer> valueListInner = new ArrayList<Integer>();
                    ListParamValue listParamValInner = (ListParamValue)paramVal;
                    for (ParamValue paramValInner : listParamValInner) {
                        valueListInner.add(((Long)((IntParamValue)paramValInner).getValue()).intValue());
                    }
                    valueList.add(valueListInner);
                }
            }
        }
        return valueList;
    }

    public <T> List<List<T>> getListListValue(String name) {
        ArrayList valueList = null;
        Parameter param = this.params.getParameter(name);
        if (param != null) {
            valueList = new ArrayList();
            ListParamValue listParamVal = (ListParamValue)param.getValue();
            if (listParamVal != null) {
                for (ParamValue paramVal : listParamVal) {
                    ArrayList<Object> valueListInner = new ArrayList<Object>();
                    ListParamValue listParamValInner = (ListParamValue)paramVal;
                    for (ParamValue paramValInner : listParamValInner) {
                        valueListInner.add(((TypedParamValue)paramValInner).getValue());
                    }
                    valueList.add(valueListInner);
                }
            }
        }
        return valueList;
    }

    public List<Boolean> getBooleanList(String name) {
        ArrayList<Boolean> valueList = null;
        Parameter param = this.params.getParameter(name);
        if (param != null) {
            valueList = new ArrayList<Boolean>();
            ListParamValue listParamVal = (ListParamValue)param.getValue();
            for (ParamValue paramVal : listParamVal) {
                Boolean lVal = (Boolean)((BoolParamValue)paramVal).getValue();
                valueList.add(lVal);
            }
        }
        return valueList;
    }
}

