/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.tuple;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.i18n.LocMsgId;

public class DIPair
implements Comparable<DIPair>,
Cloneable {
    public double first;
    public int second;

    public DIPair() {
    }

    public DIPair(double first, int second) {
        this.first = first;
        this.second = second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.first);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.second;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DIPair other = (DIPair)obj;
        if (Double.doubleToLongBits(this.first) != Double.doubleToLongBits(other.first)) {
            return false;
        }
        return this.second == other.second;
    }

    @Override
    public int compareTo(DIPair o) {
        int result = Double.compare(this.first, o.first);
        if (result == 0) {
            if (this.second < o.second) {
                return -1;
            }
            if (this.second > o.second) {
                return 1;
            }
            return 0;
        }
        return result;
    }

    public DIPair clone() {
        try {
            return (DIPair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }
}

