/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.tuple;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.i18n.LocMsgId;

public class IDPair
implements Comparable<IDPair>,
Cloneable {
    public int first;
    public double second;

    public IDPair() {
    }

    public IDPair(int first, double second) {
        this.first = first;
        this.second = second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.first;
        long temp = Double.doubleToLongBits(this.second);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public IDPair clone() {
        try {
            return (IDPair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IDPair other = (IDPair)obj;
        if (this.first != other.first) {
            return false;
        }
        return Double.doubleToLongBits(this.second) == Double.doubleToLongBits(other.second);
    }

    public String toString() {
        return "IDPair [first=" + this.first + ", second=" + this.second + "]";
    }

    @Override
    public int compareTo(IDPair o) {
        int result = 0;
        result = this.first > o.first ? 1 : (this.first < o.first ? -1 : Double.compare(this.second, o.second));
        return result;
    }
}

