/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.ac.acbase.annotation.FromCppClass;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.ac.acmath.accumstats.AccumTestStats4ContTarget;
import com.spss.ac.acmath.output.HistogramData;
import com.spss.math.MissingValue;
import com.spss.math.statistics.DistributionFunctions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@FromCppClass(value="MCMATH_NAMESPACE::MCInteractCovariateFactor")
public class InteractCovarFactorForContTarget
implements AccumTestStats4ContTarget,
ACSerializable {
    private static final long serialVersionUID = -6978663001727675893L;
    private int nLevels = 0;
    private boolean isCheckEmpty = true;
    private int covarX = -1;
    private int factorX = -1;
    private int targetX = -1;
    private int weightX = -1;
    private double[] nRecs = null;
    private double[] nOriRecs = null;
    private double[] covarMeans = null;
    private double[] targetMeans = null;
    private double[] sSqCovar = null;
    private double[] sSqTarget = null;
    private double[] xProds = null;
    private double validNRecs = 0.0;
    private double totalNRecs = 0.0;
    private double targetMean = 0.0;
    private double totalSSqTarget = 0.0;
    private double totalSSqTargetDF = MissingValue.getMissing();
    private double sSeFull = MissingValue.getMissing();
    private double sSeFullDF = MissingValue.getMissing();
    private double mSeFull = MissingValue.getMissing();
    private double ssInteract = MissingValue.getMissing();
    private double ssInteractDF = MissingValue.getMissing();
    private double msInteract = MissingValue.getMissing();
    private int validUpdCnt = 0;
    private int invalidUpdCnt = 0;
    private boolean isPerfectFit = false;
    private double fStat = MissingValue.getMissing();
    private double pValue = MissingValue.getMissing();
    private double fitMeasure = MissingValue.getMissing();
    private double interestingness = MissingValue.getMissing();
    private boolean isIncludeTarHist = false;
    private HistogramData targetHist = null;

    public InteractCovarFactorForContTarget(int nLevels, int covarX, int factorX, int targetX, int weightX, boolean isIncludeTarHist, double targetMin, double targetMax) {
        this.nLevels = nLevels;
        this.covarX = covarX;
        this.factorX = factorX;
        this.targetX = targetX;
        this.weightX = weightX;
        this.isCheckEmpty = true;
        this.nRecs = new double[nLevels];
        this.covarMeans = new double[nLevels];
        this.targetMeans = new double[nLevels];
        this.sSqCovar = new double[nLevels];
        this.sSqTarget = new double[nLevels];
        this.xProds = new double[nLevels];
        this.isIncludeTarHist = isIncludeTarHist;
        if (isIncludeTarHist) {
            this.targetHist = new HistogramData(400, targetMin, targetMax, true);
        }
    }

    public InteractCovarFactorForContTarget() {
        this(0, -1, -1, -1, -1, false, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public void setNLevels(int nLevels) {
        this.nLevels = nLevels;
        this.nRecs = new double[nLevels];
        this.covarMeans = new double[nLevels];
        this.targetMeans = new double[nLevels];
        this.sSqCovar = new double[nLevels];
        this.sSqTarget = new double[nLevels];
        this.xProds = new double[nLevels];
    }

    @Override
    public void setAggregatedStatistics(double[] arrNRecs, double[] arrTargetMeans, double[] arrSSq, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
    }

    public int getNLevels() {
        return this.nLevels;
    }

    @Override
    public int getNFactorCategs() {
        return this.nLevels;
    }

    public void setCovarIndex(int covarX) {
        this.covarX = covarX;
    }

    public int getCovarIndex() {
        return this.covarX;
    }

    public void setFactorIndex(int factorX) {
        this.factorX = factorX;
    }

    public int getFactorIndex() {
        return this.factorX;
    }

    public void setTargetIndex(int targetX) {
        this.targetX = targetX;
    }

    @Override
    public int getTargetIndex() {
        return this.targetX;
    }

    public void setWeightIndex(int weightX) {
        this.weightX = weightX;
    }

    @Override
    public int getWeightIndex() {
        return this.weightX;
    }

    @Override
    public double getFStat() {
        return this.fStat;
    }

    @Override
    public double[] getNRecs() {
        return this.nRecs;
    }

    public double[] getNOriRecs() {
        return this.nOriRecs;
    }

    public double[] getCovarMeans() {
        return this.covarMeans;
    }

    public double[] getCovarSSqDiffs() {
        return this.sSqCovar;
    }

    @Override
    public double[] getTargetMeans() {
        return this.targetMeans;
    }

    @Override
    public double[] getTargetSSqDiffs() {
        return this.sSqTarget;
    }

    public double[] getXProds() {
        return this.xProds;
    }

    @Override
    public double getTotalNRecs() {
        return this.totalNRecs;
    }

    @Override
    public double getValidNRecs() {
        return this.validNRecs;
    }

    @Override
    public int getUnweightedNRecs() {
        return this.validUpdCnt;
    }

    @Override
    public double getTotalTargetMean() {
        return this.targetMean;
    }

    @Override
    public double getTotalSumOfSquares() {
        return this.totalSSqTarget;
    }

    @Override
    public double getTotalDegreesOfFreedom() {
        return this.totalSSqTargetDF;
    }

    @Override
    public double getErrorSumOfSquares() {
        return this.sSeFull;
    }

    @Override
    public double getErrorDegreesOfFreedom() {
        return this.sSeFullDF;
    }

    @Override
    public double getErrorMeanSquares() {
        return this.mSeFull;
    }

    @Override
    public double getModelSumOfSquares() {
        return this.ssInteract;
    }

    @Override
    public double getModelDegreesOfFreedom() {
        return this.ssInteractDF;
    }

    @Override
    public double getModelMeanSquares() {
        return this.msInteract;
    }

    public double getInteractMeasure() {
        double result = MissingValue.getMissing();
        if (this.totalSSqTarget > 0.0) {
            result = this.ssInteract / this.totalSSqTarget;
        }
        return result;
    }

    @Override
    public int getValidUpdCnt() {
        return this.validUpdCnt;
    }

    @Override
    public int getInvalidUpdCnt() {
        return this.invalidUpdCnt;
    }

    public boolean isPerfectFit() {
        return this.isPerfectFit;
    }

    public boolean update(double covar, int level, double target, double weight, boolean checkArgs) {
        boolean result = true;
        if (checkArgs) {
            boolean bl = result = !MissingValue.isMissing((double)covar) && level >= 0 && level < this.nLevels && !MissingValue.isMissing((double)target) && !MissingValue.isMissing((double)weight) && weight > 0.0;
        }
        if (result) {
            double newW;
            double oldW = this.nRecs[level];
            this.nRecs[level] = newW = oldW + weight;
            double oldMeanC = this.covarMeans[level];
            int n = level;
            this.covarMeans[n] = this.covarMeans[n] + weight / newW * (covar - oldMeanC);
            double oldMeanT = this.targetMeans[level];
            int n2 = level;
            this.targetMeans[n2] = this.targetMeans[n2] + weight / newW * (target - oldMeanT);
            double diffC = covar - oldMeanC;
            int n3 = level;
            this.sSqCovar[n3] = this.sSqCovar[n3] + weight * oldW / newW * diffC * diffC;
            double diffT = target - oldMeanT;
            int n4 = level;
            this.sSqTarget[n4] = this.sSqTarget[n4] + weight * oldW / newW * diffT * diffT;
            int n5 = level;
            this.xProds[n5] = this.xProds[n5] + weight * oldW / newW * diffC * diffT;
            oldW = this.totalNRecs;
            this.totalNRecs = newW = oldW + weight;
            double oldMean = this.targetMean;
            this.targetMean += weight / newW * (target - oldMean);
            double diff = target - oldMean;
            this.totalSSqTarget += weight * oldW / newW * diff * diff;
            ++this.validUpdCnt;
            this.validNRecs += weight;
        } else {
            ++this.invalidUpdCnt;
            if (!MissingValue.isMissing((double)weight) && weight > 0.0) {
                this.totalNRecs += weight;
            }
        }
        return result;
    }

    public boolean update(double covar, int level, double target, boolean checkArgs) {
        return this.update(covar, level, target, 1.0, checkArgs);
    }

    @Override
    public boolean update(double[] record, boolean checkArgs) {
        boolean result;
        boolean bl = result = this.covarX >= 0 && this.factorX >= 0 && this.targetX >= 0;
        if (result) {
            double covar = record[this.covarX];
            int level = (int)record[this.factorX];
            double target = record[this.targetX];
            double weight = this.weightX >= 0 ? record[this.weightX] : 1.0;
            result = this.update(covar, level, target, weight, checkArgs);
        }
        return result;
    }

    @Override
    public boolean merge(AccumStats4InteractTests other) {
        boolean result = true;
        InteractCovarFactorForContTarget otherObj = (InteractCovarFactorForContTarget)other;
        if (otherObj.nLevels == 0) {
            return result;
        }
        boolean bl = result = this.nLevels == otherObj.nLevels;
        if (this.nLevels == 0) {
            this.setNLevels(otherObj.nLevels);
            this.setCovarIndex(otherObj.covarX);
            this.setFactorIndex(otherObj.factorX);
            this.setTargetIndex(otherObj.targetX);
            this.setWeightIndex(otherObj.weightX);
            result = true;
        }
        if (result) {
            for (int i = 0; i < this.nLevels; ++i) {
                double newMeanT;
                double newMeanC;
                double newW;
                double oldW = this.nRecs[i];
                double otherOldW = otherObj.nRecs[i];
                if (!(otherOldW > 0.0)) continue;
                this.nRecs[i] = newW = oldW + otherOldW;
                double oldMeanC = this.covarMeans[i];
                double otherOldMeanC = otherObj.covarMeans[i];
                this.covarMeans[i] = newMeanC = (oldMeanC * oldW + otherOldMeanC * otherOldW) / newW;
                double oldMeanT = this.targetMeans[i];
                double otherOldMeanT = otherObj.targetMeans[i];
                this.targetMeans[i] = newMeanT = (oldMeanT * oldW + otherOldMeanT * otherOldW) / newW;
                int n = i;
                this.sSqCovar[n] = this.sSqCovar[n] + (otherObj.sSqCovar[i] + oldW * oldMeanC * oldMeanC + otherOldW * otherOldMeanC * otherOldMeanC - newW * newMeanC * newMeanC);
                int n2 = i;
                this.sSqTarget[n2] = this.sSqTarget[n2] + (otherObj.sSqTarget[i] + oldW * oldMeanT * oldMeanT + otherOldW * otherOldMeanT * otherOldMeanT - newW * newMeanT * newMeanT);
                int n3 = i;
                this.xProds[n3] = this.xProds[n3] + (otherObj.xProds[i] + oldW * oldMeanC * oldMeanT + otherOldW * otherOldMeanC * otherOldMeanT - newW * newMeanC * newMeanT);
            }
            double oldW = this.totalNRecs;
            double otherOldW = otherObj.totalNRecs;
            if (otherOldW > 0.0) {
                double newMean;
                double newW;
                this.totalNRecs = newW = oldW + otherOldW;
                double oldMean = this.targetMean;
                double otherOldMean = otherObj.targetMean;
                this.targetMean = newMean = (oldMean * oldW + otherOldMean * otherOldW) / newW;
                this.totalSSqTarget += otherObj.totalSSqTarget + oldW * oldMean * oldMean + otherOldW * otherOldMean * otherOldMean - newW * newMean * newMean;
            }
            if (this.isIncludeTarHist) {
                ArrayList<HistogramData> histList = new ArrayList<HistogramData>();
                histList.add(otherObj.getTargetHistogram());
                this.targetHist.addObjects(histList);
            }
            this.validUpdCnt += otherObj.validUpdCnt;
            this.invalidUpdCnt += otherObj.invalidUpdCnt;
        }
        return result;
    }

    @Override
    public boolean merge(List<? extends AccumStats4InteractTests> others) {
        boolean result = true;
        for (int i = 0; result && i < others.size(); ++i) {
            InteractCovarFactorForContTarget other = (InteractCovarFactorForContTarget)others.get(i);
            if (other == null) continue;
            result = this.merge(other);
        }
        return result;
    }

    public void doNotCheckForEmpty() {
        this.isCheckEmpty = false;
    }

    @Override
    public double computeStatistics() {
        this.pValue = MissingValue.getMissing();
        this.totalSSqTargetDF = this.validNRecs - 1.0;
        if (this.isCheckEmpty) {
            this.removeEmpty();
        }
        this.sSeFull = this.computeResidSSqFull();
        double sSqMain = this.computeResidSSqMain();
        this.ssInteract = sSqMain - this.sSeFull;
        double criterion = 2.220446049250313E-16 * this.totalSSqTarget * (double)(2 * this.nLevels - 1);
        if (!MissingValue.isMissing((double)this.sSeFull)) {
            boolean bl = this.isPerfectFit = this.sSeFull <= criterion && this.sSeFull <= 1.0E-8;
        }
        if (this.isPerfectFit) {
            double diff = Math.abs(sSqMain - this.sSeFull);
            this.pValue = diff <= criterion && diff <= 1.0E-8 ? MissingValue.getMissing() : 0.0;
        } else {
            double df2;
            double nSample = 0.0;
            for (int i = 0; i < this.nLevels; ++i) {
                nSample += this.nRecs[i];
            }
            double df1 = this.nLevels - 1;
            this.sSeFullDF = df2 = nSample - (double)(2 * this.nLevels);
            if (!MissingValue.isMissing((double)this.sSeFull) && !MissingValue.isMissing((double)sSqMain) && df1 > 0.0 && df2 >= 0.0 && this.sSeFull > 0.0) {
                this.fStat = (sSqMain - this.sSeFull) / df1 / this.sSeFull * df2;
                double cdf = DistributionFunctions.cdfF((double)this.fStat, (double)df1, (double)df2);
                if (!MissingValue.isMissing((double)cdf)) {
                    this.pValue = 1.0 - cdf;
                }
            }
        }
        return this.pValue;
    }

    @Override
    public double getPValue() {
        return this.pValue;
    }

    private void removeEmpty() {
        int i;
        int iNE = 0;
        int iFirst = -1;
        this.nOriRecs = (double[])this.nRecs.clone();
        for (i = 0; i < this.nLevels; ++i) {
            if (this.nRecs[i] != 0.0) continue;
            iFirst = i;
            break;
        }
        if (iFirst != -1) {
            double[] nRecsTemp = new double[this.nLevels];
            double[] covarMeansTemp = new double[this.nLevels];
            double[] targetMeansTemp = new double[this.nLevels];
            double[] sSqCovarTemp = new double[this.nLevels];
            double[] sSqTargetTemp = new double[this.nLevels];
            double[] xProdsTemp = new double[this.nLevels];
            for (i = 0; i < this.nLevels; ++i) {
                if (this.nRecs[i] == 0.0) continue;
                nRecsTemp[iNE] = this.nRecs[i];
                covarMeansTemp[iNE] = this.covarMeans[i];
                targetMeansTemp[iNE] = this.targetMeans[i];
                sSqCovarTemp[iNE] = this.sSqCovar[i];
                sSqTargetTemp[iNE] = this.sSqTarget[i];
                xProdsTemp[iNE] = this.xProds[i];
                ++iNE;
            }
            this.nLevels = iNE;
            this.nRecs = new double[this.nLevels];
            this.covarMeans = new double[this.nLevels];
            this.targetMeans = new double[this.nLevels];
            this.sSqCovar = new double[this.nLevels];
            this.sSqTarget = new double[this.nLevels];
            this.xProds = new double[this.nLevels];
            System.arraycopy(nRecsTemp, 0, this.nRecs, 0, this.nLevels);
            System.arraycopy(covarMeansTemp, 0, this.covarMeans, 0, this.nLevels);
            System.arraycopy(targetMeansTemp, 0, this.targetMeans, 0, this.nLevels);
            System.arraycopy(sSqCovarTemp, 0, this.sSqCovar, 0, this.nLevels);
            System.arraycopy(sSqTargetTemp, 0, this.sSqTarget, 0, this.nLevels);
            System.arraycopy(xProdsTemp, 0, this.xProds, 0, this.nLevels);
        }
    }

    public double computeResidSSqFull() {
        double sSqFull = 0.0;
        for (int i = 0; i < this.nLevels; ++i) {
            double cXX = this.sSqCovar[i];
            if (cXX > 0.0) {
                double cXY = this.xProds[i];
                sSqFull += this.sSqTarget[i] - cXY * cXY / cXX;
                continue;
            }
            sSqFull = MissingValue.getMissing();
            break;
        }
        return sSqFull;
    }

    public double computeResidSSqMain() {
        double sumXX = 0.0;
        double sumXY = 0.0;
        double sumYY = 0.0;
        for (int i = 0; i < this.nLevels; ++i) {
            sumXX += this.sSqCovar[i];
            sumXY += this.xProds[i];
            sumYY += this.sSqTarget[i];
        }
        double sSqMain = sumXX > 0.0 ? sumYY - sumXY * sumXY / sumXX : MissingValue.getMissing();
        return sSqMain;
    }

    public double getGlobalNRecs() {
        return this.totalNRecs;
    }

    public double getGlobalMean() {
        return this.targetMean;
    }

    public double getGlobalSSq() {
        return this.totalSSqTarget;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        int i;
        dataOutput.writeInt(this.nLevels);
        dataOutput.writeBoolean(this.isCheckEmpty);
        dataOutput.writeInt(this.covarX);
        dataOutput.writeInt(this.factorX);
        dataOutput.writeInt(this.targetX);
        dataOutput.writeInt(this.weightX);
        for (i = 0; i < this.nLevels; ++i) {
            dataOutput.writeDouble(this.nRecs[i]);
        }
        for (i = 0; i < this.nLevels; ++i) {
            dataOutput.writeDouble(this.covarMeans[i]);
        }
        for (i = 0; i < this.nLevels; ++i) {
            dataOutput.writeDouble(this.targetMeans[i]);
        }
        for (i = 0; i < this.nLevels; ++i) {
            dataOutput.writeDouble(this.sSqCovar[i]);
        }
        for (i = 0; i < this.nLevels; ++i) {
            dataOutput.writeDouble(this.sSqTarget[i]);
        }
        for (i = 0; i < this.nLevels; ++i) {
            dataOutput.writeDouble(this.xProds[i]);
        }
        dataOutput.writeDouble(this.validNRecs);
        dataOutput.writeDouble(this.totalNRecs);
        dataOutput.writeDouble(this.targetMean);
        dataOutput.writeDouble(this.totalSSqTarget);
        dataOutput.writeDouble(this.totalSSqTargetDF);
        dataOutput.writeDouble(this.sSeFull);
        dataOutput.writeDouble(this.sSeFullDF);
        dataOutput.writeDouble(this.mSeFull);
        dataOutput.writeDouble(this.ssInteract);
        dataOutput.writeDouble(this.ssInteractDF);
        dataOutput.writeDouble(this.msInteract);
        dataOutput.writeInt(this.validUpdCnt);
        dataOutput.writeInt(this.invalidUpdCnt);
        dataOutput.writeBoolean(this.isPerfectFit);
        dataOutput.writeDouble(this.fStat);
        dataOutput.writeDouble(this.pValue);
        dataOutput.writeDouble(this.fitMeasure);
        dataOutput.writeDouble(this.interestingness);
        dataOutput.writeBoolean(this.isIncludeTarHist);
        if (this.isIncludeTarHist) {
            this.targetHist.writeObject(dataOutput);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        int i;
        this.nLevels = dataInput.readInt();
        this.isCheckEmpty = dataInput.readBoolean();
        this.covarX = dataInput.readInt();
        this.factorX = dataInput.readInt();
        this.targetX = dataInput.readInt();
        this.weightX = dataInput.readInt();
        this.nRecs = new double[this.nLevels];
        this.covarMeans = new double[this.nLevels];
        this.targetMeans = new double[this.nLevels];
        this.sSqCovar = new double[this.nLevels];
        this.sSqTarget = new double[this.nLevels];
        this.xProds = new double[this.nLevels];
        for (i = 0; i < this.nLevels; ++i) {
            this.nRecs[i] = dataInput.readDouble();
        }
        for (i = 0; i < this.nLevels; ++i) {
            this.covarMeans[i] = dataInput.readDouble();
        }
        for (i = 0; i < this.nLevels; ++i) {
            this.targetMeans[i] = dataInput.readDouble();
        }
        for (i = 0; i < this.nLevels; ++i) {
            this.sSqCovar[i] = dataInput.readDouble();
        }
        for (i = 0; i < this.nLevels; ++i) {
            this.sSqTarget[i] = dataInput.readDouble();
        }
        for (i = 0; i < this.nLevels; ++i) {
            this.xProds[i] = dataInput.readDouble();
        }
        this.validNRecs = dataInput.readDouble();
        this.totalNRecs = dataInput.readDouble();
        this.targetMean = dataInput.readDouble();
        this.totalSSqTarget = dataInput.readDouble();
        this.totalSSqTargetDF = dataInput.readDouble();
        this.sSeFull = dataInput.readDouble();
        this.sSeFullDF = dataInput.readDouble();
        this.mSeFull = dataInput.readDouble();
        this.ssInteract = dataInput.readDouble();
        this.ssInteractDF = dataInput.readDouble();
        this.msInteract = dataInput.readDouble();
        this.validUpdCnt = dataInput.readInt();
        this.invalidUpdCnt = dataInput.readInt();
        this.isPerfectFit = dataInput.readBoolean();
        this.fStat = dataInput.readDouble();
        this.pValue = dataInput.readDouble();
        this.fitMeasure = dataInput.readDouble();
        this.interestingness = dataInput.readDouble();
        this.isIncludeTarHist = dataInput.readBoolean();
        if (this.isIncludeTarHist) {
            this.targetHist = new HistogramData();
            this.targetHist.readObject(dataInput);
        } else {
            this.targetHist = null;
        }
        return this;
    }

    @Override
    public int compareTo(AccumStats4InteractTests o) {
        int ret = 0;
        if (this.fitMeasure > o.getFitMeasure()) {
            ret = 1;
        } else if (this.fitMeasure < o.getFitMeasure()) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public double getFitMeasure() {
        return this.fitMeasure;
    }

    @Override
    public int[] getFactorIndices() {
        int[] result = new int[]{this.factorX};
        return result;
    }

    @Override
    public int[] getCovariateIndices() {
        int[] result = new int[]{this.covarX};
        return result;
    }

    @Override
    public HistogramData getTargetHistogram() {
        return this.targetHist;
    }

    @Override
    public double getEffectSize() {
        return this.ssInteract / this.totalSSqTarget;
    }

    @Override
    public double getInterestingness() {
        return this.interestingness;
    }

    @Override
    public void setInterestingness(double val) {
        this.interestingness = val;
    }

    @Override
    public void addMissingCounts(double unweightedMissCount, double weightedMissCount) {
        this.invalidUpdCnt += (int)unweightedMissCount;
        this.totalNRecs += weightedMissCount;
    }

    public String toString() {
        return "InteractCovarFactorForContTarget [covarMeans=" + Arrays.toString(this.covarMeans) + ", covarX=" + this.covarX + ", fStat=" + this.fStat + ", factorX=" + this.factorX + ", fitMeasure=" + this.fitMeasure + ", interestingness=" + this.interestingness + ", invalidUpdCnt=" + this.invalidUpdCnt + ", isCheckEmpty=" + this.isCheckEmpty + ", isIncludeTarHist=" + this.isIncludeTarHist + ", isPerfectFit=" + this.isPerfectFit + ", mSeFull=" + this.mSeFull + ", msInteract=" + this.msInteract + ", nLevels=" + this.nLevels + ", nRecs=" + Arrays.toString(this.nRecs) + ", pValue=" + this.pValue + ", sSeFull=" + this.sSeFull + ", sSeFullDF=" + this.sSeFullDF + ", sSqCovar=" + Arrays.toString(this.sSqCovar) + ", sSqTarget=" + Arrays.toString(this.sSqTarget) + ", ssInteract=" + this.ssInteract + ", ssInteractDF=" + this.ssInteractDF + ", targetHist=" + this.targetHist + ", targetMean=" + this.targetMean + ", targetMeans=" + Arrays.toString(this.targetMeans) + ", targetX=" + this.targetX + ", totalNRecs=" + this.totalNRecs + ", totalSSqTarget=" + this.totalSSqTarget + ", totalSSqTargetDF=" + this.totalSSqTargetDF + ", validNRecs=" + this.validNRecs + ", validUpdCnt=" + this.validUpdCnt + ", weightX=" + this.weightX + ", xProds=" + Arrays.toString(this.xProds) + "]";
    }

    @Override
    public double getAccuracy() {
        double result = MissingValue.getMissing();
        if (this.totalSSqTarget > 0.0) {
            result = this.sSeFull / this.totalSSqTarget;
        }
        return result;
    }

    @Override
    public double getRelativeError() {
        double result = MissingValue.getMissing();
        if (this.totalSSqTarget > 0.0) {
            result = 1.0 - this.sSeFull / this.totalSSqTarget;
        }
        return result;
    }
}

