/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.ac.acbase.annotation.FromCppClass;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.tuple.Tuple2;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.ac.acmath.accumstats.AccumTestStats4ContTarget;
import com.spss.ac.acmath.output.HistogramData;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.RectMatrix;
import com.spss.math.statistics.DistributionFunctions;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

@FromCppClass(value="MCMATH_NAMESPACE::MCInteractFactorFactor")
public class InteractTwoFactorsForContTarget
implements AccumTestStats4ContTarget,
ACSerializable {
    private static final long serialVersionUID = 3702746794861531544L;
    private int nLevels1 = 0;
    private int nLevels2 = 0;
    private boolean isCheckEmpty = true;
    private int factor1X = -1;
    private int factor2X = -1;
    private int targetX = -1;
    private int weightX = -1;
    private DenseRectMatrix mNRecs = null;
    private double[] arrNRecs = null;
    private DenseRectMatrix mTargetMeans = null;
    private double[] arrTargetMeans = null;
    private DenseRectMatrix mSSq = null;
    private double[] arrSSq = null;
    private double validNRecs = 0.0;
    private double totalNRecs = 0.0;
    private double targetMean = 0.0;
    private double ssq = 0.0;
    private double ssqDF = MissingValue.getMissing();
    private double sSeFull = MissingValue.getMissing();
    private double sSeFullDF = MissingValue.getMissing();
    private double mSeFull = MissingValue.getMissing();
    private double ssInteract = MissingValue.getMissing();
    private double ssInteractDF = MissingValue.getMissing();
    private double msInteract = MissingValue.getMissing();
    private int validUpdCnt = 0;
    private int invalidUpdCnt = 0;
    private boolean isPerfectFit = false;
    private double fStat = MissingValue.getMissing();
    private double pValue = MissingValue.getMissing();
    private double fitMeasure = MissingValue.getMissing();
    private double interestingness = MissingValue.getMissing();
    private boolean isIncludeTarHist = false;
    private HistogramData targetHist = null;
    private Tuple2<Double, Double> PIPairs = null;

    public InteractTwoFactorsForContTarget(int nLevels1, int nLevels2, int factor1X, int factor2X, int targetX, double targetMin, double targetMax, int weightX, boolean isIncludeTarHist) {
        this.nLevels1 = nLevels1;
        this.nLevels2 = nLevels2;
        this.isCheckEmpty = true;
        this.factor1X = factor1X;
        this.factor2X = factor2X;
        this.targetX = targetX;
        this.weightX = weightX;
        this.mNRecs = new DenseRectMatrix(nLevels1, nLevels2);
        this.arrNRecs = this.mNRecs.getMatrix();
        this.mTargetMeans = new DenseRectMatrix(nLevels1, nLevels2);
        this.arrTargetMeans = this.mTargetMeans.getMatrix();
        this.mSSq = new DenseRectMatrix(nLevels1, nLevels2);
        this.arrSSq = this.mSSq.getMatrix();
        this.isIncludeTarHist = isIncludeTarHist;
        if (isIncludeTarHist) {
            this.targetHist = new HistogramData(400, targetMin, targetMax, true);
        }
    }

    public InteractTwoFactorsForContTarget(int nLevels1, int nLevels2, double[] arrNRecs, double[] arrTargetMeans, double[] arrSSq, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        int i;
        this.nLevels1 = nLevels1;
        this.nLevels2 = nLevels2;
        this.isCheckEmpty = true;
        this.mNRecs = new DenseRectMatrix(nLevels1, nLevels2);
        this.arrNRecs = this.mNRecs.getMatrix();
        this.mTargetMeans = new DenseRectMatrix(nLevels1, nLevels2);
        this.arrTargetMeans = this.mTargetMeans.getMatrix();
        this.mSSq = new DenseRectMatrix(nLevels1, nLevels2);
        this.arrSSq = this.mSSq.getMatrix();
        this.isIncludeTarHist = false;
        MathFun.dCopy((double[])arrNRecs, (double[])this.arrNRecs);
        MathFun.dCopy((double[])arrTargetMeans, (double[])this.arrTargetMeans);
        MathFun.dCopy((double[])arrSSq, (double[])this.arrSSq);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.validNRecs = validNRecs;
        this.totalNRecs = totalNRecs;
        double num = 0.0;
        double sum = 0.0;
        for (i = 0; i < arrNRecs.length; ++i) {
            num += arrNRecs[i];
            sum += arrTargetMeans[i] * arrNRecs[i];
        }
        if (num > 0.0) {
            this.targetMean = sum / num;
        }
        this.ssq = 0.0;
        for (i = 0; i < arrSSq.length; ++i) {
            this.ssq += arrSSq[i] + arrNRecs[i] * arrTargetMeans[i] * arrTargetMeans[i];
        }
        this.ssq -= num * this.targetMean * this.targetMean;
    }

    public InteractTwoFactorsForContTarget() {
        this(0, 0, -1, -1, -1, -1.7976931348623157E308, Double.MAX_VALUE, -1, false);
    }

    @Override
    public void setAggregatedStatistics(double[] arrNRecs, double[] arrTargetMeans, double[] arrSSq, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        int i;
        MathFun.dCopy((double[])this.arrNRecs, (double[])arrNRecs);
        MathFun.dCopy((double[])this.arrTargetMeans, (double[])arrTargetMeans);
        MathFun.dCopy((double[])this.arrSSq, (double[])arrSSq);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.validNRecs = validNRecs;
        this.totalNRecs = totalNRecs;
        double num = 0.0;
        double sum = 0.0;
        for (i = 0; i < arrNRecs.length; ++i) {
            num += arrNRecs[i];
            sum += arrTargetMeans[i] * arrNRecs[i];
        }
        if (num > 0.0) {
            this.targetMean = sum / num;
        }
        this.ssq = 0.0;
        for (i = 0; i < arrSSq.length; ++i) {
            this.ssq += arrSSq[i];
        }
    }

    public void setNLevels(int nLevels1, int nLevels2) {
        this.nLevels1 = nLevels1;
        this.nLevels2 = nLevels2;
        this.mNRecs.resize(nLevels1, nLevels2);
        this.arrNRecs = this.mNRecs.getMatrix();
        this.mTargetMeans.resize(nLevels1, nLevels2);
        this.arrTargetMeans = this.mTargetMeans.getMatrix();
        this.mSSq.resize(nLevels1, nLevels2);
        this.arrSSq = this.mSSq.getMatrix();
    }

    public int getNLevels1() {
        return this.nLevels1;
    }

    public int getNLevels2() {
        return this.nLevels2;
    }

    @Override
    public int getNFactorCategs() {
        return this.nLevels1 * this.nLevels2;
    }

    public void setFactor1XIndex(int factor1X) {
        this.factor1X = factor1X;
    }

    public int getFactor1XIndex() {
        return this.factor1X;
    }

    public void setFactor2XIndex(int factor2X) {
        this.factor2X = factor2X;
    }

    public int getFactor2XIndex() {
        return this.factor2X;
    }

    public void setTargetXIndex(int targetX) {
        this.targetX = targetX;
    }

    @Override
    public int getTargetIndex() {
        return this.targetX;
    }

    public void setWeightXIndex(int weightX) {
        this.weightX = weightX;
    }

    @Override
    public int getWeightIndex() {
        return this.weightX;
    }

    @Override
    public double getFStat() {
        return this.fStat;
    }

    public DenseRectMatrix getNRecsMat() {
        return this.mNRecs;
    }

    @Override
    public double[] getNRecs() {
        return this.arrNRecs;
    }

    public DenseRectMatrix getTargetMeansMat() {
        return this.mTargetMeans;
    }

    @Override
    public double[] getTargetMeans() {
        return this.arrTargetMeans;
    }

    public DenseRectMatrix getSSq() {
        return this.mSSq;
    }

    @Override
    public double[] getTargetSSqDiffs() {
        return this.arrSSq;
    }

    @Override
    public double getTotalNRecs() {
        return this.totalNRecs;
    }

    @Override
    public double getValidNRecs() {
        return this.validNRecs;
    }

    @Override
    public int getUnweightedNRecs() {
        return this.validUpdCnt;
    }

    @Override
    public double getTotalTargetMean() {
        return this.targetMean;
    }

    @Override
    public double getTotalSumOfSquares() {
        return this.ssq;
    }

    @Override
    public double getTotalDegreesOfFreedom() {
        return this.ssqDF;
    }

    @Override
    public double getErrorSumOfSquares() {
        return this.sSeFull;
    }

    @Override
    public double getErrorDegreesOfFreedom() {
        return this.sSeFullDF;
    }

    @Override
    public double getErrorMeanSquares() {
        return this.mSeFull;
    }

    @Override
    public double getModelSumOfSquares() {
        return this.ssInteract;
    }

    @Override
    public double getModelDegreesOfFreedom() {
        return this.ssInteractDF;
    }

    @Override
    public double getModelMeanSquares() {
        return this.msInteract;
    }

    public double getInteractMeasure() {
        double ret = MissingValue.getMissing();
        if (this.ssq > 0.0) {
            ret = this.ssInteract / this.ssq;
        }
        return ret;
    }

    @Override
    public double getRelativeError() {
        double result = MissingValue.getMissing();
        if (this.ssq > 0.0) {
            result = this.sSeFull / this.ssq;
        }
        return result;
    }

    @Override
    public double getAccuracy() {
        double result = MissingValue.getMissing();
        if (this.ssq > 0.0) {
            result = 1.0 - this.sSeFull / this.ssq;
        }
        return result;
    }

    @Override
    public int getValidUpdCnt() {
        return this.validUpdCnt;
    }

    @Override
    public int getInvalidUpdCnt() {
        return this.invalidUpdCnt;
    }

    public boolean isPerfectFit() {
        return this.isPerfectFit;
    }

    public boolean update(int level1, int level2, double target, double weight, boolean validateFactorVal) {
        boolean ret = true;
        if (validateFactorVal) {
            boolean bl = ret = level1 >= 0 && level1 < this.nLevels1 && level2 >= 0 && level2 < this.nLevels2;
        }
        if (ret) {
            double newW;
            int index = level1 * this.nLevels2 + level2;
            double oldW = this.arrNRecs[index];
            this.arrNRecs[index] = newW = oldW + weight;
            double oldMean = this.arrTargetMeans[index];
            int n = index;
            this.arrTargetMeans[n] = this.arrTargetMeans[n] + weight / newW * (target - oldMean);
            double diff = target - oldMean;
            int n2 = index;
            this.arrSSq[n2] = this.arrSSq[n2] + weight * oldW / newW * diff * diff;
            oldW = this.validNRecs;
            this.validNRecs = newW = oldW + weight;
            this.totalNRecs += weight;
            oldMean = this.targetMean;
            this.targetMean += weight / newW * (target - oldMean);
            diff = target - oldMean;
            this.ssq += weight * oldW / newW * diff * diff;
            if (this.isIncludeTarHist) {
                this.targetHist.updateData(weight, 1.0, target);
            }
            ++this.validUpdCnt;
        } else {
            ++this.invalidUpdCnt;
            if (!MissingValue.isMissing((double)weight) && weight > 0.0) {
                this.totalNRecs += weight;
            }
        }
        return ret;
    }

    public boolean update(int level1, int level2, double target, boolean validateFactorVal) {
        return this.update(level1, level2, target, 1.0, validateFactorVal);
    }

    @Override
    public boolean update(double[] record, boolean validateFactorVal) {
        boolean ret;
        boolean bl = ret = this.factor1X >= 0 && this.factor2X >= 0 && this.targetX >= 0;
        if (ret) {
            double cat = record[this.factor1X];
            int level1 = -1;
            int level2 = -1;
            if (!MissingValue.isMissing((double)cat)) {
                level1 = (int)cat;
            }
            if (!MissingValue.isMissing((double)(cat = record[this.factor2X]))) {
                level2 = (int)cat;
            }
            double target = record[this.targetX];
            double weight = this.weightX >= 0 ? record[this.weightX] : 1.0;
            ret = this.update(level1, level2, target, weight, validateFactorVal);
        }
        return ret;
    }

    @Override
    public boolean merge(AccumStats4InteractTests other) {
        boolean ret = true;
        InteractTwoFactorsForContTarget otherObj = (InteractTwoFactorsForContTarget)other;
        if (otherObj.nLevels1 == 0 && otherObj.nLevels2 == 0) {
            return ret;
        }
        boolean bl = ret = this.nLevels1 == otherObj.nLevels1 && this.nLevels2 == otherObj.nLevels2;
        if (this.nLevels1 == 0 && this.nLevels2 == 0) {
            this.setNLevels(otherObj.nLevels1, otherObj.nLevels2);
            this.setFactor1XIndex(otherObj.factor1X);
            this.setFactor2XIndex(otherObj.factor2X);
            this.setTargetXIndex(otherObj.targetX);
            this.setWeightXIndex(otherObj.weightX);
            ret = true;
        }
        if (ret) {
            for (int i = 0; i < this.nLevels1 * this.nLevels2; ++i) {
                double newMean;
                double newW;
                double oldW = this.arrNRecs[i];
                double otherOldW = otherObj.arrNRecs[i];
                if (!(otherOldW > 0.0)) continue;
                this.arrNRecs[i] = newW = oldW + otherOldW;
                double oldMean = this.arrTargetMeans[i];
                double otherOldMean = otherObj.arrTargetMeans[i];
                this.arrTargetMeans[i] = newMean = (oldMean * oldW + otherOldMean * otherOldW) / newW;
                int n = i;
                this.arrSSq[n] = this.arrSSq[n] + (otherObj.arrSSq[i] + oldW * oldMean * oldMean + otherOldW * otherOldMean * otherOldMean - newW * newMean * newMean);
            }
            double oldW = this.validNRecs;
            double otherOldW = otherObj.validNRecs;
            if (otherOldW > 0.0) {
                double newMean;
                double newW;
                this.validNRecs = newW = oldW + otherOldW;
                double oldMean = this.targetMean;
                double otherOldMean = otherObj.targetMean;
                this.targetMean = newMean = (oldMean * oldW + otherOldMean * otherOldW) / newW;
                this.ssq += otherObj.ssq + oldW * oldMean * oldMean + otherOldW * otherOldMean * otherOldMean - newW * newMean * newMean;
                this.totalNRecs += otherObj.totalNRecs;
            }
            if (this.isIncludeTarHist) {
                ArrayList<HistogramData> histList = new ArrayList<HistogramData>();
                histList.add(otherObj.getTargetHistogram());
                this.targetHist.addObjects(histList);
            }
            this.validUpdCnt += otherObj.validUpdCnt;
            this.invalidUpdCnt += otherObj.invalidUpdCnt;
        }
        return ret;
    }

    @Override
    public boolean merge(List<? extends AccumStats4InteractTests> others) {
        boolean ret = true;
        for (int i = 0; ret && i < others.size(); ++i) {
            InteractTwoFactorsForContTarget other = (InteractTwoFactorsForContTarget)others.get(i);
            if (other == null) continue;
            ret = this.merge(other);
        }
        return ret;
    }

    public void doNotCheckForEmpty() {
        this.isCheckEmpty = false;
    }

    @Override
    public double getPValue() {
        return this.pValue;
    }

    public Tuple2<Double, Double> getPIValues() {
        return this.PIPairs;
    }

    @Override
    public double computeStatistics() {
        return this.computeStatistics(10, 1.0E-6);
    }

    public double computeStatistics(int nIter, double tol) {
        int pStar;
        double ssCrit;
        if (this.validUpdCnt == 0) {
            return MissingValue.getMissing();
        }
        if (!MissingValue.isMissing((double)this.pValue) || !MissingValue.isMissing((double)this.fStat)) {
            return this.pValue;
        }
        double pVal = MissingValue.getMissing();
        if (this.isCheckEmpty) {
            this.removeEmpty();
        }
        double sSqFull = this.computeResidSSqFull();
        double sSqDiff = this.computeResidSSqDiff(nIter, tol);
        int nElems = this.nLevels1 * this.nLevels2;
        double nSample = InteractTwoFactorsForContTarget.sum(this.arrNRecs, nElems);
        this.ssqDF = nSample - 1.0;
        int nEmpty = InteractTwoFactorsForContTarget.numberOfZeroes(this.arrNRecs, nElems);
        double df1 = (this.nLevels1 - 1) * (this.nLevels2 - 1) - nEmpty;
        double df2 = nSample + (double)(-this.nLevels1 * this.nLevels2 + nEmpty);
        this.sSeFull = sSqFull;
        this.sSeFullDF = df2;
        this.ssInteract = sSqDiff;
        this.ssInteractDF = df1;
        if (this.sSeFullDF > 0.0) {
            this.mSeFull = this.sSeFull / this.sSeFullDF;
        }
        if (this.ssInteractDF > 0.0) {
            this.msInteract = this.ssInteract / this.ssInteractDF;
        }
        boolean bl = this.isPerfectFit = sSqFull <= (ssCrit = 2.220446049250313E-16 * this.ssq * (double)(pStar = this.nLevels1 * this.nLevels2 - nEmpty - 1)) && sSqFull <= 1.0E-8;
        if (this.isPerfectFit) {
            pVal = sSqDiff <= ssCrit && sSqDiff <= 1.0E-8 ? MissingValue.getMissing() : 0.0;
        } else if (df1 > 0.0 && df2 > 0.0 && sSqFull > 0.0) {
            this.fStat = sSqDiff / df1 / sSqFull * df2;
            double cdf = DistributionFunctions.cdfF((double)this.fStat, (double)df1, (double)df2);
            if (!MissingValue.isMissing((double)cdf)) {
                pVal = 1.0 - cdf;
            }
        } else if (sSqFull > 0.0) {
            pVal = 0.0;
        }
        this.pValue = pVal;
        if (this.ssq > 0.0 && !MissingValue.isMissing((double)this.sSeFull)) {
            double dfT = this.validNRecs - 1.0;
            this.fitMeasure = 1.0 - this.sSeFull / this.sSeFullDF / this.ssq * dfT;
        }
        return pVal;
    }

    private void removeEmpty() {
        if (this.nLevels1 > 0 && this.nLevels2 > 0) {
            int nNonZeroRows = 0;
            for (int iRow = 0; iRow < this.nLevels1; ++iRow) {
                if (this.mNRecs.isRowZero(iRow)) continue;
                ++nNonZeroRows;
            }
            int[] nonZeroRows = new int[nNonZeroRows];
            int i = 0;
            for (int iRow = 0; iRow < this.nLevels1; ++iRow) {
                if (this.mNRecs.isRowZero(iRow)) continue;
                nonZeroRows[i++] = iRow;
            }
            int nNonZeroCols = 0;
            for (int iCol = 0; iCol < this.nLevels2; ++iCol) {
                if (this.mNRecs.isColZero(iCol)) continue;
                ++nNonZeroCols;
            }
            int[] nonZeroCols = new int[nNonZeroCols];
            int j = 0;
            for (int iCol = 0; iCol < this.nLevels2; ++iCol) {
                if (this.mNRecs.isColZero(iCol)) continue;
                nonZeroCols[j++] = iCol;
            }
            DenseRectMatrix mNRecs1 = new DenseRectMatrix();
            DenseRectMatrix mTargetMeans1 = new DenseRectMatrix();
            DenseRectMatrix mSSqDevs1 = new DenseRectMatrix();
            if (nNonZeroRows < this.nLevels1 && nNonZeroCols < this.nLevels2) {
                this.mNRecs.extractRows(nonZeroRows, (RectMatrix)mNRecs1);
                this.mTargetMeans.extractRows(nonZeroRows, (RectMatrix)mTargetMeans1);
                this.mSSq.extractRows(nonZeroRows, (RectMatrix)mSSqDevs1);
                mNRecs1.extractColumns(nonZeroCols, (RectMatrix)this.mNRecs);
                mTargetMeans1.extractColumns(nonZeroCols, (RectMatrix)this.mTargetMeans);
                mSSqDevs1.extractColumns(nonZeroCols, (RectMatrix)this.mSSq);
            } else if (nNonZeroRows < this.nLevels1) {
                this.mNRecs.extractRows(nonZeroRows, (RectMatrix)mNRecs1);
                this.mTargetMeans.extractRows(nonZeroRows, (RectMatrix)mTargetMeans1);
                this.mSSq.extractRows(nonZeroRows, (RectMatrix)mSSqDevs1);
                this.mNRecs = mNRecs1;
                this.mTargetMeans = mTargetMeans1;
                this.mSSq = mSSqDevs1;
            } else if (nNonZeroCols < this.nLevels2) {
                this.mNRecs.extractColumns(nonZeroCols, (RectMatrix)mNRecs1);
                this.mTargetMeans.extractColumns(nonZeroCols, (RectMatrix)mTargetMeans1);
                this.mSSq.extractColumns(nonZeroCols, (RectMatrix)mSSqDevs1);
                this.mNRecs = mNRecs1;
                this.mTargetMeans = mTargetMeans1;
                this.mSSq = mSSqDevs1;
            }
            if (nNonZeroRows < this.nLevels1 || nNonZeroCols < this.nLevels2) {
                this.arrNRecs = this.mNRecs.getMatrix();
                this.arrTargetMeans = this.mTargetMeans.getMatrix();
                this.arrSSq = this.mSSq.getMatrix();
                this.nLevels1 = nNonZeroRows;
                this.nLevels2 = nNonZeroCols;
            }
        }
    }

    private double computeResidSSqFull() {
        double sSqFull = 0.0;
        for (int i = 0; i < this.nLevels1 * this.nLevels2; ++i) {
            sSqFull += this.arrSSq[i];
        }
        return sSqFull;
    }

    private double computeResidSSqDiff(int nIters, double tol) {
        int iCol;
        int iRow;
        int nElems = this.nLevels1 * this.nLevels2;
        double ssqInter1 = InteractTwoFactorsForContTarget.dotProductSq1(this.arrTargetMeans, this.arrNRecs, nElems);
        double[] arrNRowSums = new double[this.nLevels1];
        double[] arrNColSums = new double[this.nLevels2];
        int iMat = 0;
        for (iRow = 0; iRow < this.nLevels1; ++iRow) {
            iCol = 0;
            while (iCol < this.nLevels2) {
                double validNRecs = this.arrNRecs[iMat++];
                int n = iRow;
                arrNRowSums[n] = arrNRowSums[n] + validNRecs;
                int n2 = iCol++;
                arrNColSums[n2] = arrNColSums[n2] + validNRecs;
            }
        }
        double[] arrUpdMeans = new double[nElems];
        int rowStart = 0;
        iMat = 0;
        for (iRow = 0; iRow < this.nLevels1; ++iRow) {
            double dotP = InteractTwoFactorsForContTarget.dotProduct(this.arrTargetMeans, this.arrNRecs, rowStart, this.nLevels2);
            double ratio = dotP / arrNRowSums[iRow];
            for (iCol = 0; iCol < this.nLevels2; ++iCol) {
                arrUpdMeans[iMat] = this.arrTargetMeans[iMat] - ratio;
                ++iMat;
            }
            rowStart += this.nLevels2;
        }
        InteractTwoFactorsForContTarget.updateInColOrder(arrUpdMeans, this.arrNRecs, arrNColSums, this.nLevels1, this.nLevels2);
        double ssqInter2 = InteractTwoFactorsForContTarget.dotProductSq1(arrUpdMeans, this.arrNRecs, nElems);
        for (int iter = 1; iter < nIters && Math.abs(ssqInter1 - ssqInter2) > tol; ++iter) {
            InteractTwoFactorsForContTarget.updateInRowOrder(arrUpdMeans, this.arrNRecs, arrNRowSums, this.nLevels1, this.nLevels2);
            InteractTwoFactorsForContTarget.updateInColOrder(arrUpdMeans, this.arrNRecs, arrNColSums, this.nLevels1, this.nLevels2);
            ssqInter1 = ssqInter2;
            ssqInter2 = InteractTwoFactorsForContTarget.dotProductSq1(arrUpdMeans, this.arrNRecs, nElems);
        }
        return ssqInter2;
    }

    private static double dotProduct(double[] arr1, double[] arr2, int start, int n) {
        double result = 0.0;
        int index = start;
        for (int i = 0; i < n; ++i) {
            result += arr1[index] * arr2[index];
            ++index;
        }
        return result;
    }

    private static double dotProduct(double[] arr1, double[] arr2, int start, int n, int incr) {
        double result = 0.0;
        int index = start;
        for (int i = 0; i < n; ++i) {
            result += arr1[index] * arr2[index];
            index += incr;
        }
        return result;
    }

    private static double dotProductSq1(double[] arr1, double[] arr2, int n) {
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += arr1[i] * arr1[i] * arr2[i];
        }
        return result;
    }

    private static void updateInRowOrder(double[] upd, double[] recs, double[] rowSums, int nRows, int nCols) {
        int rowStart = 0;
        int iMat = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            double dotP = InteractTwoFactorsForContTarget.dotProduct(upd, recs, rowStart, nCols);
            double ratio = dotP / rowSums[iRow];
            for (int iCol = 0; iCol < nCols; ++iCol) {
                int n = iMat++;
                upd[n] = upd[n] - ratio;
            }
            rowStart += nCols;
        }
    }

    private static void updateInColOrder(double[] upd, double[] recs, double[] colSums, int nRows, int nCols) {
        for (int iCol = 0; iCol < nCols; ++iCol) {
            double dotP = InteractTwoFactorsForContTarget.dotProduct(upd, recs, iCol, nRows, nCols);
            double ratio = dotP / colSums[iCol];
            int iMat = iCol;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int n = iMat;
                upd[n] = upd[n] - ratio;
                iMat += nCols;
            }
        }
    }

    private static int numberOfZeroes(double[] arr, int nElems) {
        int result = 0;
        for (int i = 0; i < nElems; ++i) {
            if (arr[i] != 0.0) continue;
            ++result;
        }
        return result;
    }

    private static double sum(double[] arr, int nElems) {
        double result = 0.0;
        for (int i = 0; i < nElems; ++i) {
            result += arr[i];
        }
        return result;
    }

    public Tuple2<Double, Double> computePI(int sampleSize, int randomSeed) {
        int nRow = this.nLevels1;
        this.PIPairs = new Tuple2((Object)0.0, (Object)0.0);
        if (this.arrNRecs.length == this.arrTargetMeans.length) {
            int i;
            int totalCaseCounts = 0;
            int sampleCaseCounts = 0;
            for (int i2 = 0; i2 < this.arrNRecs.length; ++i2) {
                totalCaseCounts += (int)this.arrNRecs[i2];
            }
            double[] accumSampleCounts = new double[this.arrNRecs.length + 1];
            accumSampleCounts[0] = 0.0;
            if (sampleSize > totalCaseCounts) {
                for (i = 0; i < this.arrNRecs.length; ++i) {
                    accumSampleCounts[i + 1] = accumSampleCounts[i] + this.arrNRecs[i];
                    sampleCaseCounts = (int)((double)sampleCaseCounts + this.arrNRecs[i]);
                }
            } else {
                for (i = 0; i < this.arrNRecs.length; ++i) {
                    int num = (int)((double)sampleSize * this.arrNRecs[i] / (double)totalCaseCounts);
                    accumSampleCounts[i + 1] = accumSampleCounts[i] + (double)num;
                    sampleCaseCounts += num;
                }
            }
            int lVal = 1;
            double aveY1Y1 = 0.0;
            double aveY1Y2 = 0.0;
            double aveY1Y3 = 0.0;
            double aveY1Y4 = 0.0;
            int mode = sampleCaseCounts;
            int M = sampleCaseCounts / 2;
            Random rng = new Random(randomSeed);
            if (M > 1) {
                while (lVal <= M) {
                    int position1 = rng.nextInt(mode);
                    int index1 = Arrays.binarySearch(accumSampleCounts, (double)(position1 + 1));
                    if (index1 < 0) {
                        index1 = -(index1 + 1) - 1;
                    } else if (index1 > 0) {
                        while (index1 > 0 && accumSampleCounts[index1] == accumSampleCounts[index1 - 1]) {
                            --index1;
                        }
                        --index1;
                    }
                    if (index1 < 0) continue;
                    --mode;
                    int i3 = index1 + 1;
                    while (i3 < accumSampleCounts.length) {
                        int n = i3++;
                        accumSampleCounts[n] = accumSampleCounts[n] - 1.0;
                    }
                    int position2 = rng.nextInt(mode);
                    int index2 = Arrays.binarySearch(accumSampleCounts, (double)(position2 + 1));
                    if (index2 < 0) {
                        index2 = -(index2 + 1) - 1;
                    } else if (index2 > 0) {
                        while (index2 > 0 && accumSampleCounts[index2] == accumSampleCounts[index2 - 1]) {
                            --index2;
                        }
                        --index2;
                    }
                    if (index2 < 0) continue;
                    --mode;
                    int j = index2 + 1;
                    while (j < accumSampleCounts.length) {
                        int n = j++;
                        accumSampleCounts[n] = accumSampleCounts[n] - 1.0;
                    }
                    double temp = (double)(lVal - 1) / (double)lVal;
                    int index3 = index1 - index1 % nRow + index2 % nRow;
                    int index4 = index2 - index2 % nRow + index1 % nRow;
                    aveY1Y1 = aveY1Y1 * temp + this.arrTargetMeans[index1] * this.arrTargetMeans[index1] / (double)lVal;
                    aveY1Y2 = aveY1Y2 * temp + this.arrTargetMeans[index1] * this.arrTargetMeans[index2] / (double)lVal;
                    aveY1Y3 = (int)this.arrNRecs[index3] == 0 ? aveY1Y3 * temp + this.arrTargetMeans[index1] * this.targetMean / (double)lVal : aveY1Y3 * temp + this.arrTargetMeans[index1] * this.arrTargetMeans[index3] / (double)lVal;
                    aveY1Y4 = (int)this.arrNRecs[index4] == 0 ? aveY1Y4 * temp + this.arrTargetMeans[index1] * this.targetMean / (double)lVal : aveY1Y4 * temp + this.arrTargetMeans[index1] * this.arrTargetMeans[index4] / (double)lVal;
                    ++lVal;
                }
                double ESquare = aveY1Y2;
                double temp1 = (double)M / (double)(M - 1);
                double UX1 = temp1 * aveY1Y3;
                double UX2 = temp1 * aveY1Y4;
                double VY = temp1 * aveY1Y1 - ESquare;
                if (VY > 0.0) {
                    double SX1 = 0.0;
                    if (UX1 - ESquare >= 0.0) {
                        SX1 = (UX1 - ESquare) / VY;
                    }
                    double SX2 = 0.0;
                    if (UX2 - ESquare >= 0.0) {
                        SX2 = (UX2 - ESquare) / VY;
                    }
                    if (SX1 != 0.0 || SX2 != 0.0) {
                        this.PIPairs.first = SX1 / (SX1 + SX2);
                        this.PIPairs.second = SX2 / (SX1 + SX2);
                    }
                }
            }
        }
        return this.PIPairs;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nLevels1);
        dataOutput.writeInt(this.nLevels2);
        dataOutput.writeBoolean(this.isCheckEmpty);
        dataOutput.writeInt(this.factor1X);
        dataOutput.writeInt(this.factor2X);
        dataOutput.writeInt(this.targetX);
        dataOutput.writeInt(this.weightX);
        this.mNRecs.writeObject(dataOutput);
        this.mTargetMeans.writeObject(dataOutput);
        this.mSSq.writeObject(dataOutput);
        dataOutput.writeDouble(this.validNRecs);
        dataOutput.writeDouble(this.totalNRecs);
        dataOutput.writeDouble(this.targetMean);
        dataOutput.writeDouble(this.ssq);
        dataOutput.writeDouble(this.ssqDF);
        dataOutput.writeDouble(this.sSeFull);
        dataOutput.writeDouble(this.sSeFullDF);
        dataOutput.writeDouble(this.mSeFull);
        dataOutput.writeDouble(this.ssInteract);
        dataOutput.writeDouble(this.ssInteractDF);
        dataOutput.writeDouble(this.msInteract);
        dataOutput.writeInt(this.validUpdCnt);
        dataOutput.writeInt(this.invalidUpdCnt);
        dataOutput.writeBoolean(this.isPerfectFit);
        dataOutput.writeDouble(this.fStat);
        dataOutput.writeDouble(this.pValue);
        dataOutput.writeDouble(this.fitMeasure);
        dataOutput.writeDouble(this.interestingness);
        dataOutput.writeBoolean(this.isIncludeTarHist);
        if (this.isIncludeTarHist) {
            this.targetHist.writeObject(dataOutput);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nLevels1 = dataInput.readInt();
        this.nLevels2 = dataInput.readInt();
        this.isCheckEmpty = dataInput.readBoolean();
        this.factor1X = dataInput.readInt();
        this.factor2X = dataInput.readInt();
        this.targetX = dataInput.readInt();
        this.weightX = dataInput.readInt();
        this.mNRecs = new DenseRectMatrix();
        this.mNRecs.readObject(dataInput);
        this.arrNRecs = this.mNRecs.getMatrix();
        this.mTargetMeans = new DenseRectMatrix();
        this.mTargetMeans.readObject(dataInput);
        this.arrTargetMeans = this.mTargetMeans.getMatrix();
        this.mSSq = new DenseRectMatrix();
        this.mSSq.readObject(dataInput);
        this.arrSSq = this.mSSq.getMatrix();
        this.validNRecs = dataInput.readDouble();
        this.totalNRecs = dataInput.readDouble();
        this.targetMean = dataInput.readDouble();
        this.ssq = dataInput.readDouble();
        this.ssqDF = dataInput.readDouble();
        this.sSeFull = dataInput.readDouble();
        this.sSeFullDF = dataInput.readDouble();
        this.mSeFull = dataInput.readDouble();
        this.ssInteract = dataInput.readDouble();
        this.ssInteractDF = dataInput.readDouble();
        this.msInteract = dataInput.readDouble();
        this.validUpdCnt = dataInput.readInt();
        this.invalidUpdCnt = dataInput.readInt();
        this.isPerfectFit = dataInput.readBoolean();
        this.fStat = dataInput.readDouble();
        this.pValue = dataInput.readDouble();
        this.fitMeasure = dataInput.readDouble();
        this.interestingness = dataInput.readDouble();
        this.isIncludeTarHist = dataInput.readBoolean();
        if (this.isIncludeTarHist) {
            this.targetHist = new HistogramData();
            this.targetHist.readObject(dataInput);
        } else {
            this.targetHist = null;
        }
        return this;
    }

    @Override
    public int compareTo(AccumStats4InteractTests o) {
        int ret = 0;
        if (this.fitMeasure > o.getFitMeasure()) {
            ret = 1;
        } else if (this.fitMeasure < o.getFitMeasure()) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public double getFitMeasure() {
        return this.fitMeasure;
    }

    @Override
    public int[] getFactorIndices() {
        int[] result = new int[]{this.factor1X, this.factor2X};
        return result;
    }

    @Override
    public int[] getCovariateIndices() {
        int[] result = null;
        return result;
    }

    @Override
    public HistogramData getTargetHistogram() {
        return this.targetHist;
    }

    @Override
    public double getEffectSize() {
        return this.ssInteract / this.ssq;
    }

    @Override
    public double getInterestingness() {
        return this.interestingness;
    }

    @Override
    public void setInterestingness(double val) {
        this.interestingness = val;
    }

    @Override
    public void addMissingCounts(double unweightedMissCount, double weightedMissCount) {
        this.invalidUpdCnt += (int)unweightedMissCount;
        this.totalNRecs += weightedMissCount;
    }

    public String toString() {
        return "InteractTwoFactorsForContTarget [arrNRecs=" + Arrays.toString(this.arrNRecs) + ", arrSSq=" + Arrays.toString(this.arrSSq) + ", arrTargetMeans=" + Arrays.toString(this.arrTargetMeans) + ", fStat=" + this.fStat + ", factor1X=" + this.factor1X + ", factor2X=" + this.factor2X + ", fitMeasure=" + this.fitMeasure + ", interestingness=" + this.interestingness + ", invalidUpdCnt=" + this.invalidUpdCnt + ", isCheckEmpty=" + this.isCheckEmpty + ", isIncludeTarHist=" + this.isIncludeTarHist + ", isPerfectFit=" + this.isPerfectFit + ", mNRecs=" + this.mNRecs + ", mSSq=" + this.mSSq + ", mSeFull=" + this.mSeFull + ", mTargetMeans=" + this.mTargetMeans + ", msInteract=" + this.msInteract + ", nLevels1=" + this.nLevels1 + ", nLevels2=" + this.nLevels2 + ", pValue=" + this.pValue + ", sSeFull=" + this.sSeFull + ", sSeFullDF=" + this.sSeFullDF + ", ssInteract=" + this.ssInteract + ", ssInteractDF=" + this.ssInteractDF + ", ssq=" + this.ssq + ", ssqDF=" + this.ssqDF + ", targetHist=" + this.targetHist + ", targetMean=" + this.targetMean + ", targetX=" + this.targetX + ", totalNRecs=" + this.totalNRecs + ", validNRecs=" + this.validNRecs + ", validUpdCnt=" + this.validUpdCnt + ", weightX=" + this.weightX + "]";
    }
}

