/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.ac.acbase.annotation.FromCppClass;
import com.spss.ac.acbase.collections.ArrayUtils;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.MathFun;
import com.spss.utilities.i18n.LocMsgId;
import java.util.Arrays;

@FromCppClass(value="MCMATH_NAMESPACE::MCMeansXProdData")
public class MeansXProdData
implements Cloneable {
    protected int nVars = 0;
    protected boolean hasIntercept = true;
    protected double nCases = 0.0;
    protected double[] meansArray = null;
    protected DenseSymMatrix mXProds = null;
    protected transient double[] xProdsArray = null;

    public MeansXProdData() {
    }

    public MeansXProdData(int nVars) {
        this.nVars = nVars;
        this.hasIntercept = true;
        this.meansArray = new double[this.nVars];
        this.mXProds = new DenseSymMatrix(this.nVars);
        this.xProdsArray = this.mXProds.getMatrix();
    }

    public MeansXProdData(int nVars, boolean hasIntercept) {
        this(nVars);
        this.hasIntercept = hasIntercept;
    }

    public MeansXProdData(MeansXProdData other) {
        this.nVars = other.nVars;
        this.hasIntercept = other.hasIntercept;
        this.nCases = other.nCases;
        if (other.meansArray != null) {
            this.meansArray = new double[other.meansArray.length];
            MathFun.dCopy((double[])other.meansArray, (double[])this.meansArray);
        }
        if (other.mXProds != null) {
            this.mXProds = new DenseSymMatrix(other.mXProds);
            this.xProdsArray = this.mXProds.getMatrix();
        }
    }

    public int getNVars() {
        return this.nVars;
    }

    public boolean getHasIntercept() {
        return this.hasIntercept;
    }

    public double getNCases() {
        return this.nCases;
    }

    public double[] getMeans() {
        return this.meansArray;
    }

    public DenseSymMatrix getXProds() {
        return this.mXProds;
    }

    public void clear() {
        this.nCases = 0.0;
        Arrays.fill(this.meansArray, 0.0);
        Arrays.fill(this.xProdsArray, 0.0);
    }

    public boolean setNVars(int nVars) {
        boolean result;
        boolean bl = result = nVars >= 0;
        if (result) {
            this.nVars = nVars;
            this.meansArray = new double[this.nVars];
            this.mXProds = new DenseSymMatrix(this.nVars);
            this.xProdsArray = this.mXProds.getMatrix();
            this.nCases = 0.0;
        }
        return result;
    }

    public void setIntercept(boolean hasIntercept) {
        if (this.hasIntercept != hasIntercept) {
            this.hasIntercept = hasIntercept;
            this.clear();
        }
    }

    public boolean merge(MeansXProdData other) {
        if (other.nVars == 0) {
            return true;
        }
        if (this.nVars == 0) {
            this.nVars = other.nVars;
            this.hasIntercept = other.hasIntercept;
            this.nCases = other.nCases;
            this.meansArray = new double[this.nVars];
            MathFun.dCopy((double[])other.meansArray, (double[])this.meansArray);
            this.mXProds = new DenseSymMatrix(this.nVars);
            other.mXProds.copyTo(this.mXProds);
            this.xProdsArray = this.mXProds.getMatrix();
            return true;
        }
        boolean result = this.nVars == other.nVars && this.hasIntercept == other.hasIntercept;
        double tW = this.nCases;
        double oW = other.nCases;
        double mW = tW + oW;
        if (result && mW > 0.0) {
            int i;
            double[] vMeans = new double[this.nVars];
            double coef = oW / mW;
            for (i = 0; i < this.nVars; ++i) {
                vMeans[i] = this.meansArray[i] + coef * (other.meansArray[i] - this.meansArray[i]);
            }
            if (this.hasIntercept) {
                int iX = 0;
                for (int iRow = 0; iRow < this.nVars; ++iRow) {
                    double c1 = tW * (vMeans[iRow] - this.meansArray[iRow]);
                    double c2 = oW * (vMeans[iRow] - other.meansArray[iRow]);
                    for (int iCol = 0; iCol <= iRow; ++iCol) {
                        int n = iX;
                        this.xProdsArray[n] = this.xProdsArray[n] + (other.xProdsArray[iX] + c1 * (vMeans[iCol] - this.meansArray[iCol]) + c2 * (vMeans[iCol] - other.meansArray[iCol]));
                        ++iX;
                    }
                }
            } else {
                for (i = 0; i < this.xProdsArray.length; ++i) {
                    int n = i;
                    this.xProdsArray[n] = this.xProdsArray[n] + other.xProdsArray[i];
                }
            }
            MathFun.dCopy((double[])vMeans, (double[])this.meansArray);
            this.nCases = mW;
        }
        return result;
    }

    public boolean merge(Object[] others) {
        boolean result = true;
        for (int i = 0; i < others.length; ++i) {
            MeansXProdData other = (MeansXProdData)others[i];
            result = result && this.merge(other);
        }
        return result;
    }

    public void addCase(double[] vData, double weight) {
        double newNCases = this.nCases + weight;
        double adjWeight = this.hasIntercept ? weight * this.nCases / newNCases : weight;
        this.updateXX(vData, adjWeight);
        double ratio = weight / newNCases;
        int iVar = 0;
        while (iVar < this.nVars) {
            double incr = (vData[iVar] - this.meansArray[iVar]) * ratio;
            int n = iVar++;
            this.meansArray[n] = this.meansArray[n] + incr;
        }
        this.nCases = newNCases;
    }

    public void addCase(double[] vData, int[] indices, double weight) {
        double newNCases = this.nCases + weight;
        double adjWeight = this.hasIntercept ? weight * this.nCases / newNCases : weight;
        this.updateXXSparse(vData, indices, adjWeight);
        double ratio = weight / newNCases;
        int iVar = 0;
        while (iVar < this.nVars) {
            double incr = 0.0;
            int index = ArrayUtils.indexOf((int[])indices, (int)iVar);
            incr = index != -1 ? (vData[index] - this.meansArray[iVar]) * ratio : (0.0 - this.meansArray[iVar]) * ratio;
            int n = iVar++;
            this.meansArray[n] = this.meansArray[n] + incr;
        }
        this.nCases = newNCases;
    }

    public void deleteCase(double[] vData, double weight) {
        double newNCases = this.nCases - weight;
        double ratio1 = this.nCases / newNCases;
        double ratio2 = -weight / newNCases;
        for (int iVar = 0; iVar < this.nVars; ++iVar) {
            double oldMean = this.meansArray[iVar];
            this.meansArray[iVar] = ratio1 * oldMean + vData[iVar] * ratio2;
        }
        double adjWeight = this.hasIntercept ? -weight * newNCases / this.nCases : -weight;
        this.updateXX(vData, adjWeight);
        this.nCases = newNCases;
    }

    public void deleteCase(double[] vData, int[] indices, double weight) {
        double newNCases = this.nCases - weight;
        double ratio1 = this.nCases / newNCases;
        double ratio2 = -weight / newNCases;
        for (int iVar = 0; iVar < this.nVars; ++iVar) {
            double oldMean = this.meansArray[iVar];
            int index = ArrayUtils.indexOf((int[])indices, (int)iVar);
            this.meansArray[iVar] = index != -1 ? ratio1 * oldMean + vData[index] * ratio2 : ratio1 * oldMean;
        }
        double adjWeight = this.hasIntercept ? -weight * newNCases / this.nCases : -weight;
        this.updateXXSparse(vData, indices, adjWeight);
        this.nCases = newNCases;
    }

    protected void updateXX(double[] vData, double adjWeight) {
        if (adjWeight == 0.0) {
            return;
        }
        int iX = 0;
        for (int iRow = 0; iRow < this.nVars; ++iRow) {
            double rDiff;
            double d = rDiff = this.hasIntercept ? vData[iRow] - this.meansArray[iRow] : vData[iRow];
            if ((rDiff *= adjWeight) == 0.0) {
                iX += iRow + 1;
                continue;
            }
            for (int iCol = 0; iCol <= iRow; ++iCol) {
                double cDiff = this.hasIntercept ? vData[iCol] - this.meansArray[iCol] : vData[iCol];
                int n = iX++;
                this.xProdsArray[n] = this.xProdsArray[n] + rDiff * cDiff;
            }
        }
    }

    protected void updateXXSparse(double[] vData, int[] indices, double adjWeight) {
        if (adjWeight == 0.0) {
            return;
        }
        if (this.hasIntercept) {
            int iX = 0;
            for (int iRow = 0; iRow < this.nVars; ++iRow) {
                double rDiff = 0.0;
                int idxRow = ArrayUtils.indexOf((int[])indices, (int)iRow);
                rDiff = idxRow != -1 ? vData[idxRow] - this.meansArray[iRow] : 0.0 - this.meansArray[iRow];
                if (rDiff == 0.0) {
                    iX += iRow + 1;
                    continue;
                }
                rDiff *= adjWeight;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    double cDiff = 0.0;
                    int idxCol = ArrayUtils.indexOf((int[])indices, (int)iCol);
                    cDiff = idxCol != -1 ? vData[idxCol] - this.meansArray[iCol] : 0.0 - this.meansArray[iCol];
                    int n = iX++;
                    this.xProdsArray[n] = this.xProdsArray[n] + rDiff * cDiff;
                }
            }
        } else {
            int nonZeroVars = indices.length;
            for (int iRow = 0; iRow < nonZeroVars; ++iRow) {
                double rDiff = vData[iRow];
                if (rDiff == 0.0) continue;
                rDiff *= adjWeight;
                int iX = indices[iRow] * (indices[iRow] + 1) / 2;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    int index;
                    double cDiff = vData[iCol];
                    int n = index = iX + indices[iCol];
                    this.xProdsArray[n] = this.xProdsArray[n] + rDiff * cDiff;
                }
            }
        }
    }

    public String toString() {
        return "MeansXProdData [hasIntercept=" + this.hasIntercept + ", mXProds=" + this.mXProds + ", meansArray=" + Arrays.toString(this.meansArray) + ", nCases=" + this.nCases + ", nVars=" + this.nVars + ", xProdsArray=" + Arrays.toString(this.xProdsArray) + "]";
    }

    protected MeansXProdData clone() {
        try {
            MeansXProdData newObj = (MeansXProdData)super.clone();
            newObj.meansArray = this.meansArray != null ? (double[])this.meansArray.clone() : null;
            DenseSymMatrix denseSymMatrix = newObj.mXProds = this.mXProds != null ? this.mXProds.clone() : null;
            if (this.mXProds != null) {
                newObj.xProdsArray = newObj.mXProds.getMatrix();
            }
            return newObj;
        }
        catch (CloneNotSupportedException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }
}

