/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.ac.acmath.accumstats.AccumTestStats4ContTarget;
import com.spss.ac.acmath.output.HistogramData;
import com.spss.math.MissingValue;
import com.spss.math.statistics.DistributionFunctions;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OnewayAnovaTestForContTarget
implements ACSerializable,
AccumTestStats4ContTarget {
    private static final long serialVersionUID = 2507397760718776291L;
    private int nFactorCategs = 0;
    private int targetX = -1;
    private int factorX = -1;
    private int weightX = -1;
    private double[] accumNRecs = null;
    private double[] targetMeans = null;
    private double[] targetSSqDiffs = null;
    private int validUpdCnt = 0;
    private int invalidUpdCnt = 0;
    private double totalNRecs = 0.0;
    private double validNRecs = 0.0;
    private double totalTargetMean = 0.0;
    private double totalTargetSSqDiffs = 0.0;
    private double totalTargetSSqDiffsDF = MissingValue.getMissing();
    private double sSeFull = MissingValue.getMissing();
    private double sSeFullDF = MissingValue.getMissing();
    private double mSeFull = MissingValue.getMissing();
    private double sSFactor = MissingValue.getMissing();
    private double sSFactorDF = MissingValue.getMissing();
    private double mSFactor = MissingValue.getMissing();
    private double fStat = MissingValue.getMissing();
    private double pValue = MissingValue.getMissing();
    private double adjRSquare = MissingValue.getMissing();
    private double interestingness = MissingValue.getMissing();
    private boolean isIncludeTarHist = false;
    private HistogramData targetHist = null;

    public OnewayAnovaTestForContTarget(int nFactorCategs, int targetX, double targetMin, double targetMax, int factorX, int weightX, boolean isIncludeTarHist) {
        this.nFactorCategs = nFactorCategs;
        this.targetX = targetX;
        this.factorX = factorX;
        this.weightX = weightX;
        this.accumNRecs = new double[this.nFactorCategs];
        this.targetMeans = new double[this.nFactorCategs];
        this.targetSSqDiffs = new double[this.nFactorCategs];
        this.isIncludeTarHist = isIncludeTarHist;
        if (isIncludeTarHist) {
            this.targetHist = new HistogramData(400, targetMin, targetMax, true);
        }
    }

    public OnewayAnovaTestForContTarget(int nFactorCategs, double[] arrNRecs, double[] arrTargetMeans, double[] arrSSq, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        int i;
        this.nFactorCategs = nFactorCategs;
        this.isIncludeTarHist = false;
        this.accumNRecs = new double[this.nFactorCategs];
        MathFun.dCopy((double[])arrNRecs, (double[])this.accumNRecs);
        this.targetMeans = new double[this.nFactorCategs];
        MathFun.dCopy((double[])arrTargetMeans, (double[])this.targetMeans);
        this.targetSSqDiffs = new double[this.nFactorCategs];
        MathFun.dCopy((double[])arrSSq, (double[])this.targetSSqDiffs);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.totalNRecs = totalNRecs;
        this.validNRecs = validNRecs;
        double num = 0.0;
        double sum = 0.0;
        for (i = 0; i < arrNRecs.length; ++i) {
            num += arrNRecs[i];
            sum += arrTargetMeans[i] * arrNRecs[i];
        }
        if (num > 0.0) {
            this.totalTargetMean = sum / num;
        }
        this.totalTargetSSqDiffs = 0.0;
        for (i = 0; i < arrSSq.length; ++i) {
            this.totalTargetSSqDiffs += arrSSq[i] + arrNRecs[i] * arrTargetMeans[i] * arrTargetMeans[i];
        }
        this.totalTargetSSqDiffs -= num * this.totalTargetMean * this.totalTargetMean;
    }

    public OnewayAnovaTestForContTarget() {
        this(0, -1, -1.7976931348623157E308, Double.MIN_VALUE, -1, -1, false);
    }

    public OnewayAnovaTestForContTarget(int nFactorCategs, int targetX, double targetMin, double targetMax, int factorX, boolean isIncludeTarHist) {
        this(nFactorCategs, targetX, targetMin, targetMax, factorX, -1, isIncludeTarHist);
    }

    @Override
    public void setAggregatedStatistics(double[] arrNRecs, double[] arrTargetMeans, double[] arrSSq, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        int i;
        MathFun.dCopy((double[])this.accumNRecs, (double[])arrNRecs);
        MathFun.dCopy((double[])this.targetMeans, (double[])arrTargetMeans);
        MathFun.dCopy((double[])this.targetSSqDiffs, (double[])arrSSq);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.totalNRecs = totalNRecs;
        this.validNRecs = validNRecs;
        double num = 0.0;
        double sum = 0.0;
        for (i = 0; i < arrNRecs.length; ++i) {
            num += arrNRecs[i];
            sum += arrTargetMeans[i] * arrNRecs[i];
        }
        if (num > 0.0) {
            this.totalTargetMean = sum / num;
        }
        this.totalTargetSSqDiffs = 0.0;
        for (i = 0; i < arrSSq.length; ++i) {
            this.totalTargetSSqDiffs += arrSSq[i] + arrNRecs[i] * arrTargetMeans[i] * arrTargetMeans[i];
        }
        this.totalTargetSSqDiffs -= num * this.totalTargetMean * this.totalTargetMean;
    }

    public void setNFactorCategs(int nFactorCategs) {
        this.nFactorCategs = nFactorCategs;
        this.accumNRecs = new double[this.nFactorCategs];
        this.targetMeans = new double[this.nFactorCategs];
        this.targetSSqDiffs = new double[this.nFactorCategs];
    }

    @Override
    public int getNFactorCategs() {
        return this.nFactorCategs;
    }

    public void setTargetIndex(int targetX) {
        this.targetX = targetX;
    }

    @Override
    public int getTargetIndex() {
        return this.targetX;
    }

    public void setFactorIndex(int factorX) {
        this.factorX = factorX;
    }

    public int getFactorIndex() {
        return this.factorX;
    }

    public void setWeightIndex(int weightX) {
        this.weightX = weightX;
    }

    @Override
    public int getWeightIndex() {
        return this.weightX;
    }

    @Override
    public double[] getNRecs() {
        return this.accumNRecs;
    }

    @Override
    public double[] getTargetMeans() {
        return this.targetMeans;
    }

    @Override
    public double[] getTargetSSqDiffs() {
        return this.targetSSqDiffs;
    }

    @Override
    public int getUnweightedNRecs() {
        return this.validUpdCnt + this.invalidUpdCnt;
    }

    @Override
    public double getTotalNRecs() {
        return this.totalNRecs;
    }

    @Override
    public double getValidNRecs() {
        return this.validNRecs;
    }

    @Override
    public double getTotalTargetMean() {
        return this.totalTargetMean;
    }

    @Override
    public double getTotalSumOfSquares() {
        return this.totalTargetSSqDiffs;
    }

    @Override
    public double getTotalDegreesOfFreedom() {
        return this.totalTargetSSqDiffsDF;
    }

    @Override
    public double getErrorSumOfSquares() {
        return this.sSeFull;
    }

    @Override
    public double getErrorDegreesOfFreedom() {
        return this.sSeFullDF;
    }

    @Override
    public double getErrorMeanSquares() {
        return this.mSeFull;
    }

    @Override
    public double getModelSumOfSquares() {
        return this.sSFactor;
    }

    @Override
    public double getModelDegreesOfFreedom() {
        return this.sSFactorDF;
    }

    @Override
    public double getModelMeanSquares() {
        return this.mSFactor;
    }

    @Override
    public int getValidUpdCnt() {
        return this.validUpdCnt;
    }

    @Override
    public int getInvalidUpdCnt() {
        return this.invalidUpdCnt;
    }

    @Override
    public double getFStat() {
        return this.fStat;
    }

    @Override
    public double getPValue() {
        return this.pValue;
    }

    @Override
    public double getFitMeasure() {
        return this.adjRSquare;
    }

    @Override
    public double getRelativeError() {
        double result = MissingValue.getMissing();
        if (this.totalTargetSSqDiffs > 0.0) {
            result = this.sSeFull / this.totalTargetSSqDiffs;
        }
        return result;
    }

    @Override
    public double getAccuracy() {
        double result = MissingValue.getMissing();
        if (this.totalTargetSSqDiffs > 0.0) {
            result = 1.0 - this.sSeFull / this.totalTargetSSqDiffs;
        }
        return result;
    }

    @Override
    public boolean update(double[] record, boolean validateFactorVal) {
        double target = record[this.targetX];
        double cat = record[this.factorX];
        int categ = (int)record[this.factorX];
        double weight = this.weightX >= 0 ? record[this.weightX] : 1.0;
        boolean result = true;
        if (validateFactorVal) {
            boolean bl = result = !MissingValue.isMissing((double)cat) && categ >= 0 && categ < this.nFactorCategs;
        }
        if (result) {
            double newW;
            double oldW = this.accumNRecs[categ];
            this.accumNRecs[categ] = newW = oldW + weight;
            double oldMean = this.targetMeans[categ];
            int n = categ;
            this.targetMeans[n] = this.targetMeans[n] + weight / newW * (target - oldMean);
            double diff = target - oldMean;
            int n2 = categ;
            this.targetSSqDiffs[n2] = this.targetSSqDiffs[n2] + weight * oldW / newW * diff * diff;
            oldW = this.validNRecs;
            this.validNRecs = newW = oldW + weight;
            oldMean = this.totalTargetMean;
            this.totalTargetMean += weight / newW * (target - oldMean);
            diff = target - oldMean;
            this.totalTargetSSqDiffs += weight * oldW / newW * diff * diff;
            if (this.isIncludeTarHist) {
                this.targetHist.updateData(weight, 1.0, target);
            }
            ++this.validUpdCnt;
            this.totalNRecs += weight;
        } else {
            ++this.invalidUpdCnt;
            if (!MissingValue.isMissing((double)weight) && weight > 0.0) {
                this.totalNRecs += weight;
            }
        }
        return result;
    }

    @Override
    public boolean merge(AccumStats4InteractTests other) {
        boolean result = other instanceof OnewayAnovaTestForContTarget;
        if (!result) {
            return result;
        }
        OnewayAnovaTestForContTarget otherA = (OnewayAnovaTestForContTarget)other;
        if (otherA.nFactorCategs == 0) {
            return result;
        }
        if (this.nFactorCategs == 0) {
            this.targetX = otherA.targetX;
            this.factorX = otherA.factorX;
            this.weightX = otherA.weightX;
            this.nFactorCategs = otherA.nFactorCategs;
            this.accumNRecs = Arrays.copyOf(otherA.accumNRecs, otherA.accumNRecs.length);
            this.targetMeans = Arrays.copyOf(otherA.targetMeans, otherA.targetMeans.length);
            this.targetSSqDiffs = Arrays.copyOf(otherA.targetSSqDiffs, otherA.targetSSqDiffs.length);
            this.validUpdCnt = otherA.validUpdCnt;
            this.totalNRecs = otherA.totalNRecs;
            this.validNRecs = otherA.validNRecs;
            this.totalTargetMean = otherA.totalTargetMean;
            this.totalTargetSSqDiffs = otherA.totalTargetSSqDiffs;
            if (otherA.isIncludeTarHist) {
                this.isIncludeTarHist = true;
                this.targetHist = otherA.targetHist.clone();
            }
            return result;
        }
        if (this.nFactorCategs != otherA.nFactorCategs) {
            return false;
        }
        for (int i = 0; i < this.nFactorCategs; ++i) {
            double newMean;
            double newW;
            double oldW = this.accumNRecs[i];
            double otherOldW = otherA.accumNRecs[i];
            if (!(otherOldW > 0.0)) continue;
            this.accumNRecs[i] = newW = oldW + otherOldW;
            double oldMean = this.targetMeans[i];
            double otherOldMean = otherA.targetMeans[i];
            this.targetMeans[i] = newMean = (oldMean * oldW + otherOldMean * otherOldW) / newW;
            int n = i;
            this.targetSSqDiffs[n] = this.targetSSqDiffs[n] + (otherA.targetSSqDiffs[i] + oldW * oldMean * oldMean + otherOldW * otherOldMean * otherOldMean - newW * newMean * newMean);
        }
        double oldW = this.validNRecs;
        double otherOldW = otherA.validNRecs;
        if (otherOldW > 0.0) {
            double newMean;
            double newW;
            this.validNRecs = newW = oldW + otherOldW;
            double oldMean = this.totalTargetMean;
            double otherOldMean = otherA.totalTargetMean;
            this.totalTargetMean = newMean = (oldMean * oldW + otherOldMean * otherOldW) / newW;
            this.totalTargetSSqDiffs += otherA.totalTargetSSqDiffs + oldW * oldMean * oldMean + otherOldW * otherOldMean * otherOldMean - newW * newMean * newMean;
        }
        if (this.isIncludeTarHist) {
            ArrayList<HistogramData> histList = new ArrayList<HistogramData>();
            histList.add(otherA.getTargetHistogram());
            this.targetHist.addObjects(histList);
        }
        this.validUpdCnt += otherA.validUpdCnt;
        this.invalidUpdCnt += otherA.invalidUpdCnt;
        this.totalNRecs += otherA.totalNRecs;
        return result;
    }

    @Override
    public boolean merge(List<? extends AccumStats4InteractTests> others) {
        boolean result = true;
        for (int i = 0; result && i < others.size(); ++i) {
            AccumStats4InteractTests other = others.get(i);
            if (other == null) continue;
            result = this.merge(other);
        }
        return result;
    }

    @Override
    public double computeStatistics() {
        double result = MissingValue.getMissing();
        if (this.validUpdCnt == 0) {
            return result;
        }
        if (this.targetSSqDiffs == null) {
            return result;
        }
        this.totalTargetSSqDiffsDF = this.validNRecs - 1.0;
        this.sSeFull = 0.0;
        for (int i = 0; i < this.nFactorCategs; ++i) {
            this.sSeFull += this.targetSSqDiffs[i];
        }
        this.sSeFullDF = this.validNRecs - (double)this.nFactorCategs;
        if (this.sSeFullDF > 0.0) {
            this.mSeFull = this.sSeFull / this.sSeFullDF;
        }
        this.sSFactor = this.totalTargetSSqDiffs - this.sSeFull;
        this.sSFactorDF = (double)this.nFactorCategs - 1.0;
        if (this.sSFactorDF > 0.0) {
            this.mSFactor = this.sSFactor / this.sSFactorDF;
        }
        if (this.sSeFull > 0.0 && this.sSeFullDF > 0.0 && this.sSFactorDF > 0.0) {
            this.fStat = this.sSFactor / this.sSFactorDF / (this.sSeFull / this.sSeFullDF);
            double cdfF = DistributionFunctions.cdfF((double)this.fStat, (double)this.sSFactorDF, (double)this.sSeFullDF);
            if (!MissingValue.isMissing((double)cdfF)) {
                this.pValue = 1.0 - cdfF;
            }
        } else if (this.sSeFull < 1.0E-12 && this.sSFactor >= 1.0E-12) {
            this.pValue = 0.0;
        }
        result = this.pValue;
        if (this.sSeFullDF > 0.0 && this.totalTargetSSqDiffs > 0.0 && this.totalTargetSSqDiffsDF > 0.0) {
            this.adjRSquare = 1.0 - this.sSeFull / this.sSeFullDF / (this.totalTargetSSqDiffs / this.totalTargetSSqDiffsDF);
        }
        return result;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        int i;
        dataOutput.writeInt(this.nFactorCategs);
        dataOutput.writeInt(this.targetX);
        dataOutput.writeInt(this.factorX);
        dataOutput.writeInt(this.weightX);
        int len = this.accumNRecs.length;
        dataOutput.writeInt(len);
        for (i = 0; i < len; ++i) {
            dataOutput.writeDouble(this.accumNRecs[i]);
        }
        len = this.targetMeans.length;
        dataOutput.writeInt(len);
        for (i = 0; i < len; ++i) {
            dataOutput.writeDouble(this.targetMeans[i]);
        }
        len = this.targetSSqDiffs.length;
        dataOutput.writeInt(len);
        for (i = 0; i < len; ++i) {
            dataOutput.writeDouble(this.targetSSqDiffs[i]);
        }
        dataOutput.writeInt(this.validUpdCnt);
        dataOutput.writeInt(this.invalidUpdCnt);
        dataOutput.writeDouble(this.totalNRecs);
        dataOutput.writeDouble(this.validNRecs);
        dataOutput.writeDouble(this.totalTargetMean);
        dataOutput.writeDouble(this.totalTargetSSqDiffs);
        dataOutput.writeDouble(this.totalTargetSSqDiffsDF);
        dataOutput.writeDouble(this.sSeFull);
        dataOutput.writeDouble(this.sSeFullDF);
        dataOutput.writeDouble(this.mSeFull);
        dataOutput.writeDouble(this.sSFactor);
        dataOutput.writeDouble(this.sSFactorDF);
        dataOutput.writeDouble(this.mSFactor);
        dataOutput.writeDouble(this.fStat);
        dataOutput.writeDouble(this.pValue);
        dataOutput.writeDouble(this.adjRSquare);
        dataOutput.writeDouble(this.interestingness);
        dataOutput.writeBoolean(this.isIncludeTarHist);
        if (this.isIncludeTarHist) {
            this.targetHist.writeObject(dataOutput);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        int i;
        this.nFactorCategs = dataInput.readInt();
        this.targetX = dataInput.readInt();
        this.factorX = dataInput.readInt();
        this.weightX = dataInput.readInt();
        int len = dataInput.readInt();
        this.accumNRecs = new double[len];
        for (i = 0; i < len; ++i) {
            this.accumNRecs[i] = dataInput.readDouble();
        }
        len = dataInput.readInt();
        this.targetMeans = new double[len];
        for (i = 0; i < len; ++i) {
            this.targetMeans[i] = dataInput.readDouble();
        }
        len = dataInput.readInt();
        this.targetSSqDiffs = new double[len];
        for (i = 0; i < len; ++i) {
            this.targetSSqDiffs[i] = dataInput.readDouble();
        }
        this.validUpdCnt = dataInput.readInt();
        this.invalidUpdCnt = dataInput.readInt();
        this.totalNRecs = dataInput.readDouble();
        this.validNRecs = dataInput.readDouble();
        this.totalTargetMean = dataInput.readDouble();
        this.totalTargetSSqDiffs = dataInput.readDouble();
        this.totalTargetSSqDiffsDF = dataInput.readDouble();
        this.sSeFull = dataInput.readDouble();
        this.sSeFullDF = dataInput.readDouble();
        this.mSeFull = dataInput.readDouble();
        this.sSFactor = dataInput.readDouble();
        this.sSFactorDF = dataInput.readDouble();
        this.mSFactor = dataInput.readDouble();
        this.fStat = dataInput.readDouble();
        this.pValue = dataInput.readDouble();
        this.adjRSquare = dataInput.readDouble();
        this.interestingness = dataInput.readDouble();
        this.isIncludeTarHist = dataInput.readBoolean();
        if (this.isIncludeTarHist) {
            this.targetHist = new HistogramData();
            this.targetHist.readObject(dataInput);
        }
        return this;
    }

    @Override
    public int compareTo(AccumStats4InteractTests o) {
        int ret = 0;
        if (this.adjRSquare > o.getFitMeasure()) {
            ret = 1;
        } else if (this.adjRSquare < o.getFitMeasure()) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public int[] getFactorIndices() {
        int[] result = new int[]{this.factorX};
        return result;
    }

    @Override
    public int[] getCovariateIndices() {
        int[] result = null;
        return result;
    }

    @Override
    public HistogramData getTargetHistogram() {
        return this.targetHist;
    }

    @Override
    public double getEffectSize() {
        return this.sSFactor / this.totalTargetSSqDiffs;
    }

    @Override
    public double getInterestingness() {
        return this.interestingness;
    }

    @Override
    public void setInterestingness(double val) {
        this.interestingness = val;
    }

    @Override
    public void addMissingCounts(double unweightedMissCount, double weightedMissCount) {
        this.invalidUpdCnt += (int)unweightedMissCount;
        this.totalNRecs += weightedMissCount;
    }

    public String toString() {
        String result = "OnewayAnovaTestForContTarget:\n";
        result = result + "Target index=" + this.targetX + ", factor=" + this.factorX;
        result = result + ", pValue=" + this.pValue + ", adjRSquare=" + this.adjRSquare;
        result = result + ", accuracy=" + this.getAccuracy() + "\n";
        return result;
    }
}

