/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.ac.acmath.accumstats.AccumTestStats4CatTarget;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.RectMatrix;
import com.spss.math.statistics.DistributionFunctions;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class OnewayLRTestForCategTarget
implements ACSerializable,
AccumTestStats4CatTarget {
    private static final long serialVersionUID = 8799350372193573684L;
    private int nTargetCategs = 0;
    private int nTargetCategsAdjusted = 0;
    private int nFactorCategs = 0;
    private int targetX = -1;
    private int factorX = -1;
    private int weightX = -1;
    private DenseRectMatrix mNRecs = null;
    private double[] arrNRecs = null;
    private DenseRectMatrix mNRecsAdjusted = null;
    private double[] arrNRecsAdjusted = null;
    private double[] nRecsTargetCateg = null;
    private int[] validTargetCateg = null;
    private double[] nRecsFactorCateg = null;
    private int validUpdCnt = 0;
    private int invalidUpdCnt = 0;
    private double validNRecs = 0.0;
    private double totalNRecs = 0.0;
    private double lFull = 0.0;
    private double lReduced = 0.0;
    private double chiSquare = MissingValue.getMissing();
    private double df = MissingValue.getMissing();
    private double pValue = MissingValue.getMissing();
    private double accuracy = MissingValue.getMissing();
    private double dMcFaddenR2 = MissingValue.getMissing();
    private double effectSize = MissingValue.getMissing();
    private double interestingness = MissingValue.getMissing();

    public OnewayLRTestForCategTarget(int nTargetCategs, int nFactorCategs, int targetX, int factorX, int weightX) {
        this.nTargetCategs = nTargetCategs;
        this.nFactorCategs = nFactorCategs;
        this.factorX = factorX;
        this.targetX = targetX;
        this.weightX = weightX;
        this.mNRecs = new DenseRectMatrix(nFactorCategs, nTargetCategs);
        this.arrNRecs = this.mNRecs.getMatrix();
    }

    public OnewayLRTestForCategTarget(int nTargetCategs, int nFactorCategs, double[] arrNRecs, double[] nRecsTargetCateg, double[] nRecsFactorCateg, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        this.nTargetCategs = nTargetCategs;
        this.nFactorCategs = nFactorCategs;
        this.mNRecs = new DenseRectMatrix(nFactorCategs, nTargetCategs);
        this.arrNRecs = this.mNRecs.getMatrix();
        MathFun.dCopy((double[])arrNRecs, (double[])this.arrNRecs);
        this.nRecsTargetCateg = new double[nTargetCategs];
        MathFun.dCopy((double[])nRecsTargetCateg, (double[])this.nRecsTargetCateg);
        this.nRecsFactorCateg = new double[nFactorCategs];
        MathFun.dCopy((double[])nRecsFactorCateg, (double[])this.nRecsFactorCateg);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.totalNRecs = totalNRecs;
        this.validNRecs = validNRecs;
    }

    public OnewayLRTestForCategTarget() {
        this(0, 0, -1, -1, -1);
    }

    public OnewayLRTestForCategTarget(int nTargetCategs, int nFactorCategs, int targetX, int factorX) {
        this(nTargetCategs, nFactorCategs, targetX, factorX, -1);
    }

    @Override
    public void setAggregatedStatistics(double[] arrNRecs, double[] nRecsTargetCateg, double[] nRecsFactorCateg, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        MathFun.dCopy((double[])arrNRecs, (double[])this.arrNRecs);
        MathFun.dCopy((double[])nRecsTargetCateg, (double[])this.nRecsTargetCateg);
        MathFun.dCopy((double[])nRecsFactorCateg, (double[])this.nRecsFactorCateg);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.totalNRecs = totalNRecs;
        this.validNRecs = validNRecs;
    }

    public void setNCategs(int nTargetCategs, int nFactorCategs) {
        this.nTargetCategs = nTargetCategs;
        this.nFactorCategs = nFactorCategs;
        this.mNRecs = new DenseRectMatrix(nFactorCategs, nTargetCategs);
        this.arrNRecs = this.mNRecs.getMatrix();
    }

    @Override
    public int getNTargetCategs() {
        return this.nTargetCategs;
    }

    @Override
    public int getNFactorCategs() {
        return this.nFactorCategs;
    }

    public void setTargetIndex(int targetX) {
        this.targetX = targetX;
    }

    @Override
    public int getTargetIndex() {
        return this.targetX;
    }

    public void setFactorIndex(int factorX) {
        this.factorX = factorX;
    }

    public int getFactorIndex() {
        return this.factorX;
    }

    public void setWeightIndex(int weightX) {
        this.weightX = weightX;
    }

    @Override
    public int getWeightIndex() {
        return this.weightX;
    }

    @Override
    public DenseRectMatrix getNRecs() {
        return this.mNRecs;
    }

    @Override
    public DenseRectMatrix getObsProbs() {
        DenseRectMatrix mObsProbs = new DenseRectMatrix(this.nFactorCategs, this.nTargetCategsAdjusted);
        double[] arrObsProbs = mObsProbs.getMatrix();
        int elemX = 0;
        for (int iFac = 0; iFac < this.nFactorCategs; ++iFac) {
            double nRecsFac = this.nRecsFactorCateg[iFac];
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                arrObsProbs[elemX] = nRecsFac > 0.0 ? this.arrNRecsAdjusted[elemX] / nRecsFac : 0.0;
                ++elemX;
            }
        }
        return mObsProbs;
    }

    @Override
    public DenseRectMatrix getExpectedNRecs() {
        if (this.nRecsTargetCateg == null || this.validNRecs == 0.0) {
            return null;
        }
        DenseRectMatrix mExpectedNRecs = new DenseRectMatrix(this.nFactorCategs, this.nTargetCategs);
        double[] targetProbs = new double[this.nTargetCategs];
        for (int i = 0; i < this.nTargetCategs; ++i) {
            targetProbs[i] = this.nRecsTargetCateg[this.validTargetCateg[i]] / this.validNRecs;
            for (int k = 0; k < this.nFactorCategs; ++k) {
                double expN = targetProbs[i] * this.nRecsFactorCateg[k];
                mExpectedNRecs.setElem(k, i, expN);
            }
        }
        return mExpectedNRecs;
    }

    @Override
    public double[] getNRecsTargetCateg() {
        return this.nRecsTargetCateg;
    }

    @Override
    public int[] getValidTargetCateg() {
        return this.validTargetCateg;
    }

    @Override
    public double[] getNRecsFactorCateg() {
        return this.nRecsFactorCateg;
    }

    @Override
    public int getValidUpdCnt() {
        return this.validUpdCnt;
    }

    @Override
    public int getInvalidUpdCnt() {
        return this.invalidUpdCnt;
    }

    @Override
    public int getUnweightedNRecs() {
        return this.validUpdCnt + this.invalidUpdCnt;
    }

    @Override
    public double getValidNRecs() {
        return this.validNRecs;
    }

    @Override
    public double getTotalNRecs() {
        return this.totalNRecs;
    }

    @Override
    public double getLFull() {
        return this.lFull;
    }

    @Override
    public double getLReduced() {
        return this.lReduced;
    }

    @Override
    public double getChiSquare() {
        return this.chiSquare;
    }

    @Override
    public double getDF() {
        return this.df;
    }

    @Override
    public double getPValue() {
        return this.pValue;
    }

    @Override
    public double getFitMeasure() {
        return this.accuracy;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public double getMcFaddenR2() {
        return this.dMcFaddenR2;
    }

    @Override
    public double getEffectSize() {
        return this.effectSize;
    }

    @Override
    public boolean update(double[] record, boolean validateFactorVal) {
        double targetValue = record[this.targetX];
        double factorValue = record[this.factorX];
        double weight = this.weightX >= 0 ? record[this.weightX] : 1.0;
        boolean result = true;
        if (validateFactorVal) {
            result = !MissingValue.isMissing((double)factorValue);
        }
        int targetCateg = 0;
        int factorCateg = 0;
        if (result) {
            targetCateg = (int)targetValue;
            factorCateg = (int)factorValue;
            boolean bl = result = targetCateg >= 0 && targetCateg < this.nTargetCategs && factorCateg >= 0 && factorCateg < this.nFactorCategs && weight > 0.0;
        }
        if (result) {
            int elem;
            int n = elem = factorCateg * this.nTargetCategs + targetCateg;
            this.arrNRecs[n] = this.arrNRecs[n] + weight;
            ++this.validUpdCnt;
            this.totalNRecs += weight;
        } else {
            ++this.invalidUpdCnt;
            if (!MissingValue.isMissing((double)weight) && weight > 0.0) {
                this.totalNRecs += weight;
            }
        }
        return result;
    }

    @Override
    public boolean merge(AccumStats4InteractTests other) {
        boolean result = other instanceof OnewayLRTestForCategTarget;
        if (!result) {
            return result;
        }
        OnewayLRTestForCategTarget otherL = (OnewayLRTestForCategTarget)other;
        if (otherL.nTargetCategs == 0) {
            return result;
        }
        if (this.nTargetCategs == 0) {
            this.nTargetCategs = otherL.nTargetCategs;
            this.nFactorCategs = otherL.nFactorCategs;
            this.targetX = otherL.targetX;
            this.factorX = otherL.factorX;
            this.weightX = otherL.weightX;
            this.setNCategs(this.nTargetCategs, this.nFactorCategs);
            MathFun.dCopy((double[])otherL.arrNRecs, (double[])this.arrNRecs);
            if (otherL.nRecsTargetCateg != null) {
                this.nRecsTargetCateg = new double[this.nTargetCategs];
                MathFun.dCopy((double[])otherL.nRecsTargetCateg, (double[])this.nRecsTargetCateg);
            }
            if (otherL.nRecsFactorCateg != null) {
                this.nRecsFactorCateg = new double[this.nFactorCategs];
                MathFun.dCopy((double[])otherL.nRecsFactorCateg, (double[])this.nRecsFactorCateg);
            }
            this.validUpdCnt = otherL.validUpdCnt;
            this.invalidUpdCnt = otherL.invalidUpdCnt;
            this.totalNRecs = otherL.totalNRecs;
            this.lFull = otherL.lFull;
            this.lReduced = otherL.lReduced;
            this.chiSquare = otherL.chiSquare;
            this.pValue = otherL.pValue;
            this.accuracy = otherL.accuracy;
            this.dMcFaddenR2 = otherL.dMcFaddenR2;
            return result;
        }
        if (this.nTargetCategs != otherL.nTargetCategs || this.nFactorCategs != otherL.nFactorCategs) {
            return false;
        }
        int nCells = this.nTargetCategs * this.nFactorCategs;
        for (int iCell = 0; iCell < nCells; ++iCell) {
            int n = iCell;
            this.arrNRecs[n] = this.arrNRecs[n] + otherL.arrNRecs[iCell];
        }
        this.validUpdCnt += otherL.validUpdCnt;
        this.invalidUpdCnt += otherL.invalidUpdCnt;
        this.totalNRecs += otherL.totalNRecs;
        return result;
    }

    @Override
    public boolean merge(List<? extends AccumStats4InteractTests> others) {
        boolean result = true;
        for (int i = 0; result && i < others.size(); ++i) {
            AccumStats4InteractTests other = others.get(i);
            if (other == null) continue;
            result = this.merge(other);
        }
        return result;
    }

    @Override
    public double computeStatistics() {
        double cdf;
        int iFac;
        int elemX;
        double sum;
        if (this.validUpdCnt == 0) {
            return MissingValue.getMissing();
        }
        this.validNRecs = 0.0;
        this.nRecsTargetCateg = new double[this.nTargetCategs];
        this.nRecsFactorCateg = new double[this.nFactorCategs];
        int nMissingTargetCateg = 0;
        for (int iTar = 0; iTar < this.nTargetCategs; ++iTar) {
            sum = 0.0;
            elemX = iTar;
            for (int iFac2 = 0; iFac2 < this.nFactorCategs; ++iFac2) {
                sum += this.arrNRecs[elemX];
                elemX += this.nTargetCategs;
            }
            this.validNRecs += sum;
            this.nRecsTargetCateg[iTar] = sum;
            if (sum != 0.0) continue;
            ++nMissingTargetCateg;
        }
        this.validTargetCateg = new int[this.nTargetCategs - nMissingTargetCateg];
        int i = 0;
        for (int ind = 0; ind < this.nRecsTargetCateg.length; ++ind) {
            if (!(this.nRecsTargetCateg[ind] > 0.0)) continue;
            this.validTargetCateg[i] = ind;
            ++i;
        }
        if (nMissingTargetCateg > 0) {
            this.nTargetCategsAdjusted = this.nTargetCategs - nMissingTargetCateg;
            this.mNRecsAdjusted = new DenseRectMatrix(this.nFactorCategs, this.nTargetCategsAdjusted);
            this.mNRecs.extractColumns(this.validTargetCateg, (RectMatrix)this.mNRecsAdjusted);
            this.arrNRecsAdjusted = this.mNRecsAdjusted.getMatrix();
            this.mNRecs = this.mNRecsAdjusted;
            this.arrNRecs = this.mNRecs.getMatrix();
            this.nTargetCategs = this.nTargetCategsAdjusted;
        } else {
            this.nTargetCategsAdjusted = this.nTargetCategs;
            this.mNRecsAdjusted = this.mNRecs;
            this.arrNRecsAdjusted = this.arrNRecs;
        }
        if (this.nTargetCategsAdjusted <= 1) {
            return MissingValue.getMissing();
        }
        DenseRectMatrix mObsProbs = new DenseRectMatrix(this.nFactorCategs, this.nTargetCategsAdjusted);
        double[] arrObsProbs = mObsProbs.getMatrix();
        elemX = 0;
        int nMissingFactorCateg = 0;
        for (iFac = 0; iFac < this.nFactorCategs; ++iFac) {
            sum = 0.0;
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                sum += this.arrNRecsAdjusted[elemX++];
            }
            this.nRecsFactorCateg[iFac] = sum;
            if (sum != 0.0) continue;
            ++nMissingFactorCateg;
        }
        if (this.nFactorCategs - nMissingFactorCateg <= 1) {
            return MissingValue.getMissing();
        }
        elemX = 0;
        for (iFac = 0; iFac < this.nFactorCategs; ++iFac) {
            double nRecsFac = this.nRecsFactorCateg[iFac];
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                arrObsProbs[elemX] = nRecsFac > 0.0 ? this.arrNRecsAdjusted[elemX] / nRecsFac : 0.0;
                ++elemX;
            }
        }
        double sumMax = 0.0;
        this.lFull = 0.0;
        elemX = 0;
        for (int iFac3 = 0; iFac3 < this.nFactorCategs; ++iFac3) {
            double maxNRecs = 0.0;
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                double obsProb = arrObsProbs[elemX];
                double nRecs = this.arrNRecsAdjusted[elemX];
                maxNRecs = Math.max(maxNRecs, nRecs);
                if (obsProb > 0.0) {
                    this.lFull += nRecs * Math.log(obsProb);
                }
                ++elemX;
            }
            sumMax += maxNRecs;
        }
        this.lReduced = 0.0;
        if (this.validNRecs > 0.0) {
            for (int iTar = 0; iTar < this.nRecsTargetCateg.length; ++iTar) {
                double nRecsTar = this.nRecsTargetCateg[iTar];
                if (!(nRecsTar > 0.0)) continue;
                this.lReduced += nRecsTar * Math.log(nRecsTar / this.validNRecs);
            }
        }
        this.chiSquare = 2.0 * (this.lFull - this.lReduced);
        this.df = (double)(this.nTargetCategsAdjusted - 1) * (double)(this.nFactorCategs - nMissingFactorCateg - 1);
        this.pValue = MissingValue.getMissing();
        if (this.df > 0.0 && !MissingValue.isMissing((double)(cdf = DistributionFunctions.cdfChi((double)this.chiSquare, (double)this.df)))) {
            this.pValue = 1.0 - cdf;
        }
        this.accuracy = MissingValue.getMissing();
        this.dMcFaddenR2 = MissingValue.getMissing();
        if (this.validNRecs > 0.0) {
            this.accuracy = sumMax / this.validNRecs;
        }
        if (this.lReduced != 0.0) {
            double dfFull = (this.nFactorCategs - nMissingFactorCateg) * (this.nTargetCategsAdjusted - 1);
            this.dMcFaddenR2 = 1.0 - (this.lFull - dfFull) / this.lReduced;
            this.effectSize = (this.lReduced - this.lFull + this.df) / this.lReduced;
        }
        return this.pValue;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nTargetCategs);
        dataOutput.writeInt(this.nFactorCategs);
        dataOutput.writeInt(this.targetX);
        dataOutput.writeInt(this.factorX);
        dataOutput.writeInt(this.weightX);
        this.mNRecs.writeObject(dataOutput);
        ACSerializationUtils.writeDoubleArray((double[])this.nRecsTargetCateg, (DataOutput)dataOutput);
        ACSerializationUtils.writeIntArray((int[])this.validTargetCateg, (DataOutput)dataOutput);
        ACSerializationUtils.writeDoubleArray((double[])this.nRecsFactorCateg, (DataOutput)dataOutput);
        dataOutput.writeInt(this.validUpdCnt);
        dataOutput.writeInt(this.invalidUpdCnt);
        dataOutput.writeDouble(this.validNRecs);
        dataOutput.writeDouble(this.totalNRecs);
        dataOutput.writeDouble(this.lFull);
        dataOutput.writeDouble(this.lReduced);
        dataOutput.writeDouble(this.chiSquare);
        dataOutput.writeDouble(this.df);
        dataOutput.writeDouble(this.pValue);
        dataOutput.writeDouble(this.accuracy);
        dataOutput.writeDouble(this.dMcFaddenR2);
        dataOutput.writeDouble(this.effectSize);
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nTargetCategsAdjusted = this.nTargetCategs = dataInput.readInt();
        this.nFactorCategs = dataInput.readInt();
        this.targetX = dataInput.readInt();
        this.factorX = dataInput.readInt();
        this.weightX = dataInput.readInt();
        this.mNRecs = new DenseRectMatrix(this.nFactorCategs, this.nTargetCategs);
        this.mNRecs.readObject(dataInput);
        this.arrNRecs = this.mNRecs.getMatrix();
        this.mNRecsAdjusted = this.mNRecs;
        this.arrNRecsAdjusted = this.arrNRecs;
        this.nRecsTargetCateg = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.validTargetCateg = ACSerializationUtils.readIntArray((DataInput)dataInput);
        this.nRecsFactorCateg = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.validUpdCnt = dataInput.readInt();
        this.invalidUpdCnt = dataInput.readInt();
        this.validNRecs = dataInput.readDouble();
        this.totalNRecs = dataInput.readDouble();
        this.lFull = dataInput.readDouble();
        this.lReduced = dataInput.readDouble();
        this.chiSquare = dataInput.readDouble();
        this.df = dataInput.readDouble();
        this.pValue = dataInput.readDouble();
        this.accuracy = dataInput.readDouble();
        this.dMcFaddenR2 = dataInput.readDouble();
        this.effectSize = dataInput.readDouble();
        return this;
    }

    @Override
    public int compareTo(AccumStats4InteractTests o) {
        int ret = 0;
        if (this.accuracy > o.getFitMeasure()) {
            ret = 1;
        } else if (this.accuracy < o.getFitMeasure()) {
            ret = -1;
        } else if (o instanceof AccumTestStats4CatTarget) {
            AccumTestStats4CatTarget ats = (AccumTestStats4CatTarget)o;
            if (this.dMcFaddenR2 > ats.getMcFaddenR2()) {
                ret = 1;
            } else if (this.dMcFaddenR2 < ats.getMcFaddenR2()) {
                ret = -1;
            }
        }
        return ret;
    }

    @Override
    public int[] getFactorIndices() {
        int[] result = new int[]{this.factorX};
        return result;
    }

    @Override
    public int[] getCovariateIndices() {
        int[] result = null;
        return result;
    }

    @Override
    public double getInterestingness() {
        return this.interestingness;
    }

    @Override
    public void setInterestingness(double val) {
        this.interestingness = val;
    }

    @Override
    public void addMissingCounts(double unweightedMissCount, double weightedMissCount) {
        this.invalidUpdCnt += (int)unweightedMissCount;
        this.totalNRecs += weightedMissCount;
    }
}

