/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.statistics.MathFun;

public class TwowayLRTestLReduced {
    private DenseRectMatrix mNRecs = null;
    private double[] nRecsArray = null;
    private double[] nRecsTargetCateg = null;
    private int nTargetCategs = 0;
    private int nFactor1Categs = 0;
    private int nFactor2Categs = 0;
    private int nCells = 0;
    private boolean nRecsOK = false;
    private double[] cellNRecs = null;
    private static final double COMPTOL = 1.0E-12;
    private int maxIterOuter = 100;
    private double tolOuter = 1.0E-6;
    private int maxIterInner = 5;
    private double tolInner = 1.0E-6;
    private int maxStephalvings = 5;
    private double[] cellPis = null;
    private double[] cellWeights = null;
    private double[] cellWInv = null;
    private double[] cellScores = null;
    private double[] rowAlphas = null;
    private double[] rowAlphasStar = null;
    private double[] colBetas = null;
    private double[] colBetasStar = null;
    private double[] rowScores = null;
    private double[] colScores = null;
    private double[] workSumW = null;
    private double[] workInvW = null;
    private double[] workVec = null;
    private double[] diagVec = null;
    private double[] workSum = null;
    private boolean compProblem = false;
    private int nIterOuter = 0;
    boolean[] zeroWeightMatIndicator = null;

    public TwowayLRTestLReduced(DenseRectMatrix mNRecs, int nFactor1Categs, int nFactor2Categs) {
        this.mNRecs = mNRecs;
        this.nFactor1Categs = nFactor1Categs;
        this.nFactor2Categs = nFactor2Categs;
        this.nRecsOK = this.setup();
        this.nRecsOK = this.nRecsOK && this.nFactor1Categs > 0 && this.nFactor2Categs > 0 && this.nFactor1Categs * this.nFactor2Categs == this.nCells && this.nTargetCategs >= 2;
    }

    public boolean nRecsOK() {
        return this.nRecsOK;
    }

    public boolean compProblem() {
        return this.compProblem;
    }

    private boolean setup() {
        boolean result;
        boolean bl = result = this.mNRecs != null;
        if (result) {
            this.nRecsArray = this.mNRecs.getMatrix();
            this.nCells = this.mNRecs.getNRows();
            this.nTargetCategs = this.mNRecs.getNCols();
            boolean bl2 = result = this.nCells > 0 && this.nTargetCategs > 0;
        }
        if (result) {
            this.nRecsTargetCateg = new double[this.nTargetCategs];
            for (int iTar = 0; iTar < this.nTargetCategs; ++iTar) {
                double sum = 0.0;
                int elemX = iTar;
                for (int iFac = 0; iFac < this.nCells; ++iFac) {
                    sum += this.nRecsArray[elemX];
                    elemX += this.nTargetCategs;
                }
                this.nRecsTargetCateg[iTar] = sum;
            }
            this.cellNRecs = new double[this.nCells];
            this.zeroWeightMatIndicator = new boolean[this.nCells];
            int cellStart = 0;
            boolean allZeroes = true;
            for (int iCell = 0; iCell < this.nCells; ++iCell) {
                double nRecsInCell = 0.0;
                for (int iCat = 0; iCat < this.nTargetCategs; ++iCat) {
                    double nRecs = this.nRecsArray[cellStart + iCat];
                    nRecsInCell += nRecs;
                }
                this.cellNRecs[iCell] = nRecsInCell;
                if (nRecsInCell > 0.0) {
                    allZeroes = false;
                }
                cellStart += this.nTargetCategs;
            }
            int nPis = this.nTargetCategs - 1;
            this.cellPis = new double[this.nCells * nPis];
            int mSize = nPis * (nPis + 1) / 2;
            this.cellWeights = new double[this.nCells * mSize];
            this.cellWInv = new double[this.nCells * mSize];
            this.cellScores = new double[this.nCells * nPis];
            this.rowAlphas = new double[this.nFactor1Categs * nPis];
            this.rowAlphasStar = new double[this.nFactor1Categs * nPis];
            this.colBetas = new double[this.nFactor2Categs * nPis];
            this.colBetasStar = new double[this.nFactor2Categs * nPis];
            this.rowScores = new double[this.nFactor1Categs * nPis];
            this.colScores = new double[this.nFactor2Categs * nPis];
            this.workSumW = new double[nPis * (nPis + 1) / 2];
            this.workInvW = new double[nPis * (nPis + 1) / 2];
            this.workVec = new double[nPis];
            this.diagVec = new double[nPis];
            this.workSum = new double[nPis];
            this.nIterOuter = 0;
            result = !allZeroes;
        }
        return result;
    }

    public int setMaxIterOuter(int maxIterOuter) {
        if (maxIterOuter > 0) {
            this.maxIterOuter = maxIterOuter;
        }
        return this.maxIterOuter;
    }

    public double setTolOuter(double tolOuter) {
        if (tolOuter > 0.0) {
            this.tolOuter = tolOuter;
        }
        return this.tolOuter;
    }

    public int setMaxIterInner(int maxIterInner) {
        if (maxIterInner > 0) {
            this.maxIterInner = maxIterInner;
        }
        return this.maxIterInner;
    }

    public double setTolInner(double tolInner) {
        if (tolInner > 0.0) {
            this.tolInner = tolInner;
        }
        return this.tolInner;
    }

    public int setMaxStephalvings(int maxStephalvings) {
        if (maxStephalvings > 0) {
            this.maxStephalvings = maxStephalvings;
        }
        return this.maxStephalvings;
    }

    public double computeLReduced() {
        double result = MissingValue.getMissing();
        this.compProblem = false;
        int nPis = this.nTargetCategs - 1;
        int nAlphas = this.nFactor1Categs;
        int nBetas = this.nFactor2Categs;
        MathFun.lRZero((double[])this.rowAlphas, (int)0, (int)(nAlphas * nPis));
        MathFun.lRZero((double[])this.colBetas, (int)0, (int)(nBetas * nPis));
        double[] prevAlphas = new double[nAlphas * nPis];
        double[] prevBetas = new double[nBetas * nPis];
        this.computeAllPis();
        double lReducedNew = this.computeCurLReduced();
        boolean stopOuter = false;
        this.nIterOuter = 0;
        while (!stopOuter && !this.compProblem) {
            for (int i = 0; i < this.zeroWeightMatIndicator.length; ++i) {
                this.zeroWeightMatIndicator[i] = false;
            }
            ++this.nIterOuter;
            double lReducedOld = lReducedNew;
            this.computeAllWeightsNScores();
            if (this.compProblem) break;
            boolean stopInner = false;
            MathFun.lRZero((double[])this.rowAlphasStar, (int)0, (int)(nAlphas * nPis));
            MathFun.lRZero((double[])this.colBetasStar, (int)0, (int)(nBetas * nPis));
            int nIterInner = 0;
            while (!stopInner && !this.compProblem) {
                ++nIterInner;
                this.computeRowScores();
                if (this.compProblem) break;
                this.updateByRowScores();
                this.computeColScores();
                if (this.compProblem) break;
                this.updateByColScores();
                double maxRowScores = MathFun.dMaxAbs((int)(nAlphas * nPis), (double[])this.rowScores, (int)0);
                double maxColScores = MathFun.dMaxAbs((int)(nBetas * nPis), (double[])this.colScores, (int)0);
                double maxMarginal = Math.max(maxRowScores, maxColScores);
                stopInner = maxMarginal < this.tolInner || nIterInner >= this.maxIterInner;
            }
            boolean stopHalving = false;
            int nHalvings = 0;
            double coef = 1.0;
            MathFun.dCopy((double[])this.rowAlphas, (double[])prevAlphas);
            MathFun.dCopy((double[])this.colBetas, (double[])prevBetas);
            while (!stopHalving) {
                MathFun.dVecAdd((int)(nAlphas * nPis), (double[])this.rowAlphas, (int)0, (double[])prevAlphas, (int)0, (double[])this.rowAlphasStar, (int)0, (double)coef);
                MathFun.dVecAdd((int)(nBetas * nPis), (double[])this.colBetas, (int)0, (double[])prevBetas, (int)0, (double[])this.colBetasStar, (int)0, (double)coef);
                this.computeAllPis();
                lReducedNew = this.computeCurLReduced();
                stopHalving = lReducedNew >= lReducedOld || ++nHalvings == this.maxStephalvings;
                coef *= 0.5;
            }
            if (lReducedNew < lReducedOld && nHalvings == this.maxStephalvings) {
                stopOuter = true;
                lReducedNew = lReducedOld;
                continue;
            }
            stopOuter = Math.abs(lReducedNew - lReducedOld) < this.tolOuter || this.nIterOuter >= this.maxIterOuter;
        }
        if (!this.compProblem) {
            result = lReducedNew;
        }
        return result;
    }

    public int getNIterOuter() {
        return this.nIterOuter;
    }

    public double[] getRowAlphas() {
        return this.rowAlphas;
    }

    public double[] getColBetas() {
        return this.colBetas;
    }

    public double[] getCellWeights() {
        return this.cellWeights;
    }

    public double[] getCellScores() {
        return this.cellScores;
    }

    public double[] getEstProbs() {
        return this.cellPis;
    }

    private void computePis(double[] alpha, int sAlpha, int nPis, double[] beta, int sBeta, double[] piVec, int sPi) {
        int i;
        double sumMax = alpha[sAlpha] + beta[sBeta];
        for (int i2 = 1; i2 < nPis; ++i2) {
            if (!(this.nRecsTargetCateg[i2] > 0.0)) continue;
            sumMax = Math.max(sumMax, alpha[sAlpha + i2] + beta[sBeta + i2]);
        }
        double denom = Math.exp(-sumMax);
        for (i = 0; i < nPis; ++i) {
            if (!(this.nRecsTargetCateg[i] > 0.0)) continue;
            denom += Math.exp(-sumMax + alpha[sAlpha + i] + beta[sBeta + i]);
        }
        for (i = 0; i < nPis; ++i) {
            if (!(this.nRecsTargetCateg[i] > 0.0)) continue;
            piVec[sPi + i] = Math.exp(-sumMax + alpha[sAlpha + i] + beta[sBeta + i]) / denom;
        }
    }

    private double computeCurLReduced() {
        double result = 0.0;
        int cellStart = 0;
        int piStart = 0;
        int nPis = this.nTargetCategs - 1;
        for (int iCell = 0; iCell < this.nCells; ++iCell) {
            double pi;
            double nRecs;
            double piSum = 0.0;
            for (int iCat = 0; iCat < nPis; ++iCat) {
                nRecs = this.nRecsArray[cellStart + iCat];
                pi = this.cellPis[piStart + iCat];
                if (pi > 0.0) {
                    result += nRecs * Math.log(pi);
                }
                piSum += pi;
            }
            nRecs = this.nRecsArray[cellStart + nPis];
            pi = 1.0 - piSum;
            if (pi > 0.0) {
                result += nRecs * Math.log(pi);
            }
            cellStart += this.nTargetCategs;
            piStart += nPis;
        }
        return result;
    }

    private static void computeWeightMatrix(double nRecsInCell, int nPis, double[] piVec, int sPi, double[] weights, int sWeight) {
        if (nRecsInCell == 0.0) {
            int mSize = nPis * (nPis + 1) / 2;
            MathFun.lRZero((double[])weights, (int)sWeight, (int)mSize);
        } else {
            int iMat = 0;
            for (int iRow = 0; iRow < nPis; ++iRow) {
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    double mElem = -piVec[sPi + iRow] * piVec[sPi + iCol];
                    if (iRow == iCol) {
                        mElem += piVec[sPi + iRow];
                    }
                    weights[sWeight + iMat] = nRecsInCell * mElem;
                    ++iMat;
                }
            }
        }
    }

    private static void computeScores(double nRecsInCell, int nPis, double[] invW, int sInvW, double[] cellNRecs, int sCellN, double[] piVec, int sPi, double[] work, double[] cellScores, int sCellScore) {
        int i;
        for (i = 0; i < nPis; ++i) {
            work[i] = cellNRecs[sCellN + i] / nRecsInCell - piVec[sPi + i];
        }
        MathFun.computeSV((int)nPis, (double[])invW, (int)sInvW, (double[])work, (int)0, (double[])cellScores, (int)sCellScore);
        for (i = 0; i < nPis; ++i) {
            int n = sCellScore + i;
            cellScores[n] = cellScores[n] * nRecsInCell;
        }
    }

    private void computeAllPis() {
        int sPi = 0;
        int sAlpha = 0;
        int nPis = this.nTargetCategs - 1;
        for (int iCat1 = 0; iCat1 < this.nFactor1Categs; ++iCat1) {
            int sBeta = 0;
            for (int iCat2 = 0; iCat2 < this.nFactor2Categs; ++iCat2) {
                this.computePis(this.rowAlphas, sAlpha, nPis, this.colBetas, sBeta, this.cellPis, sPi);
                sBeta += nPis;
                sPi += nPis;
            }
            sAlpha += nPis;
        }
    }

    private boolean computeAllWeightsNScores() {
        boolean result = true;
        int sPi = 0;
        int sWeight = 0;
        int sCellScore = 0;
        int sNRecs = 0;
        int nPis = this.nTargetCategs - 1;
        int nWeights = nPis * (nPis + 1) / 2;
        for (int iCell = 0; iCell < this.nCells; ++iCell) {
            double nRecsInCell = this.cellNRecs[iCell];
            TwowayLRTestLReduced.computeWeightMatrix(nRecsInCell, nPis, this.cellPis, sPi, this.cellWeights, sWeight);
            if (nRecsInCell == 0.0) {
                MathFun.lRZero((double[])this.cellWInv, (int)sWeight, (int)nWeights);
                MathFun.lRZero((double[])this.cellScores, (int)sCellScore, (int)nPis);
            } else {
                int iDiag = 0;
                for (int i = 0; i < nPis; ++i) {
                    this.diagVec[i] = this.cellWeights[sWeight + iDiag];
                    iDiag += i + 2;
                }
                int rank = MathFun.cholInverse((int)nPis, (double[])this.cellWeights, (int)sWeight, (double[])this.diagVec, (int)0, (double)1.0E-12, (double[])this.cellWInv, (int)sWeight);
                if (rank <= 0) {
                    this.zeroWeightMatIndicator[iCell] = true;
                    continue;
                }
                TwowayLRTestLReduced.computeScores(nRecsInCell, nPis, this.cellWInv, sWeight, this.nRecsArray, sNRecs, this.cellPis, sPi, this.workVec, this.cellScores, sCellScore);
            }
            sPi += nPis;
            sWeight += nWeights;
            sCellScore += nPis;
            sNRecs += this.nTargetCategs;
        }
        return result;
    }

    private boolean computeRowScores() {
        boolean result = true;
        int nRows = this.nFactor1Categs;
        int nCols = this.nFactor2Categs;
        int nPis = this.nTargetCategs - 1;
        int nWeights = nPis * (nPis + 1) / 2;
        int sWeight = 0;
        int sCellScore = 0;
        int sRowScore = 0;
        int iCell = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            MathFun.lRZero((double[])this.workSumW, (int)0, (int)nWeights);
            MathFun.lRZero((double[])this.workSum, (int)0, (int)nPis);
            boolean emptyRow = true;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                double nRecsInCell = this.cellNRecs[iCell];
                if (nRecsInCell != 0.0 && !this.zeroWeightMatIndicator[iCell]) {
                    emptyRow = false;
                    MathFun.dVecIncr((int)nWeights, (double[])this.workSumW, (int)0, (double[])this.cellWeights, (int)sWeight);
                    MathFun.computeSV((int)nPis, (double[])this.cellWeights, (int)sWeight, (double[])this.cellScores, (int)sCellScore, (double[])this.workVec, (int)0);
                    MathFun.dVecIncr((int)nPis, (double[])this.workSum, (int)0, (double[])this.workVec, (int)0);
                }
                sWeight += nWeights;
                sCellScore += nPis;
                ++iCell;
            }
            if (emptyRow) {
                MathFun.lRZero((double[])this.rowScores, (int)sRowScore, (int)nPis);
            } else {
                int iDiag = 0;
                for (int i = 0; i < nPis; ++i) {
                    this.diagVec[i] = this.workSumW[iDiag];
                    iDiag += i + 2;
                }
                int rank = MathFun.cholInverse((int)nPis, (double[])this.workSumW, (int)0, (double[])this.diagVec, (int)0, (double)1.0E-12, (double[])this.workInvW, (int)0);
                if (rank <= 0) continue;
                MathFun.computeSV((int)nPis, (double[])this.workInvW, (int)0, (double[])this.workSum, (int)0, (double[])this.rowScores, (int)sRowScore);
            }
            sRowScore += nPis;
        }
        return result;
    }

    private boolean computeColScores() {
        boolean result = true;
        int nRows = this.nFactor1Categs;
        int nCols = this.nFactor2Categs;
        int nPis = this.nTargetCategs - 1;
        int nWeights = nPis * (nPis + 1) / 2;
        int sColScore = 0;
        for (int iCol = 0; iCol < nCols; ++iCol) {
            int iCell = iCol;
            boolean emptyCol = true;
            int sWeight = nWeights * iCol;
            int sCellScore = nPis * iCol;
            MathFun.lRZero((double[])this.workSumW, (int)0, (int)nWeights);
            MathFun.lRZero((double[])this.workSum, (int)0, (int)nPis);
            for (int iRow = 0; iRow < nRows; ++iRow) {
                double nRecsInCell = this.cellNRecs[iCell];
                if (nRecsInCell != 0.0 && !this.zeroWeightMatIndicator[iCell]) {
                    emptyCol = false;
                    MathFun.dVecIncr((int)nWeights, (double[])this.workSumW, (int)0, (double[])this.cellWeights, (int)sWeight);
                    MathFun.computeSV((int)nPis, (double[])this.cellWeights, (int)sWeight, (double[])this.cellScores, (int)sCellScore, (double[])this.workVec, (int)0);
                    MathFun.dVecIncr((int)nPis, (double[])this.workSum, (int)0, (double[])this.workVec, (int)0);
                }
                sWeight += nWeights * nCols;
                sCellScore += nPis * nCols;
                iCell += nCols;
            }
            if (emptyCol) {
                MathFun.lRZero((double[])this.colScores, (int)sColScore, (int)nPis);
            } else {
                int iDiag = 0;
                for (int i = 0; i < nPis; ++i) {
                    this.diagVec[i] = this.workSumW[iDiag];
                    iDiag += i + 2;
                }
                int rank = MathFun.cholInverse((int)nPis, (double[])this.workSumW, (int)0, (double[])this.diagVec, (int)0, (double)1.0E-12, (double[])this.workInvW, (int)0);
                if (rank <= 0) continue;
                MathFun.computeSV((int)nPis, (double[])this.workInvW, (int)0, (double[])this.workSum, (int)0, (double[])this.colScores, (int)sColScore);
            }
            sColScore += nPis;
        }
        return result;
    }

    private void updateByRowScores() {
        int nRows = this.nFactor1Categs;
        int nCols = this.nFactor2Categs;
        int nPis = this.nTargetCategs - 1;
        int sRowScore = 0;
        int sAlphaStar = 0;
        int sCellScore = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            for (int iCol = 0; iCol < nCols; ++iCol) {
                MathFun.dVecDecr((int)nPis, (double[])this.cellScores, (int)sCellScore, (double[])this.rowScores, (int)sRowScore);
                sCellScore += nPis;
            }
            MathFun.dVecIncr((int)nPis, (double[])this.rowAlphasStar, (int)sAlphaStar, (double[])this.rowScores, (int)sRowScore);
            sRowScore += nPis;
            sAlphaStar += nPis;
        }
    }

    private void updateByColScores() {
        int nRows = this.nFactor1Categs;
        int nCols = this.nFactor2Categs;
        int nPis = this.nTargetCategs - 1;
        int sColScore = 0;
        int sBetaStar = 0;
        for (int iCol = 0; iCol < nCols; ++iCol) {
            int sCellScore = nPis * iCol;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                MathFun.dVecDecr((int)nPis, (double[])this.cellScores, (int)sCellScore, (double[])this.colScores, (int)sColScore);
                sCellScore += nPis * nCols;
            }
            MathFun.dVecIncr((int)nPis, (double[])this.colBetasStar, (int)sBetaStar, (double[])this.colScores, (int)sColScore);
            sColScore += nPis;
            sBetaStar += nPis;
        }
    }
}

