/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.activeset;

import com.spss.ac.acbase.tuple.Tuple2;
import com.spss.ac.acmath.optimizer.activeset.ASMOptAccumStats;
import com.spss.ac.acmath.optimizer.common.ConverCrit;
import com.spss.ac.acmath.optimizer.common.HessianCompMethod;
import com.spss.ac.acmath.optimizer.common.OptimSettings;
import com.spss.ac.acmath.optimizer.linesearch.LineSearch;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchImpl;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchMethod;
import com.spss.ac.acmath.optimizer.newton.RegOptDataHandler;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.matrix.RectMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.math.statistics.MathFun;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ActiveSetOptimizer {
    private static final Logger log = Logger.getLogger(ActiveSetOptimizer.class);
    public static final double epsLM1AS = 0.1;
    public static final double epsLM2AS = 0.01;
    public static final double epsLM3AS = 0.001;
    public static final double infAS = 1.0E8;
    RegOptDataHandler dataHandler = null;
    ASMOptAccumStats accumStats = null;
    private OptimSettings optimSettings = null;
    private int nEstParams = 0;
    protected int lastIter = 0;
    private double[] estParams;
    private double[] estParamsPrev;
    private double objFunCur = 0.0;
    private double[] gradientCur = null;
    private DenseSymMatrix hessian = null;
    private DenseSymMatrix hessianGI = null;
    private HessianCompMethod method;
    public static final int maxNHessContNotPD = 5;
    private int nHessContNotPD = 0;
    private CCBitSet redunCur = null;
    private double[] searchDir;
    private double objFunPrevIter = 0.0;
    private double objFunChangeLastIter = 0.0;
    private double paramChangeLastIter = 0.0;
    private double[] prjGradient = null;
    private DenseSymMatrix prjHessianGI = null;
    private double[] prjSearchDir;
    private LineSearch lineSearch;
    private double initCoef = 1.0;
    private double maxStepLen;
    private CCBitSet maxStepLenIndexes;
    private double[] distance;
    private double stepLen = 1.0;
    private double epsilon = 1.0E-6;
    private int nConstr;
    private int nActiveConstr;
    private double[] varCoeffs = null;
    private double[] constCoeff = null;
    private CCBitSet activeIndexes;
    private double[] lMers = null;
    private DenseRectMatrix activeVarMat = new DenseRectMatrix();
    private double[] activeConstVec;
    private DenseRectMatrix prjMat = new DenseRectMatrix();
    private DenseRectMatrix q1Mat;
    private DenseRectMatrix qMat;
    private double[] qtGradient;
    private DenseSymMatrix rMat = null;
    private double epsilonLM;
    private boolean outIterHist = false;
    private int intervalIterHist = 1;
    private List<Tuple2<Double, double[]>> iterHist = null;

    public ActiveSetOptimizer(RegOptDataHandler dataHandler, ASMOptAccumStats accumStats, double[] estParams, OptimSettings optimSettings) {
        this.dataHandler = dataHandler;
        this.accumStats = accumStats;
        this.estParams = estParams;
        this.estParamsPrev = (double[])estParams.clone();
        this.nEstParams = estParams.length;
        this.optimSettings = optimSettings;
        this.searchDir = new double[this.nEstParams];
        this.redunCur = new CCBitSet(this.nEstParams);
        this.hessian = new DenseSymMatrix(this.nEstParams);
        this.hessianGI = new DenseSymMatrix(this.nEstParams);
        this.prjHessianGI = new DenseSymMatrix(this.nEstParams);
        this.rMat = new DenseSymMatrix();
        this.qMat = new DenseRectMatrix();
        this.q1Mat = new DenseRectMatrix();
        this.varCoeffs = new double[this.nEstParams];
        this.constCoeff = new double[1];
        this.nConstr = accumStats.getNumOfConstr();
        this.activeIndexes = new CCBitSet(this.nConstr);
        this.maxStepLenIndexes = new CCBitSet(this.nConstr);
    }

    public ActiveSetOptimizer(RegOptDataHandler dataHandler, ASMOptAccumStats accumStats, double[] estParams, OptimSettings optimSettings, boolean outIterHist, int intervalIterHist) {
        this.dataHandler = dataHandler;
        this.accumStats = accumStats;
        this.estParams = estParams;
        this.estParamsPrev = (double[])estParams.clone();
        this.nEstParams = estParams.length;
        this.optimSettings = optimSettings;
        this.searchDir = new double[this.nEstParams];
        this.redunCur = new CCBitSet(this.nEstParams);
        this.hessian = new DenseSymMatrix(this.nEstParams);
        this.hessianGI = new DenseSymMatrix(this.nEstParams);
        this.prjHessianGI = new DenseSymMatrix(this.nEstParams);
        this.rMat = new DenseSymMatrix();
        this.qMat = new DenseRectMatrix();
        this.q1Mat = new DenseRectMatrix();
        this.varCoeffs = new double[this.nEstParams];
        this.constCoeff = new double[1];
        this.nConstr = accumStats.getNumOfConstr();
        this.activeIndexes = new CCBitSet(this.nConstr);
        this.maxStepLenIndexes = new CCBitSet(this.nConstr);
        this.outIterHist = outIterHist;
        this.intervalIterHist = intervalIterHist;
        if (this.outIterHist) {
            this.iterHist = new ArrayList<Tuple2<Double, double[]>>();
        }
    }

    public ConverCrit estimate() {
        ConverCrit converCrit = ConverCrit.NOT_ALL;
        this.dataHandler.setStatsModel(this.accumStats);
        this.computeFuncGradHess();
        if (this.outIterHist) {
            this.iterHist.add((Tuple2<Double, double[]>)new Tuple2((Object)this.objFunCur, this.estParams.clone()));
        }
        boolean bContinue = true;
        this.setActiveSet();
        while (bContinue) {
            this.estParamsPrev = (double[])this.estParams.clone();
            this.objFunPrevIter = this.objFunCur;
            this.maxStepLenIndexes.clear();
            this.setActiveMatVec();
            this.computeHessianInverse();
            bContinue = this.computeProjectionMat();
            if (!bContinue) {
                converCrit = ConverCrit.INVALIDSTATS;
                break;
            }
            bContinue = this.projection(true);
            if (!bContinue) {
                converCrit = ConverCrit.INVALIDSTATS;
                break;
            }
            if (this.nActiveConstr < this.nEstParams) {
                this.prjSearchDir = this.computeSearchDirectionMul(this.prjHessianGI, this.prjGradient);
            } else if (this.nActiveConstr == this.nEstParams) {
                this.searchDir = new double[this.nEstParams];
            }
            bContinue = this.projection(false);
            if (!bContinue) {
                converCrit = ConverCrit.INVALIDSTATS;
                break;
            }
            if (this.nActiveConstr > 0) {
                bContinue = this.computeLagMulVec();
                if (!bContinue) {
                    converCrit = ConverCrit.INVALIDSTATS;
                    break;
                }
                if (this.checkLagMulVec()) {
                    if (this.nActiveConstr == this.nEstParams) {
                        break;
                    }
                } else {
                    this.deleteActiveConstr();
                    continue;
                }
            }
            this.maxStepLen = this.computeMaxStepLen(this.maxStepLenIndexes);
            this.computeInitStepLen();
            this.lineSearch = new LineSearchImpl(this.optimSettings.getMaxLineSearchIter(), this.nEstParams, this.optimSettings.getLineSearchMethod(), this.optimSettings.getLineSearchTermRule(), this.optimSettings.getAllSHValues(), this.stepLen, this.optimSettings.getLineSearchTau(), this.optimSettings.getCompTol());
            ((LineSearchImpl)this.lineSearch).initialize(this.objFunCur, this.gradientCur, this.searchDir, 0.0, this.maxStepLen, this.stepLen);
            converCrit = this.lineSearch(this.maxStepLen);
            if (converCrit.equals((Object)ConverCrit.INVALIDSTATS)) break;
            this.stepLen = this.lineSearch.getStepLength();
            this.setActiveSet();
            ++this.lastIter;
            if (this.outIterHist && this.lastIter % this.intervalIterHist == 0) {
                this.iterHist.add((Tuple2<Double, double[]>)new Tuple2((Object)this.objFunCur, this.estParams.clone()));
            }
            if (this.nHessContNotPD == 5) break;
            converCrit = this.checkForConvergence();
            if (converCrit.equals((Object)ConverCrit.ALL_CONVERGED) || converCrit.equals((Object)ConverCrit.MAX_ITERATIONS)) {
                bContinue = false;
            }
            if (!bContinue) break;
            this.computeFuncGradHess();
        }
        return converCrit;
    }

    public double computeMaxStepLen(CCBitSet maxStepLenIndexes) {
        double infVal;
        double maxStepLen = 0.0;
        maxStepLen = infVal = 1.0E8;
        CCBitSet index = this.activeIndexes.clone();
        this.setActiveSet();
        if (this.nConstr > 0) {
            int i;
            this.distance = new double[this.nConstr];
            for (i = 0; i < this.nConstr; ++i) {
                if (!this.activeIndexes.isIn(i)) {
                    this.accumStats.getConstrCoeffs(i, this.varCoeffs, this.constCoeff);
                    double tmp = MathFun.dDot((int)this.nEstParams, (double[])this.varCoeffs, (int)0, (int)1, (double[])this.searchDir, (int)0, (int)1);
                    if (tmp < 0.0) {
                        double tmp1 = MathFun.dDot((int)this.nEstParams, (double[])this.varCoeffs, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
                        double denom = tmp;
                        if (denom > -this.optimSettings.getCompTol()) {
                            denom = -this.optimSettings.getCompTol();
                        }
                        this.distance[i] = (-tmp1 - this.constCoeff[0]) / denom;
                    } else {
                        this.distance[i] = infVal;
                    }
                } else {
                    this.distance[i] = infVal;
                }
                if (!(this.distance[i] < maxStepLen)) continue;
                maxStepLen = this.distance[i];
            }
            for (i = 0; i < this.nConstr; ++i) {
                if (this.distance[i] != maxStepLen) continue;
                maxStepLenIndexes.set(i, true);
            }
        }
        this.activeIndexes = index;
        return maxStepLen;
    }

    private void setActiveSet() {
        if (this.nConstr > 0) {
            for (int i = 0; i < this.nConstr; ++i) {
                if (this.activeIndexes.isIn(i)) continue;
                this.accumStats.getConstrCoeffs(i, this.varCoeffs, this.constCoeff);
                double tol = this.epsilon * (Math.abs(this.constCoeff[0]) + 1.0);
                double tmp = MathFun.dDot((int)this.nEstParams, (double[])this.estParams, (int)0, (int)1, (double[])this.varCoeffs, (int)0, (int)1);
                if (!(Math.abs(tmp + this.constCoeff[0]) <= tol)) continue;
                this.activeIndexes.set(i, true);
            }
            this.getNActiveConstr();
        } else {
            this.nActiveConstr = 0;
        }
    }

    private void setActiveMatVec() {
        if (this.nActiveConstr > 0) {
            this.activeVarMat.resize(this.nActiveConstr, this.nEstParams);
            this.activeConstVec = new double[this.nActiveConstr];
            int activeIndex = 0;
            for (int i = 0; i < this.nConstr; ++i) {
                if (!this.activeIndexes.isIn(i)) continue;
                this.accumStats.getConstrCoeffs(i, this.varCoeffs, this.constCoeff);
                for (int j = 0; j < this.nEstParams; ++j) {
                    this.activeVarMat.setElem(activeIndex, j, this.varCoeffs[j]);
                }
                this.activeConstVec[activeIndex] = this.constCoeff[0];
                ++activeIndex;
            }
        }
    }

    private boolean computeProjectionMat() {
        this.prjMat.resize(0, 0);
        if (this.nActiveConstr > 0) {
            DenseRectMatrix tmpActiveVarMat = this.activeVarMat.clone();
            tmpActiveVarMat.transpose();
            if (!tmpActiveVarMat.decompositionH(this.rMat, this.qMat)) {
                return false;
            }
            this.q1Mat.resize(this.nEstParams, this.nActiveConstr);
            int[] extractCol = new int[this.nActiveConstr];
            for (int i = 0; i < this.nActiveConstr; ++i) {
                extractCol[i] = i;
            }
            this.qMat.extractColumns(extractCol, (RectMatrix)this.q1Mat);
            if (this.nActiveConstr < this.nEstParams) {
                int szExtract = this.nEstParams - this.nActiveConstr;
                this.prjMat = new DenseRectMatrix(this.nEstParams, szExtract);
                extractCol = new int[szExtract];
                for (int i = this.nActiveConstr; i < this.nEstParams; ++i) {
                    extractCol[i - this.nActiveConstr] = i;
                }
                this.qMat.extractColumns(extractCol, (RectMatrix)this.prjMat);
            }
        }
        return true;
    }

    private boolean projection(boolean tag) {
        boolean bResult = true;
        if (this.nActiveConstr == 0) {
            if (tag) {
                this.prjGradient = (double[])this.gradientCur.clone();
                this.prjHessianGI = this.hessianGI.clone();
                this.prjSearchDir = new double[this.nEstParams];
            } else {
                this.searchDir = (double[])this.prjSearchDir.clone();
            }
        } else if (this.nActiveConstr > 0 && this.nActiveConstr < this.nEstParams) {
            int sz = this.nEstParams - this.nActiveConstr;
            DenseRectMatrix tmpPrjMat = this.prjMat.clone();
            tmpPrjMat.transpose();
            if (tag) {
                this.prjSearchDir = new double[sz];
                this.prjGradient = new double[sz];
                bResult = tmpPrjMat.computeRV(this.gradientCur, this.prjGradient);
                if (bResult) {
                    this.prjHessianGI.setNRows(sz);
                    this.prjHessianGI = this.hessianGI.computeRTransSR(this.prjMat);
                }
            } else {
                bResult = this.prjMat.computeRV(this.prjSearchDir, this.searchDir);
            }
        }
        return bResult;
    }

    private double[] computeSearchDirectionMul(DenseSymMatrix hessSubst, double[] gradient) {
        int nSize = gradient.length;
        double[] searchDir = new double[nSize];
        double[] vNegGrad = new double[nSize];
        for (int i = 0; i < nSize; ++i) {
            vNegGrad[i] = -gradient[i];
        }
        hessSubst.computeSV(vNegGrad, searchDir);
        return searchDir;
    }

    private boolean computeLagMulVec() {
        boolean bResult = true;
        this.lMers = new double[this.nActiveConstr];
        this.qtGradient = new double[this.nActiveConstr];
        this.q1Mat.transpose();
        bResult = this.q1Mat.computeRV(this.gradientCur, this.qtGradient);
        if (bResult) {
            bResult = this.rMat.tSolveSubst(this.qtGradient, this.lMers, true);
        }
        return bResult;
    }

    private boolean checkLagMulVec() {
        boolean bResult = false;
        double maxGrad = 0.0;
        for (int i = 0; i < this.nEstParams; ++i) {
            if (!(Math.abs(this.gradientCur[i]) > maxGrad)) continue;
            maxGrad = Math.abs(this.gradientCur[i]);
        }
        double tmp = 0.0;
        tmp = 0.1 * this.optimSettings.getHessianConverCrit();
        if (0.001 * maxGrad > tmp) {
            tmp = 0.001 * maxGrad;
        }
        this.epsilonLM = tmp < 0.01 ? -tmp : -0.01;
        for (int i = 0; i < this.nActiveConstr; ++i) {
            if (!(this.lMers[i] >= this.epsilonLM)) {
                bResult = false;
                break;
            }
            bResult = true;
        }
        return bResult;
    }

    public void deleteActiveConstr() {
        int activeIndex = 0;
        int minFlag = 0;
        double min = this.epsilonLM;
        for (int i = 0; i < this.nConstr; ++i) {
            if (!this.activeIndexes.isIn(i)) continue;
            if (Double.isNaN(this.lMers[activeIndex]) || this.lMers[activeIndex] < min) {
                min = this.lMers[activeIndex];
                minFlag = i;
            }
            ++activeIndex;
        }
        this.activeIndexes.set(minFlag, false);
        this.getNActiveConstr();
    }

    private void getNActiveConstr() {
        this.nActiveConstr = this.activeIndexes.inSet();
    }

    protected void computeFuncGradHess() {
        this.method = this.optimSettings.getHessianMethod();
        int compIndicator = 2;
        if (this.method.equals((Object)HessianCompMethod.HYBRID)) {
            if (this.lastIter >= this.optimSettings.getNFisherIter()) {
                this.method = HessianCompMethod.NEWTON_RAPHSON;
                compIndicator = 2;
            } else {
                this.method = HessianCompMethod.FISHER_SCORING;
                compIndicator = 1;
            }
        }
        this.dataHandler.resetAccumStats(this.method, false);
        this.accumStats.adjustEstParamsInZone(this.estParams);
        this.dataHandler.computeStatsForOptimizer(compIndicator);
        this.objFunCur = this.accumStats.getObjFun();
        this.gradientCur = this.accumStats.getGradient();
        this.hessian = this.accumStats.getHessian();
    }

    private boolean computeHessianInverse() {
        boolean result = true;
        double[] diag = new double[this.hessian.getNRows()];
        this.hessian.getNCheckDiagonal(diag, this.optimSettings.getCompTol());
        if (this.hessian.cholInverse(diag, this.optimSettings.getCompTol(), this.hessianGI, this.redunCur) < 0) {
            result = false;
            return result;
        }
        if (this.redunCur.inRange(0, this.hessian.getNRows() - 1) != this.hessian.getNRows()) {
            this.dataHandler.resetAccumStats(HessianCompMethod.FISHER_SCORING, false);
            this.accumStats.adjustEstParamsInZone(this.estParams);
            this.dataHandler.computeStatsForOptimizer(1);
            this.hessian = this.accumStats.getHessian();
            this.method = this.optimSettings.getHessianMethod();
            if (this.method.equals((Object)HessianCompMethod.HYBRID)) {
                this.method = this.lastIter >= this.optimSettings.getNFisherIter() ? HessianCompMethod.NEWTON_RAPHSON : HessianCompMethod.FISHER_SCORING;
            }
            this.dataHandler.resetAccumStats(this.method, false);
            this.hessian.getNCheckDiagonal(diag, this.optimSettings.getCompTol());
            if (this.hessian.cholInverse(diag, this.optimSettings.getCompTol(), this.hessianGI, this.redunCur) < 0) {
                result = false;
                return result;
            }
            if (this.redunCur.inRange(0, this.hessian.getNRows() - 1) < this.hessian.getNRows()) {
                ++this.nHessContNotPD;
                result = this.hessianGI.replaceDiagZeroes(this.optimSettings.getCompTol());
                if (!result) {
                    this.hessianGI.clear();
                    this.hessianGI.addConstToDiagonal(1.0);
                    result = true;
                }
            } else {
                this.nHessContNotPD = 0;
            }
        } else {
            this.nHessContNotPD = 0;
        }
        return result;
    }

    private ConverCrit lineSearch(double maxStepLen) {
        ConverCrit state = ConverCrit.NOT_ALL;
        boolean bStop = false;
        double[] fvGradNew = new double[this.nEstParams];
        double psiNew = 0.0;
        double[] estParamsPrevLineSearch = (double[])this.estParams.clone();
        boolean lineSearchStep = false;
        while (!bStop) {
            MathFun.daxpy((int)this.nEstParams, (double)this.stepLen, (double[])this.searchDir, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
            this.accumStats.adjustEstParamsInZone(this.estParams);
            this.dataHandler.computeStatsForOptimizer(4);
            psiNew = this.accumStats.getObjFun();
            if (MissingValue.isMissing((double)psiNew)) {
                state = ConverCrit.INVALIDSTATS;
                return state;
            }
            fvGradNew = this.accumStats.getGradient();
            LineSearch.LineSearchState lineSearchState = this.lineSearch.doNextIter(psiNew, fvGradNew);
            if (lineSearchState == LineSearch.LineSearchState.LineSearchLoop) {
                for (int i = 0; i < this.nEstParams; ++i) {
                    this.estParams[i] = estParamsPrevLineSearch[i];
                }
                this.stepLen = this.lineSearch.getStepLength();
                continue;
            }
            if (lineSearchState == LineSearch.LineSearchState.Completed) {
                bStop = true;
                continue;
            }
            if (lineSearchState != LineSearch.LineSearchState.MaxIterReached) continue;
            bStop = true;
            state = ConverCrit.MAX_LINESEARCHITERS;
        }
        this.objFunCur = psiNew;
        this.gradientCur = fvGradNew;
        return state;
    }

    private void computeInitStepLen() {
        if (this.optimSettings.getLineSearchMethod().equals((Object)LineSearchMethod.STEP_HALVING) || this.optimSettings.getLineSearchMethod().equals((Object)LineSearchMethod.BACKTRACKING) || this.optimSettings.getLineSearchMethod().equals((Object)LineSearchMethod.NON_MON_BACKTRACKING)) {
            this.stepLen = this.initCoef;
            if (this.maxStepLen < this.stepLen) {
                this.stepLen = this.maxStepLen;
            }
        } else if (this.optimSettings.getLineSearchMethod().equals((Object)LineSearchMethod.BISECTION) || this.optimSettings.getLineSearchMethod().equals((Object)LineSearchMethod.QUAD_INTERPOL) || this.optimSettings.getLineSearchMethod().equals((Object)LineSearchMethod.CUBIC_INTERPOL)) {
            this.stepLen = this.maxStepLen > this.initCoef ? this.initCoef : this.maxStepLen * 0.5;
        }
    }

    protected ConverCrit checkForConvergence() {
        ConverCrit result = ConverCrit.NOT_ALL;
        if (this.lastIter >= this.optimSettings.getMaxIter()) {
            result = ConverCrit.MAX_ITERATIONS;
        } else {
            boolean converged = this.checkThreeConvergence(this.accumStats.getObjFun());
            if (converged) {
                result = ConverCrit.ALL_CONVERGED;
            }
        }
        return result;
    }

    protected boolean checkThreeConvergence(double objFun) {
        boolean converged = true;
        boolean objFunAbsChange = this.optimSettings.getObjFunAbsChange();
        boolean paramAbsChange = this.optimSettings.getParamAbsChange();
        boolean hessianAbsChange = this.optimSettings.getHessianAbsChange();
        double objFunConverCrit = this.optimSettings.getObjFunConverCrit();
        double paramConverCrit = this.optimSettings.getParamConverCrit();
        double hessianConverCrit = this.optimSettings.getHessianConverCrit();
        double denomIncr = this.optimSettings.getDenomIncr();
        double objFunChangeLastIter = Math.abs(this.objFunPrevIter - this.objFunCur);
        if (!objFunAbsChange) {
            double denom = this.objFunPrevIter == 0.0 ? denomIncr : this.objFunPrevIter;
            this.objFunChangeLastIter /= Math.abs(denom);
        }
        if (converged && objFunConverCrit > 0.0) {
            converged = this.objFunChangeLastIter < objFunConverCrit;
        }
        this.paramChangeLastIter = paramAbsChange ? MathFun.vNrm1Diff((double[])this.estParams, (double[])this.estParamsPrev) : MathFun.vMaxRelDiff((double[])this.estParams, (double[])this.estParamsPrev, (double)denomIncr);
        if (converged && paramConverCrit > 0.0 && this.nEstParams > 0) {
            boolean bl = converged = this.paramChangeLastIter < paramConverCrit;
        }
        if (converged && hessianConverCrit > 0.0) {
            double sHs = this.hessianGI.computeVSV(this.gradientCur);
            if (!hessianAbsChange) {
                double denom = objFun == 0.0 ? denomIncr : Math.abs(objFun);
                sHs /= denom;
            }
            converged = sHs < hessianConverCrit;
        }
        return converged;
    }

    public double getObjFunFinal() {
        return this.accumStats.getObjFun();
    }

    public double[] getGradient() {
        return this.accumStats.getGradient();
    }

    public double[] getEstParams() {
        return this.estParams;
    }

    public int getNIterations() {
        return this.lastIter;
    }

    public DenseSymMatrix getHessianGI() {
        return this.hessianGI;
    }

    public List<Tuple2<Double, double[]>> getIterHist() {
        return this.iterHist;
    }
}

