/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.common;

import com.spss.ac.acmath.optimizer.common.HessianCompMethod;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchMethod;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchTermRule;

public class OptimSettings {
    private OptimizationMethod optimMethod = OptimizationMethod.NewtonRaphson;
    private boolean checkObjFunCrit = false;
    private boolean checkParamCrit = true;
    private boolean checkHessianCrit = false;
    private double objFunConverCrit = 1.0E-6;
    private boolean objFunAbsChange = true;
    private double paramConverCrit = 1.0E-6;
    private boolean paramAbsChange = true;
    private double hessianConverCrit = 1.0E-4;
    private boolean hessianAbsChange = true;
    private int maxIter = 50;
    private int maxStepHalvings = 5;
    private HessianCompMethod hessianMethod = HessianCompMethod.HYBRID;
    private int nFisherIter = 2;
    private double compTol = 1.0E-12;
    private boolean minimizeObjFun = true;
    private boolean isCheckingForSeparation = false;
    private CheckForSeparationOperations checkSepOperation = CheckForSeparationOperations.Both;
    private int startIterForCS = 20;
    private double completeSepTol = 0.01;
    private double quasiSepCholDiagTol = 3.16E-4;
    private double quasiMin = 0.001;
    private double quasiMax = 0.99;
    private double denomIncr = 1.0E-6;
    private boolean allSHValues = false;
    private int lenOfHistory4LBFGS = 5;
    private int maxIter4LBFGS = 500;
    private int maxLineSearchIter = 20;
    private double initStepInLineSearch = 1.0;
    private double upperBoundInLineSearch = 4000.0;
    private LineSearchMethod lineSearchMethod = LineSearchMethod.CUBIC_INTERPOL;
    private LineSearchTermRule lineSearchTermRule = LineSearchTermRule.WOLFE;
    private double lineSearchTau = 0.5;
    private double lineSearchZeta = 0.1;
    private double objFunConver4NelderMead = 1.0E-4;
    private int maxIter4NelderMead = 500;
    private boolean checkRedundancy = true;

    public OptimSettings() {
    }

    public OptimSettings(OptimSettings other) {
        this.objFunConverCrit = other.objFunConverCrit;
        this.objFunAbsChange = other.objFunAbsChange;
        this.paramConverCrit = other.paramConverCrit;
        this.paramAbsChange = other.paramAbsChange;
        this.hessianConverCrit = other.hessianConverCrit;
        this.hessianAbsChange = other.hessianAbsChange;
        this.maxIter = other.maxIter;
        this.maxStepHalvings = other.maxStepHalvings;
        this.hessianMethod = other.hessianMethod;
        this.nFisherIter = other.nFisherIter;
        this.compTol = other.compTol;
        this.minimizeObjFun = other.minimizeObjFun;
        this.startIterForCS = other.startIterForCS;
        this.completeSepTol = other.completeSepTol;
        this.quasiSepCholDiagTol = other.quasiSepCholDiagTol;
        this.quasiMin = other.quasiMin;
        this.quasiMax = other.quasiMax;
        this.denomIncr = other.denomIncr;
        this.allSHValues = other.allSHValues;
        this.optimMethod = other.optimMethod;
        this.checkObjFunCrit = other.checkObjFunCrit;
        this.checkParamCrit = other.checkParamCrit;
        this.checkHessianCrit = other.checkHessianCrit;
        this.isCheckingForSeparation = other.isCheckingForSeparation;
        this.checkSepOperation = other.checkSepOperation;
        this.lenOfHistory4LBFGS = other.lenOfHistory4LBFGS;
        this.maxIter4LBFGS = other.maxIter4LBFGS;
        this.maxLineSearchIter = other.maxLineSearchIter;
        this.lineSearchMethod = other.lineSearchMethod;
        this.lineSearchTermRule = other.lineSearchTermRule;
        this.lineSearchTau = other.lineSearchTau;
        this.lineSearchZeta = other.lineSearchZeta;
        this.objFunConver4NelderMead = other.objFunConver4NelderMead;
        this.maxIter4NelderMead = other.maxIter4NelderMead;
        this.checkRedundancy = other.checkRedundancy;
    }

    public void setObjFunConverCrit(double objFunConverCrit) {
        this.objFunConverCrit = objFunConverCrit;
    }

    public double getObjFunConverCrit() {
        return this.objFunConverCrit;
    }

    public void setObjFunAbsChange(boolean objFunAbsChange) {
        this.objFunAbsChange = objFunAbsChange;
    }

    public boolean getObjFunAbsChange() {
        return this.objFunAbsChange;
    }

    public void setParamConverCrit(double paramConverCrit) {
        this.paramConverCrit = paramConverCrit;
    }

    public double getParamConverCrit() {
        return this.paramConverCrit;
    }

    public void setParamAbsChange(boolean paramAbsChange) {
        this.paramAbsChange = paramAbsChange;
    }

    public boolean getParamAbsChange() {
        return this.paramAbsChange;
    }

    public void setHessianConverCrit(double hessianConverCrit) {
        this.hessianConverCrit = hessianConverCrit;
    }

    public double getHessianConverCrit() {
        return this.hessianConverCrit;
    }

    public void setHessianAbsChange(boolean hessianAbsChange) {
        this.hessianAbsChange = hessianAbsChange;
    }

    public boolean getHessianAbsChange() {
        return this.hessianAbsChange;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public void setMaxStephalvings(int maxStepHalvings) {
        this.maxStepHalvings = maxStepHalvings;
    }

    public int getMaxStephalvings() {
        return this.maxStepHalvings;
    }

    public void setHessianMethod(HessianCompMethod hessianMethod) {
        this.hessianMethod = hessianMethod;
    }

    public HessianCompMethod getHessianMethod() {
        return this.hessianMethod;
    }

    public void setNFisherIter(int nFisherIter) {
        this.nFisherIter = nFisherIter;
    }

    public int getNFisherIter() {
        return this.nFisherIter;
    }

    public void setCompTol(double compTol) {
        this.compTol = compTol;
    }

    public double getCompTol() {
        return this.compTol;
    }

    public void setMinimizeObjFun(boolean minimizeObjFun) {
        this.minimizeObjFun = minimizeObjFun;
    }

    public boolean getMinimizeObjFun() {
        return this.minimizeObjFun;
    }

    public void setStartIterForCS(int startIterForCS) {
        this.startIterForCS = startIterForCS;
    }

    public int getStartIterForCS() {
        return this.startIterForCS;
    }

    public void setCompleteSepTol(double completeSepTol) {
        this.completeSepTol = completeSepTol;
    }

    public double getCompleteSepTol() {
        return this.completeSepTol;
    }

    public void setQuasiSepCholDiagTol(double quasiSepCholDiagTol) {
        this.quasiSepCholDiagTol = quasiSepCholDiagTol;
    }

    public double getQuasiSepCholDiagTol() {
        return this.quasiSepCholDiagTol;
    }

    public void setQuasiMin(double quasiMin) {
        this.quasiMin = quasiMin;
    }

    public double getQuasiMin() {
        return this.quasiMin;
    }

    public void setQuasiMax(double quasiMax) {
        this.quasiMax = quasiMax;
    }

    public double getQuasiMax() {
        return this.quasiMax;
    }

    public void setDenomIncr(double denomIncr) {
        this.denomIncr = denomIncr;
    }

    public double getDenomIncr() {
        return this.denomIncr;
    }

    public void setAllSHValues(boolean allSHValues) {
        this.allSHValues = allSHValues;
    }

    public boolean getAllSHValues() {
        return this.allSHValues;
    }

    public void setOptimizationMethod(OptimizationMethod optimMethod) {
        this.optimMethod = optimMethod;
    }

    public OptimizationMethod getOptimizationMethod() {
        return this.optimMethod;
    }

    public void setObjFunConverCritCheckFlag(boolean flag) {
        this.checkObjFunCrit = flag;
    }

    public boolean getObjFunConverCritCheckFlag() {
        return this.checkObjFunCrit;
    }

    public void setParamConverCritCheckFlag(boolean flag) {
        this.checkParamCrit = flag;
    }

    public boolean getParamConverCritCheckFlag() {
        return this.checkParamCrit;
    }

    public void setHessianConverCritCheckFlag(boolean flag) {
        this.checkHessianCrit = flag;
    }

    public boolean getHessianConverCritCheckFlag() {
        return this.checkHessianCrit;
    }

    public void setFlagOfCheckingForSeparation(boolean flag) {
        this.isCheckingForSeparation = flag;
    }

    public boolean getFlagOfCheckingForSeparation() {
        return this.isCheckingForSeparation;
    }

    public void setCheckForSepOperation(CheckForSeparationOperations op) {
        this.checkSepOperation = op;
    }

    public CheckForSeparationOperations getCheckForSepOperation() {
        return this.checkSepOperation;
    }

    public void setLengthOfHistory4LBFGS(int len) {
        this.lenOfHistory4LBFGS = len;
    }

    public int getLengthOfHistory4LBFGS() {
        return this.lenOfHistory4LBFGS;
    }

    public void setMaxIter4LBFGS(int maxIter) {
        this.maxIter4LBFGS = maxIter;
    }

    public int getMaxIter4LBFGS() {
        return this.maxIter4LBFGS;
    }

    public void setMaxLineSearchIter(int maxLineSearchIter) {
        this.maxLineSearchIter = maxLineSearchIter;
    }

    public int getMaxLineSearchIter() {
        return this.maxLineSearchIter;
    }

    public void setLineSearchMethod(LineSearchMethod lineSearchMethod) {
        this.lineSearchMethod = lineSearchMethod;
    }

    public LineSearchMethod getLineSearchMethod() {
        return this.lineSearchMethod;
    }

    public void setLineSearchTermRule(LineSearchTermRule lineSearchTermRule) {
        this.lineSearchTermRule = lineSearchTermRule;
    }

    public LineSearchTermRule getLineSearchTermRule() {
        return this.lineSearchTermRule;
    }

    public void setInitStepInLineSearch(double initStepInLineSearch) {
        this.initStepInLineSearch = initStepInLineSearch;
    }

    public double getInitStepInLineSearch() {
        return this.initStepInLineSearch;
    }

    public void setUpperBoundInLineSearch(double upperBoundInLineSearch) {
        this.upperBoundInLineSearch = upperBoundInLineSearch;
    }

    public double getUpperBoundInLineSearch() {
        return this.upperBoundInLineSearch;
    }

    public void setLineSearchTau(double lineSearchTau) {
        this.lineSearchTau = lineSearchTau;
    }

    public double getLineSearchTau() {
        return this.lineSearchTau;
    }

    public void setLineSearchZeta(double lineSearchZeta) {
        this.lineSearchZeta = lineSearchZeta;
    }

    public double getLineSearchZeta() {
        return this.lineSearchZeta;
    }

    public void setObjFunConver4NelderMead(double objFunConver4NelderMead) {
        this.objFunConver4NelderMead = objFunConver4NelderMead;
    }

    public double getObjFunConver4NelderMead() {
        return this.objFunConver4NelderMead;
    }

    public void setMaxIter4NelderMead(int maxIter) {
        this.maxIter4NelderMead = maxIter;
    }

    public int getMaxIter4NelderMead() {
        return this.maxIter4NelderMead;
    }

    public void setCheckRedundancy(boolean checkRedundancy) {
        this.checkRedundancy = checkRedundancy;
    }

    public boolean getCheckRedundancy() {
        return this.checkRedundancy;
    }

    public static enum CheckForSeparationOperations {
        Complete,
        QuasiComplete,
        Both;

    }

    public static enum OptimizationMethod {
        NewtonRaphson,
        LBFGS,
        NelderMead;

    }
}

