/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.linesearch;

import com.spss.ac.acmath.optimizer.linesearch.LineSearch;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchMethod;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchTermRule;
import com.spss.math.MissingValue;
import com.spss.math.statistics.MathFun;

public class LineSearchImpl
implements LineSearch {
    static final double lambdaW = 1.0E-4;
    static final double etaW = 0.9;
    static final double labdaA = 0.01;
    LineSearch.LineSearchState state = LineSearch.LineSearchState.Invalid;
    LineSearchMethod method = LineSearchMethod.CUBIC_INTERPOL;
    LineSearchTermRule termRule = LineSearchTermRule.WOLFE;
    double lineSearchTau = 0.5;
    private double lineSearchZeta = 0.1;
    private double compTol = 1.0E-12;
    int maxIter = 0;
    int curIter = 0;
    boolean allSHSteps = false;
    int nEstParams = 0;
    double psiInit = 0.0;
    double psiPrev = 0.0;
    double psiCur = 0.0;
    double[] searchDir = null;
    double lBoundCur = 0.0;
    double uBoundCur = 0.0;
    double stepLengthPrev = 0.0;
    double stepLengthCur = 0.0;
    double psipInit = 0.0;
    double psipPrev = 0.0;
    double psipCur = 0.0;
    double psiLB = 0.0;
    double psiUB = 0.0;
    double psipLB = 0.0;
    QuadPhase quadPhase = QuadPhase.NOTQUAD;

    public LineSearchImpl() {
    }

    public LineSearchImpl(int maxIter, int nEstParams, LineSearchMethod method, LineSearchTermRule termRule, boolean allSteps, double stepLengthInit, double lineSearchTau, double compTol) {
        this.state = this.setup(maxIter, nEstParams, method, termRule, allSteps, stepLengthInit, lineSearchTau, compTol);
    }

    @Override
    public LineSearch.LineSearchState setup(int maxIter, int nEstParams, LineSearchMethod method, LineSearchTermRule termRule, boolean allSHSteps, double stepLengthInit, double lineSearchTau, double compTol) {
        this.maxIter = maxIter;
        this.nEstParams = nEstParams;
        this.method = method;
        this.termRule = termRule;
        this.allSHSteps = allSHSteps;
        this.stepLengthCur = stepLengthInit;
        this.lineSearchTau = lineSearchTau;
        this.compTol = compTol;
        this.state = LineSearch.LineSearchState.Setup;
        this.quadPhase = this.method != LineSearchMethod.QUAD_INTERPOL ? QuadPhase.NOTQUAD : QuadPhase.QUADCOND;
        return this.state;
    }

    @Override
    public LineSearch.LineSearchState initialize(double objFun, double[] gradient, double[] searchDir, double lBound, double uBound) {
        this.psiInit = objFun;
        this.psiPrev = objFun;
        this.searchDir = searchDir;
        this.lBoundCur = lBound;
        this.uBoundCur = uBound;
        this.state = LineSearch.LineSearchState.Initialized;
        this.psipPrev = this.psipInit = MathFun.dDot((int)this.nEstParams, (double[])gradient, (int)0, (int)1, (double[])this.searchDir, (int)0, (int)1);
        return this.state;
    }

    public LineSearch.LineSearchState initialize(double objFun, double[] gradient, double[] searchDir, double lBound, double uBound, double stepLengthInit) {
        this.psiInit = objFun;
        this.psiPrev = objFun;
        this.searchDir = searchDir;
        this.lBoundCur = lBound;
        this.uBoundCur = uBound;
        this.state = LineSearch.LineSearchState.Initialized;
        this.psipPrev = this.psipInit = MathFun.dDot((int)this.nEstParams, (double[])gradient, (int)0, (int)1, (double[])this.searchDir, (int)0, (int)1);
        this.stepLengthCur = stepLengthInit;
        return this.state;
    }

    @Override
    public LineSearch.LineSearchState doNextIter(double objFun, double[] gradient) {
        this.state = LineSearch.LineSearchState.Invalid;
        switch (this.quadPhase) {
            case NOTQUAD: {
                this.state = this.doNotQuadIter(objFun, gradient);
                break;
            }
            case QUADCOND: {
                this.state = this.doQuadCondPhase(objFun, gradient);
                break;
            }
            case QUADPREP: {
                this.state = this.doQuadPrepPhase(objFun, gradient);
                break;
            }
            case QUADCOMP: {
                this.state = this.doQuadCompPhase(objFun, gradient);
            }
        }
        return this.state;
    }

    private LineSearch.LineSearchState doNotQuadIter(double objFun, double[] gradient) {
        this.state = LineSearch.LineSearchState.Invalid;
        this.psiCur = objFun;
        if (MissingValue.isMissing((double)this.psiCur)) {
            return this.state;
        }
        this.psipCur = MathFun.dDot((int)this.nEstParams, (double[])gradient, (int)0, (int)1, (double[])this.searchDir, (int)0, (int)1);
        if (this.curIter < this.maxIter) {
            if (this.checkCondOne()) {
                if (this.checkCondTwo()) {
                    this.state = LineSearch.LineSearchState.Completed;
                } else {
                    this.lBoundCur = this.stepLengthCur;
                    this.updateStepLength();
                    ++this.curIter;
                    this.state = LineSearch.LineSearchState.LineSearchLoop;
                }
            } else {
                this.uBoundCur = this.stepLengthCur;
                this.updateStepLength();
                ++this.curIter;
                this.state = LineSearch.LineSearchState.LineSearchLoop;
            }
        } else {
            this.state = LineSearch.LineSearchState.MaxIterReached;
        }
        return this.state;
    }

    private LineSearch.LineSearchState doQuadCondPhase(double objFun, double[] gradient) {
        this.state = LineSearch.LineSearchState.Invalid;
        this.psiCur = objFun;
        if (MissingValue.isMissing((double)this.psiCur)) {
            return this.state;
        }
        this.psipCur = MathFun.dDot((int)this.nEstParams, (double[])gradient, (int)0, (int)1, (double[])this.searchDir, (int)0, (int)1);
        if (this.curIter < this.maxIter) {
            if (this.checkCondOne()) {
                if (this.checkCondTwo()) {
                    this.state = LineSearch.LineSearchState.Completed;
                } else {
                    this.lBoundCur = this.stepLengthCur;
                    this.state = LineSearch.LineSearchState.LineSearchLoop;
                    this.quadPhase = QuadPhase.QUADPREP;
                }
            } else {
                this.uBoundCur = this.stepLengthCur;
                this.stepLengthCur = this.lBoundCur;
                this.state = LineSearch.LineSearchState.LineSearchLoop;
                this.quadPhase = QuadPhase.QUADPREP;
            }
        } else {
            this.state = LineSearch.LineSearchState.MaxIterReached;
        }
        return this.state;
    }

    private LineSearch.LineSearchState doQuadPrepPhase(double objFun, double[] gradient) {
        this.state = LineSearch.LineSearchState.Invalid;
        this.psiLB = objFun;
        if (MissingValue.isMissing((double)this.psiLB)) {
            return this.state;
        }
        this.psipLB = MathFun.dDot((int)this.nEstParams, (double[])gradient, (int)0, (int)1, (double[])this.searchDir, (int)0, (int)1);
        this.state = LineSearch.LineSearchState.LineSearchLoop;
        this.quadPhase = QuadPhase.QUADCOMP;
        this.stepLengthCur = this.uBoundCur;
        return this.state;
    }

    private LineSearch.LineSearchState doQuadCompPhase(double objFun, double[] gradient) {
        this.state = LineSearch.LineSearchState.Invalid;
        this.psiUB = objFun;
        if (MissingValue.isMissing((double)this.psiUB)) {
            return this.state;
        }
        this.compSLQuadIP(this.psiLB, this.psiUB, this.psipLB, this.lBoundCur, this.uBoundCur);
        ++this.curIter;
        this.state = LineSearch.LineSearchState.LineSearchLoop;
        this.quadPhase = QuadPhase.QUADCOND;
        return this.state;
    }

    @Override
    public double getStepLength() {
        return this.stepLengthCur;
    }

    @Override
    public int getNIteratons() {
        return this.curIter;
    }

    @Override
    public LineSearch.LineSearchState getState() {
        return this.state;
    }

    private boolean checkCondOne() {
        boolean result = false;
        double labda = this.termRule == LineSearchTermRule.WOLFE ? 1.0E-4 : 0.01;
        result = this.psiCur <= this.psiInit + labda * this.stepLengthCur * this.psipInit;
        return result;
    }

    private boolean checkCondTwo() {
        boolean result = false;
        switch (this.termRule) {
            case ARMIJO: {
                result = this.stepLengthCur > 0.0;
                break;
            }
            case ARMIJO_GOLDSTEIN: {
                result = this.psiCur >= this.psiInit + 0.99 * this.stepLengthCur * this.psipInit;
                break;
            }
            case WOLFE: {
                result = this.psipCur >= 0.9 * this.psipInit;
            }
        }
        return result;
    }

    private void updateStepLength() {
        switch (this.method) {
            case BACKTRACKING: {
                this.stepLengthCur *= this.lineSearchTau;
                break;
            }
            case NON_MON_BACKTRACKING: {
                double denom = (this.psipInit * this.stepLengthCur + this.psipInit - this.psipCur) * 2.0;
                denom = MathFun.replaceIfSmall((double)denom, (double)this.compTol);
                double stepLenTemp = this.psipInit * this.stepLengthCur * this.stepLengthCur / denom;
                if (stepLenTemp >= this.lineSearchTau * this.stepLengthCur) {
                    this.stepLengthCur = stepLenTemp;
                    break;
                }
                this.stepLengthCur = this.lineSearchTau * this.stepLengthCur;
                break;
            }
            case BISECTION: {
                this.stepLengthCur = (this.lBoundCur + this.uBoundCur) * 0.5;
                break;
            }
            case CUBIC_INTERPOL: {
                this.compSLCubicIP();
                this.psiPrev = this.psiCur;
                this.psipPrev = this.psipCur;
            }
        }
    }

    private void compSLQuadIP(double psiX1, double psiX2, double psipX1, double x1, double x2) {
        double delta = this.uBoundCur - this.lBoundCur;
        double d = x2 - x1;
        double denom = d * d;
        double c = (psiX2 - psiX1 - d * psipX1) / (denom = MathFun.replaceIfSmall((double)denom, (double)this.compTol));
        if (c > 0.0) {
            double tmp = this.lBoundCur + this.lineSearchZeta * delta;
            denom = MathFun.replaceIfSmall((double)(2.0 * c), (double)this.compTol);
            double maxVal = x1 + psipX1 / denom;
            if (tmp > maxVal) {
                maxVal = tmp;
            }
            double minVal = tmp = this.uBoundCur - this.lineSearchZeta * delta;
            if (maxVal < tmp) {
                minVal = maxVal;
            }
            this.stepLengthPrev = this.stepLengthCur;
            this.stepLengthCur = minVal;
        } else {
            this.stepLengthPrev = this.stepLengthCur;
            this.stepLengthCur = (this.lBoundCur + this.uBoundCur) * 0.5;
        }
    }

    private void compSLCubicIP() {
        double delta = this.uBoundCur - this.lBoundCur;
        double denom = this.stepLengthPrev - this.stepLengthCur;
        double d1 = this.psipPrev + this.psipCur - (this.psiPrev - this.psiCur) * 3.0 / (denom = MathFun.replaceIfSmall((double)denom, (double)this.compTol));
        double d2 = d1 * d1 - this.psipPrev * this.psipCur;
        if (d2 >= 0.0) {
            d2 = Math.sqrt(d2);
            double diff = this.stepLengthCur - this.stepLengthPrev;
            if (diff < 0.0) {
                d2 = -d2;
            }
            if (Math.abs(denom = this.psipCur - this.psipPrev + 2.0 * d2) > this.compTol) {
                double minVal = 0.0;
                double maxVal = this.stepLengthCur - (this.stepLengthCur - this.stepLengthPrev) * (this.psipCur + d2 - d1) / denom;
                double temp = 0.0;
                temp = this.lBoundCur + this.lineSearchZeta * delta;
                if (temp > maxVal) {
                    maxVal = temp;
                }
                if (maxVal < (minVal = (temp = this.uBoundCur - this.lineSearchZeta * delta))) {
                    minVal = maxVal;
                }
                this.stepLengthPrev = this.stepLengthCur;
                this.stepLengthCur = minVal;
            } else {
                this.compSLQuadIP(this.psiPrev, this.psiCur, this.psipPrev, this.stepLengthPrev, this.stepLengthCur);
            }
        } else {
            this.compSLQuadIP(this.psiPrev, this.psiCur, this.psipPrev, this.stepLengthPrev, this.stepLengthCur);
        }
    }

    static enum QuadPhase {
        NOTQUAD,
        QUADCOND,
        QUADPREP,
        QUADCOMP;

    }
}

