/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.neldermead;

import com.spss.math.statistics.MathFun;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NMSimplex {
    private int nDims = 3;
    private int nVertices = 4;
    private ArrayList<double[]> vertices = new ArrayList();
    private ArrayList<Double> objFunUnsorted = new ArrayList();
    private ArrayList<Double> objFunSorted = new ArrayList();
    private ArrayList<Integer> vertexIndices = new ArrayList();
    private double reflect = 1.0;
    private double expand = 2.0;
    private double contract = 0.5;
    private double reduce = 0.5;
    private double[] centerN = null;
    private double[] reflectVec = null;
    private double[] expandVec = null;
    private double[] contractVec = null;
    private double objFunReflect = 0.0;
    Comparator<DIPair> comparator = new DIPairLEComparator();
    List<DIPair> pairList = new ArrayList<DIPair>();

    public NMSimplex(int nDims) {
        int i;
        this.nDims = nDims;
        this.nVertices = this.nDims + 1;
        for (i = 0; i < this.nVertices; ++i) {
            double[] vertex = new double[nDims];
            this.vertices.add(vertex);
            this.objFunUnsorted.add(0.0);
            this.objFunSorted.add(0.0);
            this.vertexIndices.add(i);
        }
        this.centerN = new double[nDims];
        this.reflectVec = new double[nDims];
        this.expandVec = new double[nDims];
        this.contractVec = new double[nDims];
        for (i = 0; i < this.nVertices; ++i) {
            this.pairList.add(new DIPair(0.0, i));
        }
    }

    public boolean setVertex(int iVertex, double[] vertex) {
        boolean result;
        boolean bl = result = iVertex >= 0 && iVertex < this.nVertices && vertex.length >= this.nDims;
        if (result) {
            System.arraycopy(vertex, 0, this.vertices.get(iVertex), 0, this.nDims);
        }
        return result;
    }

    public boolean setObjFunValues(double[] objFunValues) {
        boolean result;
        boolean bl = result = objFunValues.length >= this.nVertices;
        if (result) {
            for (int i = 0; i < this.nVertices; ++i) {
                this.objFunUnsorted.set(i, objFunValues[i]);
            }
        }
        return result;
    }

    public boolean setObjFunValue(int iVertex, double objFunValue) {
        boolean result;
        boolean bl = result = iVertex >= 0 && iVertex < this.nVertices;
        if (result) {
            this.objFunUnsorted.set(iVertex, objFunValue);
        }
        return result;
    }

    public void setCoefficients(double reflect, double expand, double contract, double reduce) {
        this.reflect = reflect;
        this.expand = expand;
        this.contract = contract;
        this.reduce = reduce;
    }

    public void sortObjFunValues() {
        DIPair pair;
        int i;
        for (i = 0; i < this.nVertices; ++i) {
            pair = this.pairList.get(i);
            pair.first = this.objFunUnsorted.get(i);
            pair.second = i;
            this.pairList.set(i, pair);
        }
        Collections.sort(this.pairList, this.comparator);
        for (i = 0; i < this.nVertices; ++i) {
            pair = this.pairList.get(i);
            this.objFunSorted.set(i, pair.first);
            this.vertexIndices.set(i, pair.second);
        }
    }

    public void computeCenterN() {
        int i;
        Arrays.fill(this.centerN, 0.0);
        for (i = 0; i < this.nVertices - 1; ++i) {
            int index = this.vertexIndices.get(i);
            double[] vertex = this.vertices.get(index);
            MathFun.daxpy((int)this.nDims, (double)1.0, (double[])vertex, (int)0, (int)1, (double[])this.centerN, (int)0, (int)1);
        }
        i = 0;
        while (i < this.nDims) {
            int n = i++;
            this.centerN[n] = this.centerN[n] / (double)(this.nVertices - 1);
        }
    }

    private void transform(double coef, double[] outVec) {
        int index = this.vertexIndices.get(this.nVertices - 1);
        double[] vertex = this.vertices.get(index);
        for (int i = 0; i < this.nDims; ++i) {
            double center = this.centerN[i];
            outVec[i] = center + coef * (center - vertex[i]);
        }
    }

    public void computeReflection() {
        this.transform(this.reflect, this.reflectVec);
    }

    public void computeExpansion() {
        this.transform(this.expand, this.expandVec);
    }

    public void computeContraction() {
        this.transform(this.contract, this.contractVec);
    }

    public void setObjFunReflect(double objFunReflect) {
        this.objFunReflect = objFunReflect;
    }

    public double getObjFunReflect() {
        return this.objFunReflect;
    }

    public void performReduction() {
        int indexOfBest = this.vertexIndices.get(0);
        double[] bestVertex = this.vertices.get(indexOfBest);
        for (int iVertex = 1; iVertex < this.nVertices; ++iVertex) {
            int index = this.vertexIndices.get(iVertex);
            double[] vertex = this.vertices.get(index);
            for (int i = 0; i < this.nDims; ++i) {
                double vertexCoordinate = vertex[i];
                double bestCoordinate = bestVertex[i];
                vertex[i] = bestCoordinate + this.reduce * (vertexCoordinate - bestCoordinate);
            }
        }
    }

    public void replaceWorstWithReflection(double funValue) {
        this.replaceWorst(0, funValue);
    }

    public void replaceWorstWithExpansion(double funValue) {
        this.replaceWorst(1, funValue);
    }

    public void replaceWorstWithContraction(double funValue) {
        this.replaceWorst(2, funValue);
    }

    private void replaceWorst(int transform, double funValue) {
        double[] replaceBy = this.reflectVec;
        if (transform == 1) {
            replaceBy = this.expandVec;
        } else if (transform == 2) {
            replaceBy = this.contractVec;
        }
        int index = this.vertexIndices.get(this.nVertices - 1);
        double[] vertex = this.vertices.get(index);
        System.arraycopy(replaceBy, 0, vertex, 0, this.nDims);
        this.objFunUnsorted.set(index, funValue);
        this.objFunSorted.set(this.nVertices - 1, funValue);
        this.sortObjFunValues();
    }

    public double getBestObjFun() {
        return this.objFunSorted.get(0);
    }

    public double getWorstObjFun() {
        return this.objFunSorted.get(this.nVertices - 1);
    }

    public double getSecondWorstObjFun() {
        return this.objFunSorted.get(this.nVertices - 2);
    }

    public double getRelConver(double denomIncr) {
        double best = this.objFunSorted.get(0);
        double worst = this.objFunSorted.get(this.nVertices - 1);
        return (worst - best) / (Math.abs(best) + denomIncr);
    }

    public double getAbsConver() {
        double best = this.objFunSorted.get(0);
        double worst = this.objFunSorted.get(this.nVertices - 1);
        return worst - best;
    }

    public int getNDimensions() {
        return this.nDims;
    }

    public double[] getCenterN() {
        return this.centerN;
    }

    public double[] getReflection() {
        return this.reflectVec;
    }

    public double[] getExpansion() {
        return this.expandVec;
    }

    public double[] getContraction() {
        return this.contractVec;
    }

    public ArrayList<double[]> getVertices() {
        return this.vertices;
    }

    public double[] getBestVertex() {
        int index = this.vertexIndices.get(0);
        double[] result = this.vertices.get(index);
        return result;
    }

    public int getBestVertexIndex() {
        return this.vertexIndices.get(0);
    }

    public boolean copyVertices(ArrayList<double[]> outVertices) {
        boolean result;
        boolean bl = result = outVertices != null && this.nDims + 1 == outVertices.size();
        if (result) {
            for (int i = 0; result && i <= this.nDims; ++i) {
                double[] from = this.vertices.get(i);
                double[] to = outVertices.get(i);
                result = MathFun.dCopy((double[])from, (double[])to);
            }
        }
        return result;
    }

    static class DIPairLEComparator
    implements Comparator<DIPair> {
        DIPairLEComparator() {
        }

        @Override
        public int compare(DIPair object1, DIPair object2) {
            return Double.compare(object1.first, object2.first);
        }
    }

    static class DIPair {
        public double first;
        public int second;

        public DIPair(double first, int second) {
            this.first = first;
            this.second = second;
        }
    }
}

