/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.newton;

import com.spss.ac.acmath.optimizer.common.HessianCompMethod;
import com.spss.math.matrix.DenseSymMatrix;
import java.util.Arrays;

public class RegOptAccumStats {
    protected int nParams = 0;
    protected double[] beta = null;
    protected double objFun = 0.0;
    protected double[] gradient = null;
    protected DenseSymMatrix hessian = null;
    protected int compIndicator = 0;
    protected boolean checkSeparation = false;
    protected double obsRespProbMin = 0.0;
    protected double obsRespProbMax = 1.0;
    protected double compProbMin = 0.0;
    protected HessianCompMethod hessianMethod = HessianCompMethod.FISHER_SCORING;
    protected double accumWeight = 0.0;

    public RegOptAccumStats() {
    }

    public RegOptAccumStats(int nParams) {
        this.nParams = nParams;
        this.beta = new double[nParams];
        this.gradient = new double[nParams];
        this.hessian = new DenseSymMatrix(nParams);
    }

    public void reset(HessianCompMethod hessianMethod, boolean checkSeparation) {
        this.hessianMethod = hessianMethod;
        this.checkSeparation = checkSeparation;
        this.objFun = 0.0;
        Arrays.fill(this.gradient, 0.0);
        this.hessian.clear();
        this.obsRespProbMin = 0.0;
        this.obsRespProbMax = 1.0;
        this.compProbMin = 0.0;
        this.accumWeight = 0.0;
    }

    public int updateForRow(double[] record, double weight, int compIndicator) {
        return 0;
    }

    public double getObjFun() {
        return this.objFun;
    }

    public double[] getBeta() {
        return this.beta;
    }

    public double[] getGradient() {
        return this.gradient;
    }

    public DenseSymMatrix getHessian() {
        return this.hessian;
    }

    public boolean getProbs(double[] probs) {
        boolean result;
        boolean bl = result = probs.length >= 3;
        if (result) {
            probs[0] = this.obsRespProbMin;
            probs[1] = this.obsRespProbMax;
            probs[2] = this.compProbMin;
        }
        return result;
    }

    public double getAccumWeight() {
        return this.accumWeight;
    }

    public void finishComputations() {
    }
}

