/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.newton;

import com.spss.ac.acmath.optimizer.common.ConverCrit;
import com.spss.ac.acmath.optimizer.common.HessianCompMethod;
import com.spss.ac.acmath.optimizer.common.OptimSettings;
import com.spss.ac.acmath.optimizer.newton.RegOptAccumStats;
import com.spss.ac.acmath.optimizer.newton.RegOptDataHandler;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.MathFun;
import com.spss.math.statistics.Power;

public class RegOptimizer {
    private OptimSettings optimSettings = null;
    private RegOptDataHandler dataHandler = null;
    private RegOptAccumStats accumStats = null;
    private int nParams = 0;
    private double[] gradientCur = null;
    private DenseSymMatrix hessianGI = null;
    private HessianCompMethod hessianMethod = HessianCompMethod.FISHER_SCORING;
    private int nFisherIter = 0;
    private ConverCrit converCritCode = ConverCrit.NOT_ALL;
    private double objFunInitial = 0.0;
    private double objFunFinal = 0.0;
    private int lastIter = 0;
    private double objFunChangeLastIter = 0.0;
    private double paramChangeLastIter = 0.0;
    private double accumWeight = 0.0;

    public RegOptimizer(OptimSettings optimSettings, int nParams, RegOptDataHandler dataHandler, RegOptAccumStats accumStats, HessianCompMethod hessianMethod, int nFisherIter) {
        this.optimSettings = optimSettings;
        this.nParams = nParams;
        this.dataHandler = dataHandler;
        this.accumStats = accumStats;
        this.hessianMethod = hessianMethod;
        this.nFisherIter = nFisherIter;
        this.gradientCur = new double[nParams];
        this.hessianGI = new DenseSymMatrix(nParams);
    }

    public ConverCrit estimate() {
        double coeffInit;
        ConverCrit result = ConverCrit.NOT_ALL;
        int nZeroPiv = 0;
        double[] beta = this.accumStats.getBeta();
        double[] minDiagChol = new double[1];
        double[] betaChg = new double[this.nParams];
        double[] prevBeta = new double[this.nParams];
        double tol = this.optimSettings.getCompTol();
        int maxStepHalving = this.optimSettings.getMaxStephalvings();
        int startIter = this.optimSettings.getStartIterForCS();
        boolean minimizeObjFun = this.optimSettings.getMinimizeObjFun();
        HessianCompMethod hessianMethod = this.hessianMethod;
        if (hessianMethod == HessianCompMethod.HYBRID && this.nFisherIter > 0) {
            hessianMethod = HessianCompMethod.FISHER_SCORING;
        }
        this.dataHandler.setStatsModel(this.accumStats);
        boolean checkSep = startIter > 0 && this.lastIter >= startIter;
        this.dataHandler.resetAccumStats(hessianMethod, checkSep);
        this.dataHandler.computeStatsForOptimizer(2);
        double[] accumGradient = null;
        DenseSymMatrix accumHessian = null;
        double curObjFun = this.accumStats.getObjFun();
        if (MissingValue.isMissing((double)curObjFun)) {
            return result;
        }
        this.objFunInitial = curObjFun;
        accumHessian = this.accumStats.getHessian();
        accumHessian.copyTo(this.hessianGI);
        nZeroPiv = this.hessianGI.lTChol(tol, 1.0E-4, minDiagChol, false);
        accumGradient = this.accumStats.getGradient();
        MathFun.dCopy((double[])accumGradient, (double[])this.gradientCur);
        nZeroPiv = this.hessianGI.lTSubstitute(this.gradientCur, betaChg);
        boolean outerStop = false;
        int stepHalvingCnt = 0;
        if (this.nParams == 0 || this.optimSettings.getMaxIter() == 0) {
            outerStop = true;
            this.converCritCode = ConverCrit.NO_ITERATIONS;
        }
        double d = coeffInit = minimizeObjFun ? -1.0 : 1.0;
        while (!outerStop) {
            ++this.lastIter;
            stepHalvingCnt = 0;
            boolean innerStop = false;
            boolean onlyObjFun = true;
            double coeff = coeffInit;
            MathFun.dCopy((double[])beta, (double[])prevBeta);
            double prevObjFun = curObjFun;
            while (!innerStop) {
                this.dataHandler.resetAccumStats(hessianMethod, checkSep);
                MathFun.daxpy((int)this.nParams, (double)coeff, (double[])betaChg, (int)0, (int)1, (double[])beta, (int)0, (int)1);
                this.dataHandler.computeStatsForOptimizer(0);
                double newObjFun = this.accumStats.getObjFun();
                if (MissingValue.isMissing((double)newObjFun)) {
                    return result;
                }
                if (minimizeObjFun && newObjFun <= curObjFun || !minimizeObjFun && newObjFun >= curObjFun) {
                    innerStop = true;
                    continue;
                }
                if (stepHalvingCnt >= maxStepHalving) {
                    innerStop = true;
                    this.converCritCode = ConverCrit.MAX_STEPHALVING;
                    MathFun.dCopy((double[])prevBeta, (double[])beta);
                    this.objFunChangeLastIter = 0.0;
                    this.paramChangeLastIter = 0.0;
                    continue;
                }
                coeff *= 0.5;
                ++stepHalvingCnt;
                MathFun.dCopy((double[])prevBeta, (double[])beta);
            }
            checkSep = startIter > 0 && this.lastIter >= startIter;
            onlyObjFun = false;
            this.dataHandler.resetAccumStats(hessianMethod, checkSep);
            this.dataHandler.computeStatsForOptimizer(2);
            this.objFunFinal = curObjFun = this.accumStats.getObjFun();
            accumHessian = this.accumStats.getHessian();
            accumHessian.copyTo(this.hessianGI);
            nZeroPiv = this.hessianGI.lTChol(tol, 1.0E-4, minDiagChol, false);
            if (this.converCritCode == ConverCrit.NOT_ALL) {
                this.converCritCode = this.checkForConvergence(beta, prevBeta, prevObjFun, nZeroPiv, minDiagChol, checkSep);
            }
            if (this.hessianMethod == HessianCompMethod.HYBRID && this.hybridSwitch(hessianMethod)) {
                hessianMethod = HessianCompMethod.NEWTON_RAPHSON;
                this.converCritCode = ConverCrit.NOT_ALL;
                this.nFisherIter = this.lastIter;
                this.dataHandler.resetAccumStats(hessianMethod, checkSep);
                this.dataHandler.computeStatsForOptimizer(2);
                accumHessian = this.accumStats.getHessian();
                accumHessian.copyTo(this.hessianGI);
                nZeroPiv = this.hessianGI.lTChol(tol, 1.0E-4, minDiagChol, false);
                if (nZeroPiv > 0) {
                    this.converCritCode = ConverCrit.REDUNDANT_HESSIAN;
                }
            }
            if (this.converCritCode == ConverCrit.NOT_ALL) {
                accumGradient = this.accumStats.getGradient();
                MathFun.dCopy((double[])accumGradient, (double[])this.gradientCur);
                nZeroPiv = this.hessianGI.lTSubstitute(this.gradientCur, betaChg);
                continue;
            }
            outerStop = true;
        }
        if (outerStop && this.nParams > 0) {
            accumHessian = this.accumStats.getHessian();
            accumHessian.copyTo(this.hessianGI);
            this.hessianGI.lTInverse();
            this.accumWeight = this.accumStats.getAccumWeight();
        }
        result = this.converCritCode;
        return result;
    }

    private ConverCrit checkForConvergence(double[] beta, double[] prevBeta, double prevObjFun, int nZeroPiv, double[] minDgChol, boolean checkSep) {
        int maxIter;
        ConverCrit result = ConverCrit.ALL_CONVERGED;
        boolean objFunAbsChange = this.optimSettings.getObjFunAbsChange();
        boolean paramAbsChange = this.optimSettings.getParamAbsChange();
        boolean hessianAbsChange = this.optimSettings.getHessianAbsChange();
        double objFunConverCrit = this.optimSettings.getObjFunConverCrit();
        double paramConverCrit = this.optimSettings.getParamConverCrit();
        double hessianConverCrit = this.optimSettings.getHessianConverCrit();
        double denomIncr = this.optimSettings.getDenomIncr();
        if (result == ConverCrit.ALL_CONVERGED && objFunConverCrit > 0.0) {
            this.objFunChangeLastIter = Math.abs(prevObjFun - this.objFunFinal);
            if (!objFunAbsChange) {
                double denom = prevObjFun == 0.0 ? denomIncr : prevObjFun;
                this.objFunChangeLastIter /= Math.abs(denom);
            }
            if (this.objFunChangeLastIter >= objFunConverCrit) {
                result = ConverCrit.NOT_ALL;
            }
        }
        if (result == ConverCrit.ALL_CONVERGED && this.nParams > 0 && paramConverCrit > 0.0) {
            this.paramChangeLastIter = paramAbsChange ? MathFun.vNrm1Diff((double[])beta, (double[])prevBeta) : MathFun.vMaxRelDiff((double[])beta, (double[])prevBeta, (double)denomIncr);
            if (this.paramChangeLastIter >= paramConverCrit) {
                result = ConverCrit.NOT_ALL;
            }
        }
        if (result == ConverCrit.ALL_CONVERGED && hessianConverCrit > 0.0) {
            double sHs = this.hessianGI.computeVSV(this.gradientCur);
            if (!hessianAbsChange) {
                double denom = this.objFunFinal == 0.0 ? denomIncr : Math.abs(this.objFunFinal);
                sHs /= denom;
            }
            if (sHs >= hessianConverCrit) {
                result = ConverCrit.NOT_ALL;
            }
        }
        if (checkSep) {
            double completeSepTol = this.optimSettings.getCompleteSepTol();
            double quasiSepTol = this.optimSettings.getQuasiSepCholDiagTol();
            double quasiMin = this.optimSettings.getQuasiMin();
            double quasiMax = this.optimSettings.getQuasiMax();
            double[] probs = new double[3];
            this.accumStats.getProbs(probs);
            double obsRespProbMin = probs[0];
            double obsRespProbMax = probs[1];
            double compProbMin = probs[2];
            if (1.0 - obsRespProbMin <= completeSepTol && 1.0 - obsRespProbMax <= completeSepTol) {
                result = ConverCrit.COMPLETE_SEPARATION;
            }
            if (result == ConverCrit.NOT_ALL && minDgChol[0] <= quasiSepTol) {
                result = obsRespProbMax > quasiMax || compProbMin < quasiMin ? ConverCrit.QUASI_SEPARATION : ConverCrit.REDUNDANT_HESSIAN;
            }
        }
        if (result == ConverCrit.ALL_CONVERGED && nZeroPiv > 0) {
            result = ConverCrit.REDUNDANT_HESSIAN;
        }
        if (result == ConverCrit.NOT_ALL && this.lastIter >= (maxIter = this.optimSettings.getMaxIter())) {
            result = ConverCrit.MAX_ITERATIONS;
        }
        return result;
    }

    private boolean hybridSwitch(HessianCompMethod hessianMethod) {
        boolean result = false;
        if (this.hessianMethod == HessianCompMethod.HYBRID && hessianMethod == HessianCompMethod.FISHER_SCORING) {
            if (this.converCritCode == ConverCrit.ALL_CONVERGED) {
                result = true;
            } else if (this.lastIter >= this.nFisherIter && this.converCritCode == ConverCrit.NOT_ALL) {
                result = true;
            }
        }
        return result;
    }

    public boolean computeRSquares(double[] rSquares) {
        boolean result = rSquares.length >= 3;
        double miss = MissingValue.getMissing();
        if (result && (this.lastIter == 0 || this.accumWeight <= 0.0 || MissingValue.isMissing((double)this.objFunInitial) || MissingValue.isMissing((double)this.objFunFinal))) {
            result = false;
            rSquares[0] = miss;
            rSquares[1] = miss;
            rSquares[2] = miss;
        }
        if (result) {
            double denom;
            double rCS = miss;
            double rN = miss;
            double rM = miss;
            double expArg = (2.0 * this.objFunInitial - 2.0 * this.objFunFinal) / this.accumWeight;
            double maxExp = Power.getMaxEps();
            if (expArg <= maxExp) {
                rCS = 1.0 - Math.exp(expArg);
            }
            if (!MissingValue.isMissing((double)rCS) && (expArg = 2.0 * this.objFunInitial / this.accumWeight) <= maxExp && (denom = 1.0 - Math.exp(expArg)) != 0.0) {
                rN = rCS / denom;
            }
            if (this.objFunInitial != 0.0) {
                rM = 1.0 - this.objFunFinal / this.objFunInitial;
            } else if (this.objFunFinal == 0.0) {
                rM = 0.0;
            }
            rSquares[0] = rCS;
            rSquares[1] = rN;
            rSquares[2] = rM;
        }
        return result;
    }

    public DenseSymMatrix getHessianGI() {
        return this.hessianGI;
    }

    public ConverCrit getConverCrit() {
        return this.converCritCode;
    }

    public boolean getEstStats(double[] stats) {
        boolean result;
        boolean bl = result = stats.length >= 5;
        if (result) {
            stats[0] = this.lastIter;
            stats[1] = this.objFunInitial;
            stats[2] = this.objFunFinal;
            stats[3] = this.objFunChangeLastIter;
            stats[4] = this.paramChangeLastIter;
        }
        return result;
    }

    public int getFisherIterInHybrid() {
        int result = 0;
        if (this.hessianMethod == HessianCompMethod.HYBRID && this.lastIter > 0) {
            result = this.lastIter < this.nFisherIter ? this.lastIter : this.nFisherIter;
        }
        return result;
    }

    public double getAccumWeight() {
        return this.accumWeight;
    }
}

