/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.newton;

import com.spss.ac.acmath.optimizer.common.BaseOptAccumStats;
import com.spss.ac.acmath.optimizer.common.ConverCrit;
import com.spss.ac.acmath.optimizer.common.HessianCompMethod;
import com.spss.ac.acmath.optimizer.common.OptimSettings;
import com.spss.ac.acmath.optimizer.common.PassiveOptimizer;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.math.statistics.MathFun;

public class UCPassiveOptimizer
implements PassiveOptimizer {
    protected PassiveOptimizer.OptimState optimState = PassiveOptimizer.OptimState.Uninitialized;
    protected OptimSettings optimSettings = null;
    protected int nEstParams = 0;
    protected double[] estParams = null;
    protected double[] estParamsPrev = null;
    protected double[] estParamsChg = null;
    protected DenseSymMatrix hessianChol = null;
    protected DenseSymMatrix hessianGI = null;
    protected double[] minDiagChol = null;
    protected double compTol = 1.0E-12;
    protected int nZeroPiv = 0;
    protected ConverCrit converCritCode = ConverCrit.NOT_ALL;
    protected int lastIter = 0;
    protected double objFunChangeLastIter = 0.0;
    protected double paramChangeLastIter = 0.0;
    protected double accumWeight = 0.0;
    double[] probs = null;
    protected int accumStatsIndicator = 1;
    protected double objFunCur = 0.0;
    protected double objFunPrevIter = 0.0;
    protected double objFunPrevInner = 0.0;
    protected double objFunInit = 0.0;
    protected double objFunFinal = 0.0;
    protected double[] gradientCur = null;
    protected double[] gradientInit = null;
    protected boolean minf = false;
    protected int maxStepHalvings = 0;
    protected int lastStepHalving = 0;
    protected double initCoef = -1.0;
    protected double curCoef = -1.0;
    protected boolean allSHValues = false;
    protected double[] objFunSHValues = null;
    protected CCBitSet redunInit = null;
    protected CCBitSet redunCur = null;

    public UCPassiveOptimizer(int nEstParams) {
        this.nEstParams = nEstParams;
        this.optimSettings = new OptimSettings();
        this.estParams = new double[nEstParams];
        this.estParamsPrev = new double[nEstParams];
        this.estParamsChg = new double[nEstParams];
        this.gradientInit = new double[nEstParams];
        this.gradientCur = new double[nEstParams];
        this.hessianChol = new DenseSymMatrix(nEstParams);
        this.hessianGI = new DenseSymMatrix(nEstParams);
        this.minDiagChol = new double[1];
        this.probs = new double[3];
        this.redunInit = new CCBitSet(nEstParams);
        this.redunCur = new CCBitSet(nEstParams);
    }

    public UCPassiveOptimizer(int nEstParams, OptimSettings optimSettings) {
        this(nEstParams);
        this.setOptimSettings(optimSettings);
    }

    protected void setOptimSettings(OptimSettings optimSettings) {
        this.optimSettings = optimSettings;
        boolean minimize = this.optimSettings.getMinimizeObjFun();
        this.initCoef = minimize ? -1.0 : 1.0;
        this.setAccumAllStatsIndicator(0);
        this.compTol = this.optimSettings.getCompTol();
        this.minf = this.optimSettings.getMinimizeObjFun();
        this.maxStepHalvings = this.optimSettings.getMaxStephalvings();
        this.allSHValues = this.optimSettings.getAllSHValues();
        if (this.allSHValues && this.maxStepHalvings > 0) {
            this.objFunSHValues = new double[this.maxStepHalvings];
        }
    }

    protected void setAccumAllStatsIndicator(int nFisher) {
        HessianCompMethod hessianMethod = this.optimSettings.getHessianMethod();
        if (hessianMethod == HessianCompMethod.FISHER_SCORING) {
            this.accumStatsIndicator = 1;
        } else if (hessianMethod == HessianCompMethod.NEWTON_RAPHSON) {
            this.accumStatsIndicator = 2;
        } else if (hessianMethod == HessianCompMethod.HYBRID) {
            this.accumStatsIndicator = nFisher > this.optimSettings.getNFisherIter() ? 2 : 1;
        }
    }

    @Override
    public boolean initialize(double[] estParams) {
        boolean result = MathFun.dCopy((double[])estParams, (double[])this.estParams);
        if (result) {
            MathFun.dCopy((double[])estParams, (double[])this.estParamsPrev);
            this.optimState = PassiveOptimizer.OptimState.Initialized;
            this.lastIter = 0;
            this.setAccumAllStatsIndicator(0);
        } else {
            this.optimState = PassiveOptimizer.OptimState.Invalid;
        }
        return result;
    }

    public PassiveOptimizer.OptimState getState() {
        return this.optimState;
    }

    @Override
    public boolean processAccumStats(BaseOptAccumStats accumStats) {
        if (this.optimState != PassiveOptimizer.OptimState.Invalid) {
            if (this.optimState == PassiveOptimizer.OptimState.Uninitialized) {
                this.optimState = PassiveOptimizer.OptimState.Invalid;
            } else if (this.optimState == PassiveOptimizer.OptimState.Initialized) {
                ++this.lastIter;
                this.objFunInit = this.objFunCur = accumStats.getObjFun();
                this.objFunPrevIter = this.objFunCur;
                this.objFunPrevInner = this.objFunCur;
                double[] accumGradient = accumStats.getGradient();
                MathFun.dCopy((double[])accumGradient, (double[])this.gradientInit);
                MathFun.dCopy((double[])accumGradient, (double[])this.gradientCur);
                DenseSymMatrix accumHessian = accumStats.getHessian();
                accumHessian.copyTo(this.hessianChol);
                this.nZeroPiv = this.hessianChol.lTChol(this.compTol, 1.0E-4, this.minDiagChol, this.redunCur, false);
                if (this.redunInit.inSet() == 0) {
                    this.redunInit = this.redunCur.clone();
                }
                this.nZeroPiv = this.hessianChol.lTSubstitute(this.gradientInit, this.estParamsChg);
                this.lastStepHalving = 0;
                this.curCoef = this.initCoef;
                MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
                this.optimState = PassiveOptimizer.OptimState.InnerLoop;
                this.accumStatsIndicator = 0;
                if (this.allSHValues) {
                    this.accumStatsIndicator = 3;
                }
            } else if (this.optimState == PassiveOptimizer.OptimState.InnerLoop) {
                ++this.lastStepHalving;
                if (this.allSHValues) {
                    accumStats.getObjFunSHValues(this.objFunSHValues);
                    this.lastStepHalving = this.findStep();
                    this.objFunCur = this.objFunSHValues[this.lastStepHalving];
                    if (this.minf && this.objFunCur <= this.objFunPrevInner || !this.minf && this.objFunCur >= this.objFunPrevInner) {
                        this.optimState = PassiveOptimizer.OptimState.AfterInnerLoop;
                        this.setAccumAllStatsIndicator(this.lastIter);
                    } else {
                        ++this.lastIter;
                        this.converCritCode = ConverCrit.MAX_STEPHALVING;
                        MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
                        this.objFunFinal = this.objFunPrevIter;
                        this.hessianChol.copyTo(this.hessianGI);
                        this.hessianGI.lTInverse();
                        this.accumWeight = accumStats.getAccumWeight();
                        this.optimState = PassiveOptimizer.OptimState.Stopped;
                    }
                } else {
                    this.objFunCur = accumStats.getObjFun();
                    if (this.minf && this.objFunCur <= this.objFunPrevInner || !this.minf && this.objFunCur >= this.objFunPrevInner) {
                        this.optimState = PassiveOptimizer.OptimState.AfterInnerLoop;
                        this.setAccumAllStatsIndicator(this.lastIter);
                    } else if (this.lastStepHalving >= this.maxStepHalvings) {
                        ++this.lastIter;
                        this.converCritCode = ConverCrit.MAX_STEPHALVING;
                        MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
                        this.objFunFinal = this.objFunPrevIter;
                        this.hessianChol.copyTo(this.hessianGI);
                        this.hessianGI.lTInverse();
                        this.accumWeight = accumStats.getAccumWeight();
                        this.optimState = PassiveOptimizer.OptimState.Stopped;
                    } else {
                        this.curCoef *= 0.5;
                        MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
                        MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
                    }
                }
            } else if (this.optimState == PassiveOptimizer.OptimState.AfterInnerLoop) {
                ++this.lastIter;
                this.objFunCur = accumStats.getObjFun();
                double[] accumGradient = accumStats.getGradient();
                MathFun.dCopy((double[])accumGradient, (double[])this.gradientCur);
                DenseSymMatrix accumHessian = accumStats.getHessian();
                accumHessian.copyTo(this.hessianChol);
                this.nZeroPiv = this.hessianChol.lTChol(this.compTol, 1.0E-4, this.minDiagChol, this.redunCur, false);
                if (this.converCritCode == ConverCrit.NOT_ALL) {
                    this.hessianChol.copyTo(this.hessianGI);
                    this.hessianGI.lTInverse();
                    this.converCritCode = this.checkForConvergence(accumStats);
                }
                if (this.converCritCode == ConverCrit.NOT_ALL) {
                    this.objFunPrevIter = this.objFunCur;
                    MathFun.dCopy((double[])this.estParams, (double[])this.estParamsPrev);
                    this.nZeroPiv = this.hessianChol.lTSubstitute(this.gradientCur, this.estParamsChg);
                    this.lastStepHalving = 0;
                    this.curCoef = this.initCoef;
                    this.objFunPrevInner = this.objFunCur;
                    MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
                    this.optimState = PassiveOptimizer.OptimState.InnerLoop;
                    this.accumStatsIndicator = 0;
                    if (this.allSHValues) {
                        this.accumStatsIndicator = 3;
                    }
                } else {
                    this.accumWeight = accumStats.getAccumWeight();
                    this.objFunFinal = this.objFunCur;
                    this.optimState = PassiveOptimizer.OptimState.Stopped;
                }
            }
        }
        return this.optimState == PassiveOptimizer.OptimState.Stopped;
    }

    @Override
    public boolean finished() {
        return this.optimState == PassiveOptimizer.OptimState.Stopped;
    }

    @Override
    public int getNIterations() {
        return this.lastIter;
    }

    @Override
    public ConverCrit getStopReason() {
        return this.converCritCode;
    }

    @Override
    public DenseSymMatrix getHessianGI() {
        return this.hessianGI;
    }

    @Override
    public double[] getEstParams() {
        return this.estParams;
    }

    public boolean getEstParams(double[] estParams) {
        return MathFun.dCopy((double[])this.estParams, (double[])estParams);
    }

    public double getParamChangeLastIter() {
        return this.paramChangeLastIter;
    }

    @Override
    public int getAccumStatsIndicator() {
        return this.accumStatsIndicator;
    }

    public double getObjFunInit() {
        return this.objFunInit;
    }

    @Override
    public double getObjFunFinal() {
        return this.objFunFinal;
    }

    public double getObjFunChangeLastIter() {
        return this.objFunChangeLastIter;
    }

    public double[] getGradient() {
        return this.gradientCur;
    }

    public double[] getGradientInit() {
        return this.gradientInit;
    }

    public int getNZeroPivotsInHessian() {
        return this.nZeroPiv;
    }

    protected ConverCrit checkForConvergence(BaseOptAccumStats accumStats) {
        ConverCrit result = ConverCrit.NOT_ALL;
        result = this.checkForSeparation(accumStats);
        if (result != ConverCrit.NOT_ALL) {
            return result;
        }
        boolean converged = this.checkThreeConvergence(accumStats.getObjFun());
        result = converged ? ConverCrit.ALL_CONVERGED : this.checkOtherReasonStop(result);
        return result;
    }

    protected ConverCrit checkCQCSeparation(BaseOptAccumStats accumStats) {
        ConverCrit result = ConverCrit.NOT_ALL;
        double completeSepTol = this.optimSettings.getCompleteSepTol();
        double quasiSepCholDiagTol = this.optimSettings.getQuasiSepCholDiagTol();
        double quasiMin = this.optimSettings.getQuasiMin();
        double quasiMax = this.optimSettings.getQuasiMax();
        accumStats.getProbs(this.probs);
        double obsRespProbMin = this.probs[0];
        double obsRespProbMax = this.probs[1];
        double compProbMin = this.probs[2];
        if (1.0 - obsRespProbMin <= completeSepTol) {
            result = ConverCrit.COMPLETE_SEPARATION;
        } else if (this.minDiagChol[0] <= quasiSepCholDiagTol) {
            result = obsRespProbMax > quasiMax || compProbMin < quasiMin ? ConverCrit.QUASI_SEPARATION : ConverCrit.REDUNDANT_HESSIAN;
        }
        return result;
    }

    protected ConverCrit checkForSeparation(BaseOptAccumStats accumStats) {
        ConverCrit result = ConverCrit.NOT_ALL;
        int startIterForCS = this.optimSettings.getStartIterForCS();
        if (startIterForCS > 0 && this.lastIter > startIterForCS && (result = this.checkCQCSeparation(accumStats)) != ConverCrit.NOT_ALL) {
            boolean objFunAbsChange = this.optimSettings.getObjFunAbsChange();
            boolean paramAbsChange = this.optimSettings.getParamAbsChange();
            double denomIncr = this.optimSettings.getDenomIncr();
            this.objFunChangeLastIter = Math.abs(this.objFunPrevIter - this.objFunCur);
            if (!objFunAbsChange) {
                double denom = this.objFunPrevIter == 0.0 ? denomIncr : this.objFunPrevIter;
                this.objFunChangeLastIter /= Math.abs(denom);
            }
            this.paramChangeLastIter = paramAbsChange ? MathFun.vNrm1Diff((double[])this.estParams, (double[])this.estParamsPrev) : MathFun.vMaxRelDiff((double[])this.estParams, (double[])this.estParamsPrev, (double)denomIncr);
        }
        return result;
    }

    protected ConverCrit checkOtherReasonStop(ConverCrit convertCrit) {
        int maxIter = this.optimSettings.getMaxIter();
        ConverCrit result = convertCrit;
        if (convertCrit == ConverCrit.NOT_ALL && this.lastIter >= maxIter) {
            result = ConverCrit.MAX_ITERATIONS;
        }
        if (convertCrit == ConverCrit.NOT_ALL && this.optimSettings.getCheckRedundancy() && this.redunInit.isNewFalse(this.redunCur, this.nEstParams)) {
            result = ConverCrit.REDUNDANT_HESSIAN;
        }
        return result;
    }

    protected boolean checkThreeConvergence(double objFun) {
        boolean converged = true;
        boolean objFunAbsChange = this.optimSettings.getObjFunAbsChange();
        boolean paramAbsChange = this.optimSettings.getParamAbsChange();
        boolean hessianAbsChange = this.optimSettings.getHessianAbsChange();
        double objFunConverCrit = this.optimSettings.getObjFunConverCrit();
        double paramConverCrit = this.optimSettings.getParamConverCrit();
        double hessianConverCrit = this.optimSettings.getHessianConverCrit();
        double denomIncr = this.optimSettings.getDenomIncr();
        this.objFunChangeLastIter = Math.abs(this.objFunPrevIter - this.objFunCur);
        if (!objFunAbsChange) {
            double denom = this.objFunPrevIter == 0.0 ? denomIncr : this.objFunPrevIter;
            this.objFunChangeLastIter /= Math.abs(denom);
        }
        if (converged && objFunConverCrit > 0.0) {
            converged = this.objFunChangeLastIter < objFunConverCrit;
        }
        this.paramChangeLastIter = paramAbsChange ? MathFun.vNrm1Diff((double[])this.estParams, (double[])this.estParamsPrev) : MathFun.vMaxRelDiff((double[])this.estParams, (double[])this.estParamsPrev, (double)denomIncr);
        if (converged && paramConverCrit > 0.0 && this.nEstParams > 0) {
            boolean bl = converged = this.paramChangeLastIter < paramConverCrit;
        }
        if (converged && hessianConverCrit > 0.0) {
            double sHs = this.hessianGI.computeVSV(this.gradientCur);
            if (!hessianAbsChange) {
                double denom = objFun == 0.0 ? denomIncr : Math.abs(objFun);
                sHs /= denom;
            }
            converged = sHs < hessianConverCrit;
        }
        return converged;
    }

    public double getAccumWeight() {
        return this.accumWeight;
    }

    @Override
    public double[] getEstParamsForStepHalving() {
        return this.estParamsPrev;
    }

    @Override
    public double[] getEstParamsChgForStepHalving() {
        return this.estParamsChg;
    }

    @Override
    public double getInitCoefForStepHalving() {
        return this.initCoef;
    }

    public void setRedunInit(CCBitSet reduninit) {
        this.redunInit = this.redunInit.clone();
    }

    public CCBitSet getRedunInit() {
        return this.redunInit;
    }

    public CCBitSet getRedunCur() {
        return this.redunCur;
    }

    public int findStep() {
        int result = 0;
        double objFun = this.objFunSHValues[0];
        double curCoefSaved = this.curCoef = this.initCoef;
        for (int i = 1; i < this.maxStepHalvings; ++i) {
            boolean better;
            double curVal = this.objFunSHValues[i];
            this.curCoef *= 0.5;
            boolean bl = this.minf ? objFun > curVal : (better = objFun < curVal);
            if (!better) continue;
            result = i;
            objFun = curVal;
            curCoefSaved = this.curCoef;
        }
        this.curCoef = curCoefSaved;
        MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
        MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
        return result;
    }

    public int getLastStepHalving() {
        return this.lastStepHalving;
    }
}

