/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.quasinewton;

import com.spss.math.statistics.MathFun;
import java.util.ArrayList;

public class LBFGSDirectionHelper {
    protected double[][] estParamHistory = null;
    protected double[][] gradientHistory = null;
    protected ArrayList<Integer> historyIndices = null;
    protected int lengthOfHistory = 5;
    protected int numEstParams = 0;
    protected double[][] delta = null;
    protected double[][] gamma = null;
    protected double[] phi = null;
    protected double[] alpha = null;
    protected double[] beta = null;
    protected double[] nu = null;
    protected double[] w = null;

    public LBFGSDirectionHelper(int nEstParams, int lenOfHistory) {
        int i;
        this.numEstParams = nEstParams;
        this.lengthOfHistory = lenOfHistory;
        this.estParamHistory = new double[this.lengthOfHistory][];
        for (i = 0; i < this.lengthOfHistory; ++i) {
            this.estParamHistory[i] = new double[this.numEstParams];
        }
        this.gradientHistory = new double[this.lengthOfHistory][];
        for (i = 0; i < this.lengthOfHistory; ++i) {
            this.gradientHistory[i] = new double[this.numEstParams];
        }
        this.historyIndices = new ArrayList(this.lengthOfHistory);
        this.delta = new double[this.lengthOfHistory][];
        for (i = 0; i < this.lengthOfHistory; ++i) {
            this.delta[i] = new double[this.numEstParams];
        }
        this.gamma = new double[this.lengthOfHistory][];
        for (i = 0; i < this.lengthOfHistory; ++i) {
            this.gamma[i] = new double[this.numEstParams];
        }
        this.phi = new double[this.lengthOfHistory];
        this.alpha = new double[this.lengthOfHistory];
        this.beta = new double[this.lengthOfHistory];
        this.nu = new double[this.numEstParams];
        this.w = new double[this.numEstParams];
    }

    public boolean saveHistory(int iterationIndex, double[] estParams, double[] gradients) {
        boolean result = true;
        if (iterationIndex < 0) {
            result = false;
        }
        if (result) {
            if (iterationIndex < this.lengthOfHistory) {
                MathFun.dCopy((double[])estParams, (double[])this.estParamHistory[iterationIndex]);
                MathFun.dCopy((double[])gradients, (double[])this.gradientHistory[iterationIndex]);
                this.historyIndices.add(iterationIndex);
            } else {
                int ind = this.historyIndices.get(0);
                MathFun.dCopy((double[])estParams, (double[])this.estParamHistory[ind]);
                MathFun.dCopy((double[])gradients, (double[])this.gradientHistory[ind]);
                this.historyIndices.remove(0);
                this.historyIndices.add(ind);
            }
        }
        return result;
    }

    public boolean computeChangeOfParameter(double[] curParams, double[] curGradients, double[] paramChange) {
        boolean result = true;
        if (paramChange == null || paramChange.length != this.numEstParams || curParams == null || curParams.length != this.numEstParams || curGradients == null || curGradients.length != this.numEstParams) {
            result = false;
        }
        if (result) {
            int k;
            MathFun.dCopy((double[])curGradients, (double[])this.nu);
            for (int j = this.historyIndices.size() - 1; j >= 0; --j) {
                double val;
                int k2;
                if (j == this.historyIndices.size() - 1) {
                    for (k2 = 0; k2 < this.numEstParams; ++k2) {
                        this.delta[j][k2] = curParams[k2] - this.estParamHistory[this.historyIndices.get(j)][k2];
                    }
                    for (k2 = 0; k2 < this.numEstParams; ++k2) {
                        this.gamma[j][k2] = curGradients[k2] - this.gradientHistory[this.historyIndices.get(j)][k2];
                    }
                } else {
                    for (k2 = 0; k2 < this.numEstParams; ++k2) {
                        this.delta[j][k2] = this.estParamHistory[this.historyIndices.get(j + 1)][k2] - this.estParamHistory[this.historyIndices.get(j)][k2];
                    }
                    for (k2 = 0; k2 < this.numEstParams; ++k2) {
                        this.gamma[j][k2] = this.gradientHistory[this.historyIndices.get(j + 1)][k2] - this.gradientHistory[this.historyIndices.get(j)][k2];
                    }
                }
                if (Double.compare(val = MathFun.dDot((int)this.numEstParams, (double[])this.gamma[j], (int)0, (int)1, (double[])this.delta[j], (int)0, (int)1), 0.0) == 0) {
                    return false;
                }
                this.phi[j] = 1.0 / val;
                this.alpha[j] = this.phi[j] * MathFun.dDot((int)this.numEstParams, (double[])this.nu, (int)0, (int)1, (double[])this.delta[j], (int)0, (int)1);
                MathFun.daxpy((int)this.numEstParams, (double)(-this.alpha[j]), (double[])this.gamma[j], (int)0, (int)1, (double[])this.nu, (int)0, (int)1);
            }
            int ind = this.historyIndices.size() - 1;
            double numerator = MathFun.dDot((int)this.numEstParams, (double[])this.gamma[ind], (int)0, (int)1, (double[])this.delta[ind], (int)0, (int)1);
            double denominator = MathFun.dDot((int)this.numEstParams, (double[])this.gamma[ind], (int)0, (int)1, (double[])this.gamma[ind], (int)0, (int)1);
            if (Double.compare(denominator, 0.0) == 0) {
                return false;
            }
            MathFun.dCopy((double[])this.nu, (double[])this.w);
            for (k = 0; k < this.numEstParams; ++k) {
                this.w[k] = this.w[k] * (numerator / denominator);
            }
            for (int j = 0; j <= this.historyIndices.size() - 1; ++j) {
                this.beta[j] = this.phi[j] * MathFun.dDot((int)this.numEstParams, (double[])this.w, (int)0, (int)1, (double[])this.gamma[j], (int)0, (int)1);
                MathFun.daxpy((int)this.numEstParams, (double)(this.alpha[j] - this.beta[j]), (double[])this.delta[j], (int)0, (int)1, (double[])this.w, (int)0, (int)1);
            }
            for (k = 0; k < this.numEstParams; ++k) {
                paramChange[k] = -this.w[k];
            }
        }
        return result;
    }
}

