/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.quasinewton;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.ac.acmath.optimizer.common.BaseOptAccumStats;
import com.spss.ac.acmath.optimizer.common.ConverCrit;
import com.spss.ac.acmath.optimizer.common.OptimSettings;
import com.spss.ac.acmath.optimizer.common.PassiveOptimizer;
import com.spss.ac.acmath.optimizer.linesearch.LineSearch;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchImpl;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchMethod;
import com.spss.ac.acmath.optimizer.linesearch.LineSearchTermRule;
import com.spss.ac.acmath.optimizer.quasinewton.LBFGSDirectionHelper;
import com.spss.ac.acmath.optimizer.quasinewton.LBFGSOptAccumStats;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.math.statistics.MathFun;
import com.spss.utilities.i18n.LocMsgId;

public class LBFGSOptimizer
implements PassiveOptimizer {
    private PassiveOptimizer.OptimState optimState = PassiveOptimizer.OptimState.Uninitialized;
    private OptimSettings optimSettings = null;
    private int nEstParams = 0;
    private double[] estParams = null;
    private double[] estParamsPrev = null;
    private double[] estParamsChg = null;
    private CCBitSet redunInit = null;
    private CCBitSet redunCur = null;
    private ConverCrit converCritCode = ConverCrit.NOT_ALL;
    private int lastIter = 0;
    private int lastStepInLineSearch = 0;
    private double objFunChangeLastIter = 0.0;
    private double paramChangeLastIter = 0.0;
    private LBFGSOptAccumStats.LBFGSAccumStatsIndicator accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient;
    private double objFunCur = 0.0;
    private double objFunPrevIter = 0.0;
    private double objFunPrevLineSearch = 0.0;
    private double objFunInit = 0.0;
    private double objFunFinal = 0.0;
    private double[] gradientCur = null;
    private double[] gradientPrevIter = null;
    private double[] gradientInit = null;
    private boolean minf = true;
    private LineSearchImpl lineSearch = null;
    private LineSearchMethod lineSearchMethod = LineSearchMethod.CUBIC_INTERPOL;
    private LineSearchTermRule lineSearchTermRule = LineSearchTermRule.WOLFE;
    private int maxLineSearchIter = 20;
    private double initStepInLineSearch = 1.0;
    private double upperBoundInLineSearch = 4000.0;
    private double lineSearchTau = 0.5;
    private boolean allSHValues = false;
    private int maxStepHalvings = 0;
    private double initCoef = 1.0;
    private double curCoef = 1.0;
    private double[] objFunSHValues = null;
    private double compTol = 1.0E-12;
    private double accumWeight = 0.0;
    private double[] probs = null;
    private LBFGSDirectionHelper directionHelpler = null;

    public LBFGSOptimizer(int nEstParams) {
        this.nEstParams = nEstParams;
        this.optimSettings = new OptimSettings();
        this.estParams = new double[nEstParams];
        this.estParamsPrev = new double[nEstParams];
        this.estParamsChg = new double[nEstParams];
        this.gradientInit = new double[nEstParams];
        this.gradientCur = new double[nEstParams];
        this.gradientPrevIter = new double[nEstParams];
        this.redunInit = new CCBitSet(nEstParams);
        this.redunCur = new CCBitSet(nEstParams);
        this.redunInit.negate();
        this.redunCur.negate();
        this.probs = new double[3];
    }

    public LBFGSOptimizer(int nEstParams, OptimSettings optimSettings) {
        this(nEstParams);
        this.setOptimSettings(optimSettings);
    }

    private void setOptimSettings(OptimSettings optimSettings) {
        this.optimSettings = optimSettings;
        this.minf = this.optimSettings.getMinimizeObjFun();
        this.compTol = this.optimSettings.getCompTol();
        this.maxStepHalvings = this.optimSettings.getMaxStephalvings();
        this.allSHValues = this.optimSettings.getAllSHValues();
        if (this.allSHValues && this.maxStepHalvings > 0) {
            this.objFunSHValues = new double[this.maxStepHalvings];
        }
        this.lineSearchMethod = this.optimSettings.getLineSearchMethod();
        this.lineSearchTermRule = this.optimSettings.getLineSearchTermRule();
        this.maxLineSearchIter = this.optimSettings.getMaxLineSearchIter();
        this.initStepInLineSearch = this.optimSettings.getInitStepInLineSearch();
        this.upperBoundInLineSearch = this.optimSettings.getUpperBoundInLineSearch();
        this.lineSearchTau = this.optimSettings.getLineSearchTau();
        this.initCoef = this.initStepInLineSearch;
        this.lineSearch = new LineSearchImpl(this.maxLineSearchIter, this.nEstParams, this.lineSearchMethod, this.lineSearchTermRule, this.allSHValues, this.initCoef, this.lineSearchTau, this.compTol);
        this.directionHelpler = new LBFGSDirectionHelper(this.nEstParams, optimSettings.getLengthOfHistory4LBFGS());
    }

    @Override
    public boolean initialize(double[] estParams) {
        boolean result = MathFun.dCopy((double[])estParams, (double[])this.estParams);
        if (result) {
            MathFun.dCopy((double[])estParams, (double[])this.estParamsPrev);
            this.optimState = PassiveOptimizer.OptimState.Initialized;
            this.lastIter = 0;
        } else {
            this.optimState = PassiveOptimizer.OptimState.Invalid;
        }
        return result;
    }

    public LBFGSOptAccumStats.LBFGSAccumStatsIndicator getLBFGSAccumStatsIndicator() {
        return this.accumStatsIndicator;
    }

    @Override
    public int getAccumStatsIndicator() {
        int result = 0;
        if (this.accumStatsIndicator == LBFGSOptAccumStats.LBFGSAccumStatsIndicator.ObjFunSHAll) {
            result = 3;
        } else if (this.accumStatsIndicator == LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient) {
            result = 4;
        }
        return result;
    }

    @Override
    public boolean processAccumStats(BaseOptAccumStats accumStats) {
        if (!this.isValidGradient(accumStats.getGradient())) {
            MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
            this.objFunFinal = this.objFunPrevIter;
            this.accumWeight = accumStats.getAccumWeight();
            this.converCritCode = ConverCrit.INVALIDSTATS;
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        }
        if (this.optimState != PassiveOptimizer.OptimState.Invalid) {
            if (this.optimState == PassiveOptimizer.OptimState.Uninitialized) {
                this.optimState = PassiveOptimizer.OptimState.Invalid;
            } else if (this.optimState == PassiveOptimizer.OptimState.Initialized) {
                this.processInitialized(accumStats);
            } else if (this.optimState == PassiveOptimizer.OptimState.LineSearchLoop) {
                if (this.allSHValues) {
                    ++this.lastStepInLineSearch;
                    this.processAllSHValues(accumStats);
                } else if (this.lineSearchMethod == LineSearchMethod.STEP_HALVING) {
                    ++this.lastStepInLineSearch;
                    this.processOneSHValue(accumStats);
                } else {
                    this.processOtherLineSearchMethod(accumStats);
                }
            } else if (this.optimState == PassiveOptimizer.OptimState.AfterLineSearchLoop) {
                this.processAfterLineSearch(accumStats);
            }
        }
        return this.optimState == PassiveOptimizer.OptimState.Stopped;
    }

    @Override
    public boolean finished() {
        return this.optimState == PassiveOptimizer.OptimState.Stopped;
    }

    @Override
    public int getNIterations() {
        return this.lastIter;
    }

    public int getlastStepInLineSearch() {
        return this.lastStepInLineSearch;
    }

    @Override
    public ConverCrit getStopReason() {
        return this.converCritCode;
    }

    @Override
    public DenseSymMatrix getHessianGI() {
        return null;
    }

    @Override
    public double[] getEstParams() {
        return this.estParams;
    }

    public boolean getEstParams(double[] estParams) {
        return MathFun.dCopy((double[])this.estParams, (double[])estParams);
    }

    public double getParamChangeLastIter() {
        return this.paramChangeLastIter;
    }

    public double getObjFunChangeLastIter() {
        if (this.minf) {
            return this.objFunChangeLastIter;
        }
        return -this.objFunChangeLastIter;
    }

    public double getObjFunInit() {
        if (this.minf) {
            return this.objFunInit;
        }
        return -this.objFunInit;
    }

    @Override
    public double getObjFunFinal() {
        if (this.minf) {
            return this.objFunFinal;
        }
        return -this.objFunFinal;
    }

    public double[] getGradientInit() {
        return this.gradientInit;
    }

    public double[] getGradient() {
        return this.gradientCur;
    }

    public void setRedunInit(CCBitSet redInit) {
        this.redunCur = this.redunInit = redInit.clone();
    }

    public CCBitSet getRedunInit() {
        return this.redunInit;
    }

    public CCBitSet getRedunCur() {
        return this.redunCur;
    }

    public PassiveOptimizer.OptimState getState() {
        return this.optimState;
    }

    @Override
    public double[] getEstParamsForStepHalving() {
        return this.estParamsPrev;
    }

    public double[] getEstParamsChange() {
        return this.estParamsChg;
    }

    public double getInitCoefForLineSearch() {
        return this.initCoef;
    }

    public double getAccumWeight() {
        return this.accumWeight;
    }

    private void processInitialized(BaseOptAccumStats accumStats) {
        ++this.lastIter;
        this.objFunCur = accumStats.getObjFun();
        double[] accumGradient = accumStats.getGradient();
        MathFun.dCopy((double[])accumGradient, (double[])this.gradientCur);
        this.objFunInit = this.objFunCur;
        this.objFunPrevIter = this.objFunCur;
        this.objFunPrevLineSearch = this.objFunCur;
        MathFun.dCopy((double[])this.gradientCur, (double[])this.gradientInit);
        MathFun.dCopy((double[])this.gradientCur, (double[])this.gradientPrevIter);
        this.directionHelpler.saveHistory(this.lastIter - 1, this.estParams, this.gradientCur);
        for (int i = 0; i < this.gradientCur.length; ++i) {
            this.estParamsChg[i] = -this.gradientCur[i];
        }
        double norm2 = 0.0;
        for (int i = 0; i < this.nEstParams; ++i) {
            norm2 += this.gradientInit[i] * this.gradientInit[i];
        }
        norm2 = 1.0 / Math.sqrt(norm2);
        this.initCoef = 5.0;
        if (norm2 < 5.0) {
            this.initCoef = norm2;
        }
        this.optimState = PassiveOptimizer.OptimState.LineSearchLoop;
        this.lastStepInLineSearch = 0;
        this.curCoef = this.initCoef;
        if (this.lineSearchMethod == LineSearchMethod.STEP_HALVING) {
            MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
            this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.ObjFun;
            if (this.allSHValues) {
                this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.ObjFunSHAll;
            }
        } else {
            this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient;
            this.lineSearch.initialize(this.objFunCur, this.gradientCur, this.estParamsChg, 0.0, this.upperBoundInLineSearch, this.curCoef);
            MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
        }
    }

    private void processAllSHValues(BaseOptAccumStats accumStats) {
        accumStats.getObjFunSHValues(this.objFunSHValues);
        this.lastStepInLineSearch = this.findStep();
        this.objFunCur = this.objFunSHValues[this.lastStepInLineSearch];
        if (this.minf && this.objFunCur <= this.objFunPrevLineSearch || !this.minf && this.objFunCur >= this.objFunPrevLineSearch) {
            this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient;
            this.optimState = PassiveOptimizer.OptimState.AfterLineSearchLoop;
        } else {
            ++this.lastIter;
            this.converCritCode = ConverCrit.MAX_LINESEARCHITERS;
            MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
            this.objFunFinal = this.objFunPrevIter;
            this.accumWeight = accumStats.getAccumWeight();
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        }
    }

    private void processOneSHValue(BaseOptAccumStats accumStats) {
        this.objFunCur = accumStats.getObjFun();
        if (this.minf && this.objFunCur <= this.objFunPrevLineSearch || !this.minf && this.objFunCur >= this.objFunPrevLineSearch) {
            this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient;
            this.optimState = PassiveOptimizer.OptimState.AfterLineSearchLoop;
        } else if (this.lastStepInLineSearch >= this.maxStepHalvings) {
            ++this.lastIter;
            this.converCritCode = ConverCrit.MAX_LINESEARCHITERS;
            MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
            this.objFunFinal = this.objFunPrevIter;
            this.accumWeight = accumStats.getAccumWeight();
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        } else {
            this.curCoef *= 0.5;
            MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
            MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
        }
    }

    private void processOtherLineSearchMethod(BaseOptAccumStats accumStats) {
        this.objFunCur = accumStats.getObjFun();
        double[] accumGradient = accumStats.getGradient();
        MathFun.dCopy((double[])accumGradient, (double[])this.gradientCur);
        LineSearch.LineSearchState lineSearchState = this.lineSearch.doNextIter(this.objFunCur, this.gradientCur);
        this.lastStepInLineSearch = this.lineSearch.getNIteratons();
        if (lineSearchState == LineSearch.LineSearchState.LineSearchLoop) {
            MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
            this.curCoef = this.lineSearch.getStepLength();
            MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
        } else if (lineSearchState == LineSearch.LineSearchState.Completed) {
            this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient;
            this.optimState = PassiveOptimizer.OptimState.AfterLineSearchLoop;
        } else if (lineSearchState == LineSearch.LineSearchState.MaxIterReached) {
            if (this.objFunCur < this.objFunPrevIter) {
                this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient;
                this.optimState = PassiveOptimizer.OptimState.AfterLineSearchLoop;
            } else {
                ++this.lastIter;
                this.converCritCode = ConverCrit.MAX_LINESEARCHITERS;
                MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
                this.objFunFinal = this.objFunPrevIter;
                this.accumWeight = accumStats.getAccumWeight();
                this.optimState = PassiveOptimizer.OptimState.Stopped;
            }
        } else {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
    }

    private void processAfterLineSearch(BaseOptAccumStats accumStats) {
        ++this.lastIter;
        this.objFunCur = accumStats.getObjFun();
        double[] accumGradient = accumStats.getGradient();
        MathFun.dCopy((double[])accumGradient, (double[])this.gradientCur);
        if (this.converCritCode == ConverCrit.NOT_ALL) {
            this.converCritCode = this.checkForConvergence(accumStats);
        }
        if (this.converCritCode == ConverCrit.NOT_ALL) {
            this.objFunPrevIter = this.objFunCur;
            MathFun.dCopy((double[])this.gradientCur, (double[])this.gradientPrevIter);
            MathFun.dCopy((double[])this.estParams, (double[])this.estParamsPrev);
            this.directionHelpler.computeChangeOfParameter(this.estParams, this.gradientCur, this.estParamsChg);
            this.directionHelpler.saveHistory(this.lastIter - 1, this.estParams, this.gradientCur);
            this.initCoef = this.initStepInLineSearch;
            this.lastStepInLineSearch = 0;
            this.curCoef = this.initCoef;
            this.objFunPrevLineSearch = this.objFunCur;
            MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
            this.optimState = PassiveOptimizer.OptimState.LineSearchLoop;
            this.accumStatsIndicator = LBFGSOptAccumStats.LBFGSAccumStatsIndicator.Gradient;
            if (this.lineSearchMethod != LineSearchMethod.STEP_HALVING) {
                this.lineSearch.initialize(this.objFunCur, this.gradientCur, this.estParamsChg, 0.0, this.upperBoundInLineSearch, this.initCoef);
            } else {
                this.accumStatsIndicator = this.allSHValues ? LBFGSOptAccumStats.LBFGSAccumStatsIndicator.ObjFunSHAll : LBFGSOptAccumStats.LBFGSAccumStatsIndicator.ObjFun;
            }
        } else {
            this.accumWeight = accumStats.getAccumWeight();
            this.objFunFinal = this.objFunCur;
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        }
    }

    public int findStep() {
        int result = 0;
        double objFun = this.objFunSHValues[0];
        double curCoefSaved = this.curCoef = this.initCoef;
        for (int i = 1; i < this.maxStepHalvings; ++i) {
            boolean better;
            double curVal = this.objFunSHValues[i];
            this.curCoef *= 0.5;
            boolean bl = this.minf ? objFun >= curVal : (better = objFun <= curVal);
            if (!better) continue;
            result = i;
            objFun = curVal;
            curCoefSaved = this.curCoef;
        }
        this.curCoef = curCoefSaved;
        MathFun.dCopy((double[])this.estParamsPrev, (double[])this.estParams);
        MathFun.daxpy((int)this.nEstParams, (double)this.curCoef, (double[])this.estParamsChg, (int)0, (int)1, (double[])this.estParams, (int)0, (int)1);
        return result;
    }

    private ConverCrit checkForConvergence(BaseOptAccumStats accumStats) {
        ConverCrit result = ConverCrit.NOT_ALL;
        if (this.optimSettings.getFlagOfCheckingForSeparation() && (result = this.checkForSeparation(accumStats)) != ConverCrit.NOT_ALL) {
            return result;
        }
        boolean converged = this.checkThreeConvergenceCriteria(accumStats.getObjFun());
        result = converged ? ConverCrit.ALL_CONVERGED : this.checkForOtherReasonsToStop(result);
        return result;
    }

    private ConverCrit checkForSeparation(BaseOptAccumStats accumStats) {
        ConverCrit result = ConverCrit.NOT_ALL;
        int startIterForCS = this.optimSettings.getStartIterForCS();
        if (startIterForCS > 0 && this.lastIter >= startIterForCS && (result = this.checkForCQCSeparation(accumStats)) != ConverCrit.NOT_ALL) {
            boolean objFunAbsChange = this.optimSettings.getObjFunAbsChange();
            boolean paramAbsChange = this.optimSettings.getParamAbsChange();
            double denomIncr = this.optimSettings.getDenomIncr();
            this.objFunChangeLastIter = Math.abs(this.objFunPrevIter - this.objFunCur);
            if (!objFunAbsChange) {
                double denom = this.objFunPrevIter == 0.0 ? denomIncr : this.objFunPrevIter;
                this.objFunChangeLastIter /= Math.abs(denom);
            }
            this.paramChangeLastIter = paramAbsChange ? MathFun.vNrm1Diff((double[])this.estParams, (double[])this.estParamsPrev) : MathFun.vMaxRelDiff((double[])this.estParams, (double[])this.estParamsPrev, (double)denomIncr);
        }
        return result;
    }

    private ConverCrit checkForCQCSeparation(BaseOptAccumStats accumStats) {
        ConverCrit result = ConverCrit.NOT_ALL;
        double completeSepTol = this.optimSettings.getCompleteSepTol();
        accumStats.getProbs(this.probs);
        double obsRespProbMin = this.probs[0];
        if (1.0 - obsRespProbMin <= completeSepTol) {
            result = ConverCrit.COMPLETE_SEPARATION;
        }
        return result;
    }

    private boolean checkThreeConvergenceCriteria(double objFun) {
        boolean converged = true;
        boolean objFunAbsChange = this.optimSettings.getObjFunAbsChange();
        boolean paramAbsChange = this.optimSettings.getParamAbsChange();
        double objFunConverCrit = this.optimSettings.getObjFunConverCrit();
        double paramConverCrit = this.optimSettings.getParamConverCrit();
        double denomIncr = this.optimSettings.getDenomIncr();
        this.objFunChangeLastIter = Math.abs(this.objFunPrevIter - this.objFunCur);
        if (!objFunAbsChange) {
            double denom = this.objFunPrevIter == 0.0 ? denomIncr : this.objFunPrevIter;
            this.objFunChangeLastIter /= Math.abs(denom);
        }
        if (converged && this.optimSettings.getObjFunConverCritCheckFlag() && objFunConverCrit > 0.0) {
            converged = this.objFunChangeLastIter < objFunConverCrit;
        }
        this.paramChangeLastIter = paramAbsChange ? MathFun.vNrm1Diff((double[])this.estParams, (double[])this.estParamsPrev) : MathFun.vMaxRelDiff((double[])this.estParams, (double[])this.estParamsPrev, (double)denomIncr);
        if (converged && this.optimSettings.getParamConverCritCheckFlag() && paramConverCrit > 0.0 && this.nEstParams > 0) {
            converged = this.paramChangeLastIter < paramConverCrit;
        }
        return converged;
    }

    private ConverCrit checkForOtherReasonsToStop(ConverCrit convertCrit) {
        int maxIter = this.optimSettings.getMaxIter4LBFGS();
        ConverCrit result = convertCrit;
        if (convertCrit == ConverCrit.NOT_ALL && this.lastIter >= maxIter) {
            result = ConverCrit.MAX_ITERATIONS;
        }
        return result;
    }

    private boolean isValidGradient(double[] grad) {
        boolean isValid = true;
        for (int i = 0; i < grad.length; ++i) {
            if (!MissingValue.isMissing((double)grad[i]) && !Double.isInfinite(grad[i]) && !Double.isInfinite(-grad[i])) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    @Override
    public double[] getEstParamsChgForStepHalving() {
        return this.estParamsChg;
    }

    @Override
    public double getInitCoefForStepHalving() {
        return this.initCoef;
    }
}

