/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.ac.acxml.variatedata.VariateData;
import com.spss.ac.acxml.variatedata.XMLCoordinates;
import com.spss.ac.acxml.variatedata.XMLCounts;
import com.spss.math.MissingValue;
import java.util.ArrayList;
import java.util.Arrays;

public class BarChartData {
    private int numCats;
    private double[] numOfCases;
    private double totalFreqWeight;
    private boolean isNormalize;

    public BarChartData(int numCats) {
        this(numCats, false);
    }

    public BarChartData(int numCats, boolean isNormalize) {
        this.numCats = numCats;
        this.isNormalize = isNormalize;
        this.numOfCases = new double[numCats];
        this.totalFreqWeight = 0.0;
    }

    public boolean updateData(double freqWeight, double varValue) {
        boolean result;
        boolean bl = result = !MissingValue.isMissing((double)varValue) && varValue >= 0.0 && varValue < (double)this.numCats;
        if (result) {
            int n = (int)varValue;
            this.numOfCases[n] = this.numOfCases[n] + freqWeight;
            this.totalFreqWeight += freqWeight;
        }
        return result;
    }

    public VariateData generateVariateData(String varName, String[] categs) {
        VariateData result = new VariateData();
        XMLCounts xmlCounts = new XMLCounts();
        xmlCounts.setTotalFreq(this.totalFreqWeight);
        result.setCounts(xmlCounts);
        XMLCoordinates coordinates0 = new XMLCoordinates();
        XMLCoordinates coordinates1 = new XMLCoordinates();
        if (varName != null && !varName.isEmpty()) {
            coordinates0.setFeature("observed");
            coordinates0.setField(varName);
        }
        coordinates1.setFeature("frequency");
        coordinates0.setType(2);
        coordinates1.setType(1);
        coordinates0.setStringVals(new ArrayList(this.numCats));
        coordinates1.setDoubleVals(new ArrayList(this.numCats));
        for (int i = 0; i < this.numCats; ++i) {
            if (!(this.numOfCases[i] > 0.0)) continue;
            coordinates0.getStringVals().add(categs[i]);
            double catCount = this.numOfCases[i];
            if (this.isNormalize) {
                catCount /= this.totalFreqWeight;
            }
            coordinates1.getDoubleVals().add(catCount);
        }
        result.setCoordinates(Arrays.asList(coordinates0, coordinates1));
        return result;
    }

    public double getTotalFreqWeight() {
        return this.totalFreqWeight;
    }

    public String toString() {
        return "BarChartData [numCats=" + this.numCats + ", numOfCases=" + Arrays.toString(this.numOfCases) + ", totalFreqWeight=" + this.totalFreqWeight + ", isNormalize=" + this.isNormalize + "]";
    }
}

