/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.math.matrix.DenseRectMatrix;

public class ClassificationMatrix {
    private int numOfCats;
    private double weight;
    private DenseRectMatrix matrix;

    public ClassificationMatrix(int nTargetCats) {
        this.numOfCats = nTargetCats;
        this.weight = 0.0;
        this.matrix = new DenseRectMatrix(nTargetCats, nTargetCats);
    }

    public boolean updateData(double freqWeight, int observedCat, int predictedCat) {
        boolean result;
        boolean bl = result = freqWeight > 0.0 && observedCat >= 0 && observedCat < this.numOfCats && predictedCat >= 0 && predictedCat < this.numOfCats;
        if (result) {
            double oldCount = this.matrix.getElem(observedCat, predictedCat);
            this.matrix.setElem(observedCat, predictedCat, oldCount + freqWeight);
            this.weight += freqWeight;
        }
        return result;
    }

    public DenseRectMatrix getMatrix() {
        return this.matrix;
    }

    public double getTotalWeight() {
        return this.weight;
    }
}

