/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.ac.acmath.accumstats.AccumTestStats4ContTarget;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.matrix.SymMatrix;
import com.spss.math.statistics.DistributionFunctions;
import com.spss.math.statistics.Power;
import com.spss.utilities.i18n.LocMsgId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ACCategGrouping {
    private boolean bModel;
    private DenseRectMatrix mLMatrix;
    private DenseSymMatrix mCovarMatrix;
    private double[] variances;
    private double[] emmeans;
    private double[] categNRecs;
    private double df;
    private AccumTestStats4ContTarget contTargetStats;
    private int nCategs;
    private int nParams;
    private double alpha;
    private ArrayList<Double> meansSorted = new ArrayList();
    private ArrayList<Integer> meansIndices = new ArrayList();
    private ArrayList<Integer> groupHigh = new ArrayList();
    private ArrayList<Integer> groupLow = new ArrayList();
    private ArrayList<Integer> groupMiddle = new ArrayList();
    private ArrayList<Double> tValuesHigh = new ArrayList();
    private ArrayList<Double> tValuesLow = new ArrayList();
    private ArrayList<Double> pValuesHigh = new ArrayList();
    private ArrayList<Double> pValuesLow = new ArrayList();
    private double median;
    private double mad;
    private double meanAD;
    private double rangeLower;
    private double rangeUpper;
    double computeTol = 1.0E-12;

    public ACCategGrouping(DenseRectMatrix mLMatrix, DenseSymMatrix mCovarMatrix, double[] emmeans, double[] categNRecs, double df, double sigLevel) {
        this.bModel = true;
        this.mLMatrix = mLMatrix;
        this.mCovarMatrix = mCovarMatrix;
        this.emmeans = emmeans;
        this.categNRecs = categNRecs;
        this.df = df;
        this.alpha = sigLevel;
        this.contTargetStats = null;
        this.nCategs = mLMatrix.getNRows();
        this.nParams = mLMatrix.getNCols();
        this.median = MissingValue.getMissing();
        this.mad = MissingValue.getMissing();
        this.meanAD = MissingValue.getMissing();
        this.rangeLower = MissingValue.getMissing();
        this.rangeUpper = MissingValue.getMissing();
    }

    public ACCategGrouping(DenseRectMatrix mLMatrix, DenseSymMatrix mCovarMatrix, double[] emmeans, double[] categNRecs, double df) {
        this(mLMatrix, mCovarMatrix, emmeans, categNRecs, df, 0.05);
    }

    public ACCategGrouping(AccumTestStats4ContTarget contTargetStats, double sigLevel) {
        this.bModel = false;
        this.mLMatrix = null;
        this.mCovarMatrix = null;
        this.df = MissingValue.getMissing();
        this.alpha = sigLevel;
        this.contTargetStats = contTargetStats;
        this.nCategs = 0;
        this.nParams = 0;
        this.median = MissingValue.getMissing();
        this.mad = MissingValue.getMissing();
        this.rangeLower = MissingValue.getMissing();
        this.rangeUpper = MissingValue.getMissing();
        this.nCategs = contTargetStats.getNFactorCategs();
        this.categNRecs = contTargetStats.getNRecs();
    }

    public ACCategGrouping(AccumTestStats4ContTarget contTargetStats) {
        this(contTargetStats, 0.05);
    }

    public ACCategGrouping(double[] variances, double[] emmeans, double[] categNRecs, double sigLevel) {
        this.bModel = false;
        this.variances = variances;
        this.emmeans = emmeans;
        this.categNRecs = categNRecs;
        this.alpha = sigLevel;
        this.df = MissingValue.getMissing();
        this.median = MissingValue.getMissing();
        this.mad = MissingValue.getMissing();
        this.meanAD = MissingValue.getMissing();
        this.rangeLower = MissingValue.getMissing();
        this.rangeUpper = MissingValue.getMissing();
        this.nCategs = emmeans.length;
    }

    public void computeCategGroups() {
        int nLow;
        int nHigh;
        double seSquareCurrent;
        double pValue;
        double tValue;
        double sigma;
        int iCurMean;
        double curMean;
        this.groupHigh.clear();
        this.groupLow.clear();
        this.groupMiddle.clear();
        if (this.nCategs == 0) {
            throw new ACException((LocMsgId)ACMessages.REGR_LMATRIX_EMPTY, new Object[0]);
        }
        if (this.bModel && this.mCovarMatrix.getNRows() != this.nParams) {
            throw new ACException((LocMsgId)ACMessages.REGR_LMATRIXN_COLS_NOT_EQUAL, new Object[0]);
        }
        if (this.bModel && this.emmeans.length != this.nCategs) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.categNRecs.length != this.nCategs) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.variances != null && this.variances.length != this.emmeans.length) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.variances != null && this.variances.length != this.categNRecs.length) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        double[] arrayMeans = null;
        arrayMeans = this.bModel || this.variances != null ? this.emmeans : this.contTargetStats.getTargetMeans();
        this.meansSorted.clear();
        this.meansIndices.clear();
        double totalRecs = 0.0;
        for (int i = 0; i < this.categNRecs.length; ++i) {
            if (!(this.categNRecs[i] > 0.0)) continue;
            this.meansSorted.add(arrayMeans[i]);
            this.meansIndices.add(i);
            totalRecs += this.categNRecs[i];
        }
        int nNonEmpty = this.meansSorted.size();
        if (nNonEmpty == 0) {
            throw new ACException((LocMsgId)ACMessages.REGR_NO_VALID_RECORDS_RECS4MODEL, new Object[0]);
        }
        ACCategGrouping.sortPairsDIGT(this.meansSorted, this.meansIndices);
        int iLastInHighGroup = 0;
        double seSquareLarge = 0.0;
        double seSquareSum = 0.0;
        double[] product = new double[1];
        double coeff = 0.0;
        double nRecsLarge = 0.0;
        double nRecsCurrent = 0.0;
        double[] vWork = null;
        double comMean = 0.0;
        if (this.variances != null) {
            int i;
            this.df = totalRecs - (double)nNonEmpty;
            for (i = 0; i < this.nCategs; ++i) {
                coeff += this.categNRecs[i] * this.variances[i];
                comMean += this.categNRecs[i] * this.emmeans[i];
            }
            comMean /= totalRecs;
            i = 0;
            while (i < nNonEmpty) {
                curMean = this.meansSorted.get(i);
                iCurMean = this.meansIndices.get(i);
                nRecsCurrent = this.categNRecs[iCurMean];
                seSquareSum = 1.0 / (nRecsCurrent * this.df) * coeff;
                if (seSquareSum <= 0.0) break;
                sigma = Math.sqrt(seSquareSum);
                tValue = (curMean - comMean) / sigma;
                pValue = DistributionFunctions.cdfT((double)tValue, (double)this.df);
                if (MissingValue.isMissing((double)pValue)) {
                    throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
                }
                if ((pValue = 1.0 - pValue) <= this.alpha) {
                    this.groupHigh.add(iCurMean);
                    this.tValuesHigh.add(tValue);
                    this.pValuesHigh.add(pValue);
                    iLastInHighGroup = i++;
                    continue;
                }
                break;
            }
        } else {
            double largeMean = this.meansSorted.get(0);
            int iLargeMean = this.meansIndices.get(0);
            this.groupHigh.add(iLargeMean);
            this.tValuesHigh.add(MissingValue.getMissing());
            this.pValuesHigh.add(MissingValue.getMissing());
            if (this.bModel) {
                vWork = new double[this.nParams];
            } else {
                double ssFull = this.contTargetStats.getErrorSumOfSquares();
                double ssFullDF = this.contTargetStats.getErrorDegreesOfFreedom();
                if (ssFullDF <= 0.0) {
                    throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
                }
                coeff = ssFull / ssFullDF;
                this.df = ssFullDF;
                nRecsLarge = this.categNRecs[iLargeMean];
                seSquareLarge = coeff / nRecsLarge;
            }
            for (int i = 1; i < nNonEmpty; ++i) {
                curMean = this.meansSorted.get(i);
                iCurMean = this.meansIndices.get(i);
                if (curMean == largeMean) {
                    this.groupHigh.add(iCurMean);
                    this.tValuesHigh.add(0.0);
                    this.pValuesHigh.add(0.5);
                    iLastInHighGroup = i;
                    continue;
                }
                iCurMean = this.meansIndices.get(i);
                seSquareCurrent = 0.0;
                if (this.bModel) {
                    boolean bRes = this.rowDiffSymRowDifTrans(this.mLMatrix, (SymMatrix)this.mCovarMatrix, iLargeMean, iCurMean, vWork, product);
                    seSquareSum = product[0];
                    if (!bRes) {
                        break;
                    }
                } else {
                    nRecsCurrent = this.categNRecs[iCurMean];
                    seSquareCurrent = coeff / nRecsCurrent;
                    seSquareSum = seSquareLarge + seSquareCurrent;
                }
                if (seSquareSum <= 0.0) break;
                sigma = Math.sqrt(seSquareSum);
                tValue = (largeMean - curMean) / sigma;
                pValue = DistributionFunctions.cdfT((double)Math.abs(tValue), (double)this.df);
                if (MissingValue.isMissing((double)pValue)) {
                    throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
                }
                if ((pValue = 1.0 - pValue) > this.alpha) {
                    this.groupHigh.add(iCurMean);
                    this.tValuesHigh.add(tValue);
                    this.pValuesHigh.add(pValue);
                    iLastInHighGroup = i;
                    continue;
                }
                break;
            }
        }
        if (iLastInHighGroup == nNonEmpty - 1) {
            this.groupLow.clear();
            this.groupMiddle.clear();
            return;
        }
        if (this.variances != null) {
            for (int i = nNonEmpty - 1; i > iLastInHighGroup; --i) {
                curMean = this.meansSorted.get(i);
                iCurMean = this.meansIndices.get(i);
                seSquareCurrent = 0.0;
                nRecsCurrent = this.categNRecs[iCurMean];
                seSquareSum = 1.0 / (nRecsCurrent * this.df) * coeff;
                if (seSquareSum <= 0.0) break;
                sigma = Math.sqrt(seSquareSum);
                tValue = (curMean - comMean) / sigma;
                pValue = DistributionFunctions.cdfT((double)Math.abs(tValue), (double)this.df);
                if (MissingValue.isMissing((double)pValue)) {
                    throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
                }
                if ((pValue = 1.0 - pValue) <= this.alpha) {
                    this.groupLow.add(0, iCurMean);
                    this.tValuesLow.add(0, tValue);
                    this.pValuesLow.add(0, pValue);
                    continue;
                }
                break;
            }
        } else {
            double smallMean = this.meansSorted.get(nNonEmpty - 1);
            int iSmallMean = this.meansIndices.get(nNonEmpty - 1);
            this.groupLow.add(iSmallMean);
            this.tValuesLow.add(MissingValue.getMissing());
            this.pValuesLow.add(MissingValue.getMissing());
            double nRecsLow = this.categNRecs[iSmallMean];
            double seSquareLow = coeff / nRecsLow;
            for (int i = nNonEmpty - 2; i > iLastInHighGroup; --i) {
                curMean = this.meansSorted.get(i);
                iCurMean = this.meansIndices.get(i);
                seSquareCurrent = 0.0;
                if (curMean == smallMean) {
                    this.groupLow.add(0, iCurMean);
                    this.tValuesLow.add(0, 0.0);
                    this.pValuesLow.add(0, 0.5);
                    continue;
                }
                if (this.bModel) {
                    boolean bRes = this.rowDiffSymRowDifTrans(this.mLMatrix, (SymMatrix)this.mCovarMatrix, iCurMean, iSmallMean, vWork, product);
                    seSquareSum = product[0];
                    if (!bRes) {
                        break;
                    }
                } else {
                    nRecsCurrent = this.categNRecs[iCurMean];
                    seSquareCurrent = coeff / nRecsCurrent;
                    seSquareSum = seSquareLow + seSquareCurrent;
                }
                if (seSquareSum <= 0.0) break;
                sigma = Math.sqrt(seSquareSum);
                tValue = (curMean - smallMean) / sigma;
                pValue = DistributionFunctions.cdfT((double)Math.abs(tValue), (double)this.df);
                if (MissingValue.isMissing((double)pValue)) {
                    throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
                }
                if ((pValue = 1.0 - pValue) > this.alpha) {
                    this.groupLow.add(0, iCurMean);
                    this.tValuesLow.add(0, tValue);
                    this.pValuesLow.add(0, pValue);
                    continue;
                }
                break;
            }
        }
        if ((nHigh = this.groupHigh.size()) + (nLow = this.groupLow.size()) == nNonEmpty) {
            this.groupMiddle.clear();
            return;
        }
        int nMiddle = nNonEmpty - nHigh - nLow;
        for (int i = 0; i < nMiddle; ++i) {
            iCurMean = this.meansIndices.get(nHigh + i);
            this.groupMiddle.add(iCurMean);
        }
    }

    public void getCategGroups(ArrayList<Integer> alHigh, ArrayList<Integer> alLow, ArrayList<Integer> alMiddle) {
        if (this.groupHigh.isEmpty()) {
            this.computeCategGroups();
        }
        alHigh.clear();
        alLow.clear();
        alMiddle.clear();
        alHigh.addAll(this.groupHigh);
        alLow.addAll(this.groupLow);
        alMiddle.addAll(this.groupMiddle);
    }

    public void getUnusualCategs(ArrayList<Integer> alUnusualHigh, ArrayList<Integer> alUnusualLow) {
        double mean;
        double upperBound;
        double lowerBound;
        int i;
        double kC1 = 4.4478;
        double kC2 = 3.759942;
        int nNonEmpty = this.meansSorted.size();
        int nHigh = this.groupHigh.size();
        int nLow = this.groupLow.size();
        int nMiddle = this.groupMiddle.size();
        if (this.categNRecs.length == 0) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.categNRecs.length != this.nCategs) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (nNonEmpty == 0) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        double median = 0.0;
        boolean bOK = true;
        double[] AbsDev = new double[nNonEmpty];
        double mad = 0.0;
        double[] NRecs = new double[nNonEmpty];
        for (i = 0; i < nNonEmpty; ++i) {
            NRecs[i] = this.categNRecs[this.meansIndices.get(i)];
        }
        double[] meansSorted = new double[this.meansSorted.size()];
        for (i = 0; i < meansSorted.length; ++i) {
            meansSorted[i] = this.meansSorted.get(i);
        }
        median = this.computeMedian(meansSorted, NRecs);
        if (bOK) {
            for (i = 0; i < nNonEmpty; ++i) {
                AbsDev[i] = Math.abs(this.meansSorted.get(i) - median);
            }
            mad = this.computeMedian(AbsDev, NRecs);
        }
        if (!bOK) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        double meanAD = 0.0;
        if (Math.abs(mad) <= this.computeTol) {
            double sumW = 0.0;
            for (i = 0; i < nNonEmpty; ++i) {
                meanAD += AbsDev[i] * NRecs[i];
                sumW += NRecs[i];
            }
            boolean bl = bOK = sumW > 0.0;
            if (!bOK) {
                throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
            }
            lowerBound = median - 3.759942 * (meanAD /= sumW);
            upperBound = median + 3.759942 * meanAD;
        } else {
            lowerBound = median - 4.4478 * mad;
            upperBound = median + 4.4478 * mad;
        }
        alUnusualHigh.clear();
        alUnusualLow.clear();
        for (i = 0; i < nHigh; ++i) {
            mean = this.meansSorted.get(i);
            if (!(mean > upperBound)) continue;
            alUnusualHigh.add(this.meansIndices.get(i));
        }
        for (i = 0; i < nLow; ++i) {
            int iLow = nHigh + nMiddle + i;
            mean = this.meansSorted.get(iLow);
            if (!(mean < lowerBound)) continue;
            alUnusualLow.add(this.meansIndices.get(iLow));
        }
        this.median = median;
        this.mad = mad;
        this.meanAD = meanAD;
        this.rangeLower = lowerBound;
        this.rangeUpper = upperBound;
    }

    public boolean setSignifLevel(double sigLevel) {
        boolean bRes;
        boolean bl = bRes = sigLevel > 0.0 && sigLevel < 1.0;
        if (bRes) {
            this.alpha = sigLevel;
        }
        return bRes;
    }

    public double getMedianOfMeans() {
        return this.median;
    }

    public double getMedianOfAbsoluteDeviation() {
        return this.mad;
    }

    public double getMeanAD() {
        return this.meanAD;
    }

    public double getLowBoundOfRange() {
        return this.rangeLower;
    }

    public double getUpperBoundOfRange() {
        return this.rangeUpper;
    }

    public void getTValues(ArrayList<Double> tValuesHigh, ArrayList<Double> tValuesLow) {
        tValuesHigh.clear();
        tValuesLow.clear();
        tValuesHigh.addAll(this.tValuesHigh);
        tValuesLow.addAll(this.tValuesLow);
    }

    public void getPValues(ArrayList<Double> pValuesHigh, ArrayList<Double> pValuesLow) {
        pValuesHigh.clear();
        pValuesLow.clear();
        pValuesHigh.addAll(this.pValuesHigh);
        pValuesLow.addAll(this.pValuesLow);
    }

    public double getDF() {
        return this.df;
    }

    static void sortPairsDIGT(ArrayList<Double> alDbl, ArrayList<Integer> alInt) {
        int nVals = alDbl.size();
        ArrayList<DIPair> list = new ArrayList<DIPair>();
        for (int i = 0; i < nVals; ++i) {
            list.add(new DIPair(alDbl.get(i), alInt.get(i)));
        }
        DIPairGTComparator comparator = new DIPairGTComparator();
        Collections.sort(list, comparator);
        for (int i = 0; i < nVals; ++i) {
            DIPair pair = (DIPair)list.get(i);
            alDbl.set(i, pair.first);
            alInt.set(i, pair.second);
        }
    }

    static void sortPairsDDLT(double[] dbl1, double[] dbl2) {
        int nVals = dbl1.length;
        ArrayList<DDPair> list = new ArrayList<DDPair>();
        for (int i = 0; i < nVals; ++i) {
            list.add(new DDPair(dbl1[i], dbl2[i]));
        }
        DDPairLTComparator comparator = new DDPairLTComparator();
        Collections.sort(list, comparator);
        for (int i = 0; i < nVals; ++i) {
            dbl1[i] = ((DDPair)list.get((int)i)).first;
            dbl2[i] = ((DDPair)list.get((int)i)).second;
        }
    }

    private boolean rowDiffSymRowDifTrans(DenseRectMatrix mRect, SymMatrix mSym, int iRow1, int iRow2, double[] vWork, double[] product) {
        boolean bRes;
        int nRows = mRect.getNRows();
        int nCols = mRect.getNCols();
        boolean bl = bRes = mSym.getNRows() == nCols && vWork.length >= nCols && iRow1 >= 0 && iRow1 < nRows && iRow2 >= 0 && iRow2 < nRows;
        if (bRes) {
            double[] vRect = mRect.getMatrix();
            int i1 = nCols * iRow1;
            int i2 = nCols * iRow2;
            for (int i = 0; i < nCols; ++i) {
                vWork[i] = vRect[i1++] - vRect[i2++];
            }
            product[0] = mSym.computeVSV(vWork);
        }
        return bRes;
    }

    private double computeMedian(double[] values, double[] weights) {
        int i;
        boolean bRes;
        double median = MissingValue.getMissing();
        if (values == null || weights == null) {
            return median;
        }
        int n = values.length;
        boolean bl = bRes = n > 0 && weights.length == n;
        if (!bRes) {
            return median;
        }
        if (bRes && n == 1) {
            median = values[0];
            return median;
        }
        double[] vCopy = new double[n];
        double[] wCopy = new double[n];
        System.arraycopy(values, 0, vCopy, 0, values.length);
        System.arraycopy(weights, 0, wCopy, 0, values.length);
        ACCategGrouping.sortPairsDDLT(vCopy, wCopy);
        double wsum = 0.0;
        for (i = 0; i < n; ++i) {
            wsum += wCopy[i];
        }
        double pwsum = 0.5 * wsum;
        double cck = wsum;
        double coeff = 1.0;
        i = n - 1;
        while (pwsum < cck && i != -1 && !Power.almostEqual((double)pwsum, (double)cck, (double)coeff)) {
            cck -= wCopy[i--];
            coeff += 1.0;
        }
        median = i == -1 ? vCopy[0] : (i == n - 1 ? vCopy[n - 1] : (Power.almostEqual((double)pwsum, (double)cck, (double)coeff) ? (vCopy[i] + vCopy[i + 1]) / 2.0 : vCopy[i + 1]));
        return median;
    }

    static class DDPairLTComparator
    implements Comparator<DDPair>,
    Serializable {
        private static final long serialVersionUID = 3679012614272142419L;

        DDPairLTComparator() {
        }

        @Override
        public int compare(DDPair object1, DDPair object2) {
            int cmp = Double.compare(object1.first, object2.first);
            return cmp;
        }
    }

    static class DIPairGTComparator
    implements Comparator<DIPair>,
    Serializable {
        private static final long serialVersionUID = 1765170995597985942L;

        DIPairGTComparator() {
        }

        @Override
        public int compare(DIPair object1, DIPair object2) {
            int cmp = Double.compare(object2.first, object1.first);
            return cmp;
        }
    }

    static class DDPair {
        public double first;
        public double second;

        public DDPair(double first, double second) {
            this.first = first;
            this.second = second;
        }
    }

    static class DIPair {
        public double first;
        public int second;

        public DIPair(double first, int second) {
            this.first = first;
            this.second = second;
        }
    }
}

