/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acmath.accumstats.AccumTestStats4CatTarget;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.math.statistics.DistributionFunctions;
import java.util.ArrayList;

public class ACCategGrouping4CatTarget {
    private DenseRectMatrix mNRecs = null;
    private double[] nRecsArray = null;
    private int nCells = 0;
    private int nTargetCategs = 0;
    private boolean nRecsOK = false;
    private double[] cellNRecs = null;
    private double[] cellConfidence = null;
    private int[] cellModeIndex = null;
    private int[] cellNModes = null;
    private boolean modeSetupDone = false;
    private double nRecsTotal = 0.0;
    private double[] probTargetCategs = null;
    private boolean distSetupDone = false;
    private double sigLevel = 0.05;
    private CCBitSet sigCellIndicators = null;
    private ArrayList<Integer> sigCells = null;
    private ArrayList<Double> sigChiSq = null;
    private ArrayList<Double> sigPVal = null;
    private ArrayList<Double> sigEffSizes = null;
    private int nSigCells = 0;
    private boolean checkForSigCells = false;

    public ACCategGrouping4CatTarget(DenseRectMatrix mNRecs) {
        this.mNRecs = mNRecs;
        this.nRecsOK = this.cellSetup();
    }

    public ACCategGrouping4CatTarget(AccumTestStats4CatTarget catTargetStats) {
        this(catTargetStats.getNRecs());
    }

    public boolean isNRecsValid() {
        return this.nRecsOK;
    }

    public int getNModes(int cellX) {
        int result = -1;
        if (this.nRecsOK && cellX >= 0 && cellX < this.nCells) {
            if (!this.modeSetupDone) {
                this.cellModeSetup();
            }
            result = this.cellNModes[cellX];
        }
        return result;
    }

    public int getPredictedCategory(int cellX, int modeX) {
        int result = -1;
        if (this.nRecsOK && cellX >= 0 && cellX < this.nCells) {
            if (!this.modeSetupDone) {
                this.cellModeSetup();
            }
            int nModes = this.cellNModes[cellX];
            if (modeX >= 0 && modeX < nModes) {
                result = this.cellModeIndex[cellX];
                if (modeX >= 1) {
                    int iMax = this.cellModeIndex[cellX];
                    int cellStart = cellX * this.nTargetCategs;
                    double maxNRecs = this.nRecsArray[cellStart + iMax];
                    int iFound = 0;
                    for (int i = iMax + 1; i < this.nTargetCategs; ++i) {
                        double nRecs = this.nRecsArray[cellStart + i];
                        if (nRecs != maxNRecs || ++iFound != modeX) continue;
                        result = i;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public double getConfidence(int cellX) {
        double result = MissingValue.getMissing();
        if (cellX >= 0 && cellX < this.nCells) {
            if (!this.modeSetupDone) {
                this.cellModeSetup();
            }
            result = this.cellConfidence[cellX];
        }
        return result;
    }

    private boolean cellSetup() {
        boolean result;
        boolean bl = result = this.mNRecs != null;
        if (result) {
            this.nRecsArray = this.mNRecs.getMatrix();
            this.nCells = this.mNRecs.getNRows();
            this.nTargetCategs = this.mNRecs.getNCols();
            boolean bl2 = result = this.nCells > 0 && this.nTargetCategs > 0;
        }
        if (result) {
            this.cellNRecs = new double[this.nCells];
            this.nRecsTotal = 0.0;
            int cellStart = 0;
            for (int iCell = 0; iCell < this.nCells; ++iCell) {
                double nRecsInCell = 0.0;
                for (int iCat = 0; iCat < this.nTargetCategs; ++iCat) {
                    double nRecs = this.nRecsArray[cellStart + iCat];
                    nRecsInCell += nRecs;
                }
                this.cellNRecs[iCell] = nRecsInCell;
                this.nRecsTotal += nRecsInCell;
                cellStart += this.nTargetCategs;
            }
        }
        return result;
    }

    private void cellModeSetup() {
        if (!this.modeSetupDone) {
            this.cellConfidence = new double[this.nCells];
            this.cellModeIndex = new int[this.nCells];
            this.cellNModes = new int[this.nCells];
            int cellStart = 0;
            for (int iCell = 0; iCell < this.nCells; ++iCell) {
                double nRecsInCell = 0.0;
                double maxNRecs = -1.0;
                double secondMax = -1.0;
                int iMax = 0;
                int nModes = 1;
                for (int iCat = 0; iCat < this.nTargetCategs; ++iCat) {
                    double nRecs = this.nRecsArray[cellStart + iCat];
                    nRecsInCell += nRecs;
                    if (nRecs > maxNRecs) {
                        secondMax = maxNRecs;
                        maxNRecs = nRecs;
                        iMax = iCat;
                        nModes = 1;
                        continue;
                    }
                    if (nRecs == maxNRecs) {
                        secondMax = maxNRecs;
                        ++nModes;
                        continue;
                    }
                    if (!(nRecs > secondMax)) continue;
                    secondMax = nRecs;
                }
                if (nRecsInCell > 0.0) {
                    this.cellConfidence[iCell] = (maxNRecs - secondMax) / nRecsInCell;
                }
                this.cellModeIndex[iCell] = iMax;
                this.cellNModes[iCell] = nModes;
                cellStart += this.nTargetCategs;
            }
            this.modeSetupDone = true;
        }
    }

    private void distSetup() {
        if (!this.distSetupDone) {
            this.nSigCells = 0;
            this.probTargetCategs = new double[this.nTargetCategs];
            for (int iCat = 0; iCat < this.nTargetCategs; ++iCat) {
                int cellX = iCat;
                double nRecsCateg = 0.0;
                for (int iCell = 0; iCell < this.nCells; ++iCell) {
                    double nRecs = this.nRecsArray[cellX];
                    nRecsCateg += nRecs;
                    cellX += this.nTargetCategs;
                }
                this.probTargetCategs[iCat] = nRecsCateg / this.nRecsTotal;
            }
            this.distSetupDone = true;
        }
    }

    public void setSigLevel(double sigLevel) {
        this.sigLevel = sigLevel;
    }

    public double getSigLevel() {
        return this.sigLevel;
    }

    public int findSigCells() {
        if (!this.distSetupDone) {
            this.distSetup();
        }
        this.sigCellIndicators = new CCBitSet(this.nCells);
        int initCapacity = (int)Math.max((double)this.nCells * 0.1, 100.0);
        this.sigCells = new ArrayList(initCapacity);
        this.sigChiSq = new ArrayList(initCapacity);
        this.sigPVal = new ArrayList(initCapacity);
        this.sigEffSizes = new ArrayList(initCapacity);
        int cellStart = 0;
        for (int iCell = 0; iCell < this.nCells; ++iCell) {
            double chiSq = 0.0;
            double nRecsInCell = this.cellNRecs[iCell];
            for (int iCat = 0; iCat < this.nTargetCategs; ++iCat) {
                double predNRecs = this.probTargetCategs[iCat] * nRecsInCell;
                if (predNRecs == 0.0) continue;
                double diff = this.nRecsArray[cellStart + iCat] - predNRecs;
                chiSq += diff * diff / predNRecs;
            }
            double pValue = DistributionFunctions.cdfChi((double)chiSq, (double)(this.nTargetCategs - 1));
            if (!MissingValue.isMissing((double)pValue) && (pValue = 1.0 - pValue) <= this.sigLevel) {
                this.sigCellIndicators.set(iCell);
                this.sigCells.add(iCell);
                double effSize = MissingValue.getMissing();
                double denom = nRecsInCell * (double)(this.nTargetCategs - 1);
                if (denom > 0.0) {
                    effSize = Math.sqrt(chiSq / denom);
                }
                this.sigChiSq.add(chiSq);
                this.sigPVal.add(pValue);
                this.sigEffSizes.add(effSize);
                ++this.nSigCells;
            }
            cellStart += this.nTargetCategs;
        }
        this.checkForSigCells = true;
        return this.nSigCells;
    }

    public int findInflCategs(int cellX, ArrayList<Integer> inflCategs, ArrayList<Boolean> isHighCateg, ArrayList<Double> categChiSq, ArrayList<Double> categPVal, ArrayList<Double> categEffSize) {
        if (!this.checkForSigCells) {
            this.findSigCells();
        }
        int result = -1;
        if (cellX >= 0 && cellX < this.nCells && this.sigCellIndicators.get(cellX) && inflCategs != null && isHighCateg != null && categChiSq != null && categPVal != null && categEffSize != null) {
            result = 0;
            inflCategs.clear();
            isHighCateg.clear();
            categChiSq.clear();
            categPVal.clear();
            categEffSize.clear();
            int cellStart = this.nTargetCategs * cellX;
            double nRecsInCell = this.cellNRecs[cellX];
            for (int iCat = 0; iCat < this.nTargetCategs; ++iCat) {
                double pValue;
                double nRecs = this.nRecsArray[cellStart + iCat];
                double prob = this.probTargetCategs[iCat];
                double chiSq = 0.0;
                double denom = nRecsInCell * prob * (1.0 - prob);
                if (denom > 0.0) {
                    double numer = nRecs - prob * nRecsInCell;
                    numer *= numer;
                    chiSq = numer / denom;
                }
                if (MissingValue.isMissing((double)(pValue = DistributionFunctions.cdfChi((double)chiSq, (double)1.0)))) continue;
                pValue = 1.0 - pValue;
                if (!((pValue *= (double)this.nTargetCategs) <= this.sigLevel)) continue;
                ++result;
                boolean isHigh = nRecs > nRecsInCell * prob;
                double effSize = MissingValue.getMissing();
                if (nRecsInCell > 0.0 && chiSq >= 0.0) {
                    effSize = Math.sqrt(chiSq / nRecsInCell);
                }
                inflCategs.add(iCat);
                isHighCateg.add(isHigh);
                categChiSq.add(chiSq);
                categPVal.add(pValue);
                categEffSize.add(effSize);
            }
        }
        return result;
    }

    public boolean nRecsOK() {
        return this.nRecsOK;
    }

    public boolean getCheckForSigCells() {
        return this.checkForSigCells;
    }

    public int getNSigCells() {
        return this.nSigCells;
    }

    public boolean isCellSignif(int cellX) {
        boolean result = false;
        if (this.checkForSigCells && cellX >= 0 && cellX < this.nCells) {
            result = this.sigCellIndicators.get(cellX);
        }
        return result;
    }

    public int getSigCellIndex(int sigCellX) {
        int result = -1;
        if (sigCellX >= 0 && sigCellX < this.nSigCells) {
            result = this.sigCells.get(sigCellX);
        }
        return result;
    }

    public double getSigCellChiSq(int sigCellX) {
        double result = MissingValue.getMissing();
        if (sigCellX >= 0 && sigCellX < this.nSigCells) {
            result = this.sigChiSq.get(sigCellX);
        }
        return result;
    }

    public double getSigCellPValue(int sigCellX) {
        double result = MissingValue.getMissing();
        if (sigCellX >= 0 && sigCellX < this.nSigCells) {
            result = this.sigPVal.get(sigCellX);
        }
        return result;
    }

    public double getSigCellEffSize(int sigCellX) {
        double result = MissingValue.getMissing();
        if (sigCellX >= 0 && sigCellX < this.nSigCells) {
            result = this.sigEffSizes.get(sigCellX);
        }
        return result;
    }

    public ArrayList<Integer> getSigCellIndices() {
        return this.sigCells;
    }

    public ArrayList<Double> getSigCellChiSquares() {
        return this.sigChiSq;
    }

    public ArrayList<Double> getSigCellPValues() {
        return this.sigPVal;
    }

    public double getSigCellDF() {
        return this.nTargetCategs - 1;
    }

    public ArrayList<Double> getSigCellEffectSizes() {
        return this.sigEffSizes;
    }
}

